/***************************************************************************************
 *  Genesis Plus
 *  Backup RAM support
 *
 *  Copyright (C) 2007, 2008, 2009  Eke-Eke (GCN/Wii port)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ****************************************************************************************/

#ifndef _SRAM_H_
#define _SRAM_H_

typedef struct
{
  uint8 detected;
  uint8 on;
  uint8 custom;
  uint32 start;
  uint32 end;
  uint32 crc;
  uint8 *sram;
} T_SRAM;

/* Function prototypes */
extern void sram_init();
extern unsigned int sram_read_byte(unsigned int address);
extern unsigned int sram_read_word(unsigned int address);
extern void sram_write_byte(unsigned int address, unsigned int data);
extern void sram_write_word(unsigned int address, unsigned int data);

/* global variables */
extern T_SRAM sram;

#endif
