#ifndef __FCEU_FCOEFFS_H_
#define __FCEU_FCOEFFS_H_

#define SQ2NCOEFFS 1024

static int32 sq2coeffs[SQ2NCOEFFS];

static int32 SQ2C44100NTSC[SQ2NCOEFFS / 2] =
{
	#include "fir/c44100ntsc.h"
};

static int32 SQ2C48000NTSC[SQ2NCOEFFS / 2] =
{
	#include "fir/c48000ntsc.h"
};

static int32 SQ2C96000NTSC[SQ2NCOEFFS / 2] =
{
	#include "fir/c96000ntsc.h"
};

static int32 SQ2C44100PAL[SQ2NCOEFFS / 2] =
{
	#include "fir/c44100pal.h"
};

static int32 SQ2C48000PAL[SQ2NCOEFFS / 2] =
{
	#include "fir/c48000pal.h"
};

static int32 SQ2C96000PAL[SQ2NCOEFFS / 2] =
{
	#include "fir/c96000pal.h"
};

#define NCOEFFS 484

static int32 coeffs[NCOEFFS];

/* 96000hz filter could probably be improved. */

/*
Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.016761904
Order: 483
Passband ripple: 0.01 dB
Transition band: 0.01005714
Stopband attenuation: 103.0 dB

Coefficients:
*/
static int32 C96000NTSC[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 *  -5.9950991853042605E-6
/*1*/, 65536 * 16 *  -3.0394382502604395E-6
/*2*/, 65536 * 16 *  -3.728403434239284E-6
/*3*/, 65536 * 16 *  -4.460351826790638E-6
/*4*/, 65536 * 16 *  -5.2164320385801135E-6
/*5*/, 65536 * 16 *  -5.9787071016806234E-6
/*6*/, 65536 * 16 *  -6.716463411023574E-6
/*7*/, 65536 * 16 *  -7.408551386580002E-6
/*8*/, 65536 * 16 *  -8.023491429829738E-6
/*9*/, 65536 * 16 *  -8.531232892238868E-6
/*10*/, 65536 * 16 * -8.878741512154837E-6
/*11*/, 65536 * 16 * -9.046773382992595E-6
/*12*/, 65536 * 16 * -8.993971214348702E-6
/*13*/, 65536 * 16 * -8.66944931521744E-6
/*14*/, 65536 * 16 * -8.049348524459474E-6
/*15*/, 65536 * 16 * -7.083238646482467E-6
/*16*/, 65536 * 16 * -5.746762349938464E-6
/*17*/, 65536 * 16 * -4.005753681691657E-6
/*18*/, 65536 * 16 * -1.838018035195733E-6
/*19*/, 65536 * 16 * 7.763983938828864E-7
/*20*/, 65536 * 16 * 3.842232025916005E-6
/*21*/, 65536 * 16 * 7.361161707034959E-6
/*22*/, 65536 * 16 * 1.1325948767988128E-5
/*23*/, 65536 * 16 * 1.5711486406341978E-5
/*24*/, 65536 * 16 * 2.0488201424957098E-5
/*25*/, 65536 * 16 * 2.5608402660083142E-5
/*26*/, 65536 * 16 * 3.101231858515874E-5
/*27*/, 65536 * 16 * 3.6630654060842745E-5
/*28*/, 65536 * 16 * 4.2375439803123404E-5
/*29*/, 65536 * 16 * 4.815060832963289E-5
/*30*/, 65536 * 16 * 5.384626411548906E-5
/*31*/, 65536 * 16 * 5.934549587237094E-5
/*32*/, 65536 * 16 * 6.451785679907682E-5
/*33*/, 65536 * 16 * 6.923065879553487E-5
/*34*/, 65536 * 16 * 7.334304650233838E-5
/*35*/, 65536 * 16 * 7.671308820252635E-5
/*36*/, 65536 * 16 * 7.920112989696133E-5
/*37*/, 65536 * 16 * 8.066793124218096E-5
/*38*/, 65536 * 16 * 8.098382483962539E-5
/*39*/, 65536 * 16 * 8.002921154479775E-5
/*40*/, 65536 * 16 * 7.769789869215064E-5
/*41*/, 65536 * 16 * 7.390152475899438E-5
/*42*/, 65536 * 16 * 6.857231550142758E-5
/*43*/, 65536 * 16 * 6.16673817460573E-5
/*44*/, 65536 * 16 * 5.3169767940001464E-5
/*45*/, 65536 * 16 * 4.309495398773014E-5
/*46*/, 65536 * 16 * 3.148737405995964E-5
/*47*/, 65536 * 16 * 1.8428415219696232E-5
/*48*/, 65536 * 16 * 4.0337781533928895E-6
/*49*/, 65536 * 16 * -1.154525373085283E-5
/*50*/, 65536 * 16 * -2.8120750949316567E-5
/*51*/, 65536 * 16 * -4.5470242422149815E-5
/*52*/, 65536 * 16 * -6.333736379615692E-5
/*53*/, 65536 * 16 * -8.143489509942166E-5
/*54*/, 65536 * 16 * -9.94475640226242E-5
/*55*/, 65536 * 16 * -1.1703729468742291E-4
/*56*/, 65536 * 16 * -1.3384679191408508E-4
/*57*/, 65536 * 16 * -1.4950548598267213E-4
/*58*/, 65536 * 16 * -1.6363792959068823E-4
/*59*/, 65536 * 16 * -1.7586732627086947E-4
/*60*/, 65536 * 16 * -1.858264971517669E-4
/*61*/, 65536 * 16 * -1.9316312487547242E-4
/*62*/, 65536 * 16 * -1.975494021862538E-4
/*63*/, 65536 * 16 * -1.9868977868165154E-4
/*64*/, 65536 * 16 * -1.963293865814053E-4
/*65*/, 65536 * 16 * -1.9026146175876417E-4
/*66*/, 65536 * 16 * -1.803352078962109E-4
/*67*/, 65536 * 16 * -1.66463443436789E-4
/*68*/, 65536 * 16 * -1.4862710934868261E-4
/*69*/, 65536 * 16 * -1.2688200452566298E-4
/*70*/, 65536 * 16 * -1.0136212853169677E-4
/*71*/, 65536 * 16 * -7.228199463954364E-5
/*72*/, 65536 * 16 * -3.9939461621236575E-5
/*73*/, 65536 * 16 * -4.7134932934724E-6
/*74*/, 65536 * 16 * 3.2936215273699675E-5
/*75*/, 65536 * 16 * 7.247384833064696E-5
/*76*/, 65536 * 16 * 1.1329187082792405E-4
/*77*/, 65536 * 16 * 1.5471948843725746E-4
/*78*/, 65536 * 16 * 1.9603027714808286E-4
/*79*/, 65536 * 16 * 2.364532958813608E-4
/*80*/, 65536 * 16 * 2.751853212246927E-4
/*81*/, 65536 * 16 * 3.114033208188799E-4
/*82*/, 65536 * 16 * 3.442804841775461E-4
/*83*/, 65536 * 16 * 3.7300098840546946E-4
/*84*/, 65536 * 16 * 3.967764136715296E-4
/*85*/, 65536 * 16 * 4.148631617351676E-4
/*86*/, 65536 * 16 * 4.265789297533608E-4
/*87*/, 65536 * 16 * 4.3132002526188114E-4
/*88*/, 65536 * 16 * 4.2857701618443636E-4
/*89*/, 65536 * 16 * 4.179510914969621E-4
/*90*/, 65536 * 16 * 3.991670037587729E-4
/*91*/, 65536 * 16 * 3.720870989970653E-4
/*92*/, 65536 * 16 * 3.367209236003282E-4
/*93*/, 65536 * 16 * 2.932338231303312E-4
/*94*/, 65536 * 16 * 2.419533571940393E-4
/*95*/, 65536 * 16 * 1.8337169647749448E-4
/*96*/, 65536 * 16 * 1.1814612711310299E-4
/*97*/, 65536 * 16 * 4.709567952563025E-5
/*98*/, 65536 * 16 * -2.880519351052945E-5
/*99*/, 65536 * 16 * -1.08436462295612E-4
/*100*/, 65536 * 16 *  -1.905455293630124E-4
/*101*/, 65536 * 16 *  -2.7376362665015007E-4
/*102*/, 65536 * 16 *  -3.566259161939277E-4
/*103*/, 65536 * 16 *  -4.375928024937683E-4
/*104*/, 65536 * 16 *  -5.150762555847844E-4
/*105*/, 65536 * 16 *  -5.874662774920191E-4
/*106*/, 65536 * 16 *  -6.531605887419429E-4
/*107*/, 65536 * 16 *  -7.105951946653638E-4
/*108*/, 65536 * 16 *  -7.582757639600853E-4
/*109*/, 65536 * 16 *  -7.948096207059845E-4
/*110*/, 65536 * 16 *  -8.189373133065186E-4
/*111*/, 65536 * 16 *  -8.295634640890689E-4
/*112*/, 65536 * 16 *  -8.257854455404298E-4
/*113*/, 65536 * 16 *  -8.069208861135825E-4
/*114*/, 65536 * 16 *  -7.725316214556066E-4
/*115*/, 65536 * 16 *  -7.224442067331338E-4
/*116*/, 65536 * 16 *  -6.567673177902021E-4
/*117*/, 65536 * 16 *  -5.759031970767677E-4
/*118*/, 65536 * 16 *  -4.8055576975832975E-4
/*119*/, 65536 * 16 *  -3.7173219275304865E-4
/*120*/, 65536 * 16 *  -2.507394811359122E-4
/*121*/, 65536 * 16 *  -1.191747608775131E-4
/*122*/, 65536 * 16 * 2.1089774143064154E-5
/*123*/, 65536 * 16 * 1.6792832047168277E-4
/*124*/, 65536 * 16 * 3.189887341095747E-4
/*125*/, 65536 * 16 * 4.7172479984555337E-4
/*126*/, 65536 * 16 * 6.234346495766704E-4
/*127*/, 65536 * 16 * 7.713029674040095E-4
/*128*/, 65536 * 16 * 9.124478381058291E-4
/*129*/, 65536 * 16 * 0.0010439713492973299
/*130*/, 65536 * 16 * 0.0011630121060354824
/*131*/, 65536 * 16 * 0.0012668003330792172
/*132*/, 65536 * 16 * 0.0013527131638668246
/*133*/, 65536 * 16 * 0.0014183305230994348
/*134*/, 65536 * 16 * 0.0014614889365474647
/*135*/, 65536 * 16 * 0.0014803340336415063
/*136*/, 65536 * 16 * 0.0014733688575452508
/*137*/, 65536 * 16 * 0.001439498243826639
/*138*/, 65536 * 16 * 0.0013780680098511918
/*139*/, 65536 * 16 * 0.0012888970057146566
/*140*/, 65536 * 16 * 0.0011723026532406624
/*141*/, 65536 * 16 * 0.0010291180003947405
/*142*/, 65536 * 16 * 8.607001658653358E-4
/*143*/, 65536 * 16 * 6.689295599970792E-4
/*144*/, 65536 * 16 * 4.5619928199453885E-4
/*145*/, 65536 * 16 * 2.253948582736753E-4
/*146*/, 65536 * 16 *  -2.0136349562764177E-5
/*147*/, 65536 * 16 *  -2.766248035657636E-4
/*148*/, 65536 * 16 *  -5.399290507797791E-4
/*149*/, 65536 * 16 *  -8.055939397996815E-4
/*150*/, 65536 * 16 *  -0.0010689177291287714
/*151*/, 65536 * 16 *  -0.0013250265370767429
/*152*/, 65536 * 16 *  -0.0015689549600474482
/*153*/, 65536 * 16 *  -0.0017957322527663085
/*154*/, 65536 * 16 *  -0.002000472024117418
/*155*/, 65536 * 16 *  -0.0021784645223266222
/*156*/, 65536 * 16 *  -0.0023252695222818146
/*157*/, 65536 * 16 *  -0.0024368087083972345
/*158*/, 65536 * 16 *  -0.002509455241851095
/*159*/, 65536 * 16 *  -0.0025401189567937766
/*160*/, 65536 * 16 *  -0.0025263261450844377
/*161*/, 65536 * 16 *  -0.0024662908754217406
/*162*/, 65536 * 16 *  -0.002358977944127433
/*163*/, 65536 * 16 *  -0.002204154401342649
/*164*/, 65536 * 16 *  -0.002002429343138771
/*165*/, 65536 * 16 *  -0.0017552803385372808
/*166*/, 65536 * 16 *  -0.0014650656045065488
/*167*/, 65536 * 16 *  -0.001135021049166992
/*168*/, 65536 * 16 *  -7.692415547098649E-4
/*169*/, 65536 * 16 *  -3.7264671522013244E-4
/*170*/, 65536 * 16 * 4.906989195928291E-5
/*171*/, 65536 * 16 * 4.895067103339711E-4
/*172*/, 65536 * 16 * 9.416355837269647E-4
/*173*/, 65536 * 16 * 0.001397897684142057
/*174*/, 65536 * 16 * 0.0018503121614766558
/*175*/, 65536 * 16 * 0.002290597319733804
/*176*/, 65536 * 16 * 0.0027103015920374113
/*177*/, 65536 * 16 * 0.0031009433327120863
/*178*/, 65536 * 16 * 0.0034541565687980116
/*179*/, 65536 * 16 * 0.0037618412630103333
/*180*/, 65536 * 16 * 0.004016315066649496
/*181*/, 65536 * 16 * 0.004210464374744574
/*182*/, 65536 * 16 * 0.004337892288164658
/*183*/, 65536 * 16 * 0.004393060165490985
/*184*/, 65536 * 16 * 0.004371421226297046
/*185*/, 65536 * 16 * 0.004269542847715132
/*186*/, 65536 * 16 * 0.00408521543517564
/*187*/, 65536 * 16 * 0.0038175457430583526
/*188*/, 65536 * 16 * 0.00346703221076496
/*189*/, 65536 * 16 * 0.0030356209846777236
/*190*/, 65536 * 16 * 0.002526740400739804
/*191*/, 65536 * 16 * 0.0019453134428630866
/*192*/, 65536 * 16 * 0.0012977462825954304
/*193*/, 65536 * 16 * 5.918933555500828E-4
/*194*/, 65536 * 16 *  -1.6300197379338156E-4
/*195*/, 65536 * 16 *  -9.563908629597664E-4
/*196*/, 65536 * 16 *  -0.0017765255338228524
/*197*/, 65536 * 16 *  -0.0026105886000394158
/*198*/, 65536 * 16 *  -0.003444843158936217
/*199*/, 65536 * 16 *  -0.004264802433556331
/*200*/, 65536 * 16 *  -0.00505541655658742
/*201*/, 65536 * 16 *  -0.005801274223045036
/*202*/, 65536 * 16 *  -0.0064868164183708756
/*203*/, 65536 * 16 *  -0.007096559102022994
/*204*/, 65536 * 16 *  -0.007615322236172286
/*205*/, 65536 * 16 *  -0.008028460796606074
/*206*/, 65536 * 16 *  -0.008322095341268461
/*207*/, 65536 * 16 *  -0.008483337773170242
/*208*/, 65536 * 16 *  -0.008500509194641638
/*209*/, 65536 * 16 *  -0.008363346317351387
/*210*/, 65536 * 16 *  -0.008063192746297233
/*211*/, 65536 * 16 *  -0.007593172286363423
/*212*/, 65536 * 16 *  -0.0069483408893122045
/*213*/, 65536 * 16 *  -0.006125814985695579
/*214*/, 65536 * 16 *  -0.005124873148956596
/*215*/, 65536 * 16 *  -0.003947029569132915
/*216*/, 65536 * 16 *  -0.002596077508306772
/*217*/, 65536 * 16 *  -0.0010781012650798818
/*218*/, 65536 * 16 * 5.985434770618447E-4
/*219*/, 65536 * 16 * 0.0024232820773754
/*220*/, 65536 * 16 * 0.004383405101533075
/*221*/, 65536 * 16 * 0.006464184070028333
/*222*/, 65536 * 16 * 0.008649017282842432
/*223*/, 65536 * 16 * 0.010919604285452066
/*224*/, 65536 * 16 * 0.013256146772932903
/*225*/, 65536 * 16 * 0.015637573164024095
/*226*/, 65536 * 16 * 0.018041784432073237
/*227*/, 65536 * 16 * 0.020445917198990023
/*228*/, 65536 * 16 * 0.022826621253151515
/*229*/, 65536 * 16 * 0.025160347111354456
/*230*/, 65536 * 16 * 0.02742363969736895
/*231*/, 65536 * 16 * 0.02959343430076011
/*232*/, 65536 * 16 * 0.03164735012116834
/*233*/, 65536 * 16 * 0.03356397767681876
/*234*/, 65536 * 16 * 0.035323155364389396
/*235*/, 65536 * 16 * 0.03690623176571385
/*236*/, 65536 * 16 * 0.03829630932788767
/*237*/, 65536 * 16 * 0.03947846623700253
/*238*/, 65536 * 16 * 0.040439953107911
/*239*/, 65536 * 16 * 0.0411703612762271
/*240*/, 65536 * 16 * 0.04166176091370756
/*241*/, 65536 * 16 * 0.041908806136461134
};

/*
Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.01804395
Order: 483
Passband ripple: 0.01 dB
Transition band: 0.0108263
Stopband attenuation: 114.0 dB

Coefficients:
*/

static int32 C96000PAL[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 * 3.850781559466991E-7
/*1*/, 65536 * 16 *  -1.280019401722687E-6
/*2*/, 65536 * 16 *  -1.3004583488088965E-6
/*3*/, 65536 * 16 *  -1.7523167437749452E-6
/*4*/, 65536 * 16 *  -2.410249470764872E-6
/*5*/, 65536 * 16 *  -3.2346426554155092E-6
/*6*/, 65536 * 16 *  -4.227271662321092E-6
/*7*/, 65536 * 16 *  -5.3971678027414914E-6
/*8*/, 65536 * 16 *  -6.753444785567694E-6
/*9*/, 65536 * 16 *  -8.302128790766257E-6
/*10*/, 65536 * 16 * -1.0045896006160685E-5
/*11*/, 65536 * 16 * -1.1982368218542129E-5
/*12*/, 65536 * 16 * -1.4104296519058353E-5
/*13*/, 65536 * 16 * -1.6397945806910793E-5
/*14*/, 65536 * 16 * -1.8843550708827064E-5
/*15*/, 65536 * 16 * -2.1413952016264175E-5
/*16*/, 65536 * 16 * -2.407540699773165E-5
/*17*/, 65536 * 16 * -2.6786418491045868E-5
/*18*/, 65536 * 16 * -2.949883620881563E-5
/*19*/, 65536 * 16 * -3.215685693993941E-5
/*20*/, 65536 * 16 * -3.4698621200866915E-5
/*21*/, 65536 * 16 * -3.7055635055088747E-5
/*22*/, 65536 * 16 * -3.915516367387583E-5
/*23*/, 65536 * 16 * -4.092005046973106E-5
/*24*/, 65536 * 16 * -4.227173792151256E-5
/*25*/, 65536 * 16 * -4.313002076491602E-5
/*26*/, 65536 * 16 * -4.3416606424857764E-5
/*27*/, 65536 * 16 * -4.3054793786740716E-5
/*28*/, 65536 * 16 * -4.1974462257106624E-5
/*29*/, 65536 * 16 * -4.011236719136458E-5
/*30*/, 65536 * 16 * -3.7415159397597796E-5
/*31*/, 65536 * 16 * -3.3846213818414235E-5
/*32*/, 65536 * 16 * -2.9372757531099172E-5
/*33*/, 65536 * 16 * -2.3989695934591954E-5
/*34*/, 65536 * 16 * -1.7705989252101064E-5
/*35*/, 65536 * 16 * -1.0551320217411096E-5
/*36*/, 65536 * 16 * -2.5775325043216536E-6
/*37*/, 65536 * 16 * 6.139645766572715E-6
/*38*/, 65536 * 16 * 1.5501423038008354E-5
/*39*/, 65536 * 16 * 2.5384753820737575E-5
/*40*/, 65536 * 16 * 3.5643398684518664E-5
/*41*/, 65536 * 16 * 4.6108393091574726E-5
/*42*/, 65536 * 16 * 5.659011526249589E-5
/*43*/, 65536 * 16 * 6.68803323899828E-5
/*44*/, 65536 * 16 * 7.675537622878941E-5
/*45*/, 65536 * 16 * 8.597960059720824E-5
/*46*/, 65536 * 16 * 9.430960279897814E-5
/*47*/, 65536 * 16 * 1.0149893801465577E-4
/*48*/, 65536 * 16 * 1.0730328189856642E-4
/*49*/, 65536 * 16 * 1.1148622997923174E-4
/*50*/, 65536 * 16 * 1.1382511217545132E-4
/*51*/, 65536 * 16 * 1.141174295909343E-4
/*52*/, 65536 * 16 * 1.1218671460549208E-4
/*53*/, 65536 * 16 * 1.078890398041802E-4
/*54*/, 65536 * 16 * 1.0111839925160891E-4
/*55*/, 65536 * 16 * 9.181292532691402E-5
/*56*/, 65536 * 16 * 7.995923739813694E-5
/*57*/, 65536 * 16 * 6.559772591687974E-5
/*58*/, 65536 * 16 * 4.882471526869663E-5
/*59*/, 65536 * 16 * 2.9795861807919456E-5
/*60*/, 65536 * 16 * 8.727003235393024E-6
/*61*/, 65536 * 16 * -1.4106777294769694E-5
/*62*/, 65536 * 16 * -3.836880959229582E-5
/*63*/, 65536 * 16 * -6.366921149307032E-5
/*64*/, 65536 * 16 * -8.956481187350594E-5
/*65*/, 65536 * 16 * -1.1556632861786434E-4
/*66*/, 65536 * 16 * -1.411455941949306E-4
/*67*/, 65536 * 16 * -1.657445386231986E-4
/*68*/, 65536 * 16 * -1.8878427001863077E-4
/*69*/, 65536 * 16 * -2.0967688285495866E-4
/*70*/, 65536 * 16 * -2.2783715638612827E-4
/*71*/, 65536 * 16 * -2.4269587549180196E-4
/*72*/, 65536 * 16 * -2.5371305459897316E-4
/*73*/, 65536 * 16 * -2.603919787720978E-4
/*74*/, 65536 * 16 * -2.6229284265917287E-4
/*75*/, 65536 * 16 * -2.59046413963889E-4
/*76*/, 65536 * 16 * -2.503668396740634E-4
/*77*/, 65536 * 16 * -2.3606367328604213E-4
/*78*/, 65536 * 16 * -2.160524966650091E-4
/*79*/, 65536 * 16 * -1.903639226156617E-4
/*80*/, 65536 * 16 * -1.59150691014015E-4
/*81*/, 65536 * 16 * -1.2269241610349266E-4
/*82*/, 65536 * 16 * -8.139812226735764E-5
/*83*/, 65536 * 16 * -3.5805772732231955E-5
/*84*/, 65536 * 16 * 1.3420603339835859E-5
/*85*/, 65536 * 16 * 6.549742374431074E-5
/*86*/, 65536 * 16 * 1.1953033076822495E-4
/*87*/, 65536 * 16 * 1.745269622757623E-4
/*88*/, 65536 * 16 * 2.2941123586808386E-4
/*89*/, 65536 * 16 * 2.830419125977025E-4
/*90*/, 65536 * 16 * 3.3423267917052983E-4
/*91*/, 65536 * 16 * 3.81774499172079E-4
/*92*/, 65536 * 16 * 4.244616654237554E-4
/*93*/, 65536 * 16 * 4.611154134679936E-4
/*94*/, 65536 * 16 * 4.906128810250551E-4
/*95*/, 65536 * 16 * 5.119138315653597E-4
/*96*/, 65536 * 16 * 5.240878477917174E-4
/*97*/, 65536 * 16 * 5.263406012974186E-4
/*98*/, 65536 * 16 * 5.180395272684202E-4
/*99*/, 65536 * 16 * 4.987363674123535E-4
/*100*/, 65536 * 16 * 4.681879119879578E-4
/*101*/, 65536 * 16 * 4.263728836819278E-4
/*102*/, 65536 * 16 * 3.735054898141368E-4
/*103*/, 65536 * 16 * 3.1004425441119956E-4
/*104*/, 65536 * 16 * 2.3669640454159868E-4
/*105*/, 65536 * 16 * 1.5441686754990788E-4
/*106*/, 65536 * 16 * 6.440207419421148E-5
/*107*/, 65536 * 16 *  -3.192198333335273E-5
/*108*/, 65536 * 16 *  -1.3291717686663037E-4
/*109*/, 65536 * 16 *  -2.3675627296534203E-4
/*110*/, 65536 * 16 *  -3.414512496033162E-4
/*111*/, 65536 * 16 *  -4.4488659997924806E-4
/*112*/, 65536 * 16 *  -5.44857304239037E-4
/*113*/, 65536 * 16 *  -6.391106241040588E-4
/*114*/, 65536 * 16 *  -7.253914361418537E-4
/*115*/, 65536 * 16 *  -8.0148962040363E-4
/*116*/, 65536 * 16 *  -8.652895191393541E-4
/*117*/, 65536 * 16 *  -9.148193159968953E-4
/*118*/, 65536 * 16 *  -9.483009583169883E-4
/*119*/, 65536 * 16 *  -9.64197392644944E-4
/*120*/, 65536 * 16 *  -9.612579850877552E-4
/*121*/, 65536 * 16 *  -9.385600118624972E-4
/*122*/, 65536 * 16 *  -8.955444281498081E-4
/*123*/, 65536 * 16 *  -8.320477398703453E-4
/*124*/, 65536 * 16 *  -7.483247067952744E-4
/*125*/, 65536 * 16 *  -6.450648142040654E-4
/*126*/, 65536 * 16 *  -5.234000259248345E-4
/*127*/, 65536 * 16 *  -3.8490357943433983E-4
/*128*/, 65536 * 16 *  -2.3157879639504726E-4
/*129*/, 65536 * 16 *  -6.583909529283622E-5
/*130*/, 65536 * 16 * 1.0952239530879758E-4
/*131*/, 65536 * 16 * 2.9137227027685464E-4
/*132*/, 65536 * 16 * 4.76285797012954E-4
/*133*/, 65536 * 16 * 6.606041066674581E-4
/*134*/, 65536 * 16 * 8.404993785845289E-4
/*135*/, 65536 * 16 * 0.0010120465600366754
/*136*/, 65536 * 16 * 0.00117130077980147
/*137*/, 65536 * 16 * 0.0013143787565297594
/*138*/, 65536 * 16 * 0.0014375429397231808
/*139*/, 65536 * 16 * 0.0015372865339524395
/*140*/, 65536 * 16 * 0.0016104178085955662
/*141*/, 65536 * 16 * 0.0016541417860661317
/*142*/, 65536 * 16 * 0.0016661374441763997
/*143*/, 65536 * 16 * 0.0016446287155235182
/*144*/, 65536 * 16 * 0.0015884472759871292
/*145*/, 65536 * 16 * 0.0014970858621845143
/*146*/, 65536 * 16 * 0.0013707399310406382
/*147*/, 65536 * 16 * 0.0012103371052757787
/*148*/, 65536 * 16 * 0.0010175519857289184
/*149*/, 65536 * 16 * 7.94807053668863E-4
/*150*/, 65536 * 16 * 5.452573395422002E-4
/*151*/, 65536 * 16 * 2.727594075846488E-4
/*152*/, 65536 * 16 *  -1.8175144027827955E-5
/*153*/, 65536 * 16 *  -3.2244298920455907E-4
/*154*/, 65536 * 16 *  -6.344261333752713E-4
/*155*/, 65536 * 16 *  -9.480839637356165E-4
/*156*/, 65536 * 16 *  -0.001257058056943197
/*157*/, 65536 * 16 *  -0.001554788246611654
/*158*/, 65536 * 16 *  -0.001834637661184569
/*159*/, 65536 * 16 *  -0.0020900256934556468
/*160*/, 65536 * 16 *  -0.0023145651572872143
/*161*/, 65536 * 16 *  -0.0025022020560114683
/*162*/, 65536 * 16 *  -0.002647354498854991
/*163*/, 65536 * 16 *  -0.002745048447695108
/*164*/, 65536 * 16 *  -0.0027910469441460657
/*165*/, 65536 * 16 *  -0.002781970255972488
/*166*/, 65536 * 16 *  -0.0027154038464012363
/*167*/, 65536 * 16 *  -0.002589991713387623
/*168*/, 65536 * 16 *  -0.0024055123883779776
/*169*/, 65536 * 16 *  -0.0021629354924022053
/*170*/, 65536 * 16 *  -0.0018644567566629092
/*171*/, 65536 * 16 *  -0.0015135100031795994
/*172*/, 65536 * 16 *  -0.0011147548631940517
/*173*/, 65536 * 16 *  -6.740394224166433E-4
/*174*/, 65536 * 16 *  -1.9833762845333352E-4
/*175*/, 65536 * 16 * 3.043386309556266E-4
/*176*/, 65536 * 16 * 8.250516255359581E-4
/*177*/, 65536 * 16 * 0.0013540734762851313
/*178*/, 65536 * 16 * 0.0018810427835111666
/*179*/, 65536 * 16 * 0.002395141352428365
/*180*/, 65536 * 16 * 0.002885286937512414
/*181*/, 65536 * 16 * 0.0033403397957704442
/*182*/, 65536 * 16 * 0.003749319662913449
/*183*/, 65536 * 16 * 0.00410162844368435
/*184*/, 65536 * 16 * 0.00438727601255591
/*185*/, 65536 * 16 * 0.004597103692808949
/*186*/, 65536 * 16 * 0.004723001540295747
/*187*/, 65536 * 16 * 0.004758115147888017
/*188*/, 65536 * 16 * 0.0046970379302800494
/*189*/, 65536 * 16 * 0.0045359837766146575
/*190*/, 65536 * 16 * 0.004272937350956345
/*191*/, 65536 * 16 * 0.003907777448988567
/*192*/, 65536 * 16 * 0.0034423707924944227
/*193*/, 65536 * 16 * 0.0028806330094231125
/*194*/, 65536 * 16 * 0.0022285548928660825
/*195*/, 65536 * 16 * 0.0014941919971143964
/*196*/, 65536 * 16 * 6.876167025638233E-4
/*197*/, 65536 * 16 *  -1.7916781098860902E-4
/*198*/, 65536 * 16 *  -0.001092351250031068
/*199*/, 65536 * 16 *  -0.002036476651580642
/*200*/, 65536 * 16 *  -0.002994635788760751
/*201*/, 65536 * 16 *  -0.003948697212655613
/*202*/, 65536 * 16 *  -0.004879563858611486
/*203*/, 65536 * 16 *  -0.005767456511229176
/*204*/, 65536 * 16 *  -0.006592218979894068
/*205*/, 65536 * 16 *  -0.007333640031607341
/*206*/, 65536 * 16 *  -0.007971787269457032
/*207*/, 65536 * 16 *  -0.008487346947516187
/*208*/, 65536 * 16 *  -0.008861964740105959
/*209*/, 65536 * 16 *  -0.009078580419089913
/*210*/, 65536 * 16 *  -0.009121751784315056
/*211*/, 65536 * 16 *  -0.008977961157199062
/*212*/, 65536 * 16 *  -0.008635898786325313
/*213*/, 65536 * 16 *  -0.008086718339557295
/*214*/, 65536 * 16 *  -0.007324258683042848
/*215*/, 65536 * 16 *  -0.0063452279676933475
/*216*/, 65536 * 16 *  -0.005149346015761238
/*217*/, 65536 * 16 *  -0.0037394415039958702
/*218*/, 65536 * 16 *  -0.0021215012056140783
/*219*/, 65536 * 16 *  -3.046703636518387E-4
/*220*/, 65536 * 16 * 0.0016987979320526618
/*221*/, 65536 * 16 * 0.0038736435001752246
/*222*/, 65536 * 16 * 0.006201749792159754
/*223*/, 65536 * 16 * 0.00866234250983842
/*224*/, 65536 * 16 * 0.011232233932071251
/*225*/, 65536 * 16 * 0.013886109426908738
/*226*/, 65536 * 16 * 0.016596852190097027
/*227*/, 65536 * 16 * 0.01933590131308301
/*228*/, 65536 * 16 * 0.022073637826085922
/*229*/, 65536 * 16 * 0.024779792715016697
/*230*/, 65536 * 16 * 0.027423870545765342
/*231*/, 65536 * 16 * 0.029975581949125456
/*232*/, 65536 * 16 * 0.03240527801144671
/*233*/, 65536 * 16 * 0.034684379593278115
/*234*/, 65536 * 16 * 0.03678579448103684
/*235*/, 65536 * 16 * 0.03868431571442653
/*236*/, 65536 * 16 * 0.04035699420925718
/*237*/, 65536 * 16 * 0.041783479941480954
/*238*/, 65536 * 16 * 0.04294632536294341
/*239*/, 65536 * 16 * 0.043831247006285705
/*240*/, 65536 * 16 * 0.044427339714649856
/*241*/, 65536 * 16 * 0.04472724072106236
};

/*
Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.0077845
Order: 483
Passband ripple: 0.1 dB
Transition band: 0.005625
Stopband attenuation: 60.0 dB
*/
static int32 C48000NTSC[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 *  -1.2211019733097893E-4
/*1*/, 65536 * 16 * 5.374660789759626E-4
/*2*/, 65536 * 16 * 1.9882723274804067E-4
/*3*/, 65536 * 16 * 1.3631041618360223E-4
/*4*/, 65536 * 16 * 1.3153691128499229E-4
/*5*/, 65536 * 16 * 1.3886281724158703E-4
/*6*/, 65536 * 16 * 1.4887278966773673E-4
/*7*/, 65536 * 16 * 1.5943890243162037E-4
/*8*/, 65536 * 16 * 1.7020639605259616E-4
/*9*/, 65536 * 16 * 1.809192079749018E-4
/*10*/, 65536 * 16 * 1.9162093203709557E-4
/*11*/, 65536 * 16 * 2.02127312351196E-4
/*12*/, 65536 * 16 * 2.1249848894399555E-4
/*13*/, 65536 * 16 * 2.2254095363111247E-4
/*14*/, 65536 * 16 * 2.323202963851337E-4
/*15*/, 65536 * 16 * 2.4163344759163413E-4
/*16*/, 65536 * 16 * 2.505472122265602E-4
/*17*/, 65536 * 16 * 2.5885306226458603E-4
/*18*/, 65536 * 16 * 2.6660828860384193E-4
/*19*/, 65536 * 16 * 2.736061193417779E-4
/*20*/, 65536 * 16 * 2.79907587492226E-4
/*21*/, 65536 * 16 * 2.852884076207648E-4
/*22*/, 65536 * 16 * 2.898305905338908E-4
/*23*/, 65536 * 16 * 2.93305922863925E-4
/*24*/, 65536 * 16 * 2.958004341042564E-4
/*25*/, 65536 * 16 * 2.9706939623100196E-4
/*26*/, 65536 * 16 * 2.972508466837626E-4
/*27*/, 65536 * 16 * 2.960684730022295E-4
/*28*/, 65536 * 16 * 2.937123123731801E-4
/*29*/, 65536 * 16 * 2.898634667442807E-4
/*30*/, 65536 * 16 * 2.8478700978604426E-4
/*31*/, 65536 * 16 * 2.7808505097364714E-4
/*32*/, 65536 * 16 * 2.7016032300539216E-4
/*33*/, 65536 * 16 * 2.6042025835357706E-4
/*34*/, 65536 * 16 * 2.496053090718662E-4
/*35*/, 65536 * 16 * 2.3660011363209167E-4
/*36*/, 65536 * 16 * 2.228827056917728E-4
/*37*/, 65536 * 16 * 2.0662381151599093E-4
/*38*/, 65536 * 16 * 1.8946729340692708E-4
/*39*/, 65536 * 16 * 1.707894290302382E-4
/*40*/, 65536 * 16 * 1.4964075656329285E-4
/*41*/, 65536 * 16 * 1.2806315562352013E-4
/*42*/, 65536 * 16 * 1.0470129333132878E-4
/*43*/, 65536 * 16 * 7.952742687952367E-5
/*44*/, 65536 * 16 * 5.3080519892589936E-5
/*45*/, 65536 * 16 * 2.5960680465529317E-5
/*46*/, 65536 * 16 * -2.5651586484338896E-6
/*47*/, 65536 * 16 * -3.248840068536756E-5
/*48*/, 65536 * 16 * -6.374045088088799E-5
/*49*/, 65536 * 16 * -9.575401529845337E-5
/*50*/, 65536 * 16 * -1.2853435644071695E-4
/*51*/, 65536 * 16 * -1.6188456243132127E-4
/*52*/, 65536 * 16 * -1.9591394048834482E-4
/*53*/, 65536 * 16 * -2.3037663947407175E-4
/*54*/, 65536 * 16 * -2.6523734278928246E-4
/*55*/, 65536 * 16 * -3.0020331327926296E-4
/*56*/, 65536 * 16 * -3.352268879856044E-4
/*57*/, 65536 * 16 * -3.700260022275662E-4
/*58*/, 65536 * 16 * -4.045571559416333E-4
/*59*/, 65536 * 16 * -4.38534577720557E-4
/*60*/, 65536 * 16 * -4.718927645081437E-4
/*61*/, 65536 * 16 * -5.043317033789757E-4
/*62*/, 65536 * 16 * -5.357994753678582E-4
/*63*/, 65536 * 16 * -5.659671580788766E-4
/*64*/, 65536 * 16 * -5.947897013020397E-4
/*65*/, 65536 * 16 * -6.219384666963997E-4
/*66*/, 65536 * 16 * -6.473787936195385E-4
/*67*/, 65536 * 16 * -6.707514595741775E-4
/*68*/, 65536 * 16 * -6.920680579893526E-4
/*69*/, 65536 * 16 * -7.109402066802999E-4
/*70*/, 65536 * 16 * -7.274298271538291E-4
/*71*/, 65536 * 16 * -7.411375648954899E-4
/*72*/, 65536 * 16 * -7.520788343347275E-4
/*73*/, 65536 * 16 * -7.600510659768832E-4
/*74*/, 65536 * 16 * -7.647430899316486E-4
/*75*/, 65536 * 16 * -7.664294191482773E-4
/*76*/, 65536 * 16 * -7.644147173692687E-4
/*77*/, 65536 * 16 * -7.590920613362674E-4
/*78*/, 65536 * 16 * -7.501459543641885E-4
/*79*/, 65536 * 16 * -7.373621082253133E-4
/*80*/, 65536 * 16 * -7.208964561671388E-4
/*81*/, 65536 * 16 * -7.006901755632023E-4
/*82*/, 65536 * 16 * -6.764591748580997E-4
/*83*/, 65536 * 16 * -6.483697284795448E-4
/*84*/, 65536 * 16 * -6.164929718400197E-4
/*85*/, 65536 * 16 * -5.806918766677904E-4
/*86*/, 65536 * 16 * -5.409344735839229E-4
/*87*/, 65536 * 16 * -4.97405373620265E-4
/*88*/, 65536 * 16 * -4.502086002815554E-4
/*89*/, 65536 * 16 * -3.9932330033988294E-4
/*90*/, 65536 * 16 * -3.448028565721092E-4
/*91*/, 65536 * 16 * -2.8685420307046736E-4
/*92*/, 65536 * 16 * -2.256958038579715E-4
/*93*/, 65536 * 16 * -1.615040528190604E-4
/*94*/, 65536 * 16 * -9.438524808984473E-5
/*95*/, 65536 * 16 * -2.4519303584370608E-5
/*96*/, 65536 * 16 * 4.786961616483501E-5
/*97*/, 65536 * 16 * 1.2248011782462745E-4
/*98*/, 65536 * 16 * 1.990534978611127E-4
/*99*/, 65536 * 16 * 2.7728245405517893E-4
/*100*/, 65536 * 16 * 3.5690342407690407E-4
/*101*/, 65536 * 16 * 4.376002679601721E-4
/*102*/, 65536 * 16 * 5.19047629492113E-4
/*103*/, 65536 * 16 * 6.008846564336277E-4
/*104*/, 65536 * 16 * 6.827617063818499E-4
/*105*/, 65536 * 16 * 7.643160551093983E-4
/*106*/, 65536 * 16 * 8.451272011819538E-4
/*107*/, 65536 * 16 * 9.248890776355356E-4
/*108*/, 65536 * 16 * 0.001003072355955673
/*109*/, 65536 * 16 * 0.0010794672777372975
/*110*/, 65536 * 16 * 0.0011534276232606116
/*111*/, 65536 * 16 * 0.0012247823207262698
/*112*/, 65536 * 16 * 0.0012929541324917778
/*113*/, 65536 * 16 * 0.001357585199795128
/*114*/, 65536 * 16 * 0.001418338397346014
/*115*/, 65536 * 16 * 0.0014746734285279383
/*116*/, 65536 * 16 * 0.0015262884930771822
/*117*/, 65536 * 16 * 0.0015728226550844923
/*118*/, 65536 * 16 * 0.00161379655898045
/*119*/, 65536 * 16 * 0.001648915948444658
/*120*/, 65536 * 16 * 0.0016778840108713717
/*121*/, 65536 * 16 * 0.0017002560629258679
/*122*/, 65536 * 16 * 0.0017157641984855009
/*123*/, 65536 * 16 * 0.0017241805985007432
/*124*/, 65536 * 16 * 0.001725182645995729
/*125*/, 65536 * 16 * 0.0017184841648036691
/*126*/, 65536 * 16 * 0.0017039216808435336
/*127*/, 65536 * 16 * 0.001681334520841587
/*128*/, 65536 * 16 * 0.0016504918660173195
/*129*/, 65536 * 16 * 0.0016112687597971862
/*130*/, 65536 * 16 * 0.0015636063248128528
/*131*/, 65536 * 16 * 0.0015074624593932396
/*132*/, 65536 * 16 * 0.0014427699009003175
/*133*/, 65536 * 16 * 0.001369527394628539
/*134*/, 65536 * 16 * 0.0012878043567412672
/*135*/, 65536 * 16 * 0.0011977101442406943
/*136*/, 65536 * 16 * 0.0010993686954177168
/*137*/, 65536 * 16 * 9.928872878864818E-4
/*138*/, 65536 * 16 * 8.784941174786496E-4
/*139*/, 65536 * 16 * 7.564288883294911E-4
/*140*/, 65536 * 16 * 6.270372159510238E-4
/*141*/, 65536 * 16 * 4.905983779660314E-4
/*142*/, 65536 * 16 * 3.4754116793679786E-4
/*143*/, 65536 * 16 * 1.9816162887093084E-4
/*144*/, 65536 * 16 * 4.300342678121075E-5
/*145*/, 65536 * 16 *  -1.1751370467978956E-4
/*146*/, 65536 * 16 *  -2.8280605795854083E-4
/*147*/, 65536 * 16 *  -4.523173545514795E-4
/*148*/, 65536 * 16 *  -6.255041797790695E-4
/*149*/, 65536 * 16 *  -8.016355996557292E-4
/*150*/, 65536 * 16 *  -9.801573426762404E-4
/*151*/, 65536 * 16 *  -0.0011602954820678437
/*152*/, 65536 * 16 *  -0.001341343986206184
/*153*/, 65536 * 16 *  -0.001522571621631356
/*154*/, 65536 * 16 *  -0.001703172768158951
/*155*/, 65536 * 16 *  -0.0018823360844618293
/*156*/, 65536 * 16 *  -0.00205930337901632
/*157*/, 65536 * 16 *  -0.0022331579230920632
/*158*/, 65536 * 16 *  -0.002403069015327
/*159*/, 65536 * 16 *  -0.0025682175666884455
/*160*/, 65536 * 16 *  -0.002727682820990084
/*161*/, 65536 * 16 *  -0.002880584481539458
/*162*/, 65536 * 16 *  -0.003026077683940661
/*163*/, 65536 * 16 *  -0.00316326704154516
/*164*/, 65536 * 16 *  -0.003291235176827385
/*165*/, 65536 * 16 *  -0.0034091436232751705
/*166*/, 65536 * 16 *  -0.0035161624262765347
/*167*/, 65536 * 16 *  -0.00361139707788214
/*168*/, 65536 * 16 *  -0.0036940241232429707
/*169*/, 65536 * 16 *  -0.003763249197925811
/*170*/, 65536 * 16 *  -0.0038183138554794805
/*171*/, 65536 * 16 *  -0.003858413648517434
/*172*/, 65536 * 16 *  -0.0038828565696081884
/*173*/, 65536 * 16 *  -0.0038909308779192654
/*174*/, 65536 * 16 *  -0.0038820231307916493
/*175*/, 65536 * 16 *  -0.0038554750792844325
/*176*/, 65536 * 16 *  -0.003810737282493679
/*177*/, 65536 * 16 *  -0.003747262375484652
/*178*/, 65536 * 16 *  -0.0036646285078894706
/*179*/, 65536 * 16 *  -0.0035623728689170597
/*180*/, 65536 * 16 *  -0.0034401218523635543
/*181*/, 65536 * 16 *  -0.003297594128579178
/*182*/, 65536 * 16 *  -0.0031344918897463427
/*183*/, 65536 * 16 *  -0.0029506999116335536
/*184*/, 65536 * 16 *  -0.002746012743503227
/*185*/, 65536 * 16 *  -0.0025204082871514897
/*186*/, 65536 * 16 *  -0.0022738407863853822
/*187*/, 65536 * 16 *  -0.0020063873037173175
/*188*/, 65536 * 16 *  -0.0017182175415557032
/*189*/, 65536 * 16 *  -0.0014095092681882975
/*190*/, 65536 * 16 *  -0.0010805220633352567
/*191*/, 65536 * 16 *  -7.316077716348434E-4
/*192*/, 65536 * 16 *  -3.631468249678417E-4
/*193*/, 65536 * 16 * 2.438177178474359E-5
/*194*/, 65536 * 16 * 4.3040711526763105E-4
/*195*/, 65536 * 16 * 8.543758511240976E-4
/*196*/, 65536 * 16 * 0.0012955688715509065
/*197*/, 65536 * 16 * 0.0017532574138845757
/*198*/, 65536 * 16 * 0.0022266720975588176
/*199*/, 65536 * 16 * 0.0027149312534676365
/*200*/, 65536 * 16 * 0.003217102703811305
/*201*/, 65536 * 16 * 0.0037322302087511496
/*202*/, 65536 * 16 * 0.004259307964559864
/*203*/, 65536 * 16 * 0.004797205731205993
/*204*/, 65536 * 16 * 0.00534482556712745
/*205*/, 65536 * 16 * 0.00590099232932727
/*206*/, 65536 * 16 * 0.0064644836497811
/*207*/, 65536 * 16 * 0.007034017389280477
/*208*/, 65536 * 16 * 0.007608353016621833
/*209*/, 65536 * 16 * 0.008186157965561618
/*210*/, 65536 * 16 * 0.008766068964147668
/*211*/, 65536 * 16 * 0.009346716260147759
/*212*/, 65536 * 16 * 0.009926718862388615
/*213*/, 65536 * 16 * 0.010504681043184161
/*214*/, 65536 * 16 * 0.01107917387309342
/*215*/, 65536 * 16 * 0.011648797102049465
/*216*/, 65536 * 16 * 0.012212089485935572
/*217*/, 65536 * 16 * 0.012767702033610684
/*218*/, 65536 * 16 * 0.01331416222058608
/*219*/, 65536 * 16 * 0.013850107485964188
/*220*/, 65536 * 16 * 0.01437415626494087
/*221*/, 65536 * 16 * 0.01488494484218882
/*222*/, 65536 * 16 * 0.015381157046388828
/*223*/, 65536 * 16 * 0.015861470914555698
/*224*/, 65536 * 16 * 0.016324639468324405
/*225*/, 65536 * 16 * 0.01676942738258265
/*226*/, 65536 * 16 * 0.017194657140859698
/*227*/, 65536 * 16 * 0.01759919326505855
/*228*/, 65536 * 16 * 0.01798195744932672
/*229*/, 65536 * 16 * 0.018341882104229386
/*230*/, 65536 * 16 * 0.018678046774501487
/*231*/, 65536 * 16 * 0.018989525183852277
/*232*/, 65536 * 16 * 0.019275463483745325
/*233*/, 65536 * 16 * 0.019535099985330217
/*234*/, 65536 * 16 * 0.019767681230128092
/*235*/, 65536 * 16 * 0.019972616359274192
/*236*/, 65536 * 16 * 0.02014933369102741
/*237*/, 65536 * 16 * 0.020297350637687013
/*238*/, 65536 * 16 * 0.020416241350314838
/*239*/, 65536 * 16 * 0.020505719050281913
/*240*/, 65536 * 16 * 0.020565502954380747
/*241*/, 65536 * 16 * 0.02059542406883178
};


/* 44100 NTSC

Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.006695
Order: 483
Passband ripple: 0.2 dB
Transition band: 0.005625
Stopband attenuation: 66.4 dB

Coefficients:
*/

static int32 C44100NTSC[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 * 2.7250584077004043E-4
/*1*/, 65536 * 16 *  -5.6651407794062126E-5
/*2*/, 65536 * 16 *  -5.387595203270082E-5
/*3*/, 65536 * 16 *  -5.3104114528112036E-5
/*4*/, 65536 * 16 *  -5.3927905431407917E-5
/*5*/, 65536 * 16 *  -5.624810531844495E-5
/*6*/, 65536 * 16 *  -5.9753966587005594E-5
/*7*/, 65536 * 16 *  -6.443298022976466E-5
/*8*/, 65536 * 16 *  -7.002861393823279E-5
/*9*/, 65536 * 16 *  -7.658937335809571E-5
/*10*/, 65536 * 16 * -8.388337472693157E-5
/*11*/, 65536 * 16 * -9.20081628039712E-5
/*12*/, 65536 * 16 * -1.007311169050114E-4
/*13*/, 65536 * 16 * -1.1019992230503533E-4
/*14*/, 65536 * 16 * -1.2014773803429516E-4
/*15*/, 65536 * 16 * -1.3080398984366903E-4
/*16*/, 65536 * 16 * -1.4175865072457003E-4
/*17*/, 65536 * 16 * -1.536527853404198E-4
/*18*/, 65536 * 16 * -1.6517054562524376E-4
/*19*/, 65536 * 16 * -1.7797585116596963E-4
/*20*/, 65536 * 16 * -1.909845496405445E-4
/*21*/, 65536 * 16 * -2.0389566936141008E-4
/*22*/, 65536 * 16 * -2.1726846302640957E-4
/*23*/, 65536 * 16 * -2.310008165840215E-4
/*24*/, 65536 * 16 * -2.4506881863360544E-4
/*25*/, 65536 * 16 * -2.5926465655995895E-4
/*26*/, 65536 * 16 * -2.735381275272462E-4
/*27*/, 65536 * 16 * -2.878190904612406E-4
/*28*/, 65536 * 16 * -3.0209388781875723E-4
/*29*/, 65536 * 16 * -3.163448868528516E-4
/*30*/, 65536 * 16 * -3.30514980542584E-4
/*31*/, 65536 * 16 * -3.4458721564408845E-4
/*32*/, 65536 * 16 * -3.5843761692424506E-4
/*33*/, 65536 * 16 * -3.720823326733447E-4
/*34*/, 65536 * 16 * -3.8529611278848583E-4
/*35*/, 65536 * 16 * -3.982435971141635E-4
/*36*/, 65536 * 16 * -4.1054225307421383E-4
/*37*/, 65536 * 16 * -4.223385042208698E-4
/*38*/, 65536 * 16 * -4.3363210365443626E-4
/*39*/, 65536 * 16 * -4.440451096331875E-4
/*40*/, 65536 * 16 * -4.537334227294333E-4
/*41*/, 65536 * 16 * -4.6260960194346025E-4
/*42*/, 65536 * 16 * -4.706224417116799E-4
/*43*/, 65536 * 16 * -4.776010427698281E-4
/*44*/, 65536 * 16 * -4.8350610346281614E-4
/*45*/, 65536 * 16 * -4.8826489934975626E-4
/*46*/, 65536 * 16 * -4.918511387810396E-4
/*47*/, 65536 * 16 * -4.941839548845786E-4
/*48*/, 65536 * 16 * -4.95186572618022E-4
/*49*/, 65536 * 16 * -4.947817087436606E-4
/*50*/, 65536 * 16 * -4.928828353341973E-4
/*51*/, 65536 * 16 * -4.894676199661217E-4
/*52*/, 65536 * 16 * -4.8443244774343773E-4
/*53*/, 65536 * 16 * -4.778002134883142E-4
/*54*/, 65536 * 16 * -4.694896704084311E-4
/*55*/, 65536 * 16 * -4.593928438902496E-4
/*56*/, 65536 * 16 * -4.4763586771533415E-4
/*57*/, 65536 * 16 * -4.3399559196764174E-4
/*58*/, 65536 * 16 * -4.185187519793231E-4
/*59*/, 65536 * 16 * -4.0118338859945383E-4
/*60*/, 65536 * 16 * -3.820043675631783E-4
/*61*/, 65536 * 16 * -3.6090543967085524E-4
/*62*/, 65536 * 16 * -3.379128204177913E-4
/*63*/, 65536 * 16 * -3.130247503897743E-4
/*64*/, 65536 * 16 * -2.8628759491904673E-4
/*65*/, 65536 * 16 * -2.5769205396918157E-4
/*66*/, 65536 * 16 * -2.2726228845123853E-4
/*67*/, 65536 * 16 * -1.9501222414998665E-4
/*68*/, 65536 * 16 * -1.609903786128509E-4
/*69*/, 65536 * 16 * -1.2525258280646142E-4
/*70*/, 65536 * 16 * -8.786088130641809E-5
/*71*/, 65536 * 16 * -4.885883411475722E-5
/*72*/, 65536 * 16 * -8.373566315346232E-6
/*73*/, 65536 * 16 * 3.362843819360238E-5
/*74*/, 65536 * 16 * 7.69302822233031E-5
/*75*/, 65536 * 16 * 1.2151249228835434E-4
/*76*/, 65536 * 16 * 1.6724878315058612E-4
/*77*/, 65536 * 16 * 2.1402171363813576E-4
/*78*/, 65536 * 16 * 2.6167305946436103E-4
/*79*/, 65536 * 16 * 3.10122854445744E-4
/*80*/, 65536 * 16 * 3.5921866691687363E-4
/*81*/, 65536 * 16 * 4.0882826181233784E-4
/*82*/, 65536 * 16 * 4.5876834733749337E-4
/*83*/, 65536 * 16 * 5.089048509923103E-4
/*84*/, 65536 * 16 * 5.590621717784201E-4
/*85*/, 65536 * 16 * 6.090870406928206E-4
/*86*/, 65536 * 16 * 6.587768488216395E-4
/*87*/, 65536 * 16 * 7.079653533691067E-4
/*88*/, 65536 * 16 * 7.56434905175643E-4
/*89*/, 65536 * 16 * 8.040537989021466E-4
/*90*/, 65536 * 16 * 8.505576158388297E-4
/*91*/, 65536 * 16 * 8.958345533585908E-4
/*92*/, 65536 * 16 * 9.396170235698547E-4
/*93*/, 65536 * 16 * 9.817197600520506E-4
/*94*/, 65536 * 16 * 0.0010219440113723856
/*95*/, 65536 * 16 * 0.0010600976395277468
/*96*/, 65536 * 16 * 0.0010959465933076378
/*97*/, 65536 * 16 * 0.0011293213059753442
/*98*/, 65536 * 16 * 0.001160012212002378
/*99*/, 65536 * 16 * 0.0011878334518393636
/*100*/, 65536 * 16 * 0.0012125633172564833
/*101*/, 65536 * 16 * 0.0012340340153475305
/*102*/, 65536 * 16 * 0.0012520523486154733
/*103*/, 65536 * 16 * 0.001266464375255462
/*104*/, 65536 * 16 * 0.001277070934117742
/*105*/, 65536 * 16 * 0.0012837351142488396
/*106*/, 65536 * 16 * 0.0012862625405968798
/*107*/, 65536 * 16 * 0.0012845614834936406
/*108*/, 65536 * 16 * 0.0012784420593778636
/*109*/, 65536 * 16 * 0.0012678178114382621
/*110*/, 65536 * 16 * 0.0012525556826375537
/*111*/, 65536 * 16 * 0.0012325473943852084
/*112*/, 65536 * 16 * 0.0012077126268838676
/*113*/, 65536 * 16 * 0.0011779966448355029
/*114*/, 65536 * 16 * 0.0011433146771737655
/*115*/, 65536 * 16 * 0.0011036347058885887
/*116*/, 65536 * 16 * 0.0010589202139950945
/*117*/, 65536 * 16 * 0.0010091683044254098
/*118*/, 65536 * 16 * 9.543624468571229E-4
/*119*/, 65536 * 16 * 8.945398819399117E-4
/*120*/, 65536 * 16 * 8.297313883125644E-4
/*121*/, 65536 * 16 * 7.600155199968718E-4
/*122*/, 65536 * 16 * 6.854405952299358E-4
/*123*/, 65536 * 16 * 6.061236114458317E-4
/*124*/, 65536 * 16 * 5.221478191516476E-4
/*125*/, 65536 * 16 * 4.336813620599164E-4
/*126*/, 65536 * 16 * 3.408549526515998E-4
/*127*/, 65536 * 16 * 2.438450825114285E-4
/*128*/, 65536 * 16 * 1.428494911857926E-4
/*129*/, 65536 * 16 * 3.8067640594361634E-5
/*130*/, 65536 * 16 *  -7.027035111775681E-5
/*131*/, 65536 * 16 *  -1.818984143827126E-4
/*132*/, 65536 * 16 *  -2.9656343184630157E-4
/*133*/, 65536 * 16 *  -4.1397802421901906E-4
/*134*/, 65536 * 16 *  -5.33838500742085E-4
/*135*/, 65536 * 16 *  -6.558110253978588E-4
/*136*/, 65536 * 16 *  -7.795655816897978E-4
/*137*/, 65536 * 16 *  -9.047371821667003E-4
/*138*/, 65536 * 16 *  -0.001030961345825847
/*139*/, 65536 * 16 *  -0.0011578367988084777
/*140*/, 65536 * 16 *  -0.0012849810572319298
/*141*/, 65536 * 16 *  -0.0014119662266064482
/*142*/, 65536 * 16 *  -0.0015383759515758101
/*143*/, 65536 * 16 *  -0.001663756794188296
/*144*/, 65536 * 16 *  -0.0017876541594460456
/*145*/, 65536 * 16 *  -0.001909621722046808
/*146*/, 65536 * 16 *  -0.0020291786719378088
/*147*/, 65536 * 16 *  -0.002145855089743562
/*148*/, 65536 * 16 *  -0.002259171910476534
/*149*/, 65536 * 16 *  -0.0023686314802222655
/*150*/, 65536 * 16 *  -0.002473745572697707
/*151*/, 65536 * 16 *  -0.0025740277587192853
/*152*/, 65536 * 16 *  -0.0026689831666099955
/*153*/, 65536 * 16 *  -0.0027581124255643377
/*154*/, 65536 * 16 *  -0.0028409282136656177
/*155*/, 65536 * 16 *  -0.0029169432593640367
/*156*/, 65536 * 16 *  -0.002985680612410139
/*157*/, 65536 * 16 *  -0.003046658228485494
/*158*/, 65536 * 16 *  -0.003099414222252269
/*159*/, 65536 * 16 *  -0.0031434902530511595
/*160*/, 65536 * 16 *  -0.003178436798255356
/*161*/, 65536 * 16 *  -0.0032038260756887147
/*162*/, 65536 * 16 *  -0.003219225355080285
/*163*/, 65536 * 16 *  -0.0032242502222488744
/*164*/, 65536 * 16 *  -0.003218506103318342
/*165*/, 65536 * 16 *  -0.003201625222636992
/*166*/, 65536 * 16 *  -0.003173259488065382
/*167*/, 65536 * 16 *  -0.0031330803817718332
/*168*/, 65536 * 16 *  -0.0030807779128908526
/*169*/, 65536 * 16 *  -0.0030160821637947783
/*170*/, 65536 * 16 *  -0.0029387362752889335
/*171*/, 65536 * 16 *  -0.002848510131379585
/*172*/, 65536 * 16 *  -0.0027451998188029363
/*173*/, 65536 * 16 *  -0.00262863682904045
/*174*/, 65536 * 16 *  -0.0024986780420415064
/*175*/, 65536 * 16 *  -0.0023552114528323513
/*176*/, 65536 * 16 *  -0.0021981491527779964
/*177*/, 65536 * 16 *  -0.0020274504745732714
/*178*/, 65536 * 16 *  -0.0018430877753141852
/*179*/, 65536 * 16 *  -0.0016450910502005863
/*180*/, 65536 * 16 *  -0.0014334955802048866
/*181*/, 65536 * 16 *  -0.0012083983821827642
/*182*/, 65536 * 16 *  -9.699135443572468E-4
/*183*/, 65536 * 16 *  -7.181935207475589E-4
/*184*/, 65536 * 16 *  -4.534224887286362E-4
/*185*/, 65536 * 16 *  -1.758311300125605E-4
/*186*/, 65536 * 16 * 1.1433027008948132E-4
/*187*/, 65536 * 16 * 4.1675921199616097E-4
/*188*/, 65536 * 16 * 7.311320710094336E-4
/*189*/, 65536 * 16 * 0.0010570872458505827
/*190*/, 65536 * 16 * 0.0013942372682560795
/*191*/, 65536 * 16 * 0.001742148094642797
/*192*/, 65536 * 16 * 0.002100362793433286
/*193*/, 65536 * 16 * 0.0024683818857210646
/*194*/, 65536 * 16 * 0.002845695057494279
/*195*/, 65536 * 16 * 0.0032317385772924275
/*196*/, 65536 * 16 * 0.0036259433326630884
/*197*/, 65536 * 16 * 0.0040276894120370626
/*198*/, 65536 * 16 * 0.004436353627556968
/*199*/, 65536 * 16 * 0.004851271439526238
/*200*/, 65536 * 16 * 0.005271762758295799
/*201*/, 65536 * 16 * 0.005697120565601845
/*202*/, 65536 * 16 * 0.006126626859240469
/*203*/, 65536 * 16 * 0.006559527746778011
/*204*/, 65536 * 16 * 0.0069950693344747504
/*205*/, 65536 * 16 * 0.007432470090915211
/*206*/, 65536 * 16 * 0.007870944336430185
/*207*/, 65536 * 16 * 0.008309688701943495
/*208*/, 65536 * 16 * 0.008747898549370043
/*209*/, 65536 * 16 * 0.009184747205291654
/*210*/, 65536 * 16 * 0.009619414724898365
/*211*/, 65536 * 16 * 0.010051063453485451
/*212*/, 65536 * 16 * 0.010478876316671397
/*213*/, 65536 * 16 * 0.010902016899039163
/*214*/, 65536 * 16 * 0.011319665474466693
/*215*/, 65536 * 16 * 0.011730992134403782
/*216*/, 65536 * 16 * 0.012135186113163639
/*217*/, 65536 * 16 * 0.01253143889871197
/*218*/, 65536 * 16 * 0.012918956981226547
/*219*/, 65536 * 16 * 0.013296952886747157
/*220*/, 65536 * 16 * 0.013664665893392403
/*221*/, 65536 * 16 * 0.014021339353548561
/*222*/, 65536 * 16 * 0.014366244972764902
/*223*/, 65536 * 16 * 0.014698670942210527
/*224*/, 65536 * 16 * 0.015017930945351435
/*225*/, 65536 * 16 * 0.015323359168800435
/*226*/, 65536 * 16 * 0.015614322198635518
/*227*/, 65536 * 16 * 0.015890204972590742
/*228*/, 65536 * 16 * 0.016150433344740527
/*229*/, 65536 * 16 * 0.01639445378257351
/*230*/, 65536 * 16 * 0.016621758349582072
/*231*/, 65536 * 16 * 0.01683186471138077
/*232*/, 65536 * 16 * 0.01702432745775747
/*233*/, 65536 * 16 * 0.017198732908190056
/*234*/, 65536 * 16 * 0.017354710361561963
/*235*/, 65536 * 16 * 0.017491928210652433
/*236*/, 65536 * 16 * 0.017610096156964024
/*237*/, 65536 * 16 * 0.017708958417438553
/*238*/, 65536 * 16 * 0.017788304726419644
/*239*/, 65536 * 16 * 0.01784796484627723
/*240*/, 65536 * 16 * 0.017887808513528385
/*241*/, 65536 * 16 * 0.01790775243433271
};

/* 48000 PAL
Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.008810
Order: 483
Passband ripple: 0.133 dB
Transition band: 0.005625
Stopband attenuation: 63.0 dB

Coefficients:
*/
static int32 C48000PAL[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 *  -4.8720337170268194E-4
/*1*/, 65536 * 16 * 7.629902642634879E-7
/*2*/, 65536 * 16 * 2.1378369687164975E-6
/*3*/, 65536 * 16 * 4.2506426520122444E-6
/*4*/, 65536 * 16 * 7.369889860416342E-6
/*5*/, 65536 * 16 * 1.1216062943011637E-5
/*6*/, 65536 * 16 * 1.6073843505677063E-5
/*7*/, 65536 * 16 * 2.1633099120040373E-5
/*8*/, 65536 * 16 * 2.8206508485377597E-5
/*9*/, 65536 * 16 * 3.543629776593455E-5
/*10*/, 65536 * 16 * 4.368764327716006E-5
/*11*/, 65536 * 16 * 5.2518982409171E-5
/*12*/, 65536 * 16 * 6.239757141317561E-5
/*13*/, 65536 * 16 * 7.27096511997309E-5
/*14*/, 65536 * 16 * 8.417180660805913E-5
/*15*/, 65536 * 16 * 9.556951705928003E-5
/*16*/, 65536 * 16 * 1.0902571193097876E-4
/*17*/, 65536 * 16 * 1.227237340685471E-4
/*18*/, 65536 * 16 * 1.3608963828565135E-4
/*19*/, 65536 * 16 * 1.5074291732163737E-4
/*20*/, 65536 * 16 * 1.654957671774518E-4
/*21*/, 65536 * 16 * 1.8094544537755017E-4
/*22*/, 65536 * 16 * 1.9650254639058925E-4
/*23*/, 65536 * 16 * 2.124977005396817E-4
/*24*/, 65536 * 16 * 2.2850169154416925E-4
/*25*/, 65536 * 16 * 2.447269340662641E-4
/*26*/, 65536 * 16 * 2.60813097374866E-4
/*27*/, 65536 * 16 * 2.769089011403406E-4
/*28*/, 65536 * 16 * 2.926838284872595E-4
/*29*/, 65536 * 16 * 3.082587328683191E-4
/*30*/, 65536 * 16 * 3.233018169377691E-4
/*31*/, 65536 * 16 * 3.379664790017549E-4
/*32*/, 65536 * 16 * 3.520147829064225E-4
/*33*/, 65536 * 16 * 3.6489502104188965E-4
/*34*/, 65536 * 16 * 3.771837837785839E-4
/*35*/, 65536 * 16 * 3.8841744550992556E-4
/*36*/, 65536 * 16 * 3.985152578693797E-4
/*37*/, 65536 * 16 * 4.0737410559796126E-4
/*38*/, 65536 * 16 * 4.1485052511765913E-4
/*39*/, 65536 * 16 * 4.2087321591616255E-4
/*40*/, 65536 * 16 * 4.252880030529943E-4
/*41*/, 65536 * 16 * 4.2804175098790727E-4
/*42*/, 65536 * 16 * 4.289792011350111E-4
/*43*/, 65536 * 16 * 4.280677040429387E-4
/*44*/, 65536 * 16 * 4.251526022872329E-4
/*45*/, 65536 * 16 * 4.202312572840644E-4
/*46*/, 65536 * 16 * 4.1313629237647344E-4
/*47*/, 65536 * 16 * 4.0393669855985745E-4
/*48*/, 65536 * 16 * 3.9229544134295797E-4
/*49*/, 65536 * 16 * 3.785081882385653E-4
/*50*/, 65536 * 16 * 3.624387298611128E-4
/*51*/, 65536 * 16 * 3.439609793120755E-4
/*52*/, 65536 * 16 * 3.2317107312926493E-4
/*53*/, 65536 * 16 * 3.0001522643985015E-4
/*54*/, 65536 * 16 * 2.7456037312211196E-4
/*55*/, 65536 * 16 * 2.468022375847908E-4
/*56*/, 65536 * 16 * 2.1682011116032351E-4
/*57*/, 65536 * 16 * 1.846463359087917E-4
/*58*/, 65536 * 16 * 1.5038519581308458E-4
/*59*/, 65536 * 16 * 1.1409999503195986E-4
/*60*/, 65536 * 16 * 7.592602477010921E-5
/*61*/, 65536 * 16 * 3.594949037485983E-5
/*62*/, 65536 * 16 * -5.654205953473915E-6
/*63*/, 65536 * 16 * -4.8796158887641113E-5
/*64*/, 65536 * 16 * -9.324450907374415E-5
/*65*/, 65536 * 16 * -1.3875102646747199E-4
/*66*/, 65536 * 16 * -1.853099936736042E-4
/*67*/, 65536 * 16 * -2.3256519878196182E-4
/*68*/, 65536 * 16 * -2.803629983423417E-4
/*69*/, 65536 * 16 * -3.284299717573991E-4
/*70*/, 65536 * 16 * -3.7655572805983734E-4
/*71*/, 65536 * 16 * -4.244648731259925E-4
/*72*/, 65536 * 16 * -4.7191652130487173E-4
/*73*/, 65536 * 16 * -5.18626812434502E-4
/*74*/, 65536 * 16 * -5.64334322901072E-4
/*75*/, 65536 * 16 * -6.087503654593899E-4
/*76*/, 65536 * 16 * -6.515995849807032E-4
/*77*/, 65536 * 16 * -6.925935510204477E-4
/*78*/, 65536 * 16 * -7.314432865833455E-4
/*79*/, 65536 * 16 * -7.678735923848921E-4
/*80*/, 65536 * 16 * -8.015359919770463E-4
/*81*/, 65536 * 16 * -8.322768680565776E-4
/*82*/, 65536 * 16 * -8.597539203190856E-4
/*83*/, 65536 * 16 * -8.836879776280238E-4
/*84*/, 65536 * 16 * -9.038629010388075E-4
/*85*/, 65536 * 16 * -9.200080217158554E-4
/*86*/, 65536 * 16 * -9.319235257639778E-4
/*87*/, 65536 * 16 * -9.393690949611698E-4
/*88*/, 65536 * 16 * -9.421725179420662E-4
/*89*/, 65536 * 16 * -9.401299048871544E-4
/*90*/, 65536 * 16 * -9.33106896645869E-4
/*91*/, 65536 * 16 * -9.209400636174311E-4
/*92*/, 65536 * 16 * -9.035401279622776E-4
/*93*/, 65536 * 16 * -8.807854817776823E-4
/*94*/, 65536 * 16 * -8.526430615286829E-4
/*95*/, 65536 * 16 * -8.190296190822509E-4
/*96*/, 65536 * 16 * -7.799980167439345E-4
/*97*/, 65536 * 16 * -7.355478199155667E-4
/*98*/, 65536 * 16 * -6.8567697874281E-4
/*99*/, 65536 * 16 * -6.305240657493408E-4
/*100*/, 65536 * 16 *  -5.701694385732142E-4
/*101*/, 65536 * 16 *  -5.047740591296687E-4
/*102*/, 65536 * 16 *  -4.344980221283718E-4
/*103*/, 65536 * 16 *  -3.595556715693896E-4
/*104*/, 65536 * 16 *  -2.8017864491759883E-4
/*105*/, 65536 * 16 *  -1.9664106446578853E-4
/*106*/, 65536 * 16 *  -1.0924056590418239E-4
/*107*/, 65536 * 16 *  -1.831009861307028E-5
/*108*/, 65536 * 16 * 7.579029921420169E-5
/*109*/, 65536 * 16 * 1.726696848384902E-4
/*110*/, 65536 * 16 * 2.719067221880469E-4
/*111*/, 65536 * 16 * 3.7305728261123155E-4
/*112*/, 65536 * 16 * 4.7562651195605295E-4
/*113*/, 65536 * 16 * 5.791888527128953E-4
/*114*/, 65536 * 16 * 6.831673135667645E-4
/*115*/, 65536 * 16 * 7.870493762901182E-4
/*116*/, 65536 * 16 * 8.902822670362451E-4
/*117*/, 65536 * 16 * 9.923024258505538E-4
/*118*/, 65536 * 16 * 0.0010925350458368308
/*119*/, 65536 * 16 * 0.0011903898503065698
/*120*/, 65536 * 16 * 0.0012852771482304163
/*121*/, 65536 * 16 * 0.0013765956662458894
/*122*/, 65536 * 16 * 0.001463753120426749
/*123*/, 65536 * 16 * 0.001546148019165285
/*124*/, 65536 * 16 * 0.0016231971391851225
/*125*/, 65536 * 16 * 0.0016943089588603764
/*126*/, 65536 * 16 * 0.0017589264521182184
/*127*/, 65536 * 16 * 0.001816477825843157
/*128*/, 65536 * 16 * 0.001866465750234791
/*129*/, 65536 * 16 * 0.001908351881851273
/*130*/, 65536 * 16 * 0.0019416355874888774
/*131*/, 65536 * 16 * 0.0019658912100497094
/*132*/, 65536 * 16 * 0.0019806705540431754
/*133*/, 65536 * 16 * 0.001985602463070219
/*134*/, 65536 * 16 * 0.0019803173347810094
/*135*/, 65536 * 16 * 0.001964518487218229
/*136*/, 65536 * 16 * 0.00193792749109128
/*137*/, 65536 * 16 * 0.0019003361153152295
/*138*/, 65536 * 16 * 0.0018515636696845045
/*139*/, 65536 * 16 * 0.0017915008584460717
/*140*/, 65536 * 16 * 0.0017200735452676211
/*141*/, 65536 * 16 * 0.0016372830430278298
/*142*/, 65536 * 16 * 0.0015431709906056357
/*143*/, 65536 * 16 * 0.0014378573929982352
/*144*/, 65536 * 16 * 0.0013215084987890104
/*145*/, 65536 * 16 * 0.001194328283068528
/*146*/, 65536 * 16 * 0.0010566468386934231
/*147*/, 65536 * 16 * 9.088002025373218E-4
/*148*/, 65536 * 16 * 7.512135584215806E-4
/*149*/, 65536 * 16 * 5.843621536328689E-4
/*150*/, 65536 * 16 * 4.087894375795271E-4
/*151*/, 65536 * 16 * 2.2510227575334467E-4
/*152*/, 65536 * 16 * 3.396239791846655E-5
/*153*/, 65536 * 16 *  -1.6390294871759475E-4
/*154*/, 65536 * 16 *  -3.6771789280231503E-4
/*155*/, 65536 * 16 *  -5.766405458635558E-4
/*156*/, 65536 * 16 *  -7.897872933737203E-4
/*157*/, 65536 * 16 *  -0.001006209757480115
/*158*/, 65536 * 16 *  -0.0012249304977170316
/*159*/, 65536 * 16 *  -0.0014449054341312839
/*160*/, 65536 * 16 *  -0.0016650898600315796
/*161*/, 65536 * 16 *  -0.001884343774622382
/*162*/, 65536 * 16 *  -0.0021015342465919864
/*163*/, 65536 * 16 *  -0.0023154975831354337
/*164*/, 65536 * 16 *  -0.0025250324219407566
/*165*/, 65536 * 16 *  -0.0027289312457094736
/*166*/, 65536 * 16 *  -0.0029259546931934967
/*167*/, 65536 * 16 *  -0.003114871201398419
/*168*/, 65536 * 16 *  -0.003294430723892981
/*169*/, 65536 * 16 *  -0.003463396424710959
/*170*/, 65536 * 16 *  -0.003620525188769811
/*171*/, 65536 * 16 *  -0.0037645967189351955
/*172*/, 65536 * 16 *  -0.003894396916361478
/*173*/, 65536 * 16 *  -0.00400874728567525
/*174*/, 65536 * 16 *  -0.004106485394068385
/*175*/, 65536 * 16 *  -0.004186497692846864
/*176*/, 65536 * 16 *  -0.004247692032125654
/*177*/, 65536 * 16 *  -0.004289020763525844
/*178*/, 65536 * 16 *  -0.0043095197889136795
/*179*/, 65536 * 16 *  -0.004308238489219152
/*180*/, 65536 * 16 *  -0.004284317631022625
/*181*/, 65536 * 16 *  -0.0042369380515990835
/*182*/, 65536 * 16 *  -0.004165372803509635
/*183*/, 65536 * 16 *  -0.004068956516951112
/*184*/, 65536 * 16 *  -0.003947110543306579
/*185*/, 65536 * 16 *  -0.003799332887739826
/*186*/, 65536 * 16 *  -0.0036252122359255057
/*187*/, 65536 * 16 *  -0.0034244255727248728
/*188*/, 65536 * 16 *  -0.0031967441992062605
/*189*/, 65536 * 16 *  -0.0029420359603045624
/*190*/, 65536 * 16 *  -0.002660262473612329
/*191*/, 65536 * 16 *  -0.0023514913391939015
/*192*/, 65536 * 16 *  -0.002015874218170038
/*193*/, 65536 * 16 *  -0.0016537021922741356
/*194*/, 65536 * 16 *  -0.0012653326032471951
/*195*/, 65536 * 16 *  -8.512425489658283E-4
/*196*/, 65536 * 16 *  -4.12008134196091E-4
/*197*/, 65536 * 16 * 5.169160678832697E-5
/*198*/, 65536 * 16 * 5.3906734093252E-4
/*199*/, 65536 * 16 * 0.0010492444783799305
/*200*/, 65536 * 16 * 0.0015812369440962736
/*201*/, 65536 * 16 * 0.002133975437656693
/*202*/, 65536 * 16 * 0.002706284295633396
/*203*/, 65536 * 16 * 0.003296910987472264
/*204*/, 65536 * 16 * 0.0039045040922850343
/*205*/, 65536 * 16 * 0.004527645156076457
/*206*/, 65536 * 16 * 0.005164822580527953
/*207*/, 65536 * 16 * 0.00581446977998051
/*208*/, 65536 * 16 * 0.00647492818678252
/*209*/, 65536 * 16 * 0.007144495527005753
/*210*/, 65536 * 16 * 0.007821417135435386
/*211*/, 65536 * 16 * 0.008503870707064397
/*212*/, 65536 * 16 * 0.00919000676302643
/*213*/, 65536 * 16 * 0.009877917856582038
/*214*/, 65536 * 16 * 0.010565689475867907
/*215*/, 65536 * 16 * 0.011251366750588049
/*216*/, 65536 * 16 * 0.01193298816023733
/*217*/, 65536 * 16 * 0.012608574497468706
/*218*/, 65536 * 16 * 0.013276151008399953
/*219*/, 65536 * 16 * 0.013933744269275995
/*220*/, 65536 * 16 * 0.014579397589755912
/*221*/, 65536 * 16 * 0.015211171751139368
/*222*/, 65536 * 16 * 0.015827155422328678
/*223*/, 65536 * 16 * 0.01642547256780349
/*224*/, 65536 * 16 * 0.01700428326907068
/*225*/, 65536 * 16 * 0.017561819587529177
/*226*/, 65536 * 16 * 0.018096338432718698
/*227*/, 65536 * 16 * 0.018606183762999433
/*228*/, 65536 * 16 * 0.019089749497960648
/*229*/, 65536 * 16 * 0.019545523698532997
/*230*/, 65536 * 16 * 0.019972069058400564
/*231*/, 65536 * 16 * 0.02036803110561515
/*232*/, 65536 * 16 * 0.020732154475618856
/*233*/, 65536 * 16 * 0.021063275458886234
/*234*/, 65536 * 16 * 0.021360340738775345
/*235*/, 65536 * 16 * 0.02162239534537267
/*236*/, 65536 * 16 * 0.021848603142668337
/*237*/, 65536 * 16 * 0.02203823092181804
/*238*/, 65536 * 16 * 0.022190674411724294
/*239*/, 65536 * 16 * 0.022305434241445123
/*240*/, 65536 * 16 * 0.022382153728111424
/*241*/, 65536 * 16 * 0.022420574751016616
};

/* 44100 PAL
Parks-McClellan FIR Filter Design

Filter type: Low pass
Passband: 0 - 0.0076373
Order: 483
Passband ripple: 0.1 dB
Transition band: 0.005625
Stopband attenuation: 60.5 dB

Coefficients:
*/
static int32 C44100PAL[NCOEFFS / 2] =
{
/*0*/ 65536 * 16 * 5.793783958720019E-4
/*1*/, 65536 * 16 * 1.0571291666629312E-4
/*2*/, 65536 * 16 * 1.1459085882755871E-4
/*3*/, 65536 * 16 * 1.2371675029136968E-4
/*4*/, 65536 * 16 * 1.3275170325031607E-4
/*5*/, 65536 * 16 * 1.4207721167879995E-4
/*6*/, 65536 * 16 * 1.5130497600100568E-4
/*7*/, 65536 * 16 * 1.6077227873948047E-4
/*8*/, 65536 * 16 * 1.6990814771316866E-4
/*9*/, 65536 * 16 * 1.79005024990367E-4
/*10*/, 65536 * 16 * 1.8739246068939436E-4
/*11*/, 65536 * 16 * 1.9572039600801667E-4
/*12*/, 65536 * 16 * 2.0352846914404956E-4
/*13*/, 65536 * 16 * 2.1201116607443127E-4
/*14*/, 65536 * 16 * 2.188838839136502E-4
/*15*/, 65536 * 16 * 2.2495686284733203E-4
/*16*/, 65536 * 16 * 2.3149812422937834E-4
/*17*/, 65536 * 16 * 2.363635497444841E-4
/*18*/, 65536 * 16 * 2.410054979130104E-4
/*19*/, 65536 * 16 * 2.445286108284421E-4
/*20*/, 65536 * 16 * 2.474675828550653E-4
/*21*/, 65536 * 16 * 2.4934815214903343E-4
/*22*/, 65536 * 16 * 2.50372333906785E-4
/*23*/, 65536 * 16 * 2.501665763315339E-4
/*24*/, 65536 * 16 * 2.488750795254978E-4
/*25*/, 65536 * 16 * 2.4640153199411455E-4
/*26*/, 65536 * 16 * 2.428720291968876E-4
/*27*/, 65536 * 16 * 2.3801309032826844E-4
/*28*/, 65536 * 16 * 2.3160240772113682E-4
/*29*/, 65536 * 16 * 2.2423402291517938E-4
/*30*/, 65536 * 16 * 2.152856501527123E-4
/*31*/, 65536 * 16 * 2.0488674543318888E-4
/*32*/, 65536 * 16 * 1.9317919544163198E-4
/*33*/, 65536 * 16 * 1.7994016398005858E-4
/*34*/, 65536 * 16 * 1.6541109383681028E-4
/*35*/, 65536 * 16 * 1.4938382649739635E-4
/*36*/, 65536 * 16 * 1.3200975730094075E-4
/*37*/, 65536 * 16 * 1.1313240842725184E-4
/*38*/, 65536 * 16 * 9.296992728984174E-5
/*39*/, 65536 * 16 * 7.143010735440594E-5
/*40*/, 65536 * 16 * 4.8632764324109725E-5
/*41*/, 65536 * 16 * 2.443073549738759E-5
/*42*/, 65536 * 16 * -8.284349612349981E-7
/*43*/, 65536 * 16 * -2.7227387247375577E-5
/*44*/, 65536 * 16 * -5.4818038895146106E-5
/*45*/, 65536 * 16 * -8.330005435111118E-5
/*46*/, 65536 * 16 * -1.1275737974091186E-4
/*47*/, 65536 * 16 * -1.4298620796919756E-4
/*48*/, 65536 * 16 * -1.7390785487074508E-4
/*49*/, 65536 * 16 * -2.054308580401118E-4
/*50*/, 65536 * 16 * -2.37415521983132E-4
/*51*/, 65536 * 16 * -2.697456782629617E-4
/*52*/, 65536 * 16 * -3.022375619849705E-4
/*53*/, 65536 * 16 * -3.348339660959209E-4
/*54*/, 65536 * 16 * -3.673583086741243E-4
/*55*/, 65536 * 16 * -3.996554197363865E-4
/*56*/, 65536 * 16 * -4.3147108191834185E-4
/*57*/, 65536 * 16 * -4.6285023012872966E-4
/*58*/, 65536 * 16 * -4.934440989261961E-4
/*59*/, 65536 * 16 * -5.231720978150925E-4
/*60*/, 65536 * 16 * -5.518656107257292E-4
/*61*/, 65536 * 16 * -5.793049560550073E-4
/*62*/, 65536 * 16 * -6.053792205725333E-4
/*63*/, 65536 * 16 * -6.298765704841736E-4
/*64*/, 65536 * 16 * -6.526402738994988E-4
/*65*/, 65536 * 16 * -6.734722964365358E-4
/*66*/, 65536 * 16 * -6.922485843472661E-4
/*67*/, 65536 * 16 * -7.088111930758961E-4
/*68*/, 65536 * 16 * -7.229789042068006E-4
/*69*/, 65536 * 16 * -7.34572975483669E-4
/*70*/, 65536 * 16 * -7.435049180176613E-4
/*71*/, 65536 * 16 * -7.496258178311876E-4
/*72*/, 65536 * 16 * -7.527294926570751E-4
/*73*/, 65536 * 16 * -7.528075552986548E-4
/*74*/, 65536 * 16 * -7.496410435428715E-4
/*75*/, 65536 * 16 * -7.432054606042111E-4
/*76*/, 65536 * 16 * -7.33375741493331E-4
/*77*/, 65536 * 16 * -7.200753858529672E-4
/*78*/, 65536 * 16 * -7.03226653737734E-4
/*79*/, 65536 * 16 * -6.827921676621563E-4
/*80*/, 65536 * 16 * -6.58752773848678E-4
/*81*/, 65536 * 16 * -6.31061807229375E-4
/*82*/, 65536 * 16 * -5.997124150992168E-4
/*83*/, 65536 * 16 * -5.647352645065657E-4
/*84*/, 65536 * 16 * -5.261799041455252E-4
/*85*/, 65536 * 16 * -4.8402880277824417E-4
/*86*/, 65536 * 16 * -4.3840329475572E-4
/*87*/, 65536 * 16 * -3.893672279202991E-4
/*88*/, 65536 * 16 * -3.37002579326518E-4
/*89*/, 65536 * 16 * -2.8148278838384204E-4
/*90*/, 65536 * 16 * -2.2288467365854118E-4
/*91*/, 65536 * 16 * -1.6140368454103024E-4
/*92*/, 65536 * 16 * -9.718648150744015E-5
/*93*/, 65536 * 16 * -3.046343268277719E-5
/*94*/, 65536 * 16 * 3.859234051837562E-5
/*95*/, 65536 * 16 * 1.0974328274324426E-4
/*96*/, 65536 * 16 * 1.8273974279995372E-4
/*97*/, 65536 * 16 * 2.5730055402762935E-4
/*98*/, 65536 * 16 * 3.3318458939353874E-4
/*99*/, 65536 * 16 * 4.100891270013777E-4
/*100*/, 65536 * 16 * 4.876860015464126E-4
/*101*/, 65536 * 16 * 5.657011755504638E-4
/*102*/, 65536 * 16 * 6.437547403393535E-4
/*103*/, 65536 * 16 * 7.215350856659516E-4
/*104*/, 65536 * 16 * 7.986901321007353E-4
/*105*/, 65536 * 16 * 8.748424228508639E-4
/*106*/, 65536 * 16 * 9.496338070297501E-4
/*107*/, 65536 * 16 * 0.0010226804298925178
/*108*/, 65536 * 16 * 0.001093633836878271
/*109*/, 65536 * 16 * 0.0011620773771650913
/*110*/, 65536 * 16 * 0.001227641045409496
/*111*/, 65536 * 16 * 0.0012899374110895208
/*112*/, 65536 * 16 * 0.001348607725415767
/*113*/, 65536 * 16 * 0.001403236086962171
/*114*/, 65536 * 16 * 0.0014534904370406968
/*115*/, 65536 * 16 * 0.0014989864777827345
/*116*/, 65536 * 16 * 0.0015393672007052272
/*117*/, 65536 * 16 * 0.0015743174329729173
/*118*/, 65536 * 16 * 0.0016034756800234508
/*119*/, 65536 * 16 * 0.0016265420570988364
/*120*/, 65536 * 16 * 0.0016432110467175217
/*121*/, 65536 * 16 * 0.0016532197970121178
/*122*/, 65536 * 16 * 0.0016562968359550962
/*123*/, 65536 * 16 * 0.0016521969919585549
/*124*/, 65536 * 16 * 0.001640721606064916
/*125*/, 65536 * 16 * 0.001621678045313759
/*126*/, 65536 * 16 * 0.0015948992297934834
/*127*/, 65536 * 16 * 0.0015602457924787695
/*128*/, 65536 * 16 * 0.0015176354451292787
/*129*/, 65536 * 16 * 0.0014669598890367775
/*130*/, 65536 * 16 * 0.001408218899058892
/*131*/, 65536 * 16 * 0.001341376545671481
/*132*/, 65536 * 16 * 0.0012664621369705463
/*133*/, 65536 * 16 * 0.0011835425953369801
/*134*/, 65536 * 16 * 0.0010927146027981068
/*135*/, 65536 * 16 * 9.941150953832762E-4
/*136*/, 65536 * 16 * 8.878982163088053E-4
/*137*/, 65536 * 16 * 7.742911468907501E-4
/*138*/, 65536 * 16 * 6.535350381595103E-4
/*139*/, 65536 * 16 * 5.259114487251054E-4
/*140*/, 65536 * 16 * 3.9173611703422796E-4
/*141*/, 65536 * 16 * 2.513813444320677E-4
/*142*/, 65536 * 16 * 1.0522988594595334E-4
/*143*/, 65536 * 16 *  -4.627799877161863E-5
/*144*/, 65536 * 16 *  -2.0266153878465397E-4
/*145*/, 65536 * 16 *  -3.6344539072942917E-4
/*146*/, 65536 * 16 *  -5.28061484912101E-4
/*147*/, 65536 * 16 *  -6.959549845043866E-4
/*148*/, 65536 * 16 *  -8.665108935058429E-4
/*149*/, 65536 * 16 *  -0.0010391137133997624
/*150*/, 65536 * 16 *  -0.001213088248571412
/*151*/, 65536 * 16 *  -0.0013877438142645866
/*152*/, 65536 * 16 *  -0.0015623746142961936
/*153*/, 65536 * 16 *  -0.001736242850147973
/*154*/, 65536 * 16 *  -0.0019085899496564314
/*155*/, 65536 * 16 *  -0.002078639823528187
/*156*/, 65536 * 16 *  -0.0022456104279907118
/*157*/, 65536 * 16 *  -0.002408678368623706
/*158*/, 65536 * 16 *  -0.002567052121352872
/*159*/, 65536 * 16 *  -0.0027198956481072887
/*160*/, 65536 * 16 *  -0.0028663750213148488
/*161*/, 65536 * 16 *  -0.0030056713494924794
/*162*/, 65536 * 16 *  -0.0031369487365098063
/*163*/, 65536 * 16 *  -0.0032593909953083865
/*164*/, 65536 * 16 *  -0.0033721594370116153
/*165*/, 65536 * 16 *  -0.0034744643621211356
/*166*/, 65536 * 16 *  -0.0035654990231207963
/*167*/, 65536 * 16 *  -0.003644488024347632
/*168*/, 65536 * 16 *  -0.0037106644342197828
/*169*/, 65536 * 16 *  -0.0037632989436418352
/*170*/, 65536 * 16 *  -0.00380166827783197
/*171*/, 65536 * 16 *  -0.0038250950477227447
/*172*/, 65536 * 16 *  -0.0038329329853570827
/*173*/, 65536 * 16 *  -0.0038245430145814447
/*174*/, 65536 * 16 *  -0.0037993625516763766
/*175*/, 65536 * 16 *  -0.003756842883124589
/*176*/, 65536 * 16 *  -0.0036964913119694686
/*177*/, 65536 * 16 *  -0.0036178458358447655
/*178*/, 65536 * 16 *  -0.00352050628243193
/*179*/, 65536 * 16 *  -0.003404123578517079
/*180*/, 65536 * 16 *  -0.003268383375473133
/*181*/, 65536 * 16 *  -0.0031130454148921446
/*182*/, 65536 * 16 *  -0.002937909773123352
/*183*/, 65536 * 16 *  -0.0027428475146560275
/*184*/, 65536 * 16 *  -0.0025277729297779944
/*185*/, 65536 * 16 *  -0.0022926869206439508
/*186*/, 65536 * 16 *  -0.0020376141174133374
/*187*/, 65536 * 16 *  -0.0017626719756025908
/*188*/, 65536 * 16 *  -0.0014680351622130402
/*189*/, 65536 * 16 *  -0.0011539297872750212
/*190*/, 65536 * 16 *  -8.206567501069872E-4
/*191*/, 65536 * 16 *  -4.685710694984321E-4
/*192*/, 65536 * 16 *  -9.811116382477182E-5
/*193*/, 65536 * 16 * 2.902488429495873E-4
/*194*/, 65536 * 16 * 6.959516881166062E-4
/*195*/, 65536 * 16 * 0.0011183883405789612
/*196*/, 65536 * 16 * 0.0015568865209671754
/*197*/, 65536 * 16 * 0.0020107155705137744
/*198*/, 65536 * 16 * 0.002479084293281152
/*199*/, 65536 * 16 * 0.002961149037985776
/*200*/, 65536 * 16 * 0.0034560223628435746
/*201*/, 65536 * 16 * 0.0039627343373741354
/*202*/, 65536 * 16 * 0.0044803036416812955
/*203*/, 65536 * 16 * 0.005007678185806692
/*204*/, 65536 * 16 * 0.00554377521563058
/*205*/, 65536 * 16 * 0.006087456836491167
/*206*/, 65536 * 16 * 0.006637561024809676
/*207*/, 65536 * 16 * 0.007192890398414245
/*208*/, 65536 * 16 * 0.0077522050201042055
/*209*/, 65536 * 16 * 0.008314254820045306
/*210*/, 65536 * 16 * 0.008877749982246051
/*211*/, 65536 * 16 * 0.009441393781470539
/*212*/, 65536 * 16 * 0.010003862886118781
/*213*/, 65536 * 16 * 0.01056383933598836
/*214*/, 65536 * 16 * 0.011119972235266088
/*215*/, 65536 * 16 * 0.011670924253482212
/*216*/, 65536 * 16 * 0.012215363764388693
/*217*/, 65536 * 16 * 0.012751945584822125
/*218*/, 65536 * 16 * 0.013279348664168343
/*219*/, 65536 * 16 * 0.013796251849197938
/*220*/, 65536 * 16 * 0.0143013718962506
/*221*/, 65536 * 16 * 0.014793420656675483
/*222*/, 65536 * 16 * 0.015271157641252524
/*223*/, 65536 * 16 * 0.015733358657288442
/*224*/, 65536 * 16 * 0.016178837288118402
/*225*/, 65536 * 16 * 0.016606446422463023
/*226*/, 65536 * 16 * 0.01701507865820779
/*227*/, 65536 * 16 * 0.017403671672970734
/*228*/, 65536 * 16 * 0.01777119975394863
/*229*/, 65536 * 16 * 0.018116717572056962
/*230*/, 65536 * 16 * 0.01843930362202181
/*231*/, 65536 * 16 * 0.01873811058717855
/*232*/, 65536 * 16 * 0.01901234584784063
/*233*/, 65536 * 16 * 0.019261287195027194
/*234*/, 65536 * 16 * 0.019484271195397335
/*235*/, 65536 * 16 * 0.0196806998422779
/*236*/, 65536 * 16 * 0.019850058102456474
/*237*/, 65536 * 16 * 0.019991882444368586
/*238*/, 65536 * 16 * 0.0201058042761605
/*239*/, 65536 * 16 * 0.02019151207246131
/*240*/, 65536 * 16 * 0.02024878178965319
/*241*/, 65536 * 16 * 0.020277449712345474
};


#endif
