/* Quick conversion stuff for MAME->FCE Ultra */

#include <stdio.h>
#include "../fceu-types.h"
#include "../palette.h"
#include "palettes.h"

/* check 0x08 */
static uint8 rp2c04001_colortable[] =
{
	0x35, 0x23, 0x16, 0x22, 0x1c, 0x09, 0xff, 0x15,     /* 0x00 - 0x07 */
	0x20, 0x00, 0x27, 0x05, 0x04, 0x27, 0x08, 0x30,     /* 0x08 - 0x0f */
	0x21, 0xff, 0xff, 0x29, 0x3c, 0x32, 0x36, 0x12,     /* 0x10 - 0x17 */
	0xff, 0x2b, 0x0f, 0xff, 0x20, 0x10, 0x24, 0x01,     /* 0x18 - 0x1f */
	0xff, 0x31, 0xff, 0x2a, 0x2c, 0x0c, 0xff, 0xff,     /* 0x20 - 0x27 */
	0xff, 0x07, 0x34, 0x06, 0x13, 0x02, 0x26, 0x0f,     /* 0x28 - 0x2f */
	0xff, 0x19, 0x10, 0x0a, 0x39, 0xff, 0x37, 0x17,     /* 0x30 - 0x37 */
	0xff, 0x11, 0x09, 0xff, 0x39, 0x25, 0x18, 0xff      /* 0x38 - 0x3f */
};

/* RP2C04-002 */
static uint8 rp2c04002_colortable[] =
{
	0x0f, 0x27, 0x18, 0xff, 0x3a, 0x25, 0xff, 0x31,     /* 0x00 - 0x07 */
	0x16, 0x13, 0x38, 0x34, 0x20, 0x23, 0xff, 0x0b,     /* 0x08 - 0x0f */
	0xff, 0x21, 0x06, 0xff, 0x1b, 0x29, 0xff, 0x22,     /* 0x10 - 0x17 */
	0xff, 0x24, 0xff, 0x2b, 0xff, 0x08, 0xff, 0x03,     /* 0x18 - 0x1f */
	0xff, 0x36, 0x26, 0x33, 0x11, 0xff, 0x10, 0x02,     /* 0x20 - 0x27 */
	0x14, 0xff, 0x00, 0x09, 0x12, 0x0f, 0x37, 0x30,     /* 0x28 - 0x2f */
	0xff, 0xff, 0x2a, 0x17, 0x0c, 0x01, 0x15, 0x19,     /* 0x30 - 0x37 */
	0xff, 0x2c, 0x07, 0x37, 0xff, 0x05, 0x0a, 0x00      /* 0x38 - 0x3f */
};

/* RP2C04-003 */
/* Check 0x00.  Used in Dr Mario. */
static uint8 rp2c04003_colortable[] =
{
	0x03, 0xff, 0xff, 0x00, 0x1a, 0x30, 0x31, 0x09,     /* 0x00 - 0x07 */
	0x01, 0x0f, 0x36, 0x08, 0x15, 0xff, 0xff, 0x30,     /* 0x08 - 0x0f */
	0x22, 0x1c, 0xff, 0x12, 0x19, 0x18, 0x17, 0x1b,     /* 0x10 - 0x17 */
	0x00, 0xff, 0xff, 0x02, 0x16, 0x06, 0xff, 0x35,     /* 0x18 - 0x1f */
	0x23, 0xff, 0x0f, 0x37, 0xff, 0x27, 0x26, 0x30,     /* 0x20 - 0x27 */
	0x29, 0xff, 0x21, 0x24, 0x11, 0xff, 0x0f, 0xff,     /* 0x28 - 0x2f */
	0x2c, 0xff, 0xff, 0xff, 0x07, 0x2a, 0x28, 0xff,     /* 0x30 - 0x37 */
	0x0a, 0xff, 0x32, 0x37, 0x13, 0xff, 0xff, 0x0c      /* 0x38 - 0x3f */
};

/* RP2C05-004 */
/* check 0x1d, 0x38 */
static uint8 rp2c05004_colortable[] =
{
	0x18, 0xff, 0x1c, 0x28, 0xff, 0xff, 0x01, 0x17,     /* 0x00 - 0x07 */
	0x10, 0x0f, 0x2a, 0x0f, 0x36, 0x37, 0x1a, 0xff,     /* 0x08 - 0x0f */
	0x25, 0xff, 0x12, 0xff, 0x0f, 0xff, 0xff, 0x26,     /* 0x10 - 0x17 */
	0xff, 0xff, 0x22, 0x19, 0xff, 0x0f, 0x3a, 0x21,     /* 0x18 - 0x1f */
	0x05, 0x0a, 0x07, 0x01, 0x13, 0xff, 0x00, 0x15,     /* 0x20 - 0x27 */
	0x0c, 0xff, 0x11, 0xff, 0xff, 0x38, 0xff, 0xff,     /* 0x28 - 0x2f */
	0xff, 0xff, 0x08, 0x16, 0xff, 0xff, 0x30, 0x3c,     /* 0x30 - 0x37 */
	0x0f, 0x27, 0xff, 0x31, 0x29, 0xff, 0x30, 0x09      /* 0x38 - 0x3f */
};


main() {
	int x;
	for (x = 0; x < 64; x++) {
		// if(x <= 0x20)
//  if(rp2c04002_colortable[x] == 0xFF) rp2c04002_colortable[x]= 0x30;
		printf("{0x%02x, 0x%02x, 0x%02x},\n", palette[rp2c04001_colortable[x] & 0x3F].r,
			   palette[rp2c04001_colortable[x] & 0x3F].g,
			   palette[rp2c04001_colortable[x] & 0x3F].b);
	}
}
