#!/bin/bash

# functions
function printTitle() {
    echo
    echo "################################################################"
    echo "###   CYBER Wired Controller LITE Update Tool - udev rules   ###"
    echo "################################################################"
    echo 
}

function printDone() {
    echo
    echo "################################################################"
    echo "###      CYBER Wired Controller LITE Update Tool - done      ###"
    echo "################################################################"
    echo
}

function printErrorRoot() {
    echo "The udev rule could not be created."
    echo "Please run the scrip as root."
}

function printInfo() {
    echo "The rule for the CYBER Wired Controller LITE was successfully installed."
    echo "In order for the new rule to work you need to reboot your computer."
}

function printRebootYes() {
    echo "You selected to reboot now."
    echo "The computer will reboot in 10 seconds."
}

function printRebootNo() {
    echo "You selected to reboot later."
    echo "Remember to reboot your computer before using the CYBER Wired Controller LITE Update Tool."
}
# functions

# script
printTitle

if [ "$EUID" -ne 0 ]
  then
    printErrorRoot
    printDone
  exit
fi

echo "ATTR{idVendor}==\"0413\", ATTR{idProduct}==\"5040\", MODE+=\"666\"" > /etc/udev/rules.d/CYBER_Wired_Controller_LITE_Update.rules

printInfo

echo
read -p "Do you want to reboot the computer now? (Yy/Nn): " -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]
then
    printRebootYes
    printDone
    sleep 10
    reboot
else
    printRebootNo
    printDone
fi
# script
