/*
 * Driver for OV5642 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/videodev2.h>
#include <linux/slab.h>
#include <linux/i2c.h>
#include <linux/log2.h>
#include <linux/platform_device.h>
#include <linux/delay.h>
#include <linux/circ_buf.h>
#include <linux/hardirq.h>
#include <linux/miscdevice.h>
#include <asm/io.h>

#include <media/v4l2-common.h>
#include <media/v4l2-chip-ident.h>
#include <media/soc_camera.h>
#include <plat/rk_camera.h>
#include "mt9p111.h"

static int debug;
module_param(debug, int, S_IRUGO|S_IWUSR);

#define dprintk(level, fmt, arg...) do {			\
	if (debug >= level) 					\
	printk(KERN_WARNING fmt , ## arg); } while (0)

#define SENSOR_TR(format, ...) printk(KERN_ERR format, ## __VA_ARGS__)
#define SENSOR_DG(format, ...) dprintk(1, format, ## __VA_ARGS__)

#define _CONS(a,b) a##b
#define CONS(a,b) _CONS(a,b)

#define __STR(x) #x
#define _STR(x) __STR(x)
#define STR(x) _STR(x)

#define MIN(x,y)   ((x<y) ? x: y)
#define MAX(x,y)    ((x>y) ? x: y)

/* Sensor Driver Configuration */
#define SENSOR_NAME RK29_CAM_SENSOR_MT9P111
#define SENSOR_V4L2_IDENT V4L2_IDENT_MT9P111
#define SENSOR_ID SEQUENCE_END
#define SENSOR_ID_REG SEQUENCE_END
#define SENSOR_RESET_REG 0x0010
#define SENSOR_RESET_VAL 0x0115
#define SENSOR_RESET_REG_LEN  WORD_LEN
#define SENSOR_MIN_WIDTH    176
#define SENSOR_MIN_HEIGHT   144
#define SENSOR_MAX_WIDTH    2592
#define SENSOR_MAX_HEIGHT   1944
#define SENSOR_INIT_WIDTH	640			/* Sensor pixel size for sensor_init_data array */
#define SENSOR_INIT_HEIGHT  480
#define SENSOR_INIT_WINSEQADR sensor_vga
#define SENSOR_INIT_PIXFMT  V4L2_MBUS_FMT_UYVY8_2X8
#define YUV420_BUFFER_MAX_SIZE  7558272     /* 2592*1944*1.5*/ 

#define CONFIG_SENSOR_WhiteBalance	1
#define CONFIG_SENSOR_Brightness	0
#define CONFIG_SENSOR_Contrast      0
#define CONFIG_SENSOR_Saturation    0
#define CONFIG_SENSOR_Effect        1
#define CONFIG_SENSOR_Scene         1
#define CONFIG_SENSOR_DigitalZoom   0
#define CONFIG_SENSOR_Exposure      0
#define CONFIG_SENSOR_Flash         1
#define CONFIG_SENSOR_Mirror        0
#define CONFIG_SENSOR_Flip          1
#define CONFIG_SENSOR_Focus         1


#define CONFIG_SENSOR_I2C_SPEED     100000       /* Hz */
//#define CONFIG_SENSOR_I2C_SPEED   350000       /* Hz */
   
/* Sensor write register continues by preempt_disable/preempt_enable for current process not be scheduled */
#define CONFIG_SENSOR_I2C_NOSCHED   0
#define CONFIG_SENSOR_I2C_RDWRCHK   0


#define SENSOR_BUS_PARAM  (SOCAM_MASTER | SOCAM_PCLK_SAMPLE_RISING|\
                          SOCAM_HSYNC_ACTIVE_HIGH | SOCAM_VSYNC_ACTIVE_HIGH|\
                          SOCAM_DATA_ACTIVE_HIGH | SOCAM_DATAWIDTH_8  |SOCAM_MCLK_24MHZ)

#define COLOR_TEMPERATURE_CLOUDY_DN    6500
#define COLOR_TEMPERATURE_CLOUDY_UP    8000
#define COLOR_TEMPERATURE_CLEARDAY_DN  5000
#define COLOR_TEMPERATURE_CLEARDAY_UP    6500
#define COLOR_TEMPERATURE_OFFICE_DN     3500
#define COLOR_TEMPERATURE_OFFICE_UP     5000
#define COLOR_TEMPERATURE_HOME_DN       2500
#define COLOR_TEMPERATURE_HOME_UP       3500

#define SENSOR_NAME_STRING(a) STR(CONS(SENSOR_NAME, a))
#define SENSOR_NAME_VARFUN(a) CONS(SENSOR_NAME, a)

#define SENSOR_AF_IS_ERR    (0x00<<0)
#define SENSOR_AF_IS_OK		(0x01<<0)
#define SENSOR_INIT_IS_ERR   (0x00<<28)
#define SENSOR_INIT_IS_OK    (0x01<<28)



#if CONFIG_SENSOR_Focus
#define SENSOR_AF_MODE_INFINITY    0
#define SENSOR_AF_MODE_MACRO       1
#define SENSOR_AF_MODE_FIXED       2
#define SENSOR_AF_MODE_AUTO        3
#define SENSOR_AF_MODE_CONTINUOUS  4
#define SENSOR_AF_MODE_CLOSE       5
#endif

//flash off in fixed time to prevent from too hot , zyc
struct  flash_timer{
    struct soc_camera_device *icd;
	struct hrtimer timer;
};
static enum hrtimer_restart flash_off_func(struct hrtimer *timer);

static struct  flash_timer flash_off_timer;
//for user defined if user want to customize the series , zyc
#ifdef CONFIG_MT9P111_USER_DEFINED_SERIES
#include "mt9p111_user_series.c"
#else

/* init 640X480 VGA */
static struct reginfo sensor_init_data[] =
{
//[Step2-PLL_Timing]
//for 24MHz input, VCO=MAX=768mhz  
{ 0x0010, 0x0340, WORD_LEN, 0},
/*sovle problem that lack of pclk during one href*/
#if  ADJUST_PCLK_FRE_FALG
{ 0x0012, 0x0080, WORD_LEN, 0},     //PCLK=85MHz
#else
{ 0x0012, 0x0090, WORD_LEN, 0},     //PCLK=76MHz
#endif
{ 0x0014, 0x2025, WORD_LEN, 0},
{ 0x001E, 0x0565, WORD_LEN, 0},    // PAD_SLEW_PAD_CONFIG
{ 0x0022, 0x0030, WORD_LEN, 0},   //0x01E0// VDD_DIS_COUNTER
#if   ADJUST_PCLK_FRE_FALG
{ 0x002A, 0x7FFF, WORD_LEN, 0},  
#else
{ 0x002A, 0x7F7E, WORD_LEN, 0},   //0x7F7F// PLL_P4_P5_P6_DIVIDERS By Hwang 20101104
#endif
{ 0x002C, 0x0000, WORD_LEN, 0}, 	// PLL_P7_DIVIDER
{ 0x002E, 0x0000, WORD_LEN, 0}, 	// SENSOR_CLOCK_DIVIDER
{ 0x0018, 0x4008, WORD_LEN, 0}, 	// STANDBY_CONTROL_AND_STATUS
//////{ SEQUENCE_WAIT_MS,100,WORD_LEN, 0},
{ SEQUENCE_WAIT_MS,20,WORD_LEN, 0},
//timing_settings
{ 0x0010, 0x0340, WORD_LEN, 0}, 	// PLL_DIVIDERS
{ 0x098E, 0x483A, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [CAM_CORE_A_Y_ADDR_START]
{ 0xC83A, 0x000C, WORD_LEN, 0}, 	// CAM_CORE_A_Y_ADDR_START
{ 0xC83C, 0x0018, WORD_LEN, 0}, 	// CAM_CORE_A_X_ADDR_START
{ 0xC83E, 0x07B1, WORD_LEN, 0}, 	// CAM_CORE_A_Y_ADDR_END
{ 0xC840, 0x0A45, WORD_LEN, 0}, 	// CAM_CORE_A_X_ADDR_END
{ 0xC842, 0x0001, WORD_LEN, 0}, 	// CAM_CORE_A_ROW_SPEED
{ 0xC844, 0x0103, WORD_LEN, 0}, 	// CAM_CORE_A_SKIP_X_CORE
{ 0xC846, 0x0103, WORD_LEN, 0}, 	// CAM_CORE_A_SKIP_Y_CORE
{ 0xC848, 0x0103, WORD_LEN, 0}, 	// CAM_CORE_A_SKIP_X_PIPE
{ 0xC84A, 0x0103, WORD_LEN, 0}, 	// CAM_CORE_A_SKIP_Y_PIPE
{ 0xC84C, 0x00F6, WORD_LEN, 0}, 	// CAM_CORE_A_POWER_MODE
{ 0xC84E, 0x0001, WORD_LEN, 0}, 	// CAM_CORE_A_BIN_MODE
/*lzg@rock-chips.com, FIH:preview image to be mirrored and flipped */
#if CONFIG_SENSOR_NONE_FLIP_MIRROR
{ 0xC850, 0x00, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_MIRROR
{ 0xC850, 0x01, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_FLIPE
{ 0xC850, 0x02, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_MIRROR_AND_FLIPE
{ 0xC850, 0x03, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#endif
{ 0xC851, 0x00, BYTE_LEN, 0}, 	    // CAM_CORE_A_PIXEL_ORDER
{ 0xC852, 0x019C, WORD_LEN, 0}, 	// CAM_CORE_A_FINE_CORRECTION
{ 0xC854, 0x0732, WORD_LEN, 0}, 	// CAM_CORE_A_FINE_ITMIN
{ 0xC858, 0x0000, WORD_LEN, 0}, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC85A, 0x0001, WORD_LEN, 0}, 	// CAM_CORE_A_COARSE_ITMAX_MARGIN
{ 0xC85C, 0x0423, WORD_LEN, 0}, 	// CAM_CORE_A_MIN_FRAME_LENGTH_LINES
{ 0xC85E, 0xFFFF, WORD_LEN, 0}, 	// CAM_CORE_A_MAX_FRAME_LENGTH_LINS
{ 0xC860, 0x0423, WORD_LEN, 0}, 	// CAM_CORE_A_BASE_FRAME_LENGTH_LINES
{ 0xC862, 0x1194, WORD_LEN, 0}, 	// CAM_CORE_A_MIN_LINE_LENGTH_PCLK
{ 0xC864, 0xFFFE, WORD_LEN, 0}, 	// CAM_CORE_A_MAX_LINE_LENGTH_PCLK
{ 0xC866, 0x7F7F, WORD_LEN, 0}, 	// CAM_CORE_A_P4_5_6_DIVIDER
{ 0xC868, 0x0423, WORD_LEN, 0}, 	// CAM_CORE_A_FRAME_LENGTH_LINES
{ 0xC86A, 0x1194, WORD_LEN, 0}, 	// CAM_CORE_A_LINE_LENGTH_PCK
{ 0xC86C, 0x0518, WORD_LEN, 0}, 	// CAM_CORE_A_OUTPUT_SIZE_WIDTH
{ 0xC86E, 0x03D4, WORD_LEN, 0}, 	// CAM_CORE_A_OUTPUT_SIZE_HEIGHT
{ 0xC870, 0x0014, WORD_LEN, 0}, 	// CAM_CORE_A_RX_FIFO_TRIGGER_MARK
{ 0xC858, 0x0003, WORD_LEN, 0}, 	// CAM_CORE_A_COARSE_ITMIN
{ 0xC8B8, 0x0004, WORD_LEN, 0}, 	// CAM_OUTPUT_0_JPEG_CONTROL
{ 0xC8AE, 0x0001, WORD_LEN, 0}, 	// CAM_OUTPUT_0_OUTPUT_FORMAT
{ 0xC8AA, 0x0280, WORD_LEN, 0}, 	// CAM_OUTPUT_0_IMAGE_WIDTH
{ 0xC8AC, 0x01E0, WORD_LEN, 0}, 	// CAM_OUTPUT_0_IMAGE_HEIGHT
{ 0xC872, 0x0010, WORD_LEN, 0}, 	// CAM_CORE_B_Y_ADDR_START
{ 0xC874, 0x001C, WORD_LEN, 0}, 	// CAM_CORE_B_X_ADDR_START
{ 0xC876, 0x07AF, WORD_LEN, 0}, 	// CAM_CORE_B_Y_ADDR_END
{ 0xC878, 0x0A43, WORD_LEN, 0}, 	// CAM_CORE_B_X_ADDR_END
{ 0xC87A, 0x0001, WORD_LEN, 0}, 	// CAM_CORE_B_ROW_SPEED
{ 0xC87C, 0x0101, WORD_LEN, 0}, 	// CAM_CORE_B_SKIP_X_CORE
{ 0xC87E, 0x0101, WORD_LEN, 0}, 	// CAM_CORE_B_SKIP_Y_CORE
{ 0xC880, 0x0101, WORD_LEN, 0}, 	// CAM_CORE_B_SKIP_X_PIPE
{ 0xC882, 0x0101, WORD_LEN, 0}, 	// CAM_CORE_B_SKIP_Y_PIPE
{ 0xC884, 0x00F2, WORD_LEN, 0}, 	// CAM_CORE_B_POWER_MODE
{ 0xC886, 0x0000, WORD_LEN, 0}, 	// CAM_CORE_B_BIN_MODE
/*lzg@rock-chips.com, FIH:capture image to be mirrored and flipped */
#if CONFIG_SENSOR_NONE_FLIP_MIRROR
{ 0xC888, 0x00, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_MIRROR
{ 0xC888, 0x01, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_FLIPE
{ 0xC888, 0x02, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#elif CONFIG_SENSOR_MIRROR_AND_FLIPE
{ 0xC888, 0x03, BYTE_LEN, 0}, 	    // CAM_CORE_A_ORIENTATION
#endif
{ 0xC889, 0x00, BYTE_LEN, 0}, 	// CAM_CORE_B_PIXEL_ORDER
{ 0xC88A, 0x009C, WORD_LEN, 0}, 	// CAM_CORE_B_FINE_CORRECTION
{ 0xC88C, 0x034A, WORD_LEN, 0}, 	// CAM_CORE_B_FINE_ITMIN
{ 0xC890, 0x0000, WORD_LEN, 0}, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC892, 0x0001, WORD_LEN, 0}, 	// CAM_CORE_B_COARSE_ITMAX_MARGIN                  
{ 0xC894, 0x07EF, WORD_LEN, 0}, 	// CAM_CORE_B_MIN_FRAME_LENGTH_LINES
{ 0xC896, 0xFFFF, WORD_LEN, 0}, 	// CAM_CORE_B_MAX_FRAME_LENGTH_LINES
{ 0xC898, 0x082F, WORD_LEN, 0}, 	// CAM_CORE_B_BASE_FRAME_LENGTH_LINES
{ 0xC89A, 0x1964, WORD_LEN, 0}, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC89C, 0xFFFE, WORD_LEN, 0}, 	// CAM_CORE_B_MAX_LINE_LENGTH_PCLK
{ 0xC89E, 0x7F7F, WORD_LEN, 0}, 	// CAM_CORE_B_P4_5_6_DIVIDER
{ 0xC8A0, 0x07EF, WORD_LEN, 0}, 	// CAM_CORE_B_FRAME_LENGTH_LINES
{ 0xC8A2, 0x1964, WORD_LEN, 0}, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8A4, 0x0A28, WORD_LEN, 0}, 	// CAM_CORE_B_OUTPUT_SIZE_WIDTH
{ 0xC8A6, 0x07A0, WORD_LEN, 0}, 	// CAM_CORE_B_OUTPUT_SIZE_HEIGHT
{ 0xC8A8, 0x0124, WORD_LEN, 0}, 	// CAM_CORE_B_RX_FIFO_TRIGGER_MARK
{ 0xC890, 0x0003, WORD_LEN, 0}, 	// CAM_CORE_B_COARSE_ITMIN
{ 0xC8C0, 0x0A20, WORD_LEN, 0}, 	// CAM_OUTPUT_1_IMAGE_WIDTH
{ 0xC8C2, 0x0798, WORD_LEN, 0}, 	// CAM_OUTPUT_1_IMAGE_HEIGHT
{ 0xC89A, 0x1964, WORD_LEN, 0}, 	// CAM_CORE_B_MIN_LINE_LENGTH_PCLK
{ 0xC8A2, 0x1964, WORD_LEN, 0}, 	// CAM_CORE_B_LINE_LENGTH_PCK
{ 0xC8C4, 0x0001, WORD_LEN, 0}, 	// CAM_OUTPUT_1_OUTPUT_FORMAT
{ 0xC8C6, 0x0000, WORD_LEN, 0}, 	// CAM_OUTPUT_1_OUTPUT_FORMAT_ORDER
{ 0xC8CE, 0x0014, WORD_LEN, 0}, 	// CAM_OUTPUT_1_JPEG_CONTROL
{ 0xD822, 0x4610, WORD_LEN, 0}, 	// JPEG_JPSS_CTRL_VAR
{ 0x3330, 0x0000, WORD_LEN, 0}, 	// OUTPUT_FORMAT_TEST
{ 0x098E, 0xA00E, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0xA00E, 0x32, BYTE_LEN, 0}, 	// FD_MAX_NUM_AUTOCOR_FUNC_VALUES_TO_CHECK
{ 0xA010, 0x00CC, WORD_LEN, 0}, 	// FD_MIN_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA012, 0x00E0, WORD_LEN, 0}, 	// FD_MAX_EXPECTED50HZ_FLICKER_PERIOD
{ 0xA014, 0x00A8, WORD_LEN, 0}, 	// FD_MIN_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA016, 0x00BC, WORD_LEN, 0}, 	// FD_MAX_EXPECTED60HZ_FLICKER_PERIOD
{ 0xA018, 0x00D6, WORD_LEN, 0}, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01A, 0x0075, WORD_LEN, 0}, 	// FD_EXPECTED50HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA01C, 0x00B2, WORD_LEN, 0}, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_A
{ 0xA01E, 0x0062, WORD_LEN, 0}, 	// FD_EXPECTED60HZ_FLICKER_PERIOD_IN_CONTEXT_B
{ 0xA000, 0x10, BYTE_LEN, 0}, 	// FD_STATUS
{ 0x8417, 0x02, BYTE_LEN, 0}, 	// SEQ_STATE_CFG_1_FD
{ 0x8404, 0x06, BYTE_LEN, 0}, 	// SEQ_CMD
//////{ SEQUENCE_WAIT_MS,300, BYTE_LEN, 0},
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},
//[Step3-Recommended]
//[k28a_rev3_FW_patch7]
//  k28a_rev03_patch07_CR30221_MCNEX_AWB_AFNOISE_YOFFSET_APGA_REV1
{ 0x0982, 0x0000, WORD_LEN, 0}, 	// ACCESS_CTL_STAT
{ 0x098A, 0x0000, WORD_LEN, 0}, 	// PHYSICAL_ADDRESS_ACCESS
{ 0x886C, 0xC0F1, WORD_LEN, 0},
{ 0x886E, 0xC5E1, WORD_LEN, 0},
{ 0x8870, 0x246A, WORD_LEN, 0},
{ 0x8872, 0x1280, WORD_LEN, 0},
{ 0x8874, 0xC4E1, WORD_LEN, 0},
{ 0x8876, 0xD20F, WORD_LEN, 0},
{ 0x8878, 0x2069, WORD_LEN, 0},
{ 0x887A, 0x0000, WORD_LEN, 0},
{ 0x887C, 0x6A62, WORD_LEN, 0},
{ 0x887E, 0x1303, WORD_LEN, 0},
{ 0x8880, 0x0084, WORD_LEN, 0},
{ 0x8882, 0x1734, WORD_LEN, 0},
{ 0x8884, 0x7005, WORD_LEN, 0},
{ 0x8886, 0xD801, WORD_LEN, 0},
{ 0x8888, 0x8A41, WORD_LEN, 0},
{ 0x888A, 0xD900, WORD_LEN, 0},
{ 0x888C, 0x0D5A, WORD_LEN, 0},
{ 0x888E, 0x0664, WORD_LEN, 0},
{ 0x8890, 0x8B61, WORD_LEN, 0},
{ 0x8892, 0xE80B, WORD_LEN, 0},
{ 0x8894, 0x000D, WORD_LEN, 0},
{ 0x8896, 0x0020, WORD_LEN, 0},
{ 0x8898, 0xD508, WORD_LEN, 0},
{ 0x889A, 0x1504, WORD_LEN, 0},
{ 0x889C, 0x1400, WORD_LEN, 0},
{ 0x889E, 0x7840, WORD_LEN, 0},
{ 0x88A0, 0xD007, WORD_LEN, 0},
{ 0x88A2, 0x0DFB, WORD_LEN, 0},
{ 0x88A4, 0x9004, WORD_LEN, 0},
{ 0x88A6, 0xC4C1, WORD_LEN, 0},
{ 0x88A8, 0x2029, WORD_LEN, 0},
{ 0x88AA, 0x0300, WORD_LEN, 0},
{ 0x88AC, 0x0219, WORD_LEN, 0},
{ 0x88AE, 0x06C4, WORD_LEN, 0},
{ 0x88B0, 0xFF80, WORD_LEN, 0},
{ 0x88B2, 0x08C8, WORD_LEN, 0},
{ 0x88B4, 0xFF80, WORD_LEN, 0},
{ 0x88B6, 0x086C, WORD_LEN, 0},
{ 0x88B8, 0xFF80, WORD_LEN, 0},
{ 0x88BA, 0x08C0, WORD_LEN, 0},
{ 0x88BC, 0xFF80, WORD_LEN, 0},
{ 0x88BE, 0x08C8, WORD_LEN, 0},
{ 0x88C0, 0xFF80, WORD_LEN, 0},
{ 0x88C2, 0x08D0, WORD_LEN, 0},
{ 0x88C4, 0xFF80, WORD_LEN, 0},
{ 0x88C6, 0x0978, WORD_LEN, 0},
{ 0x88C8, 0x0007, WORD_LEN, 0},
{ 0x88CA, 0x0001, WORD_LEN, 0},
{ 0x88CC, 0x0000, WORD_LEN, 0},
{ 0x88CE, 0x0000, WORD_LEN, 0},
{ 0x88D0, 0xC0F1, WORD_LEN, 0},
{ 0x88D2, 0x097E, WORD_LEN, 0},
{ 0x88D4, 0x06E4, WORD_LEN, 0},
{ 0x88D6, 0xDA14, WORD_LEN, 0},
{ 0x88D8, 0xD0C8, WORD_LEN, 0},
{ 0x88DA, 0xDE00, WORD_LEN, 0},
{ 0x88DC, 0xD1C8, WORD_LEN, 0},
{ 0x88DE, 0x2E41, WORD_LEN, 0},
{ 0x88E0, 0x120C, WORD_LEN, 0},
{ 0x88E2, 0xA895, WORD_LEN, 0},
{ 0x88E4, 0xD5C7, WORD_LEN, 0},
{ 0x88E6, 0xA8D4, WORD_LEN, 0},
{ 0x88E8, 0xA8D6, WORD_LEN, 0},
{ 0x88EA, 0x0F0A, WORD_LEN, 0},
{ 0x88EC, 0x06A4, WORD_LEN, 0},
{ 0x88EE, 0x2555, WORD_LEN, 0},
{ 0x88F0, 0x1440, WORD_LEN, 0},
{ 0x88F2, 0xD0C5, WORD_LEN, 0},
{ 0x88F4, 0x2555, WORD_LEN, 0},
{ 0x88F6, 0x1441, WORD_LEN, 0},
{ 0x88F8, 0x77A9, WORD_LEN, 0},
{ 0x88FA, 0xA515, WORD_LEN, 0},
{ 0x88FC, 0xD0C3, WORD_LEN, 0},
{ 0x88FE, 0xA020, WORD_LEN, 0},
{ 0x8900, 0xD1C3, WORD_LEN, 0},
{ 0x8902, 0x70E9, WORD_LEN, 0},
{ 0x8904, 0x0EEE, WORD_LEN, 0},
{ 0x8906, 0x06A4, WORD_LEN, 0},
{ 0x8908, 0xDA44, WORD_LEN, 0},
{ 0x890A, 0xD0C2, WORD_LEN, 0},
{ 0x890C, 0xD1C2, WORD_LEN, 0},
{ 0x890E, 0xA502, WORD_LEN, 0},
{ 0x8910, 0xD0C2, WORD_LEN, 0},
{ 0x8912, 0xA0E0, WORD_LEN, 0},
{ 0x8914, 0xD0C2, WORD_LEN, 0},
{ 0x8916, 0xB0CB, WORD_LEN, 0},
{ 0x8918, 0x8900, WORD_LEN, 0},
{ 0x891A, 0xDB08, WORD_LEN, 0},
{ 0x891C, 0xDAF0, WORD_LEN, 0},
{ 0x891E, 0x19B0, WORD_LEN, 0},
{ 0x8920, 0x00C2, WORD_LEN, 0},
{ 0x8922, 0xB8A6, WORD_LEN, 0},
{ 0x8924, 0xA900, WORD_LEN, 0},
{ 0x8926, 0xD851, WORD_LEN, 0},
{ 0x8928, 0x19B2, WORD_LEN, 0},
{ 0x892A, 0x0002, WORD_LEN, 0},
{ 0x892C, 0xD852, WORD_LEN, 0},
{ 0x892E, 0x19B3, WORD_LEN, 0},
{ 0x8930, 0x0002, WORD_LEN, 0},
{ 0x8932, 0xD855, WORD_LEN, 0},
{ 0x8934, 0x19B6, WORD_LEN, 0},
{ 0x8936, 0x0002, WORD_LEN, 0},
{ 0x8938, 0xD856, WORD_LEN, 0},
{ 0x893A, 0x19B7, WORD_LEN, 0},
{ 0x893C, 0x0002, WORD_LEN, 0},
{ 0x893E, 0xD896, WORD_LEN, 0},
{ 0x8940, 0x19B8, WORD_LEN, 0},
{ 0x8942, 0x0004, WORD_LEN, 0},
{ 0x8944, 0xD814, WORD_LEN, 0},
{ 0x8946, 0x19BA, WORD_LEN, 0},
{ 0x8948, 0x0004, WORD_LEN, 0},
{ 0x894A, 0xD805, WORD_LEN, 0},
{ 0x894C, 0xB111, WORD_LEN, 0},
{ 0x894E, 0x19B1, WORD_LEN, 0},
{ 0x8950, 0x0082, WORD_LEN, 0},
{ 0x8952, 0x19B4, WORD_LEN, 0},
{ 0x8954, 0x00C2, WORD_LEN, 0},
{ 0x8956, 0x19B5, WORD_LEN, 0},
{ 0x8958, 0x0082, WORD_LEN, 0},
{ 0x895A, 0xD1B2, WORD_LEN, 0},
{ 0x895C, 0x2556, WORD_LEN, 0},
{ 0x895E, 0x12C0, WORD_LEN, 0},
{ 0x8960, 0x0E92, WORD_LEN, 0},
{ 0x8962, 0x06A4, WORD_LEN, 0},
{ 0x8964, 0xDA2C, WORD_LEN, 0},
{ 0x8966, 0xD0B0, WORD_LEN, 0},
{ 0x8968, 0x2556, WORD_LEN, 0},
{ 0x896A, 0x12C1, WORD_LEN, 0},
{ 0x896C, 0xA519, WORD_LEN, 0},
{ 0x896E, 0xD0AF, WORD_LEN, 0},
{ 0x8970, 0x0145, WORD_LEN, 0},
{ 0x8972, 0x06E4, WORD_LEN, 0},
{ 0x8974, 0xA020, WORD_LEN, 0},
{ 0x8976, 0x78E0, WORD_LEN, 0},
{ 0x8978, 0xC0F1, WORD_LEN, 0},
{ 0x897A, 0xD0AD, WORD_LEN, 0},
{ 0x897C, 0xD1AD, WORD_LEN, 0},
{ 0x897E, 0xD2AE, WORD_LEN, 0},
{ 0x8980, 0xA020, WORD_LEN, 0},
{ 0x8982, 0x8A09, WORD_LEN, 0},
{ 0x8984, 0x8A6A, WORD_LEN, 0},
{ 0x8986, 0xB808, WORD_LEN, 0},
{ 0x8988, 0x7865, WORD_LEN, 0},
{ 0x898A, 0xB880, WORD_LEN, 0},
{ 0x898C, 0x2841, WORD_LEN, 0},
{ 0x898E, 0x020C, WORD_LEN, 0},
{ 0x8990, 0xAA89, WORD_LEN, 0},
{ 0x8992, 0xAA0A, WORD_LEN, 0},
{ 0x8994, 0xD2A9, WORD_LEN, 0},
{ 0x8996, 0x8A00, WORD_LEN, 0},
{ 0x8998, 0x0809, WORD_LEN, 0},
{ 0x899A, 0x01DE, WORD_LEN, 0},
{ 0x899C, 0xB8A7, WORD_LEN, 0},
{ 0x899E, 0xAA00, WORD_LEN, 0},
{ 0x89A0, 0xDBFF, WORD_LEN, 0},
{ 0x89A2, 0x2B41, WORD_LEN, 0},
{ 0x89A4, 0x0200, WORD_LEN, 0},
{ 0x89A6, 0xAA0C, WORD_LEN, 0},
{ 0x89A8, 0x1228, WORD_LEN, 0},
{ 0x89AA, 0x0080, WORD_LEN, 0},
{ 0x89AC, 0xAA6D, WORD_LEN, 0},
{ 0x89AE, 0x0815, WORD_LEN, 0},
{ 0x89B0, 0x01DE, WORD_LEN, 0},
{ 0x89B2, 0xB8A7, WORD_LEN, 0},
{ 0x89B4, 0x1A28, WORD_LEN, 0},
{ 0x89B6, 0x0002, WORD_LEN, 0},
{ 0x89B8, 0x8123, WORD_LEN, 0},
{ 0x89BA, 0x7960, WORD_LEN, 0},
{ 0x89BC, 0x1228, WORD_LEN, 0},
{ 0x89BE, 0x0080, WORD_LEN, 0},
{ 0x89C0, 0xC0D1, WORD_LEN, 0},
{ 0x89C2, 0x7EE0, WORD_LEN, 0},
{ 0x89C4, 0xC0F1, WORD_LEN, 0},
{ 0x89C6, 0x088E, WORD_LEN, 0},
{ 0x89C8, 0x06E4, WORD_LEN, 0},
{ 0x89CA, 0xDB03, WORD_LEN, 0},
{ 0x89CC, 0xD29B, WORD_LEN, 0},
{ 0x89CE, 0x8A2E, WORD_LEN, 0},
{ 0x89D0, 0x8ACF, WORD_LEN, 0},
{ 0x89D2, 0xB908, WORD_LEN, 0},
{ 0x89D4, 0x79C5, WORD_LEN, 0},
{ 0x89D6, 0xDD65, WORD_LEN, 0},
{ 0x89D8, 0x094F, WORD_LEN, 0},
{ 0x89DA, 0x00D1, WORD_LEN, 0},
{ 0x89DC, 0xD90A, WORD_LEN, 0},
{ 0x89DE, 0x1A24, WORD_LEN, 0},
{ 0x89E0, 0x0042, WORD_LEN, 0},
{ 0x89E2, 0x8A24, WORD_LEN, 0},
{ 0x89E4, 0xE1E5, WORD_LEN, 0},
{ 0x89E6, 0xF6C9, WORD_LEN, 0},
{ 0x89E8, 0xD902, WORD_LEN, 0},
{ 0x89EA, 0x2941, WORD_LEN, 0},
{ 0x89EC, 0x0200, WORD_LEN, 0},
{ 0x89EE, 0xAA0E, WORD_LEN, 0},
{ 0x89F0, 0xAA2F, WORD_LEN, 0},
{ 0x89F2, 0x70A9, WORD_LEN, 0},
{ 0x89F4, 0xF014, WORD_LEN, 0},
{ 0x89F6, 0xE1C8, WORD_LEN, 0},
{ 0x89F8, 0x0036, WORD_LEN, 0},
{ 0x89FA, 0x000B, WORD_LEN, 0},
{ 0x89FC, 0xE0C8, WORD_LEN, 0},
{ 0x89FE, 0x003A, WORD_LEN, 0},
{ 0x8A00, 0x000A, WORD_LEN, 0},
{ 0x8A02, 0xD901, WORD_LEN, 0},
{ 0x8A04, 0x2941, WORD_LEN, 0},
{ 0x8A06, 0x0200, WORD_LEN, 0},
{ 0x8A08, 0xAA0E, WORD_LEN, 0},
{ 0x8A0A, 0xAA2F, WORD_LEN, 0},
{ 0x8A0C, 0xD848, WORD_LEN, 0},
{ 0x8A0E, 0xF008, WORD_LEN, 0},
{ 0x8A10, 0xD900, WORD_LEN, 0},
{ 0x8A12, 0x2941, WORD_LEN, 0},
{ 0x8A14, 0x0200, WORD_LEN, 0},
{ 0x8A16, 0xAA0E, WORD_LEN, 0},
{ 0x8A18, 0xAA2F, WORD_LEN, 0},
{ 0x8A1A, 0xD820, WORD_LEN, 0},
{ 0x8A1C, 0xD288, WORD_LEN, 0},
{ 0x8A1E, 0x8A26, WORD_LEN, 0},
{ 0x8A20, 0xB961, WORD_LEN, 0},
{ 0x8A22, 0xAA26, WORD_LEN, 0},
{ 0x8A24, 0xF00D, WORD_LEN, 0},
{ 0x8A26, 0x091F, WORD_LEN, 0},
{ 0x8A28, 0x0091, WORD_LEN, 0},
{ 0x8A2A, 0x8A24, WORD_LEN, 0},
{ 0x8A2C, 0xF1E5, WORD_LEN, 0},
{ 0x8A2E, 0x0913, WORD_LEN, 0},
{ 0x8A30, 0x0812, WORD_LEN, 0},
{ 0x8A32, 0x08E1, WORD_LEN, 0},
{ 0x8A34, 0x8812, WORD_LEN, 0},
{ 0x8A36, 0x2B41, WORD_LEN, 0},
{ 0x8A38, 0x0201, WORD_LEN, 0},
{ 0x8A3A, 0xAA2E, WORD_LEN, 0},
{ 0x8A3C, 0xAA6F, WORD_LEN, 0},
{ 0x8A3E, 0x0081, WORD_LEN, 0},
{ 0x8A40, 0x06C4, WORD_LEN, 0},
{ 0x8A42, 0x09F7, WORD_LEN, 0},
{ 0x8A44, 0x8051, WORD_LEN, 0},
{ 0x8A46, 0x8A24, WORD_LEN, 0},
{ 0x8A48, 0xF1F3, WORD_LEN, 0},
{ 0x8A4A, 0x78E0, WORD_LEN, 0},
{ 0x8A4C, 0xC0F1, WORD_LEN, 0},
{ 0x8A4E, 0x0FFA, WORD_LEN, 0},
{ 0x8A50, 0x0684, WORD_LEN, 0},
{ 0x8A52, 0xD67A, WORD_LEN, 0},
{ 0x8A54, 0x7508, WORD_LEN, 0},
{ 0x8A56, 0x8E01, WORD_LEN, 0},
{ 0x8A58, 0xD179, WORD_LEN, 0},
{ 0x8A5A, 0x2046, WORD_LEN, 0},
{ 0x8A5C, 0x00C0, WORD_LEN, 0},
{ 0x8A5E, 0xAE01, WORD_LEN, 0},
{ 0x8A60, 0x1145, WORD_LEN, 0},
{ 0x8A62, 0x0080, WORD_LEN, 0},
{ 0x8A64, 0x1146, WORD_LEN, 0},
{ 0x8A66, 0x0082, WORD_LEN, 0},
{ 0x8A68, 0xB808, WORD_LEN, 0},
{ 0x8A6A, 0x7845, WORD_LEN, 0},
{ 0x8A6C, 0x0817, WORD_LEN, 0},
{ 0x8A6E, 0x001E, WORD_LEN, 0},
{ 0x8A70, 0x8900, WORD_LEN, 0},
{ 0x8A72, 0x8941, WORD_LEN, 0},
{ 0x8A74, 0xB808, WORD_LEN, 0},
{ 0x8A76, 0x7845, WORD_LEN, 0},
{ 0x8A78, 0x080B, WORD_LEN, 0},
{ 0x8A7A, 0x00DE, WORD_LEN, 0},
{ 0x8A7C, 0x70A9, WORD_LEN, 0},
{ 0x8A7E, 0xFFD2, WORD_LEN, 0},
{ 0x8A80, 0x7508, WORD_LEN, 0},
{ 0x8A82, 0x1604, WORD_LEN, 0},
{ 0x8A84, 0x1090, WORD_LEN, 0},
{ 0x8A86, 0x0D93, WORD_LEN, 0},
{ 0x8A88, 0x1400, WORD_LEN, 0},
{ 0x8A8A, 0x8EEA, WORD_LEN, 0},
{ 0x8A8C, 0x8E0B, WORD_LEN, 0},
{ 0x8A8E, 0x214A, WORD_LEN, 0},
{ 0x8A90, 0x2040, WORD_LEN, 0},
{ 0x8A92, 0x8E2D, WORD_LEN, 0},
{ 0x8A94, 0xBF08, WORD_LEN, 0},
{ 0x8A96, 0x7F05, WORD_LEN, 0},
{ 0x8A98, 0x8E0C, WORD_LEN, 0},
{ 0x8A9A, 0xB808, WORD_LEN, 0},
{ 0x8A9C, 0x7825, WORD_LEN, 0},
{ 0x8A9E, 0x7710, WORD_LEN, 0},
{ 0x8AA0, 0x21C2, WORD_LEN, 0},
{ 0x8AA2, 0x244C, WORD_LEN, 0},
{ 0x8AA4, 0x081D, WORD_LEN, 0},
{ 0x8AA6, 0x03E3, WORD_LEN, 0},
{ 0x8AA8, 0xD9FF, WORD_LEN, 0},
{ 0x8AAA, 0x2702, WORD_LEN, 0},
{ 0x8AAC, 0x1002, WORD_LEN, 0},
{ 0x8AAE, 0x2A05, WORD_LEN, 0},
{ 0x8AB0, 0x037E, WORD_LEN, 0},
{ 0x8AB2, 0x0876, WORD_LEN, 0},
{ 0x8AB4, 0x06E4, WORD_LEN, 0},
{ 0x8AB6, 0x702F, WORD_LEN, 0},
{ 0x8AB8, 0x7810, WORD_LEN, 0},
{ 0x8ABA, 0x7F02, WORD_LEN, 0},
{ 0x8ABC, 0x7FF0, WORD_LEN, 0},
{ 0x8ABE, 0xF00B, WORD_LEN, 0},
{ 0x8AC0, 0x78E2, WORD_LEN, 0},
{ 0x8AC2, 0x2805, WORD_LEN, 0},
{ 0x8AC4, 0x037E, WORD_LEN, 0},
{ 0x8AC6, 0x0862, WORD_LEN, 0},
{ 0x8AC8, 0x06E4, WORD_LEN, 0},
{ 0x8ACA, 0x702F, WORD_LEN, 0},
{ 0x8ACC, 0x7810, WORD_LEN, 0},
{ 0x8ACE, 0x671F, WORD_LEN, 0},
{ 0x8AD0, 0x7FF0, WORD_LEN, 0},
{ 0x8AD2, 0x7FEF, WORD_LEN, 0},
{ 0x8AD4, 0x8E08, WORD_LEN, 0},
{ 0x8AD6, 0xBF06, WORD_LEN, 0},
{ 0x8AD8, 0xD15A, WORD_LEN, 0},
{ 0x8ADA, 0xB8C3, WORD_LEN, 0},
{ 0x8ADC, 0x78E5, WORD_LEN, 0},
{ 0x8ADE, 0xB88F, WORD_LEN, 0},
{ 0x8AE0, 0x1908, WORD_LEN, 0},
{ 0x8AE2, 0x0024, WORD_LEN, 0},
{ 0x8AE4, 0x2841, WORD_LEN, 0},
{ 0x8AE6, 0x0201, WORD_LEN, 0},
{ 0x8AE8, 0x1E26, WORD_LEN, 0},
{ 0x8AEA, 0x1042, WORD_LEN, 0},
{ 0x8AEC, 0x0D15, WORD_LEN, 0},
{ 0x8AEE, 0x1423, WORD_LEN, 0},
{ 0x8AF0, 0x1E27, WORD_LEN, 0},
{ 0x8AF2, 0x1002, WORD_LEN, 0},
{ 0x8AF4, 0x214C, WORD_LEN, 0},
{ 0x8AF6, 0xA000, WORD_LEN, 0},
{ 0x8AF8, 0x214A, WORD_LEN, 0},
{ 0x8AFA, 0x2040, WORD_LEN, 0},
{ 0x8AFC, 0x21C2, WORD_LEN, 0},
{ 0x8AFE, 0x2442, WORD_LEN, 0},
{ 0x8B00, 0x8E21, WORD_LEN, 0},
{ 0x8B02, 0x214F, WORD_LEN, 0},
{ 0x8B04, 0x0040, WORD_LEN, 0},
{ 0x8B06, 0x090F, WORD_LEN, 0},
{ 0x8B08, 0x2010, WORD_LEN, 0},
{ 0x8B0A, 0x2145, WORD_LEN, 0},
{ 0x8B0C, 0x0181, WORD_LEN, 0},
{ 0x8B0E, 0xAE21, WORD_LEN, 0},
{ 0x8B10, 0xF003, WORD_LEN, 0},
{ 0x8B12, 0xB8A2, WORD_LEN, 0},
{ 0x8B14, 0xAE01, WORD_LEN, 0},
{ 0x8B16, 0x0BFA, WORD_LEN, 0},
{ 0x8B18, 0xFFE3, WORD_LEN, 0},
{ 0x8B1A, 0x70A9, WORD_LEN, 0},
{ 0x8B1C, 0x0789, WORD_LEN, 0},
{ 0x8B1E, 0x0684, WORD_LEN, 0},
{ 0x8B20, 0xD149, WORD_LEN, 0},
{ 0x8B22, 0xD24A, WORD_LEN, 0},
{ 0x8B24, 0x11B2, WORD_LEN, 0},
{ 0x8B26, 0x8903, WORD_LEN, 0},
{ 0x8B28, 0x1252, WORD_LEN, 0},
{ 0x8B2A, 0x0100, WORD_LEN, 0},
{ 0x8B2C, 0x7B6F, WORD_LEN, 0},
{ 0x8B2E, 0xB808, WORD_LEN, 0},
{ 0x8B30, 0x2004, WORD_LEN, 0},
{ 0x8B32, 0x0F80, WORD_LEN, 0},
{ 0x8B34, 0x0000, WORD_LEN, 0},
{ 0x8B36, 0xFF00, WORD_LEN, 0},
{ 0x8B38, 0x7865, WORD_LEN, 0},
{ 0x8B3A, 0x19B2, WORD_LEN, 0},
{ 0x8B3C, 0x8024, WORD_LEN, 0},
{ 0x8B3E, 0xD044, WORD_LEN, 0},
{ 0x8B40, 0x8801, WORD_LEN, 0},
{ 0x8B42, 0xB8E1, WORD_LEN, 0},
{ 0x8B44, 0xD800, WORD_LEN, 0},
{ 0x8B46, 0xF404, WORD_LEN, 0},
{ 0x8B48, 0x1234, WORD_LEN, 0},
{ 0x8B4A, 0x0080, WORD_LEN, 0},
{ 0x8B4C, 0x1955, WORD_LEN, 0},
{ 0x8B4E, 0x803C, WORD_LEN, 0},
{ 0x8B50, 0x1233, WORD_LEN, 0},
{ 0x8B52, 0x0080, WORD_LEN, 0},
{ 0x8B54, 0xB802, WORD_LEN, 0},
{ 0x8B56, 0x1957, WORD_LEN, 0},
{ 0x8B58, 0x803C, WORD_LEN, 0},
{ 0x8B5A, 0x1958, WORD_LEN, 0},
{ 0x8B5C, 0x803C, WORD_LEN, 0},
{ 0x8B5E, 0x1959, WORD_LEN, 0},
{ 0x8B60, 0x803C, WORD_LEN, 0},
{ 0x8B62, 0x195A, WORD_LEN, 0},
{ 0x8B64, 0x803C, WORD_LEN, 0},
{ 0x8B66, 0x7EE0, WORD_LEN, 0},
{ 0x8B68, 0xC0F1, WORD_LEN, 0},
{ 0x8B6A, 0x0EE6, WORD_LEN, 0},
{ 0x8B6C, 0x0684, WORD_LEN, 0},
{ 0x8B6E, 0xD523, WORD_LEN, 0},
{ 0x8B70, 0x8D2C, WORD_LEN, 0},
{ 0x8B72, 0x0983, WORD_LEN, 0},
{ 0x8B74, 0x0010, WORD_LEN, 0},
{ 0x8B76, 0xD236, WORD_LEN, 0},
{ 0x8B78, 0x123A, WORD_LEN, 0},
{ 0x8B7A, 0x0083, WORD_LEN, 0},
{ 0x8B7C, 0x123B, WORD_LEN, 0},
{ 0x8B7E, 0x008F, WORD_LEN, 0},
{ 0x8B80, 0x8D55, WORD_LEN, 0},
{ 0x8B82, 0xBB08, WORD_LEN, 0},
{ 0x8B84, 0x7BE5, WORD_LEN, 0},
{ 0x8B86, 0x8DF6, WORD_LEN, 0},
{ 0x8B88, 0xBA08, WORD_LEN, 0},
{ 0x8B8A, 0x7AE5, WORD_LEN, 0},
{ 0x8B8C, 0x0B0D, WORD_LEN, 0},
{ 0x8B8E, 0x00A3, WORD_LEN, 0},
{ 0x8B90, 0x8DC5, WORD_LEN, 0},
{ 0x8B92, 0x8D54, WORD_LEN, 0},
{ 0x8B94, 0xAD45, WORD_LEN, 0},
{ 0x8B96, 0xF026, WORD_LEN, 0},
{ 0x8B98, 0x65DB, WORD_LEN, 0},
{ 0x8B9A, 0x8B6D, WORD_LEN, 0},
{ 0x8B9C, 0x0815, WORD_LEN, 0},
{ 0x8B9E, 0x00E2, WORD_LEN, 0},
{ 0x8BA0, 0x65DA, WORD_LEN, 0},
{ 0x8BA2, 0x8A51, WORD_LEN, 0},
{ 0x8BA4, 0x0A0D, WORD_LEN, 0},
{ 0x8BA6, 0x0002, WORD_LEN, 0},
{ 0x8BA8, 0xE683, WORD_LEN, 0},
{ 0x8BAA, 0x22CA, WORD_LEN, 0},
{ 0x8BAC, 0x038B, WORD_LEN, 0},
{ 0x8BAE, 0xF69A, WORD_LEN, 0},
{ 0x8BB0, 0xDA00, WORD_LEN, 0},
{ 0x8BB2, 0xAD45, WORD_LEN, 0},
{ 0x8BB4, 0x2540, WORD_LEN, 0},
{ 0x8BB6, 0x1343, WORD_LEN, 0},
{ 0x8BB8, 0xE180, WORD_LEN, 0},
{ 0x8BBA, 0x2540, WORD_LEN, 0},
{ 0x8BBC, 0x144F, WORD_LEN, 0},
{ 0x8BBE, 0xF6D2, WORD_LEN, 0},
{ 0x8BC0, 0x719F, WORD_LEN, 0},
{ 0x8BC2, 0x78E0, WORD_LEN, 0},
{ 0x8BC4, 0x20A8, WORD_LEN, 0},
{ 0x8BC6, 0x0280, WORD_LEN, 0},
{ 0x8BC8, 0x8B20, WORD_LEN, 0},
{ 0x8BCA, 0x0813, WORD_LEN, 0},
{ 0x8BCC, 0x0043, WORD_LEN, 0},
{ 0x8BCE, 0xE201, WORD_LEN, 0},
{ 0x8BD0, 0x7A4F, WORD_LEN, 0},
{ 0x8BD2, 0xAD45, WORD_LEN, 0},
{ 0x8BD4, 0xE301, WORD_LEN, 0},
{ 0x8BD6, 0xE701, WORD_LEN, 0},
{ 0x8BD8, 0xF004, WORD_LEN, 0},
{ 0x8BDA, 0x8F20, WORD_LEN, 0},
{ 0x8BDC, 0x09F3, WORD_LEN, 0},
{ 0x8BDE, 0x8002, WORD_LEN, 0},
{ 0x8BE0, 0xD01C, WORD_LEN, 0},
{ 0x8BE2, 0x8800, WORD_LEN, 0},
{ 0x8BE4, 0xE803, WORD_LEN, 0},
{ 0x8BE6, 0x0E0F, WORD_LEN, 0},
{ 0x8BE8, 0x1080, WORD_LEN, 0},
{ 0x8BEA, 0xD008, WORD_LEN, 0},
{ 0x8BEC, 0x8000, WORD_LEN, 0},
{ 0x8BEE, 0x8002, WORD_LEN, 0},
{ 0x8BF0, 0x7840, WORD_LEN, 0},
{ 0x8BF2, 0x06C5, WORD_LEN, 0},
{ 0x8BF4, 0x0684, WORD_LEN, 0},
{ 0x8BF6, 0x78E0, WORD_LEN, 0},
{ 0x8BF8, 0xFF80, WORD_LEN, 0},
{ 0x8BFA, 0x0644, WORD_LEN, 0},
{ 0x8BFC, 0x0000, WORD_LEN, 0},
{ 0x8BFE, 0xF978, WORD_LEN, 0},
{ 0x8C00, 0xFF80, WORD_LEN, 0},
{ 0x8C02, 0x0E00, WORD_LEN, 0},
{ 0x8C04, 0xFF80, WORD_LEN, 0},
{ 0x8C06, 0x0B68, WORD_LEN, 0},
{ 0x8C08, 0x8000, WORD_LEN, 0},
{ 0x8C0A, 0x0164, WORD_LEN, 0},
{ 0x8C0C, 0x0000, WORD_LEN, 0},
{ 0x8C0E, 0xF9AC, WORD_LEN, 0},
{ 0x8C10, 0xFF80, WORD_LEN, 0},
{ 0x8C12, 0x0B20, WORD_LEN, 0},
{ 0x8C14, 0xFF80, WORD_LEN, 0},
{ 0x8C16, 0x0314, WORD_LEN, 0},
{ 0x8C18, 0x8000, WORD_LEN, 0},
{ 0x8C1A, 0x016C, WORD_LEN, 0},
{ 0x8C1C, 0xFF80, WORD_LEN, 0},
{ 0x8C1E, 0x0694, WORD_LEN, 0},
{ 0x8C20, 0x0000, WORD_LEN, 0},
{ 0x8C22, 0xF444, WORD_LEN, 0},
{ 0x8C24, 0xFF80, WORD_LEN, 0},
{ 0x8C26, 0x0C54, WORD_LEN, 0},
{ 0x8C28, 0x8000, WORD_LEN, 0},
{ 0x8C2A, 0x009C, WORD_LEN, 0},
{ 0x8C2C, 0x8000, WORD_LEN, 0},
{ 0x8C2E, 0x0008, WORD_LEN, 0},
{ 0x8C30, 0xFF80, WORD_LEN, 0},
{ 0x8C32, 0x0DF0, WORD_LEN, 0},
{ 0x8C34, 0xFF80, WORD_LEN, 0},
{ 0x8C36, 0x02CC, WORD_LEN, 0},
{ 0x8C38, 0xFF80, WORD_LEN, 0},
{ 0x8C3A, 0x0158, WORD_LEN, 0},
{ 0x8C3C, 0xFF80, WORD_LEN, 0},
{ 0x8C3E, 0x0290, WORD_LEN, 0},
{ 0x8C40, 0xFF00, WORD_LEN, 0},
{ 0x8C42, 0x0618, WORD_LEN, 0},
{ 0x8C44, 0xFF00, WORD_LEN, 0},
{ 0x8C46, 0x33CC, WORD_LEN, 0},
{ 0x8C48, 0xFF80, WORD_LEN, 0},
{ 0x8C4A, 0x0658, WORD_LEN, 0},
{ 0x8C4C, 0xFF80, WORD_LEN, 0},
{ 0x8C4E, 0x0250, WORD_LEN, 0},
{ 0x8C50, 0x8000, WORD_LEN, 0},
{ 0x8C52, 0x0168, WORD_LEN, 0},
{ 0x8C54, 0xC0F1, WORD_LEN, 0},
{ 0x8C56, 0x0DFE, WORD_LEN, 0},
{ 0x8C58, 0x0684, WORD_LEN, 0},
{ 0x8C5A, 0x17BC, WORD_LEN, 0},
{ 0x8C5C, 0xF00E, WORD_LEN, 0},
{ 0x8C5E, 0x8E01, WORD_LEN, 0},
{ 0x8C60, 0xB8A4, WORD_LEN, 0},
{ 0x8C62, 0xAE01, WORD_LEN, 0},
{ 0x8C64, 0x8E09, WORD_LEN, 0},
{ 0x8C66, 0xB8E0, WORD_LEN, 0},
{ 0x8C68, 0xF29B, WORD_LEN, 0},
{ 0x8C6A, 0x17E4, WORD_LEN, 0},
{ 0x8C6C, 0xF00D, WORD_LEN, 0},
{ 0x8C6E, 0x153A, WORD_LEN, 0},
{ 0x8C70, 0x1080, WORD_LEN, 0},
{ 0x8C72, 0x153B, WORD_LEN, 0},
{ 0x8C74, 0x1081, WORD_LEN, 0},
{ 0x8C76, 0xB808, WORD_LEN, 0},
{ 0x8C78, 0x7825, WORD_LEN, 0},
{ 0x8C7A, 0x16B8, WORD_LEN, 0},
{ 0x8C7C, 0x1101, WORD_LEN, 0},
{ 0x8C7E, 0x092D, WORD_LEN, 0},
{ 0x8C80, 0x0003, WORD_LEN, 0},
{ 0x8C82, 0x16B0, WORD_LEN, 0},
{ 0x8C84, 0x1082, WORD_LEN, 0},
{ 0x8C86, 0x1E3C, WORD_LEN, 0},
{ 0x8C88, 0x1082, WORD_LEN, 0},
{ 0x8C8A, 0x16B1, WORD_LEN, 0},
{ 0x8C8C, 0x1082, WORD_LEN, 0},
{ 0x8C8E, 0x1E3D, WORD_LEN, 0},
{ 0x8C90, 0x1082, WORD_LEN, 0},
{ 0x8C92, 0x16B4, WORD_LEN, 0},
{ 0x8C94, 0x1082, WORD_LEN, 0},
{ 0x8C96, 0x1E3E, WORD_LEN, 0},
{ 0x8C98, 0x1082, WORD_LEN, 0},
{ 0x8C9A, 0x16B5, WORD_LEN, 0},
{ 0x8C9C, 0x1082, WORD_LEN, 0},
{ 0x8C9E, 0x1E3F, WORD_LEN, 0},
{ 0x8CA0, 0x1082, WORD_LEN, 0},
{ 0x8CA2, 0x8E40, WORD_LEN, 0},
{ 0x8CA4, 0xBAA6, WORD_LEN, 0},
{ 0x8CA6, 0xAE40, WORD_LEN, 0},
{ 0x8CA8, 0x098F, WORD_LEN, 0},
{ 0x8CAA, 0x0022, WORD_LEN, 0},
{ 0x8CAC, 0x16BA, WORD_LEN, 0},
{ 0x8CAE, 0x1102, WORD_LEN, 0},
{ 0x8CB0, 0x0A87, WORD_LEN, 0},
{ 0x8CB2, 0x0003, WORD_LEN, 0},
{ 0x8CB4, 0x16B2, WORD_LEN, 0},
{ 0x8CB6, 0x1084, WORD_LEN, 0},
{ 0x8CB8, 0x0F2E, WORD_LEN, 0},
{ 0x8CBA, 0x0664, WORD_LEN, 0},
{ 0x8CBC, 0x16B0, WORD_LEN, 0},
{ 0x8CBE, 0x1083, WORD_LEN, 0},
{ 0x8CC0, 0x1E3C, WORD_LEN, 0},
{ 0x8CC2, 0x1002, WORD_LEN, 0},
{ 0x8CC4, 0x153A, WORD_LEN, 0},
{ 0x8CC6, 0x1080, WORD_LEN, 0},
{ 0x8CC8, 0x153B, WORD_LEN, 0},
{ 0x8CCA, 0x1081, WORD_LEN, 0},
{ 0x8CCC, 0x16B3, WORD_LEN, 0},
{ 0x8CCE, 0x1084, WORD_LEN, 0},
{ 0x8CD0, 0xB808, WORD_LEN, 0},
{ 0x8CD2, 0x7825, WORD_LEN, 0},
{ 0x8CD4, 0x16B8, WORD_LEN, 0},
{ 0x8CD6, 0x1101, WORD_LEN, 0},
{ 0x8CD8, 0x16BA, WORD_LEN, 0},
{ 0x8CDA, 0x1102, WORD_LEN, 0},
{ 0x8CDC, 0x0F0A, WORD_LEN, 0},
{ 0x8CDE, 0x0664, WORD_LEN, 0},
{ 0x8CE0, 0x16B1, WORD_LEN, 0},
{ 0x8CE2, 0x1083, WORD_LEN, 0},
{ 0x8CE4, 0x1E3D, WORD_LEN, 0},
{ 0x8CE6, 0x1002, WORD_LEN, 0},
{ 0x8CE8, 0x153A, WORD_LEN, 0},
{ 0x8CEA, 0x1080, WORD_LEN, 0},
{ 0x8CEC, 0x153B, WORD_LEN, 0},
{ 0x8CEE, 0x1081, WORD_LEN, 0},
{ 0x8CF0, 0x16B6, WORD_LEN, 0},
{ 0x8CF2, 0x1084, WORD_LEN, 0},
{ 0x8CF4, 0xB808, WORD_LEN, 0},
{ 0x8CF6, 0x7825, WORD_LEN, 0},
{ 0x8CF8, 0x16B8, WORD_LEN, 0},
{ 0x8CFA, 0x1101, WORD_LEN, 0},
{ 0x8CFC, 0x16BA, WORD_LEN, 0},
{ 0x8CFE, 0x1102, WORD_LEN, 0},
{ 0x8D00, 0x0EE6, WORD_LEN, 0},
{ 0x8D02, 0x0664, WORD_LEN, 0},
{ 0x8D04, 0x16B4, WORD_LEN, 0},
{ 0x8D06, 0x1083, WORD_LEN, 0},
{ 0x8D08, 0x1E3E, WORD_LEN, 0},
{ 0x8D0A, 0x1002, WORD_LEN, 0},
{ 0x8D0C, 0x153A, WORD_LEN, 0},
{ 0x8D0E, 0x1080, WORD_LEN, 0},
{ 0x8D10, 0x153B, WORD_LEN, 0},
{ 0x8D12, 0x1081, WORD_LEN, 0},
{ 0x8D14, 0x16B7, WORD_LEN, 0},
{ 0x8D16, 0x1084, WORD_LEN, 0},
{ 0x8D18, 0xB808, WORD_LEN, 0},
{ 0x8D1A, 0x7825, WORD_LEN, 0},
{ 0x8D1C, 0x16B8, WORD_LEN, 0},
{ 0x8D1E, 0x1101, WORD_LEN, 0},
{ 0x8D20, 0x16BA, WORD_LEN, 0},
{ 0x8D22, 0x1102, WORD_LEN, 0},
{ 0x8D24, 0x0EC2, WORD_LEN, 0},
{ 0x8D26, 0x0664, WORD_LEN, 0},
{ 0x8D28, 0x16B5, WORD_LEN, 0},
{ 0x8D2A, 0x1083, WORD_LEN, 0},
{ 0x8D2C, 0x1E3F, WORD_LEN, 0},
{ 0x8D2E, 0x1002, WORD_LEN, 0},
{ 0x8D30, 0x8E00, WORD_LEN, 0},
{ 0x8D32, 0xB8A6, WORD_LEN, 0},
{ 0x8D34, 0xAE00, WORD_LEN, 0},
{ 0x8D36, 0x153A, WORD_LEN, 0},
{ 0x8D38, 0x1081, WORD_LEN, 0},
{ 0x8D3A, 0x153B, WORD_LEN, 0},
{ 0x8D3C, 0x1080, WORD_LEN, 0},
{ 0x8D3E, 0xB908, WORD_LEN, 0},
{ 0x8D40, 0x7905, WORD_LEN, 0},
{ 0x8D42, 0x16BA, WORD_LEN, 0},
{ 0x8D44, 0x1100, WORD_LEN, 0},
{ 0x8D46, 0x085B, WORD_LEN, 0},
{ 0x8D48, 0x0042, WORD_LEN, 0},
{ 0x8D4A, 0xD018, WORD_LEN, 0},
{ 0x8D4C, 0x9E31, WORD_LEN, 0},
{ 0x8D4E, 0x904D, WORD_LEN, 0},
{ 0x8D50, 0x0A2B, WORD_LEN, 0},
{ 0x8D52, 0x0063, WORD_LEN, 0},
{ 0x8D54, 0x8E00, WORD_LEN, 0},
{ 0x8D56, 0x16B0, WORD_LEN, 0},
{ 0x8D58, 0x1081, WORD_LEN, 0},
{ 0x8D5A, 0x1E3C, WORD_LEN, 0},
{ 0x8D5C, 0x1042, WORD_LEN, 0},
{ 0x8D5E, 0x16B1, WORD_LEN, 0},
{ 0x8D60, 0x1081, WORD_LEN, 0},
{ 0x8D62, 0x1E3D, WORD_LEN, 0},
{ 0x8D64, 0x1042, WORD_LEN, 0},
{ 0x8D66, 0x16B4, WORD_LEN, 0},
{ 0x8D68, 0x1081, WORD_LEN, 0},
{ 0x8D6A, 0x1E3E, WORD_LEN, 0},
{ 0x8D6C, 0x1042, WORD_LEN, 0},
{ 0x8D6E, 0x16B5, WORD_LEN, 0},
{ 0x8D70, 0x1081, WORD_LEN, 0},
{ 0x8D72, 0x1E3F, WORD_LEN, 0},
{ 0x8D74, 0x1042, WORD_LEN, 0},
{ 0x8D76, 0xB886, WORD_LEN, 0},
{ 0x8D78, 0xF012, WORD_LEN, 0},
{ 0x8D7A, 0x16B2, WORD_LEN, 0},
{ 0x8D7C, 0x1081, WORD_LEN, 0},
{ 0x8D7E, 0xB8A6, WORD_LEN, 0},
{ 0x8D80, 0x1E3C, WORD_LEN, 0},
{ 0x8D82, 0x1042, WORD_LEN, 0},
{ 0x8D84, 0x16B3, WORD_LEN, 0},
{ 0x8D86, 0x1081, WORD_LEN, 0},
{ 0x8D88, 0x1E3D, WORD_LEN, 0},
{ 0x8D8A, 0x1042, WORD_LEN, 0},
{ 0x8D8C, 0x16B6, WORD_LEN, 0},
{ 0x8D8E, 0x1081, WORD_LEN, 0},
{ 0x8D90, 0x1E3E, WORD_LEN, 0},
{ 0x8D92, 0x1042, WORD_LEN, 0},
{ 0x8D94, 0x16B7, WORD_LEN, 0},
{ 0x8D96, 0x1081, WORD_LEN, 0},
{ 0x8D98, 0x1E3F, WORD_LEN, 0},
{ 0x8D9A, 0x1042, WORD_LEN, 0},
{ 0x8D9C, 0xAE00, WORD_LEN, 0},
{ 0x8D9E, 0x0D92, WORD_LEN, 0},
{ 0x8DA0, 0x0184, WORD_LEN, 0},
{ 0x8DA2, 0x051D, WORD_LEN, 0},
{ 0x8DA4, 0x0684, WORD_LEN, 0},
{ 0x8DA6, 0x78E0, WORD_LEN, 0},
{ 0x8DA8, 0xFF80, WORD_LEN, 0},
{ 0x8DAA, 0x050C, WORD_LEN, 0},
{ 0x8DAC, 0xE280, WORD_LEN, 0},
{ 0x8DAE, 0x24CA, WORD_LEN, 0},
{ 0x8DB0, 0x7082, WORD_LEN, 0},
{ 0x8DB2, 0x78E0, WORD_LEN, 0},
{ 0x8DB4, 0x20E8, WORD_LEN, 0},
{ 0x8DB6, 0x01A2, WORD_LEN, 0},
{ 0x8DB8, 0x1002, WORD_LEN, 0},
{ 0x8DBA, 0x0D02, WORD_LEN, 0},
{ 0x8DBC, 0x1902, WORD_LEN, 0},
{ 0x8DBE, 0x0094, WORD_LEN, 0},
{ 0x8DC0, 0x7FE0, WORD_LEN, 0},
{ 0x8DC2, 0x7028, WORD_LEN, 0},
{ 0x8DC4, 0x7308, WORD_LEN, 0},
{ 0x8DC6, 0x1000, WORD_LEN, 0},
{ 0x8DC8, 0x0900, WORD_LEN, 0},
{ 0x8DCA, 0x7904, WORD_LEN, 0},
{ 0x8DCC, 0x7947, WORD_LEN, 0},
{ 0x8DCE, 0x1B00, WORD_LEN, 0},
{ 0x8DD0, 0x0064, WORD_LEN, 0},
{ 0x8DD2, 0x7EE0, WORD_LEN, 0},
{ 0x8DD4, 0xE280, WORD_LEN, 0},
{ 0x8DD6, 0x24CA, WORD_LEN, 0},
{ 0x8DD8, 0x7082, WORD_LEN, 0},
{ 0x8DDA, 0x78E0, WORD_LEN, 0},
{ 0x8DDC, 0x20E8, WORD_LEN, 0},
{ 0x8DDE, 0x01A2, WORD_LEN, 0},
{ 0x8DE0, 0x1102, WORD_LEN, 0},
{ 0x8DE2, 0x0502, WORD_LEN, 0},
{ 0x8DE4, 0x1802, WORD_LEN, 0},
{ 0x8DE6, 0x00B4, WORD_LEN, 0},
{ 0x8DE8, 0x7FE0, WORD_LEN, 0},
{ 0x8DEA, 0x7028, WORD_LEN, 0},
{ 0x8DEC, 0x0000, WORD_LEN, 0},
{ 0x8DEE, 0x0000, WORD_LEN, 0},
{ 0x8DF0, 0xFF80, WORD_LEN, 0},
{ 0x8DF2, 0x0978, WORD_LEN, 0},
{ 0x8DF4, 0xFF80, WORD_LEN, 0},
{ 0x8DF6, 0x0A4C, WORD_LEN, 0},
{ 0x8DF8, 0x0000, WORD_LEN, 0},
{ 0x8DFA, 0x08DC, WORD_LEN, 0},
{ 0x8DFC, 0x0000, WORD_LEN, 0},
{ 0x8DFE, 0x0998, WORD_LEN, 0},
{ 0x098E, 0x0016, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0x8016, 0x086C, WORD_LEN, 0}, 	// MON_ADDRESS_LO
{ 0x8002, 0x0001, WORD_LEN, 0}, 	// MON_CMD
//POLL_{0x800A,0x00,!=0x07,DELAY=10,TIMEOUT=100	//Wait for the core ready
////{ SEQUENCE_WAIT_MS,300, BYTE_LEN, 0},
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},
//char_settings
{ 0x30D4, 0x9080, WORD_LEN, 0}, 	// COLUMN_CORRECTION
{ 0x316E, 0xC400, WORD_LEN, 0}, 	// DAC_ECL
{ 0x305E, 0x10A0, WORD_LEN, 0}, 	// GLOBAL_GAIN
{ 0x3E00, 0x0010, WORD_LEN, 0}, 	// SAMP_CONTROL
{ 0x3E02, 0xED02, WORD_LEN, 0}, 	// SAMP_ADDR_EN
{ 0x3E04, 0xC88C, WORD_LEN, 0}, 	// SAMP_RD1_SIG
{ 0x3E06, 0xC88C, WORD_LEN, 0}, 	// SAMP_RD1_SIG_BOOST
{ 0x3E08, 0x700A, WORD_LEN, 0}, 	// SAMP_RD1_RST
{ 0x3E0A, 0x701E, WORD_LEN, 0}, 	// SAMP_RD1_RST_BOOST
{ 0x3E0C, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST1_EN
{ 0x3E0E, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST1_BOOST
{ 0x3E10, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST1_CLOOP_SH
{ 0x3E12, 0x0000, WORD_LEN, 0}, 	// SAMP_RST_BOOST_SEQ
{ 0x3E14, 0xC78C, WORD_LEN, 0}, 	// SAMP_SAMP1_SIG
{ 0x3E16, 0x6E06, WORD_LEN, 0}, 	// SAMP_SAMP1_RST
{ 0x3E18, 0xA58C, WORD_LEN, 0}, 	// SAMP_TX_EN
{ 0x3E1A, 0xA58E, WORD_LEN, 0}, 	// SAMP_TX_BOOST
{ 0x3E1C, 0xA58E, WORD_LEN, 0}, 	// SAMP_TX_CLOOP_SH
{ 0x3E1E, 0xC0D0, WORD_LEN, 0}, 	// SAMP_TX_BOOST_SEQ
{ 0x3E20, 0xEB00, WORD_LEN, 0}, 	// SAMP_VLN_EN
{ 0x3E22, 0x00FF, WORD_LEN, 0}, 	// SAMP_VLN_HOLD
{ 0x3E24, 0xEB02, WORD_LEN, 0}, 	// SAMP_VCL_EN
{ 0x3E26, 0xEA02, WORD_LEN, 0}, 	// SAMP_COLCLAMP
{ 0x3E28, 0xEB0A, WORD_LEN, 0}, 	// SAMP_SH_VCL
{ 0x3E2A, 0xEC01, WORD_LEN, 0}, 	// SAMP_SH_VREF
{ 0x3E2C, 0xEB01, WORD_LEN, 0}, 	// SAMP_SH_VBST
{ 0x3E2E, 0x00FF, WORD_LEN, 0}, 	// SAMP_SPARE
{ 0x3E30, 0x00F3, WORD_LEN, 0}, 	// SAMP_READOUT
{ 0x3E32, 0x3DFA, WORD_LEN, 0}, 	// SAMP_RESET_DONE
{ 0x3E34, 0x00FF, WORD_LEN, 0}, 	// SAMP_VLN_CLAMP
{ 0x3E36, 0x00F3, WORD_LEN, 0}, 	// SAMP_ASC_INT
{ 0x3E38, 0x0000, WORD_LEN, 0}, 	// SAMP_RS_CLOOP_SH_R
{ 0x3E3A, 0xF802, WORD_LEN, 0}, 	// SAMP_RS_CLOOP_SH
{ 0x3E3C, 0x0FFF, WORD_LEN, 0}, 	// SAMP_RS_BOOST_SEQ
{ 0x3E3E, 0xEA10, WORD_LEN, 0}, 	// SAMP_TXLO_GND
{ 0x3E40, 0xEB05, WORD_LEN, 0}, 	// SAMP_VLN_PER_COL
{ 0x3E42, 0xE5C8, WORD_LEN, 0}, 	// SAMP_RD2_SIG
{ 0x3E44, 0xE5C8, WORD_LEN, 0}, 	// SAMP_RD2_SIG_BOOST
{ 0x3E46, 0x8C70, WORD_LEN, 0}, 	// SAMP_RD2_RST
{ 0x3E48, 0x8C71, WORD_LEN, 0}, 	// SAMP_RD2_RST_BOOST
{ 0x3E4A, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST2_EN
{ 0x3E4C, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST2_BOOST
{ 0x3E4E, 0x00FF, WORD_LEN, 0}, 	// SAMP_RST2_CLOOP_SH
{ 0x3E50, 0xE38D, WORD_LEN, 0}, 	// SAMP_SAMP2_SIG
{ 0x3E52, 0x8B0A, WORD_LEN, 0}, 	// SAMP_SAMP2_RST
{ 0x3E58, 0xEB0A, WORD_LEN, 0}, 	// SAMP_PIX_CLAMP_EN
{ 0x3E5C, 0x0A00, WORD_LEN, 0}, 	// SAMP_PIX_PULLUP_EN
{ 0x3E5E, 0x00FF, WORD_LEN, 0}, 	// SAMP_PIX_PULLDOWN_EN_R
{ 0x3E60, 0x00FF, WORD_LEN, 0}, 	// SAMP_PIX_PULLDOWN_EN_S
{ 0x3E90, 0x3C01, WORD_LEN, 0}, 	// RST_ADDR_EN
{ 0x3E92, 0x00FF, WORD_LEN, 0}, 	// RST_RST_EN
{ 0x3E94, 0x00FF, WORD_LEN, 0}, 	// RST_RST_BOOST
{ 0x3E96, 0x3C00, WORD_LEN, 0}, 	// RST_TX_EN
{ 0x3E98, 0x3C00, WORD_LEN, 0}, 	// RST_TX_BOOST
{ 0x3E9A, 0x3C00, WORD_LEN, 0}, 	// RST_TX_CLOOP_SH
{ 0x3E9C, 0xC0E0, WORD_LEN, 0}, 	// RST_TX_BOOST_SEQ
{ 0x3E9E, 0x00FF, WORD_LEN, 0}, 	// RST_RST_CLOOP_SH
{ 0x3EA0, 0x0000, WORD_LEN, 0}, 	// RST_RST_BOOST_SEQ
{ 0x3EA6, 0x3C00, WORD_LEN, 0}, 	// RST_PIX_PULLUP_EN
{ 0x3ED8, 0x3057, WORD_LEN, 0}, 	// DAC_LD_12_13
{ 0x316C, 0xB44F, WORD_LEN, 0}, 	// DAC_TXLO
{ 0x316E, 0xC6FF, WORD_LEN, 0}, 	// DAC_ECL
{ 0x3ED2, 0xEA0A, WORD_LEN, 0}, 	// DAC_LD_6_7
{ 0x3ED4, 0x00A3, WORD_LEN, 0}, 	// DAC_LD_8_9
{ 0x3EDC, 0x6020, WORD_LEN, 0}, 	// DAC_LD_16_17
{ 0x3EE6, 0xA541, WORD_LEN, 0}, 	// DAC_LD_26_27
{ 0x31E0, 0x0001, WORD_LEN, 0}, 	// PIX_DEF_ID
{ 0x3ED0, 0x2409, WORD_LEN, 0}, 	// DAC_LD_4_5
//{ 0x3EDA, 0x6000 	// DAC_LD_14_15  //
{ 0x3EDE, 0x0A49, WORD_LEN, 0}, 	// DAC_LD_18_19
{ 0x3EE0, 0x4910, WORD_LEN, 0}, 	// DAC_LD_20_21
{ 0x3EE2, 0x09D2, WORD_LEN, 0}, 	// DAC_LD_22_23
{ 0x30B6, 0x0008, WORD_LEN, 0}, 	// AUTOLR_CONTROL
{ 0x337C, 0x0006, WORD_LEN, 0}, 	// YUV_YCBCR_CONTROL
{ 0x3E1A, 0xA582, WORD_LEN, 0}, 	// SAMP_TX_BOOST
{ 0x3E2E, 0xEC05, WORD_LEN, 0}, 	// SAMP_SPARE
{ 0x3EE6, 0xA5C0, WORD_LEN, 0}, 	// DAC_LD_26_27
{ 0x316C, 0xB43F, WORD_LEN, 0}, 	// DAC_TXLO
{ 0x316E, 0xC6FF, WORD_LEN, 0}, 	// DAC_ECL
//LOAD = Lens Correction 90% 04/29/10 12:58:28
{ 0x381C, 0x0000, WORD_LEN, 0},
{ 0xE02A, 0x0001, WORD_LEN, 0}, 	// IO_NV_MEM_COMMAND
  //  POLL  IO_NV_MEM_STATUS::IO_NVMEM_STAT_OTPM_AVAIL =>  0x00
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},
{ 0x3812, 0x2124, WORD_LEN, 0},
//POLL_FIELD= IO_NV_MEM_STATUS, IO_NV_MEM_STATUS!=0xC1,DELAY=100,TIMEOUT=50 //5 sec
{ SEQUENCE_WAIT_MS,100, BYTE_LEN, 0},
{ 0xD004, 0x04, BYTE_LEN, 0}, 	// PGA_SOLUTION
{ 0xD006, 0x0008, WORD_LEN, 0}, 	// PGA_ZONE_ADDR_0
{ 0xD005, 0x00, BYTE_LEN, 0}, 	// PGA_CURRENT_ZONE
{ 0xD002, 0x8002, WORD_LEN, 0}, 	// PGA_ALGO
{ 0x3210, 0x49B8, WORD_LEN, 0}, 	// COLOR_PIPELINE_CONTROL
//[Step5-AWB_CCM]
//awb_setup
{ 0xAC02, 0x00FF , WORD_LEN, 0 }, 	// AWB_ALGO
{ 0xAC01, 0x7F, BYTE_LEN, 0 }, 	// AWB_MODE
//preawb_params
{ 0xAC3C, 0x39, BYTE_LEN, 0 },	//42 	// AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO
{ 0xAC3D, 0x6E, BYTE_LEN, 0 },	//50 	// AWB_MAX_ACCEPTED_PRE_AWB_R2G_RATIO
{ 0xAC3E, 0x28, BYTE_LEN, 0 },	//13 	// AWB_MIN_ACCEPTED_PRE_AWB_B2G_RATIO
{ 0xAC3F, 0x6B, BYTE_LEN, 0 },	//5B 	// AWB_MAX_ACCEPTED_PRE_AWB_B2G_RATIO
{ 0xAC40, 0x64, BYTE_LEN, 0 },	//52 	// AWB_MIN_ACCEPTED_POST_AWB_R2G_RATIO
{ 0xAC41, 0x66, BYTE_LEN, 0 },	//56 	// AWB_MAX_ACCEPTED_POST_AWB_R2G_RATIO
{ 0xAC42, 0x64, BYTE_LEN, 0 }, 	// AWB_MIN_ACCEPTED_POST_AWB_B2G_RATIO
{ 0xAC43, 0x66, BYTE_LEN, 0 }, 	// AWB_MAX_ACCEPTED_POST_AWB_B2G_RATIO
//awb_patch
{ 0xACB0, 0x31, BYTE_LEN, 0 }, 	// AWB_RG_MIN
{ 0xACB1, 0x5B, BYTE_LEN, 0 },	//50 	// AWB_RG_MAX
{ 0xACB4, 0x2A, BYTE_LEN, 0 },	//13 	// AWB_BG_MIN
{ 0xACB5, 0x5B, BYTE_LEN, 0 }, 	// AWB_BG_MAX
{ 0xACB2, 0x42, BYTE_LEN, 0 },	 	// AWB_RG_MIN_BRIGHT
{ 0xACB3, 0x4B, BYTE_LEN, 0 },	 	// AWB_RG_MAX_BRIGHT
{ 0xACB6, 0x36, BYTE_LEN, 0 },	 	// AWB_BG_MIN_BRIGHT
{ 0xACB7, 0x42, BYTE_LEN, 0 },	 	// AWB_BG_MAX_BRIGHT
{ 0xACB8, 0x00D0, WORD_LEN, 0},		// 0x0100 	// AWB_START_NUM_INT_LINES
{ 0xACBA, 0x0090, WORD_LEN, 0},		// B0 	// AWB_END_NUM_INT_LINES
//bright_DNP_patch
{ 0x098E, 0xAC09, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS
{ 0xAC09, 0x01, BYTE_LEN, 0}, 	// AWB_MODE_EX
{ 0xAC22, 0x0000, WORD_LEN, 0}, 	// AWB_SHARPNESS_TH
//soc5140_ccm_settings
{ 0x098E, 0x2C46, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_LEFT_CCM_0]
{ 0xAC46, 0x010F, WORD_LEN, 0},   //0x015F 	// AWB_LEFT_CCM_0
{ 0xAC48, 0xFFAE, WORD_LEN, 0},   //0xFFC2 	// AWB_LEFT_CCM_1
{ 0xAC4A, 0x0043, WORD_LEN, 0},   //0xFFDF 	// AWB_LEFT_CCM_2
{ 0xAC4C, 0xFF7E, WORD_LEN, 0},   //0xFF7F 	// AWB_LEFT_CCM_3
{ 0xAC4E, 0x01BD, WORD_LEN, 0},   //0x01BB 	// AWB_LEFT_CCM_4
{ 0xAC50, 0xFFC5, WORD_LEN, 0},   //0xFFC6 	// AWB_LEFT_CCM_5
{ 0xAC52, 0xFFE1, WORD_LEN, 0},   //0xFFC7 	// AWB_LEFT_CCM_6
{ 0xAC54, 0xFF34, WORD_LEN, 0},   //0xFEFA 	// AWB_LEFT_CCM_7
{ 0xAC56, 0x01EB, WORD_LEN, 0},   //0x023F 	// AWB_LEFT_CCM_8
{ 0xAC58, 0x00A8, WORD_LEN, 0}, 	// AWB_LEFT_CCM_R2BRATIO
{ 0xAC5C, 0x0233, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_0
{ 0xAC5E, 0xFF23, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_1
{ 0xAC60, 0xFFAA, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_2
{ 0xAC62, 0xFF91, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_3
{ 0xAC64, 0x01AF, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_4
{ 0xAC66, 0xFFBF, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_5
{ 0xAC68, 0xFFE7, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_6
{ 0xAC6A, 0xFF4C, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_7
{ 0xAC6C, 0x01CE, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_8
{ 0xAC6E, 0x005A, WORD_LEN, 0}, 	// AWB_RIGHT_CCM_R2BRATIO
{ 0xAC72, 0x004D, WORD_LEN, 0}, 	// AWB_LL_CCM_0
{ 0xAC74, 0x0096, WORD_LEN, 0}, 	// AWB_LL_CCM_1
{ 0xAC76, 0x001D, WORD_LEN, 0}, 	// AWB_LL_CCM_2
{ 0xAC78, 0x004D, WORD_LEN, 0}, 	// AWB_LL_CCM_3
{ 0xAC7A, 0x0096, WORD_LEN, 0}, 	// AWB_LL_CCM_4
{ 0xAC7C, 0x001D, WORD_LEN, 0}, 	// AWB_LL_CCM_5
{ 0xAC7E, 0x004D, WORD_LEN, 0}, 	// AWB_LL_CCM_6
{ 0xAC80, 0x0096, WORD_LEN, 0}, 	// AWB_LL_CCM_7
{ 0xAC82, 0x001D, WORD_LEN, 0}, 	// AWB_LL_CCM_8
{ 0xAC97, 0x80, BYTE_LEN, 0}, 	// AWB_LEFT_TINT_COEF_FOR_CCM_ROW_0
{ 0xAC98, 0x80, BYTE_LEN, 0}, 	// AWB_LEFT_TINT_COEF_FOR_CCM_ROW_1
{ 0xAC99, 0x74, BYTE_LEN, 0},   //0x64 	// AWB_LEFT_TINT_COEF_FOR_CCM_ROW_2
{ 0xAC9A, 0x7D, BYTE_LEN, 0},   //0x76 	// AWB_RIGHT_TINT_COEF_FOR_CCM_ROW_0
{ 0xAC9B, 0x80, BYTE_LEN, 0}, 	// AWB_RIGHT_TINT_COEF_FOR_CCM_ROW_1
{ 0xAC9C, 0x7D, BYTE_LEN, 0},   //0x78 	// AWB_RIGHT_TINT_COEF_FOR_CCM_ROW_2
{ 0xB83E, 0x10, BYTE_LEN, 0}, 	// STAT_AWB_WINDOW_POS_X
{ 0xB83F, 0x10, BYTE_LEN, 0}, 	// STAT_AWB_WINDOW_POS_Y
{ 0xB840, 0xDF, BYTE_LEN, 0}, 	// STAT_AWB_WINDOW_SIZE_X
{ 0xB841, 0xCF, BYTE_LEN, 0}, 	// STAT_AWB_WINDOW_SIZE_Y
//soc5140_weighted2D_awb_settings
{ 0xB842, 0x0034, WORD_LEN, 0},   //0x0032 	// STAT_AWB_GRAY_CHECKER_OFFSET_X
{ 0xB844, 0x003C, WORD_LEN, 0},   //0x0038 	// STAT_AWB_GRAY_CHECKER_OFFSET_Y
{ 0x3240, 0x0024, WORD_LEN, 0}, 	// AWB_XY_SCALE
{ 0x3242, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R0
{ 0x3244, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R1
{ 0x3246, 0x0000, WORD_LEN, 0}, 	// AWB_WEIGHT_R2
{ 0x3248, 0x7070, WORD_LEN, 0}, 	// AWB_WEIGHT_R3
{ 0x324A, 0x38E0, WORD_LEN, 0}, 	// AWB_WEIGHT_R4
{ 0x324C, 0x70E0, WORD_LEN, 0}, 	// AWB_WEIGHT_R5
{ 0x324E, 0x01B8, WORD_LEN, 0}, 	// AWB_WEIGHT_R6
{ 0x3250, 0x00AB, WORD_LEN, 0}, 	// AWB_WEIGHT_R7
{ 0xD80F, 0x04, BYTE_LEN, 0}, 	// JPEG_QSCALE_0
{ 0xD810, 0x08, BYTE_LEN, 0}, 	// JPEG_QSCALE_1
{ 0xC8D2, 0x04, BYTE_LEN, 0}, 	// CAM_OUTPUT_1_JPEG_QSCALE_0
{ 0xC8D3, 0x08, BYTE_LEN, 0}, 	// CAM_OUTPUT_1_JPEG_QSCALE_1
{ 0xC8BC, 0x04, BYTE_LEN, 0}, 	// CAM_OUTPUT_0_JPEG_QSCALE_0
{ 0xC8BD, 0x08, BYTE_LEN, 0}, 	// CAM_OUTPUT_0_JPEG_QSCALE_1
//sys_settings
{ 0x301A, 0x10F4, WORD_LEN, 0}, 	// RESET_REGISTER
{ 0x301E, 0x0083, WORD_LEN, 0}, 	// DATA_PEDESTAL
{ 0x301A, 0x10FC, WORD_LEN, 0}, 	// RESET_REGISTER
{ 0xDC33, 0x20, BYTE_LEN, 0}, 	// SYS_FIRST_BLACK_LEVEL
{ 0xDC35, 0x04, BYTE_LEN, 0}, 	// SYS_UV_COLOR_BOOST
{ 0x326E, 0x0006, WORD_LEN, 0}, 	// LOW_PASS_YUV_FILTER
{ 0xDC37, 0x62, BYTE_LEN, 0}, 	// SYS_BRIGHT_COLORKILL
{ 0x35A4, 0x0596, WORD_LEN, 0}, 	// BRIGHT_COLOR_KILL_CONTROLS
{ 0x35A2, 0x009C, WORD_LEN, 0}, 	// DARK_COLOR_KILL_CONTROLS
{ 0x098E, 0x5C02, WORD_LEN, 0},		// MCU_ADDR
{ 0xDC02, 0x003E, WORD_LEN, 0}, 	// SYS_ALGO
{ 0xDC36, 0x34, BYTE_LEN, 0}, 	// SYS_DARK_COLOR_KILL
	// Refresh Mode - skip
{ 0xBC18, 0x00, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_0
{ 0xBC19, 0x11, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_1
{ 0xBC1A, 0x23, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_2
{ 0xBC1B, 0x3F, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_3
{ 0xBC1C, 0x67, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_4
{ 0xBC1D, 0x85, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_5
{ 0xBC1E, 0x9B, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_6
{ 0xBC1F, 0xAD, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_7
{ 0xBC20, 0xBB, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_8
{ 0xBC21, 0xC7, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_9
{ 0xBC22, 0xD1, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_10
{ 0xBC23, 0xDA, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_11
{ 0xBC24, 0xE1, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_12
{ 0xBC25, 0xE8, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_13
{ 0xBC26, 0xEE, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_14
{ 0xBC27, 0xF3, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_15
{ 0xBC28, 0xF7, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_16
{ 0xBC29, 0xFB, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_17
{ 0xBC2A, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_CONTRAST_CURVE_18
{ 0xBC2B, 0x00, BYTE_LEN, 0},  	// LL_GAMMA_NEUTRAL_CURVE_0
{ 0xBC2C, 0x0A, BYTE_LEN, 0},  	// LL_GAMMA_NEUTRAL_CURVE_1
{ 0xBC2D, 0x1C, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_2
{ 0xBC2E, 0x36, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_3
{ 0xBC2F, 0x53, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_4
{ 0xBC30, 0x6F, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_5
{ 0xBC31, 0x86, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_6
{ 0xBC32, 0x99, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_7
{ 0xBC33, 0xAB, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_8
{ 0xBC34, 0xBB, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_9
{ 0xBC35, 0xC6, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_10
{ 0xBC36, 0xD0, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_11
{ 0xBC37, 0xD9, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_12
{ 0xBC38, 0xE2, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_13
{ 0xBC39, 0xE9, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_14
{ 0xBC3A, 0xEF, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_15
{ 0xBC3B, 0xF5, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_16
{ 0xBC3C, 0xFA, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_17
{ 0xBC3D, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_NEUTRAL_CURVE_18
{ 0xBC3E, 0x00, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_0
{ 0xBC3F, 0x18, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_1
{ 0xBC40, 0x25, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_2
{ 0xBC41, 0x3A, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_3
{ 0xBC42, 0x59, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_4
{ 0xBC43, 0x70, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_5
{ 0xBC44, 0x81, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_6
{ 0xBC45, 0x90, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_7
{ 0xBC46, 0x9E, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_8
{ 0xBC47, 0xAB, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_9
{ 0xBC48, 0xB6, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_10
{ 0xBC49, 0xC1, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_11
{ 0xBC4A, 0xCB, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_12
{ 0xBC4B, 0xD5, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_13
{ 0xBC4C, 0xDE, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_14
{ 0xBC4D, 0xE7, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_15
{ 0xBC4E, 0xEF, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_16
{ 0xBC4F, 0xF7, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_17
{ 0xBC50, 0xFF, BYTE_LEN, 0}, 	// LL_GAMMA_NR_CURVE_18
{ 0xBC51, 0x04, BYTE_LEN, 0}, 	// LL_GAMMA_CURVE_SELECTOR
//BM_dampening
{ 0xB801, 0xE0, BYTE_LEN, 0}, 	// STAT_MODE
{ 0xB862, 0x04, BYTE_LEN, 0}, 	// STAT_BMTRACKING_SPEED
//AE
{ 0xB829, 0x02, BYTE_LEN, 0}, 	// STAT_LL_BRIGHTNESS_METRIC_DIVISOR
{ 0xB863, 0x02, BYTE_LEN, 0}, 	// STAT_BM_MUL
{ 0xB827, 0x0F, BYTE_LEN, 0}, 	// STAT_AE_EV_SHIFT
{ 0xA409, 0x4A, BYTE_LEN, 0}, 	// AE_RULE_BASE_TARGET
{ 0xA805, 0x06, BYTE_LEN, 0}, 	// AE_TRACK_GATE
{ 0xA80D, 0x08, BYTE_LEN, 0},
{ 0xA816, 0x0002, WORD_LEN, 0}, 	// AE_TRACK_MIN_INT_TIME_ROWS
{ 0xA401, 0x00, BYTE_LEN, 0}, 	// AE_RULE_MODE
{ 0xA80E, 0x06, BYTE_LEN, 0}, 	// AE_TRACK_MAX_BLACK_LEVEL
//BM_GM_start_stop
{ 0xC8E6, 0x014C, WORD_LEN, 0}, 	// RESERVED_CAM_E6
{ 0xC8E8, 0x0040, WORD_LEN, 0}, 	// RESERVED_CAM_E8
{ 0xBC52, 0x00C8, WORD_LEN, 0}, 	// LL_START_BRIGHTNESS_METRIC
{ 0xBC54, 0x0A28, WORD_LEN, 0}, 	// LL_END_BRIGHTNESS_METRIC
{ 0xBC58, 0x0100, WORD_LEN, 0},   //0x0000 	// LL_START_GAIN_METRIC
{ 0xBC5A, 0x0480, WORD_LEN, 0},   //0x1000 	// LL_END_GAIN_METRIC
{ 0xBC5E, 0x0227, WORD_LEN, 0}, 	// LL_START_APERTURE_GAIN_BM
{ 0xBC60, 0x0540, WORD_LEN, 0}, 	// LL_END_APERTURE_GAIN_BM
{ 0xBC66, 0x0154, WORD_LEN, 0}, 	// LL_START_APERTURE_GM
{ 0xBC68, 0x07D0, WORD_LEN, 0}, 	// LL_END_APERTURE_GM
{ 0xBC86, 0x00C8, WORD_LEN, 0}, 	// LL_START_FFNR_GM
{ 0xBC88, 0x0420, WORD_LEN, 0}, 	// LL_END_FFNR_GM
{ 0xBCBC, 0x0040, WORD_LEN, 0}, 	// LL_SFFB_START_GAIN
{ 0xBCBE, 0x01FC, WORD_LEN, 0}, 	// LL_SFFB_END_GAIN
{ 0xBCCC, 0x00C8, WORD_LEN, 0}, 	// LL_SFFB_START_MAX_GM
{ 0xBCCE, 0x0640, WORD_LEN, 0}, 	// LL_SFFB_END_MAX_GM
{ 0xBC90, 0x00C8, WORD_LEN, 0}, 	// LL_START_GRB_GM
{ 0xBC92, 0x0640, WORD_LEN, 0}, 	// LL_END_GRB_GM
{ 0xBC0E, 0x0032, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_START_POS
{ 0xBC10, 0x0064, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_MID_POS
{ 0xBC12, 0x0FA0, WORD_LEN, 0}, 	// LL_GAMMA_CURVE_ADJ_END_POS
{ 0xBCAA, 0x03E8, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_START_POS
{ 0xBCAC, 0x012C, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_MID_POS
{ 0xBCAE, 0x0009, WORD_LEN, 0}, 	// LL_CDC_THR_ADJ_END_POS
{ 0xBCD8, 0x00C8, WORD_LEN, 0}, 	// LL_PCR_START_BM
{ 0xBCDA, 0x0A28, WORD_LEN, 0}, 	// LL_PCR_END_BM

//[Kernel]
{ 0x3380, 0x0504, WORD_LEN, 0}, 	// KERNEL_CONFIG
{ 0x3380, 0x0505, WORD_LEN, 0}, 	// KERNEL_CONFIG
{ 0x3380, 0x0584, WORD_LEN, 0}, 	// KERNEL_CONFIG
{ 0x3380, 0x0586, WORD_LEN, 0}, 	// KERNEL_CONFIG
{ 0x3380, 0x0587, WORD_LEN, 0}, 	// KERNEL_CONFIG

//GRB
{ 0xBC94, 0x06, BYTE_LEN, 0}, 	// LL_GB_START_THRESHOLD_0
{ 0xBC95, 0x05, BYTE_LEN, 0}, 	// LL_GB_START_THRESHOLD_1
{ 0xBC9C, 0x09, BYTE_LEN, 0}, 	// RESERVED_LL_9C
{ 0xBC9D, 0x05, BYTE_LEN, 0}, 	// RESERVED_LL_9D

//demosaic
{ 0x33B0, 0x2A16, WORD_LEN, 0}, 	// FFNR_ALPHA_BETA
{ 0xBC8A, 0x0E, BYTE_LEN, 0},   //0x00 	// LL_START_FF_MIX_THRESH_Y
{ 0xBC8B, 0x4C, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_Y
{ 0xBC8C, 0x00, BYTE_LEN, 0}, 	// LL_START_FF_MIX_THRESH_YGAIN
{ 0xBC8D, 0x24, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_YGAIN
{ 0xBC8E, 0xFF, BYTE_LEN, 0}, 	// LL_START_FF_MIX_THRESH_GAIN
{ 0xBC8F, 0x00, BYTE_LEN, 0}, 	// LL_END_FF_MIX_THRESH_GAIN
{ 0xBCB2, 0x20, BYTE_LEN, 0}, 	// LL_CDC_DARK_CLUS_SLOPE
{ 0xBCB3, 0x3A, BYTE_LEN, 0}, 	// LL_CDC_DARK_CLUS_SATUR
{ 0xBCB4, 0x39, BYTE_LEN, 0}, 	// RESERVED_LL_B4
{ 0xBCB7, 0x39, BYTE_LEN, 0}, 	// RESERVED_LL_B7
{ 0xBCB5, 0x20, BYTE_LEN, 0}, 	// RESERVED_LL_B5
{ 0xBCB8, 0x3A, BYTE_LEN, 0}, 	// RESERVED_LL_B8
{ 0xBCB6, 0x80, BYTE_LEN, 0}, 	// RESERVED_LL_B6
{ 0xBCB9, 0x24, BYTE_LEN, 0}, 	// RESERVED_LL_B9

//SFFB_rev3_noisemodel
{ 0xBCC0, 0x1F, BYTE_LEN, 0}, 	// LL_SFFB_RAMP_START
{ 0xBCC1, 0x03, BYTE_LEN, 0}, 	// LL_SFFB_RAMP_STOP
{ 0xBCC2, 0x3C, BYTE_LEN, 0}, 	// LL_SFFB_SLOPE_START
{ 0xBCC3, 0x10, BYTE_LEN, 0}, 	// LL_SFFB_SLOPE_STOP
{ 0xBCC4, 0x07, BYTE_LEN, 0}, 	// LL_SFFB_THSTART
{ 0xBCC5, 0x0B, BYTE_LEN, 0}, 	// LL_SFFB_THSTOP
{ 0xBCBA, 0x0009, WORD_LEN, 0}, 	// LL_SFFB_CONFIG

//[Step7-CPIPE_Preference]
//ftb_off
{ 0xBC14, 0xFFFE, WORD_LEN, 0}, 	// LL_GAMMA_FADE_TO_BLACK_START_POS
{ 0xBC16, 0xFFFF, WORD_LEN, 0}, 	// LL_GAMMA_FADE_TO_BLACK_END_POS

//aperture_preference
{ 0xBC6A, 0x06, BYTE_LEN, 0}, 	// LL_START_APERTURE_INTEGER_GAIN
{ 0xBC6B, 0x00, BYTE_LEN, 0}, 	// LL_END_APERTURE_INTEGER_GAIN
{ 0xBC6C, 0x00, BYTE_LEN, 0}, 	// LL_START_APERTURE_EXP_GAIN
{ 0xBC6D, 0x00, BYTE_LEN, 0}, 	// LL_END_APERTURE_EXP_GAIN
{ 0xBCE2, 0x0A, BYTE_LEN, 0}, 	// LL_START_POS_KNEE
{ 0xBCE3, 0x2B, BYTE_LEN, 0}, 	// LL_END_POS_KNEE
{ 0xBCE4, 0x0A, BYTE_LEN, 0}, 	// LL_START_NEG_KNEE
{ 0xBCE5, 0x2B, BYTE_LEN, 0}, 	// LL_END_NEG_KNEE
{ 0x33BA, 0x0084, WORD_LEN, 0}, 	// APEDGE_CONTROL
{ 0x33BE, 0x0000, WORD_LEN, 0}, 	// UA_KNEE_L
{ 0x33C2, 0x5600, WORD_LEN, 0}, 	// UA_WEIGHTS
{ 0xBC62, 0x10, BYTE_LEN, 0}, 	// LL_START_APERTURE_KPGAIN
{ 0xBC63, 0x1F, BYTE_LEN, 0}, 	// LL_END_APERTURE_KPGAIN
{ 0xBC64, 0x10, BYTE_LEN, 0}, 	// LL_START_APERTURE_KNGAIN
{ 0xBC65, 0x1F, BYTE_LEN, 0}, 	// LL_END_APERTURE_KNGAIN
{ 0xA81C, 0x0043, WORD_LEN, 0}, 	// AE_TRACK_MIN_AGAIN
{ 0xA81E, 0x0102, WORD_LEN, 0}, 	// AE_TRACK_TARGET_AGAIN
{ 0xA820, 0x0102, WORD_LEN, 0}, 	// AE_TRACK_MAX_AGAIN
{ 0xA822, 0x0080, WORD_LEN, 0}, 	// AE_TRACK_MIN_DGAIN
{ 0xA824, 0x0080, WORD_LEN, 0}, 	// AE_TRACK_MAX_DGAIN

//min_fps
{ 0xA818, 0x07D0, WORD_LEN, 0}, 	// AE_TRACK_TARGET_INT_TIME_ROWS
{ 0xA81A, 0x0A00, WORD_LEN, 0},  //0x0810(10.9Fps)   //0x0FF4(5Fps) 	// AE_TRACK_MAX_INT_TIME_ROWS

//ccm_saturation
{ 0xBC56, 0x80, BYTE_LEN, 0},		//0xA8 	// LL_START_CCM_SATURATION
{ 0xBC57, 0x10, BYTE_LEN, 0},	// LL_END_CCM_SATURATION

//DCCM
{ 0xBCDE, 0x03, BYTE_LEN, 0}, 	// LL_START_SYS_THRESHOLD
{ 0xBCDF, 0x50, BYTE_LEN, 0}, 	// LL_STOP_SYS_THRESHOLD
{ 0xBCE0, 0x08, BYTE_LEN, 0}, 	// LL_START_SYS_GAIN
{ 0xBCE1, 0x03, BYTE_LEN, 0}, 	// LL_STOP_SYS_GAIN

//sobel
{ 0xBCD0, 0x000A, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_FLAT_START
{ 0xBCD2, 0x00FE, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_FLAT_STOP
{ 0xBCD4, 0x001E, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_SHARP_START
{ 0xBCD6, 0x00FF, WORD_LEN, 0}, 	// LL_SFFB_SOBEL_SHARP_STOP
{ 0xBCC6, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_SHARPENING_START
{ 0xBCC7, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_SHARPENING_STOP
{ 0xBCC8, 0x20, BYTE_LEN, 0}, 	// LL_SFFB_FLATNESS_START
{ 0xBCC9, 0x40, BYTE_LEN, 0}, 	// LL_SFFB_FLATNESS_STOP
{ 0xBCCA, 0x04, BYTE_LEN, 0}, 	// LL_SFFB_TRANSITION_START
{ 0xBCCB, 0x00, BYTE_LEN, 0}, 	// LL_SFFB_TRANSITION_STOP
//SFFB_slope_zero_enable
{ 0xBCE6, 0x03 , BYTE_LEN, 0 },	// LL_SFFB_ZERO_ENABLE
//manual_FD(auto)
{ 0x8417, 0x02, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_1_FD
//tx_setting
{ 0xC8ED, 0x02, BYTE_LEN, 0 }, 	// CAM_TX_ENABLE_MODE Context A,B time
//cdc_off
{ 0x8404, 0x06, BYTE_LEN, 0 }, 	// SEQ_CMD
///{ SEQUENCE_WAIT_MS,300, WORD_LEN, 0},
{ SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
{ SEQUENCE_END, 0x00, 0, 0}
};

/* 720p 15fps @ 1280x720 */
static struct reginfo sensor_720p[]=
{
	//{SEQUENCE_END, 0x00},
	{0x098E, 0x843C, WORD_LEN, 0}, // LOGICAL_ADDRESS_ACCESS [CAM_CORE_A_Y_ADDR_START]
	{0x843C, 0x01, BYTE_LEN, 0 }, // SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, BYTE_LEN, 0 }, // SEQ_CMD
	{0x0016, 0x0447, WORD_LEN, 0},  // CLOCKS_CONTROL
	{0xC83A, 0x0106, WORD_LEN, 0},  // CAM_CORE_A_Y_ADDR_START
	{0xC83C, 0x0018, WORD_LEN, 0},  // CAM_CORE_A_X_ADDR_START
	{0xC83E, 0x06B7, WORD_LEN, 0},  // CAM_CORE_A_Y_ADDR_END
	{0xC840, 0x0A45, WORD_LEN, 0},  // CAM_CORE_A_X_ADDR_END
	{0xC86C, 0x0518, WORD_LEN, 0},  // CAM_CORE_A_OUTPUT_SIZE_WIDTH
	{0xC86E, 0x02D8, WORD_LEN, 0},  // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
	{0xC870, 0x0014, WORD_LEN, 0},  // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
	{0xC858, 0x0003, WORD_LEN, 0}, // CAM_CORE_A_COARSE_ITMIN
	{0xC8B8, 0x0004, WORD_LEN, 0},  // CAM_OUTPUT_0_JPEG_CONTROL
/****bug:part pixsels data not to be aquired *****/
#if ADJUST_FOR_720P_FALG            
	{0xC8AA, 0x0500, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_WIDTH
	{0xC8AC, 0x02D1, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_HEIGHT
#else
	{0xC8AA, 0x0500, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_WIDTH
	{0xC8AC, 0x02D0, WORD_LEN, 0},  // CAM_OUTPUT_0_IMAGE_HEIGHT
#endif	
	{0xC8AE, 0x0001, WORD_LEN, 0},  // CAM_OUTPUT_0_OUTPUT_FORMAT
	{0x8404, 0x06, BYTE_LEN, 0 },  // SEQ_CMD

	{SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
   { SEQUENCE_END, 0x00, 0, 0}
};

/* 	1080p, 0x15fps, 0xyuv @1920x1080 */
static struct reginfo sensor_1080p[]=
{
{ SEQUENCE_END, 0x00, 0, 0}
};

/* 2592X1944 QSXGA */
#if  ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_qsxga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0A20,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0798,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_qsxga[] =
{
	{SEQUENCE_PROPERTY,SEQUENCE_CAPTURE},
    { SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 2048*1536 QXGA */
#if ADJUST_FOR_CAPTURE_FALG
// send extra two lines to forbid to be captured error
static struct reginfo sensor_qxga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0800,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0602,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_qxga[] =
{
{ SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 1600X1200 UXGA */
#if ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_uxga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0640,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x04b2,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_uxga[] =
{
    { SEQUENCE_END, 0x00, 0, 0}
};
#endif

/* 1280X1024 SXGA */
static struct reginfo sensor_sxga[] =
{
	{SEQUENCE_END, 0x00}
};

/*  1024X768 XGA */
#if ADJUST_FOR_CAPTURE_FALG
static struct reginfo sensor_xga[] =
{
    {0x098E, 0x48C0,WORD_LEN,0},    // LOGICAL_ADDRESS_ACCESS [CAM_OUTPUT_1_IMAGE_WIDTH]
    {0xC8C0, 0x0403,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_WIDTH
    {0xC8C2, 0x0302,WORD_LEN,0},    // CAM_OUTPUT_1_IMAGE_HEIGHT
    {0x8404, 0x06 ,BYTE_LEN,0},      // SEQ_CMD
    {SEQUENCE_WAIT_MS,100,WORD_LEN,0},
    {SEQUENCE_END, 0x00, 0, 0}
};
#else
static struct reginfo sensor_xga[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif


/* 800X600 SVGA*/
static struct reginfo sensor_svga[] =
{
    { SEQUENCE_END, 0x00, 0, 0}
};

/* 640X480 VGA */
static struct reginfo sensor_vga[] =
{
	//720p2vga
    {0xC83A, 0x000C, WORD_LEN, 0},    // CAM_CORE_A_Y_ADDR_START
    {0xC83C, 0x0018, WORD_LEN, 0},    // CAM_CORE_A_X_ADDR_START
    {0xC83E, 0x07B1, WORD_LEN, 0 },    // CAM_CORE_A_Y_ADDR_END
    {0xC840, 0x0A45, WORD_LEN, 0},    // CAM_CORE_A_X_ADDR_END
    {0xC868, 0x0423, WORD_LEN, 0},    // CAM_CORE_A_FRAME_LENGTH_LINES
    {0xC86A, 0x1194, WORD_LEN, 0},    // CAM_CORE_A_LINE_LENGTH_PCK
    {0xC86C, 0x0518, WORD_LEN, 0},    // CAM_CORE_A_OUTPUT_SIZE_WIDTH
    {0xC86E, 0x03D4, WORD_LEN, 0},    // CAM_CORE_A_OUTPUT_SIZE_HEIGHT
    {0xC870, 0x0014, WORD_LEN, 0},    // CAM_CORE_A_RX_FIFO_TRIGGER_MARK
    {0xC858, 0x0003, WORD_LEN, 0},  // CAM_CORE_A_COARSE_ITMIN
    {0xC8A4, 0x0A28, WORD_LEN, 0},    // CAM_CORE_B_OUTPUT_SIZE_WIDTH
    {0xC8A6, 0x07A0, WORD_LEN, 0 },    // CAM_CORE_B_OUTPUT_SIZE_HEIGHT
    {0xC8AA, 0x0280, WORD_LEN, 0 },    // CAM_OUTPUT_0_IMAGE_WIDTH
    {0xC8AC, 0x01E0, WORD_LEN, 0 },    // CAM_OUTPUT_0_IMAGE_HEIGHT
    {0xC8AE, 0x0001, WORD_LEN, 0 },    // CAM_OUTPUT_0_OUTPUT_FORMAT
    {0x8404, 0x06, BYTE_LEN, 0 }, // SEQ_CMD
    {SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
    {SEQUENCE_END, 0x00, 0, 0}

};

/* 352X288 CIF */
static struct reginfo sensor_cif[] =
{
	{SEQUENCE_END, 0x00}
};

/* 320*240 QVGA */
static  struct reginfo sensor_qvga[] =
{
	{SEQUENCE_END, 0x00}
};

/* 176X144 QCIF*/
static struct reginfo sensor_qcif[] =
{
	{SEQUENCE_END, 0x00}
};
#endif
static  struct reginfo sensor_Preview2Capture[]=
{
	//capture2preview
	{0x098E, 0x843C, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0xFF, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x02, BYTE_LEN, 0 },	// SEQ_CMD
	{SEQUENCE_END, 0x00, 0, 0}

};

static  struct reginfo sensor_Capture2Preview[]=
{
	//snap2preview
	{0x098E, 0x843C, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [SEQ_STATE_CFG_5_MAX_FRAME_CNT]
	{0x843C, 0x01, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_5_MAX_FRAME_CNT
	{0x8404, 0x01, BYTE_LEN, 0 },	// SEQ_CMD
	{0x0016, 0x0447, WORD_LEN, 0},	// CLOCKS_CONTRO
	{SEQUENCE_END, 0x00, 0, 0}

};
static  struct reginfo sensor_ClrFmt_YUYV[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_ClrFmt_UYVY[]=
{
	{SEQUENCE_END, 0x00}
};


#if CONFIG_SENSOR_WhiteBalance
static  struct reginfo sensor_WhiteB_Auto[]=
{
	//Auto
	{0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x31, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x5B, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x2A, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x5B, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x40, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x48, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x3f, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x48, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x00, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{SEQUENCE_END, 0x00, 0, 0}

};
/* Cloudy Colour Temperature : 6500K - 8000K  */
static  struct reginfo sensor_WhiteB_Cloudy[]=
{
	//[V.       DL 7500]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x38, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x42, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x44, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x4C, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x38, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x42, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x44, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x4C, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x7C, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x3E, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x48, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x7F, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}

};
/* ClearDay Colour Temperature : 5000K - 6500K  */
static  struct reginfo sensor_WhiteB_ClearDay[]=
{
	//[IV       Day Light]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x3A, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x40, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x4A, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x3A, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x40, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x4A, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x7C, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x7F, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x40, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x48, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x7F, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}

};
/* Office Colour Temperature : 3500K - 5000K  */
static  struct reginfo sensor_WhiteB_TungstenLamp1[]=
{
	//[III        Fluorescent]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x4B, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x2C, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x34, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x44, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x4B, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x2C, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x34, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x40, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x4A, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x47, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x30, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x45, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}
};
/* Home Colour Temperature : 2500K - 3500K  */
static  struct reginfo sensor_WhiteB_TungstenLamp2[]=
{
	//[II.        Incandescent]
	{ 0x098E, 0xACB0, WORD_LEN, 0}, 	// LOGICAL_ADDRESS_ACCESS [AWB_MIN_ACCEPTED_PRE_AWB_R2G_RATIO]
	{0xACB0, 0x57, BYTE_LEN, 0 }, 	// AWB_RG_MIN
	{0xACB1, 0x5F, BYTE_LEN, 0 }, 	// AWB_RG_MAX
	{0xACB4, 0x26, BYTE_LEN, 0 }, 	// AWB_BG_MIN
	{0xACB5, 0x2E, BYTE_LEN, 0 }, 	// AWB_BG_MAX
	{0xACB2, 0x57, BYTE_LEN, 0 }, 	// AWB_RG_MIN_BRIGHT
	{0xACB3, 0x5F, BYTE_LEN, 0 }, 	// AWB_RG_MAX_BRIGHT
	{0xACB6, 0x26, BYTE_LEN, 0 }, 	// AWB_BG_MIN_BRIGHT
	{0xACB7, 0x2E, BYTE_LEN, 0 }, 	// AWB_BG_MAX_BRIGHT
	{0xAC44, 0x00, BYTE_LEN, 0 }, 	// AWB_LEFT_CCM_POS_RANGE_LIMIT
	{0xAC45, 0x08, BYTE_LEN, 0 }, 	// AWB_RIGHT_CCM_POS_RANGE_LIMIT
	{0xAC04, 0x5B, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_R2G_RATIO
	{0xAC05, 0x2A, BYTE_LEN, 0 }, 	// AWB_PRE_AWB_B2G_RATIO
	{0xAC08, 0x00, BYTE_LEN, 0 }, 	// AWB_CUR_CCM_POS
	{SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_WhiteBalanceSeqe[] = {sensor_WhiteB_Auto, sensor_WhiteB_TungstenLamp1,sensor_WhiteB_TungstenLamp2,
    sensor_WhiteB_ClearDay, sensor_WhiteB_Cloudy,NULL,
};
#endif

#if CONFIG_SENSOR_Brightness
static  struct reginfo sensor_Brightness0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness4[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Brightness5[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_BrightnessSeqe[] = {sensor_Brightness0, sensor_Brightness1, sensor_Brightness2, sensor_Brightness3,
    sensor_Brightness4, sensor_Brightness5,NULL,
};

#endif

#if CONFIG_SENSOR_Effect
static  struct reginfo sensor_Effect_Normal[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x00, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
#if 0
static  struct reginfo sensor_Effect_WandB[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif
static  struct reginfo sensor_Effect_Sepia[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x02, BYTE_LEN, 0 },
	{0xdc3a,0x10, BYTE_LEN, 0 },
	{0xdc3b,0xe0, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_Effect_Negative[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x03, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
#if 0
static  struct reginfo sensor_Effect_Bluish[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_Effect_Green[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
#endif
static struct reginfo sensor_Effect_Solarize[] =
{
	{0x098e,0xdc38, WORD_LEN, 0},
	{0xdc38,0x05, BYTE_LEN, 0 },
	{0xdc39,0x20, BYTE_LEN, 0 },
	{0x8404,0x06, BYTE_LEN, 0 },
	{SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_EffectSeqe[] = {sensor_Effect_Normal, sensor_Effect_Negative,sensor_Effect_Sepia,
    sensor_Effect_Solarize,NULL,
};
#endif
#if CONFIG_SENSOR_Exposure
static  struct reginfo sensor_Exposure0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure4[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure5[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Exposure6[]=
{
	{SEQUENCE_END, 0x00}
};

static struct reginfo *sensor_ExposureSeqe[] = {sensor_Exposure0, sensor_Exposure1, sensor_Exposure2, sensor_Exposure3,
    sensor_Exposure4, sensor_Exposure5,sensor_Exposure6,NULL,
};
#endif
#if CONFIG_SENSOR_Saturation
static  struct reginfo sensor_Saturation0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Saturation2[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_SaturationSeqe[] = {sensor_Saturation0, sensor_Saturation1, sensor_Saturation2, NULL,};

#endif
#if CONFIG_SENSOR_Contrast
static  struct reginfo sensor_Contrast0[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast1[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast2[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast3[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast4[]=
{
	{SEQUENCE_END, 0x00}
};


static  struct reginfo sensor_Contrast5[]=
{
	{SEQUENCE_END, 0x00}
};

static  struct reginfo sensor_Contrast6[]=
{
	{SEQUENCE_END, 0x00}
};
static struct reginfo *sensor_ContrastSeqe[] = {sensor_Contrast0, sensor_Contrast1, sensor_Contrast2, sensor_Contrast3,
    sensor_Contrast4, sensor_Contrast5, sensor_Contrast6, NULL,
};

#endif
#if CONFIG_SENSOR_Mirror
static  struct reginfo sensor_MirrorOn[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_MirrorOff[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_MirrorSeqe[] = {sensor_MirrorOff, sensor_MirrorOn,NULL,};
#endif
#if CONFIG_SENSOR_Flip
static  struct reginfo sensor_FlipOn[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_FlipOff[]=
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_FlipSeqe[] = {sensor_FlipOff, sensor_FlipOn,NULL,};

#endif

#if CONFIG_SENSOR_Scene
static  struct reginfo sensor_SceneAuto[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static  struct reginfo sensor_SceneNight[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_SceneSeqe[] = {sensor_SceneAuto, sensor_SceneNight,NULL,};

#endif

#if CONFIG_SENSOR_DigitalZoom
static struct reginfo sensor_Zoom0[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static struct reginfo sensor_Zoom1[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};

static struct reginfo sensor_Zoom2[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};


static struct reginfo sensor_Zoom3[] =
{
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo *sensor_ZoomSeqe[] = {sensor_Zoom0, sensor_Zoom1, sensor_Zoom2, sensor_Zoom3, NULL};
#endif
static const struct v4l2_querymenu sensor_menus[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 0,  .name = "auto",  .reserved = 0, }, {  .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 1, .name = "incandescent",  .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 2,  .name = "fluorescent", .reserved = 0,}, {  .id = V4L2_CID_DO_WHITE_BALANCE, .index = 3,  .name = "daylight", .reserved = 0,},
    { .id = V4L2_CID_DO_WHITE_BALANCE,  .index = 4,  .name = "cloudy-daylight", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Effect
    { .id = V4L2_CID_EFFECT,  .index = 0,  .name = "none",  .reserved = 0, }, {  .id = V4L2_CID_EFFECT,  .index = 1, .name = "negative",  .reserved = 0,},
    { .id = V4L2_CID_EFFECT,  .index = 2,  .name = "sepia", .reserved = 0,}, {  .id = V4L2_CID_EFFECT, .index = 3,  .name = "solarize", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Scene
    { .id = V4L2_CID_SCENE,  .index = 0, .name = "auto", .reserved = 0,} ,{ .id = V4L2_CID_SCENE,  .index = 1,  .name = "night", .reserved = 0,},
    #endif

	#if CONFIG_SENSOR_Flash
    { .id = V4L2_CID_FLASH,  .index = 0,  .name = "off",  .reserved = 0, }, {  .id = V4L2_CID_FLASH,  .index = 1, .name = "auto",  .reserved = 0,},
    { .id = V4L2_CID_FLASH,  .index = 2,  .name = "on", .reserved = 0,}, {  .id = V4L2_CID_FLASH, .index = 3,  .name = "torch", .reserved = 0,},
    #endif
};

static  struct v4l2_queryctrl sensor_controls[] =
{
	#if CONFIG_SENSOR_WhiteBalance
    {
        .id		= V4L2_CID_DO_WHITE_BALANCE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "White Balance Control",
        .minimum	= 0,
        .maximum	= 4,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Brightness
	{
        .id		= V4L2_CID_BRIGHTNESS,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Brightness Control",
        .minimum	= -3,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Effect
	{
        .id		= V4L2_CID_EFFECT,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Effect Control",
        .minimum	= 0,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Exposure
	{
        .id		= V4L2_CID_EXPOSURE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Exposure Control",
        .minimum	= 0,
        .maximum	= 6,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Saturation
	{
        .id		= V4L2_CID_SATURATION,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Saturation Control",
        .minimum	= 0,
        .maximum	= 2,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Contrast
	{
        .id		= V4L2_CID_CONTRAST,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Contrast Control",
        .minimum	= -3,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
	#endif

	#if CONFIG_SENSOR_Mirror
	{
        .id		= V4L2_CID_HFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Mirror Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Flip
	{
        .id		= V4L2_CID_VFLIP,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Flip Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 1,
    },
    #endif

	#if CONFIG_SENSOR_Scene
    {
        .id		= V4L2_CID_SCENE,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Scene Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_DigitalZoom
    {
        .id		= V4L2_CID_ZOOM_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_ZOOM_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "DigitalZoom Control",
        .minimum	= 0,
        .maximum	= 3,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Focus
	{
        .id		= V4L2_CID_FOCUS_RELATIVE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= -1,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    }, {
        .id		= V4L2_CID_FOCUS_ABSOLUTE,
        .type		= V4L2_CTRL_TYPE_INTEGER,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 255,
        .step		= 1,
        .default_value = 125,
    },
	{
        .id		= V4L2_CID_FOCUS_AUTO,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },{
        .id		= V4L2_CID_FOCUS_CONTINUOUS,
        .type		= V4L2_CTRL_TYPE_BOOLEAN,
        .name		= "Focus Control",
        .minimum	= 0,
        .maximum	= 1,
        .step		= 1,
        .default_value = 0,
    },
    #endif

	#if CONFIG_SENSOR_Flash
	{
        .id		= V4L2_CID_FLASH,
        .type		= V4L2_CTRL_TYPE_MENU,
        .name		= "Flash Control",
        .minimum	= 0,
        .maximum	= 2,
        //.maximum	= 3
        .step		= 1,
        .default_value = 0,
    },
	#endif
};

static int sensor_probe(struct i2c_client *client, const struct i2c_device_id *did);
static int sensor_video_probe(struct soc_camera_device *icd, struct i2c_client *client);
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl);
static int sensor_g_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_s_ext_controls(struct v4l2_subdev *sd,  struct v4l2_ext_controls *ext_ctrl);
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg);
static int sensor_resume(struct soc_camera_device *icd);
static int sensor_set_bus_param(struct soc_camera_device *icd,unsigned long flags);
static unsigned long sensor_query_bus_param(struct soc_camera_device *icd);
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value);
static int sensor_deactivate(struct i2c_client *client);

static struct soc_camera_ops sensor_ops =
{
    .suspend                     = sensor_suspend,
    .resume                       = sensor_resume,
    .set_bus_param		= sensor_set_bus_param,
    .query_bus_param	= sensor_query_bus_param,
    .controls		= sensor_controls,
    .menus                         = sensor_menus,
    .num_controls		= ARRAY_SIZE(sensor_controls),
    .num_menus		= ARRAY_SIZE(sensor_menus),
};

/* only one fixed colorspace per pixelcode */
struct sensor_datafmt {
	enum v4l2_mbus_pixelcode code;
	enum v4l2_colorspace colorspace;
};

/* Find a data format by a pixel code in an array */
static const struct sensor_datafmt *sensor_find_datafmt(
	enum v4l2_mbus_pixelcode code, const struct sensor_datafmt *fmt,
	int n)
{
	int i;
	for (i = 0; i < n; i++)
		if (fmt[i].code == code)
			return fmt + i;

	return NULL;
}

static const struct sensor_datafmt sensor_colour_fmts[] = {
    {V4L2_MBUS_FMT_UYVY8_2X8, V4L2_COLORSPACE_JPEG},
    {V4L2_MBUS_FMT_YUYV8_2X8, V4L2_COLORSPACE_JPEG}	
};
enum sensor_work_state
{
	sensor_work_ready = 0,
	sensor_working,
};
struct sensor_work
{
	struct i2c_client *client;
	struct delayed_work dwork;
	enum sensor_work_state state;
};

typedef struct sensor_info_priv_s
{
    int whiteBalance;
    int brightness;
    int contrast;
    int saturation;
    int effect;
    int scene;
    int digitalzoom;
    int focus;
	int auto_focus;
	int affm_reinit;
    int flash;
    int exposure;
    unsigned char mirror;                                        /* HFLIP */
    unsigned char flip;                                          /* VFLIP */
	bool snap2preview;
	bool video2preview;
	int capture_w;
	int capture_h;
	int preview_w;
	int preview_h;
    struct reginfo *winseqe_cur_addr;
	struct sensor_datafmt fmt;
	unsigned int enable;
	unsigned int funmodule_state;
} sensor_info_priv_t;



struct sensor_parameter
{
	unsigned short int preview_maxlines;
	unsigned short int preview_exposure;
	unsigned short int preview_line_width;
	unsigned short int preview_gain;

	unsigned short int capture_framerate;
	unsigned short int preview_framerate;
};

struct sensor
{
    struct v4l2_subdev subdev;
    struct i2c_client *client;
    sensor_info_priv_t info_priv;
	struct sensor_parameter parameter;
	struct workqueue_struct *sensor_wq;
	struct sensor_work sensor_wk;
	struct mutex wq_lock;
    int model;	/* V4L2_IDENT_OV* codes from v4l2-chip-ident.h */
#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_t tasklock_cnt;
#endif
	struct rk29camera_platform_data *sensor_io_request;
    struct rk29camera_gpio_res *sensor_gpio_res;
};

static struct sensor* to_sensor(const struct i2c_client *client)
{
    return container_of(i2c_get_clientdata(client), struct sensor, subdev);
}

static int sensor_task_lock(struct i2c_client *client, int lock)
{
#if CONFIG_SENSOR_I2C_NOSCHED
	int cnt = 3;
    struct sensor *sensor = to_sensor(client);

	if (lock) {
		if (atomic_read(&sensor->tasklock_cnt) == 0) {
			while ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt>0)) {
				SENSOR_TR("\n %s will obtain i2c in atomic, but i2c bus is locked! Wait...\n",SENSOR_NAME_STRING());
				msleep(35);
				cnt--;
			}
			if ((atomic_read(&client->adapter->bus_lock.count) < 1) && (cnt<=0)) {
				SENSOR_TR("\n %s obtain i2c fail in atomic!!\n",SENSOR_NAME_STRING());
				goto sensor_task_lock_err;
			}
			preempt_disable();
		}

		atomic_add(1, &sensor->tasklock_cnt);
	} else {
		if (atomic_read(&sensor->tasklock_cnt) > 0) {
			atomic_sub(1, &sensor->tasklock_cnt);

			if (atomic_read(&sensor->tasklock_cnt) == 0)
				preempt_enable();
		}
	}    
	return 0;
sensor_task_lock_err:
	return -1;    
#else
    return 0;
#endif
}
/*sensor register write */
static int sensor_write(struct i2c_client *client, struct reginfo *reg_info)
{
    int err=0,cnt;
    u8 buf[4];
    struct i2c_msg msg[1];

	switch (reg_info->reg)
	{
		case SEQUENCE_WAIT_MS:
		{
			if (in_atomic())
				mdelay(reg_info->val);
			else
				msleep(reg_info->val);
			break;
		}

		case SEQUENCE_WAIT_US:
		{
			udelay(reg_info->val);
			break;
		}
		case SEQUENCE_PROPERTY:
		{
			break;
		}
		default:
		{
		    buf[0] = reg_info->reg >> 8;
		    buf[1] = reg_info->reg & 0xFF;
			if (reg_info->reg_len == WORD_LEN) {
				buf[2] = reg_info->val >> 8;
				buf[3] = reg_info->val & 0xFF;
				msg->len = 4;
			} else if (reg_info->reg_len == BYTE_LEN) {
				buf[2] = reg_info->val;
				msg->len = 3;
			}
		    msg->addr = client->addr;
		    msg->flags = client->flags;
		    msg->buf = buf;
		    msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
		    msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */
		    cnt = 3;
		    err = -EAGAIN;
		    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
		        err = i2c_transfer(client->adapter, msg, 1);

		        if (err >= 0) {
		            return 0;
		        } else {
		            SENSOR_TR("\n %s write reg(0x%x, val:0x%x) failed, try to write again!\n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
		            udelay(10);
		        }
		    }
		}
	}
    return err;
}

/**
 *sensor_write_Multiple_data - sensor register write with Multiple data
 * @i2c_client: 
 * @reg_info: the first register address
 * @count: data number
 *
 * Returns negative errno, else the number of messages executed.
 *
 * Note that it 
 */
static int sensor_write_Multiple_data(struct i2c_client *client, struct reginfo *reg_info, int count)
{
    int err=0,cnt;  
    int i=0;
    int sum =0;
    struct reginfo *tmpval = NULL;
    u8 *buf;
    struct i2c_msg msg[1];
    tmpval = reg_info;
    
    if(count < 1 || tmpval==NULL||tmpval->reg==0x0000)                         
     return -EINVAL;

    memset((char*)&msg[0],0,sizeof(struct i2c_msg));   
    buf = kmalloc((count*2+10)*sizeof(u8),GFP_KERNEL);
    if (buf == NULL) {
        SENSOR_TR("%s %s fail,because kmalloc failed",SENSOR_NAME_STRING(),__FUNCTION__);
        err = -1;
        goto sensor_write_Multiple_data_end;
    }
    memset(buf,0,sizeof(buf));
    
	switch (reg_info->reg)
  	{
  		case SEQUENCE_WAIT_MS:
		{
			if (in_atomic())
				mdelay(reg_info->val);
			else
				msleep(reg_info->val);
			break;
		}

		case SEQUENCE_WAIT_US:
		{
			udelay(reg_info->val);
			break;
		}

		case SEQUENCE_PROPERTY:
		{
			break;
		}
		default:
		{
            
		    buf[0] = tmpval->reg >> 8;
		    buf[1] = tmpval->reg & 0xFF;
            i= 2;    
			if (tmpval->reg_len == WORD_LEN)
            {
               sum = (count+1)*2;
               while(i<sum) 
               {
				 buf[i] = tmpval->val >> 8;
				 buf[i+1] = tmpval->val & 0xFF;
                 i=i+2;
                 tmpval++;
               }             
			   msg->len = sum;               
			} else if (tmpval->reg_len == BYTE_LEN) {
			  sum = count+2;
               while(i<sum) 
               {
				 buf[i] = tmpval->val;
                 i++;
                 tmpval++;
               }             
			   msg->len = sum;               
			}
		    msg->addr = client->addr;
		    msg->flags = client->flags;
		    msg->buf = buf;
		    msg->scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
		    msg->read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */
		    cnt = 3;
		    err = -EAGAIN;
		    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
		        err = i2c_transfer(client->adapter, msg, 1);
		        if (err >= 0) {
		            return 0;
		        } else {
		            SENSOR_TR("\n %s write reg(0x%x, val:0x%x) failed, try to write again!\n",SENSOR_NAME_STRING(),reg_info->reg, reg_info->val);
		            udelay(10);
		        }
		    }            
		}                
	}
sensor_write_Multiple_data_end:  
    if (buf) {
        kfree(buf);
        buf = NULL;
    }
    return err;
}

/* sensor register read */
static int sensor_read(struct i2c_client *client, u16 reg, u16 *val)
{
    int err,cnt;
    u8 buf[2];
    struct i2c_msg msg[2];

    buf[0] = reg >> 8;
    buf[1] = reg & 0xFF; 

    msg[0].addr = client->addr;
    msg[0].flags = client->flags;
    msg[0].buf = buf;
    msg[0].len = sizeof(buf);
    msg[0].scl_rate = CONFIG_SENSOR_I2C_SPEED;       /* ddl@rock-chips.com : 100kHz */
    msg[0].read_type = 2;   /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    msg[1].addr = client->addr;
    msg[1].flags = client->flags|I2C_M_RD;
    msg[1].buf = buf;
    msg[1].len = 2;
    msg[1].scl_rate = CONFIG_SENSOR_I2C_SPEED;                       /* ddl@rock-chips.com : 100kHz */
    msg[1].read_type = 2;                             /* fpga i2c:0==I2C_NO_STOP : direct use number not enum for don't want include spi_fpga.h */

    cnt = 3;
    err = -EAGAIN;
    while ((cnt-- > 0) && (err < 0)) {                       /* ddl@rock-chips.com :  Transfer again if transent is failed   */
        err = i2c_transfer(client->adapter, msg, 2);

        if (err >= 0) {
            *val = buf[0];
            return 0;
        } else {
        	SENSOR_TR("\n %s read reg(0x%x val:0x%x) failed, try to read again! \n",SENSOR_NAME_STRING(),reg, *val);
            udelay(10);
        }
    }

    return err;
}

/* write a array of registers  */
static int sensor_write_array(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0,j=0;
    int num = 0;  
    u16 temp = 0;
    
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
	cnt = 0;

	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
    
   // SENSOR_TR("%s ..%s..\n",SENSOR_NAME_STRING(),__FUNCTION__);         
   
    while (regarray[i].reg != SEQUENCE_END) {           
       num =1;
       j= i+1;      
       while((regarray[j].reg_len ==regarray[i].reg_len)&&regarray[j].reg != SEQUENCE_END)
       {
          temp = regarray[j].reg - regarray[j-1].reg;            
          if((regarray[j].reg_len==WORD_LEN && temp!=0x0002)||(regarray[j].reg_len==BYTE_LEN && temp!=0x0001))
           break;
           num++;
           j++;
       }         
       err = sensor_write_Multiple_data(client, &regarray[i], num) ;            
       if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }

       i=i+num;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}

/* write sensor initial data */
static int sensor_write_init_data(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0;
    int num = 0;
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
    int ti=0;	   
    int table[167] = {                   /*written data numbers every time*/
        3,1,1,3,1,1,1,1,11,2,2,13,1,1,1,2,11,2,2,13,
        1,2,1,1,2,1,1,1,1,1,8,1,1,1,1,1,1,714,1,1,
        1,1,1,1,1,42,1,3,9,1,1,2,2,1,1,1,1,3,1,1,
        1,1,1,2,1,1,1,1,1,1,1,1,1,1,1,1,8,2,2,2,
        2,2,1,1,1,1,10,10,9,6,4,2,9,2,2,2,1,1,1,1,
        1,1,1,1,1,1,1,1,58,1,1,1,1,1,1,1,1,1,1,1,
        2,2,2,2,2,2,2,2,2,3,3,2,1,1,1,1,1, 2,2,1,
        6,3,1,1,1,1,1,6,1,2,4,4,1,1,1,4,5,2,2,4,
        4,6,1,1,1,1,1
    };
    
    cnt = 0; 
	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
   
    while (regarray[i].reg != SEQUENCE_END) { 

      if(ti < 167){
         num = table[ti];
         ti++;
       }         
       err = sensor_write_Multiple_data(client, &regarray[i], num) ;            
       if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }
       i=i+num;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}

#if 0
/* write a array of registers  */
static int sensor_write_array(struct i2c_client *client, struct reginfo *regarray)
{
    int err = 0, cnt;
    int i = 0;
#if CONFIG_SENSOR_I2C_RDWRCHK
	char valchk;
#endif
	cnt = 0;
	if (sensor_task_lock(client, 1) < 0)
		goto sensor_write_array_end;
    
    while (regarray[i].reg != SEQUENCE_END) {
       
        err = sensor_write(client, &regarray[i]);
        
        if (err < 0)
        {
            if (cnt-- > 0) {
			    SENSOR_TR("%s..write failed current reg:0x%x, Write array again !\n", SENSOR_NAME_STRING(),regarray[i].reg);
				i = 0;
				continue;
            } else {
                SENSOR_TR("%s..write array failed!!!\n", SENSOR_NAME_STRING());
                err = -EPERM;
				goto sensor_write_array_end;
            }
        } else {
        #if CONFIG_SENSOR_I2C_RDWRCHK
			sensor_read(client, regarray[i].reg, &valchk);
			if (valchk != regarray[i].val)
				SENSOR_TR("%s Reg:0x%x write(0x%x, 0x%x) fail\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);
		#endif
        }
        i++;
    }
sensor_write_array_end:
	sensor_task_lock(client,0);
    return err;
}
#endif
#if CONFIG_SENSOR_I2C_RDWRCHK
static int sensor_readchk_array(struct i2c_client *client, struct reginfo *regarray)
{
    int cnt;
    int i = 0;
	char valchk;

	cnt = 0;
	valchk = 0;
    while (regarray[i].reg != SEQUENCE_END)
    {
		sensor_read(client, regarray[i].reg, &valchk);
		if (valchk != regarray[i].val)
			SENSOR_TR("%s Reg:0x%x read(0x%x, 0x%x) error\n",SENSOR_NAME_STRING(), regarray[i].reg, regarray[i].val, valchk);

        i++;
    }
    return 0;
}
#endif

#if CONFIG_SENSOR_Focus
static struct reginfo sensor_af_init0[] =
{
	{ 0xC400, 0x88, BYTE_LEN, 0 }, 	// AFM_ALGO
	{ 0x8419, 0x05, BYTE_LEN, 0 }, 	// SEQ_STATE_CFG_1_AF
	{ 0xC400, 0x08, BYTE_LEN, 0 }, 	// AFM_ALGO
	//AF_settings
	{ 0xB002, 0x0305, WORD_LEN, 0}, 	// AF_MODE
	{ 0xB004, 0x0002, WORD_LEN, 0}, 	// AF_ALGO

	{ 0xB008, 0x0003, WORD_LEN, 0},  // AF_ZONE_WEIGHTS_HI
	{ 0xB00A, 0xFFFF, WORD_LEN, 0},  // AF_ZONE_WEIGHTS_HI
	{ 0xB00C, 0xFFFF, WORD_LEN, 0},  // AF_ZONE_WEIGHTS_LO
	{ 0xB00E, 0xFFFF, WORD_LEN, 0},  // AF_ZONE_WEIGHTS_LO
    {SEQUENCE_END, 0x00, 0, 0}
};
static struct reginfo sensor_af_init1[] =
{
//set_posMin/Max
{ 0xC40A, 0x0028, WORD_LEN, 0 }, 	// AFM_POS_MIN
{ 0xC40C, 0x00BE, WORD_LEN, 0 }, 	// AFM_POS_MAX
//AF_postition_settings
{ 0xB018, 0x00, BYTE_LEN, 0}, 	// AF_FS_POS_0
{ 0xB019, 0x20, BYTE_LEN, 0}, 	// AF_FS_POS_1
{ 0xB01A, 0x40, BYTE_LEN, 0}, 	// AF_FS_POS_2
{ 0xB01B, 0x60, BYTE_LEN, 0}, 	// AF_FS_POS_3
{ 0xB01C, 0x80, BYTE_LEN, 0}, 	// AF_FS_POS_4
{ 0xB01D, 0xA0, BYTE_LEN, 0}, 	// AF_FS_POS_5
{ 0xB01E, 0xC0, BYTE_LEN, 0}, 	// AF_FS_POS_6
{ 0xB01A, 0x38, BYTE_LEN, 0}, 	// AF_FS_POS_2
{ 0xB01B, 0x50, BYTE_LEN, 0}, 	// AF_FS_POS_3
{ 0xB01C, 0x68, BYTE_LEN, 0}, 	// AF_FS_POS_4
{ 0xB01D, 0x80, BYTE_LEN, 0}, 	// AF_FS_POS_5
{ 0xB01E, 0x98, BYTE_LEN, 0}, 	// AF_FS_POS_6
{ 0xB01F, 0xB0, BYTE_LEN, 0}, 	// AF_FS_POS_7
{ 0xB020, 0xC0, BYTE_LEN, 0}, 	// AF_FS_POS_8
{ 0xB012, 0x09, BYTE_LEN, 0}, 	// AF_FS_NUM_STEPS
//2nd_scan_option
{ 0xB013, 0x55, BYTE_LEN, 0}, 	// AF_FS_NUM_STEPS2
{ 0xB014, 0x06, BYTE_LEN, 0}, 	// AF_FS_STEP_SIZE
{ 0x8404, 0x05, BYTE_LEN, 0}, 	// SEQ_CMD
//{ SEQUENCE_WAIT_MS,300, WORD_LEN, 0},
{ SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
//{ 0x3EDA, 0x6060 	// DAC_LD_14_15
{ 0x0018, 0x2008, WORD_LEN, 0}, 	// STANDBY_CONTROL_AND_STATUS
//{ SEQUENCE_WAIT_MS,100, WORD_LEN, 0},
{ SEQUENCE_WAIT_MS,30, WORD_LEN, 0},
{ 0x3EDA, 0x6060, WORD_LEN, 0 }, 	// DAC_LD_14_15
{SEQUENCE_END, 0x00, 0, 0}
};


static struct reginfo sensor_af_trigger[] =
{
	{0x098e,0xb006, WORD_LEN, 0 },
	{0xb006,0x01, BYTE_LEN, 0 },
    {SEQUENCE_END, 0x00, 0, 0}
};
static int sensor_af_single(struct i2c_client *client)
{
	int ret = 0;

	ret = sensor_write_array(client, sensor_af_trigger);
	if (ret<0)
		SENSOR_TR("%s sensor auto focus trigger fail!!\n",SENSOR_NAME_STRING());
	else
		SENSOR_DG("%s sensor auto focus trigger success!\n",SENSOR_NAME_STRING());
sensor_af_single_end:
	return ret;
}

static int sensor_af_const(struct i2c_client *client)
{
	int ret = 0;

sensor_af_const_end:
	return ret;
}

static int sensor_af_zoneupdate(struct i2c_client *client)
{
	int ret = 0;
	struct i2c_msg msg[2];
    u8 buf[2][6] =
	{
		{0xb0,0x08,0x00,0x03,0xff,0xff},
		{0xb0,0x0c,0xff,0xff,0xff,0xff},
	};

    msg[0].addr = client->addr;
    msg[0].flags = client->flags;
    msg[0].buf = buf[0];
    msg[0].len = sizeof(buf);
    msg[0].scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
    msg[0].read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */

    msg[1].addr = client->addr;
    msg[1].flags = client->flags;
    msg[1].buf = buf[1];
    msg[1].len = sizeof(buf);
    msg[1].scl_rate = CONFIG_SENSOR_I2C_SPEED;         /* ddl@rock-chips.com : 100kHz */
    msg[1].read_type = 0;               /* fpga i2c:0==I2C_NORMAL : direct use number not enum for don't want include spi_fpga.h */

    ret = i2c_transfer(client->adapter, &msg[0], 1);
	ret |= i2c_transfer(client->adapter, &msg[1], 1);
    if (ret >= 0) {
        return 0;
    } else {
    	SENSOR_TR("\n %s sensor auto focus zone set fail!!\n",SENSOR_NAME_STRING());
    }

sensor_af_zoneupdate_end:
	return ret;
}

static int sensor_af_init(struct i2c_client *client)
{
	int ret = 0;

	ret = sensor_write_array(client, sensor_af_init0);
	if (ret<0) {
		SENSOR_DG("%s sensor auto focus init_0 fail!!",SENSOR_NAME_STRING());
	} else {
	    SENSOR_DG("%s sensor auto focus init_0 sucess!!",SENSOR_NAME_STRING());
		if (sensor_af_zoneupdate(client) == 0) {
			ret = sensor_write_array(client, sensor_af_init1);
			if (ret<0) {
				SENSOR_DG("%s sensor auto focus init_1 fail!!",SENSOR_NAME_STRING());
			}else{
				SENSOR_DG("%s sensor auto focus init_1 success!!",SENSOR_NAME_STRING());
            }
		}
	}

	return ret;
}
#endif

static int sensor_ioctrl(struct soc_camera_device *icd,enum rk29sensor_power_cmd cmd, int on)
{
	struct soc_camera_link *icl = to_soc_camera_link(icd);
	int ret = 0;

    SENSOR_DG("%s %s  cmd(%d) on(%d)\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd,on);
	switch (cmd)
	{
		case Sensor_PowerDown:
		{
			if (icl->powerdown) {
				ret = icl->powerdown(icd->pdev, on);
				if (ret == RK29_CAM_IO_SUCCESS) {
					if (on == 0) {
						mdelay(2);
						if (icl->reset)
							icl->reset(icd->pdev);
					}
				} else if (ret == RK29_CAM_EIO_REQUESTFAIL) {
					ret = -ENODEV;
					goto sensor_power_end;
				}
			}
			break;
		}
		case Sensor_Flash:
		{
			struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    		struct sensor *sensor = to_sensor(client);

			if (sensor->sensor_io_request && sensor->sensor_io_request->sensor_ioctrl) {
				sensor->sensor_io_request->sensor_ioctrl(icd->pdev,Cam_Flash, on);
                if(on){
                    //flash off after 2 secs
            		hrtimer_cancel(&(flash_off_timer.timer));
            		hrtimer_start(&(flash_off_timer.timer),ktime_set(0, 800*1000*1000),HRTIMER_MODE_REL);
                    }
			}
			break;
		}
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown!",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}

sensor_power_end:
	return ret;
}

static enum hrtimer_restart flash_off_func(struct hrtimer *timer){
	struct flash_timer *fps_timer = container_of(timer, struct flash_timer, timer);
    sensor_ioctrl(fps_timer->icd,Sensor_Flash,0);
	SENSOR_DG("%s %s !!!!!!",SENSOR_NAME_STRING(),__FUNCTION__);
    return 0;
    
}

static int sensor_init(struct v4l2_subdev *sd, u32 val)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
#if (ADJUST_OPTIMIZE_TIME_FALG == 0)
	const struct v4l2_queryctrl *qctrl;
#endif
    const struct sensor_datafmt *fmt;
    int ret,pid = 0;
    int index  =0 ;
#if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
#endif

    SENSOR_DG("\n%s..%s.. \n",SENSOR_NAME_STRING(),__FUNCTION__);

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_INIT_ERR;
	}
    
    SENSOR_DG("\n soft reset..%s.\n",SENSOR_NAME_STRING());

    /* soft reset */
	if (sensor_task_lock(client,1)<0)
		goto sensor_INIT_ERR;

#if (SENSOR_RESET_REG != SEQUENCE_END)
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_INIT_ERR;
    }
    mdelay(5);     //delay 5 microseconds
#endif

	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif

    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_INIT_ERR;
    }
    
    SENSOR_DG("\n sensor_init_data..%s.\n",SENSOR_NAME_STRING());
 
    ret =sensor_write_init_data(client, sensor_init_data);
    if (ret != 0) {
        SENSOR_TR("error: %s initial failed\n",SENSOR_NAME_STRING());
        goto sensor_INIT_ERR;
    }
	sensor_task_lock(client,0);
    sensor->info_priv.preview_w = SENSOR_INIT_WIDTH;
    sensor->info_priv.preview_h = SENSOR_INIT_HEIGHT;
    sensor->info_priv.capture_w = SENSOR_MAX_WIDTH;
    sensor->info_priv.capture_h = SENSOR_MAX_HEIGHT;
    sensor->info_priv.winseqe_cur_addr  = SENSOR_INIT_WINSEQADR;
	fmt = sensor_find_datafmt(SENSOR_INIT_PIXFMT,sensor_colour_fmts, ARRAY_SIZE(sensor_colour_fmts));
    if (!fmt) {
        SENSOR_TR("error: %s initial array colour fmts is not support!!",SENSOR_NAME_STRING());
        ret = -EINVAL;
        goto sensor_INIT_ERR;
    }
	sensor->info_priv.fmt = *fmt;

    /* sensor sensor information for initialization  */
#if ADJUST_OPTIMIZE_TIME_FALG   
    SENSOR_DG("\n optimize code..%s.\n",SENSOR_NAME_STRING());
	#if CONFIG_SENSOR_WhiteBalance
      sensor->info_priv.whiteBalance = 0;
    #endif    
	#if CONFIG_SENSOR_Brightness
      sensor->info_priv.brightness = 0;
    #endif
	#if CONFIG_SENSOR_Effect
    	sensor->info_priv.effect = 0;
    #endif
	#if CONFIG_SENSOR_Exposure
        sensor->info_priv.exposure = 0;
    #endif
	#if CONFIG_SENSOR_Saturation
        sensor->info_priv.saturation = 0;
    #endif
	#if CONFIG_SENSOR_Contrast
        sensor->info_priv.contrast = 0;
    #endif        
	#if CONFIG_SENSOR_Mirror
        sensor->info_priv.mirror = 1;
    #endif
	#if CONFIG_SENSOR_Flip
        sensor->info_priv.flip = 1;
        index++;        
    #endif        
	#if CONFIG_SENSOR_Scene
        sensor->info_priv.scene = 0;
        index++;        
    #endif
	#if CONFIG_SENSOR_DigitalZoom
        sensor->info_priv.digitalzoom = 0;
    #endif        
	#if CONFIG_SENSOR_Focus
        sensor->info_priv.focus = 125  ;
        if (sensor_af_init(client) < 0) {
		sensor->info_priv.funmodule_state &= ~SENSOR_AF_IS_OK;
		SENSOR_TR("%s auto focus module init is fail!\n",SENSOR_NAME_STRING());
	    } else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
		SENSOR_DG("%s auto focus module init is success!\n",SENSOR_NAME_STRING());
	    }
    #endif    
	#if CONFIG_SENSOR_Flash
        sensor->info_priv.flash = 0 ;    
    #endif
    
#else
    SENSOR_DG("\n origin code..%s.\n",SENSOR_NAME_STRING());

	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_DO_WHITE_BALANCE);
	if (qctrl)
    	sensor->info_priv.whiteBalance = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_BRIGHTNESS);
	if (qctrl)
    	sensor->info_priv.brightness = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EFFECT);
	if (qctrl)
    	sensor->info_priv.effect = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_EXPOSURE);
	if (qctrl)
        sensor->info_priv.exposure = qctrl->default_value;

	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SATURATION);
	if (qctrl)
        sensor->info_priv.saturation = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_CONTRAST);
	if (qctrl)
        sensor->info_priv.contrast = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_HFLIP);
	if (qctrl)
        sensor->info_priv.mirror = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_VFLIP);
	if (qctrl)
        sensor->info_priv.flip = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_SCENE);
	if (qctrl)
        sensor->info_priv.scene = qctrl->default_value;
    
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.digitalzoom = qctrl->default_value;

    /* ddl@rock-chips.com : if sensor support auto focus and flash, programer must run focus and flash code  */
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (qctrl)
        sensor->info_priv.focus = qctrl->default_value;
   
	#if CONFIG_SENSOR_Focus
	if (sensor_af_init(client) < 0) {
		sensor->info_priv.funmodule_state &= ~SENSOR_AF_IS_OK;
		SENSOR_TR("%s auto focus module init is fail!\n",SENSOR_NAME_STRING());
	} else {
		sensor->info_priv.funmodule_state |= SENSOR_AF_IS_OK;
		SENSOR_DG("%s auto focus module init is success!\n",SENSOR_NAME_STRING());
	}
	#endif
	#if CONFIG_SENSOR_Flash
	qctrl = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FLASH);
	if (qctrl)
        sensor->info_priv.flash = qctrl->default_value;

    flash_off_timer.icd = icd;
	flash_off_timer.timer.function = flash_off_func;
    #endif
#endif      
    SENSOR_DG("\n%s..%s.. icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),((val == 0)?__FUNCTION__:"sensor_reinit"),icd->user_width,icd->user_height);
    sensor->info_priv.funmodule_state |= SENSOR_INIT_IS_OK;
    return 0;
sensor_INIT_ERR:
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;
	sensor_task_lock(client,0);
	sensor_deactivate(client);
    return ret;
}
static int sensor_deactivate(struct i2c_client *client)
{
	struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);

	SENSOR_DG("\n%s..%s.. Enter\n",SENSOR_NAME_STRING(),__FUNCTION__);

	/* ddl@rock-chips.com : all sensor output pin must change to input for other sensor */


	sensor_ioctrl(icd, Sensor_PowerDown, 1);
    msleep(100);

	/* ddl@rock-chips.com : sensor config init width , because next open sensor quickly(soc_camera_open -> Try to configure with default parameters) */
	icd->user_width = SENSOR_INIT_WIDTH;
    icd->user_height = SENSOR_INIT_HEIGHT;
    sensor->info_priv.funmodule_state &= ~SENSOR_INIT_IS_OK;

	return 0;
}
static  struct reginfo sensor_power_down_sequence[]=
{
    {0x00,0x00}
};
static int sensor_suspend(struct soc_camera_device *icd, pm_message_t pm_msg)
{
    int ret;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if (pm_msg.event == PM_EVENT_SUSPEND) {
        SENSOR_DG("\n %s Enter Suspend..pm_msg.event=%d \n", SENSOR_NAME_STRING(),pm_msg.event);
        ret = sensor_write_array(client, sensor_power_down_sequence) ;
        if (ret != 0) {
            SENSOR_TR("\n %s..%s WriteReg Fail.. \n", SENSOR_NAME_STRING(),__FUNCTION__);
            return ret;
        } else {
            ret = sensor_ioctrl(icd, Sensor_PowerDown, 1);
            if (ret < 0) {
			    SENSOR_TR("\n %s suspend fail for turn on power!\n", SENSOR_NAME_STRING());
                return -EINVAL;
            }
        }
    } else {
        SENSOR_TR("\n %s cann't suppout Suspend..\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    return 0;
}

static int sensor_resume(struct soc_camera_device *icd)
{
	int ret;

    ret = sensor_ioctrl(icd, Sensor_PowerDown, 0);
    if (ret < 0) {
		SENSOR_TR("\n %s resume fail for turn on power!\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

	SENSOR_DG("\n %s Enter Resume.. \n", SENSOR_NAME_STRING());
	return 0;
}

static int sensor_set_bus_param(struct soc_camera_device *icd,
                                unsigned long flags)
{

    return 0;
}

static unsigned long sensor_query_bus_param(struct soc_camera_device *icd)
{
    struct soc_camera_link *icl = to_soc_camera_link(icd);
    unsigned long flags = SENSOR_BUS_PARAM;

    return soc_camera_apply_sensor_flags(icl, flags);
}

static int sensor_g_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);

    mf->width	= icd->user_width;
	mf->height	= icd->user_height;
	mf->code	= sensor->info_priv.fmt.code;
	mf->colorspace	= sensor->info_priv.fmt.colorspace;
	mf->field	= V4L2_FIELD_NONE;

    return 0;
}
static bool sensor_fmt_capturechk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;

	if ((mf->width == 1024) && (mf->height == 768)) {
		ret = true;
	} else if ((mf->width == 1280) && (mf->height == 1024)) {
		ret = true;
	} else if ((mf->width == 1600) && (mf->height == 1200)) {
		ret = true;
	} else if ((mf->width == 2048) && (mf->height == 1536)) {
		ret = true;
	} else if ((mf->width == 2592) && (mf->height == 1944)) {
		ret = true;
	}

	if (ret == true)
		SENSOR_DG("%s %dx%d is capture format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}

static bool sensor_fmt_videochk(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    bool ret = false;

	if ((mf->width == 1280) && (mf->height == 720)) {
		ret = true;
	} else if ((mf->width == 1920) && (mf->height == 1080)) {
		ret = true;
	}

	if (ret == true)
		SENSOR_DG("%s %dx%d is video format\n", __FUNCTION__, mf->width, mf->height);
	return ret;
}
static struct reginfo* sensor_fmt_catch(int set_w, int set_h, int *ret_w, int *ret_h)
{
	struct reginfo *winseqe_set_addr = NULL;
    
    if (set_w*240 == set_h*320) {        
        if (((set_w >= 320) && (set_h >= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} 

#if  ADJUST_FOR_VGA_FALG    
        // to forbid preview err         
        if (((set_w >= 576) && (set_h >= 432)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 576;
            *ret_h = 432;
        } 
#else
        if (((set_w >= 640) && (set_h >= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } 

#endif
              
        if (((set_w >= 800) && (set_h >= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } 

        if (((set_w >= 1024) && (set_h >= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} 
      
        if (((set_w >= 1280) && (set_h >= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        }         

        if (((set_w >= 1600) && (set_h >= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} 

        if (((set_w >= 2048) && (set_h >= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        } 

        if (((set_w >= 2592) && (set_h >= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qsxga;
            *ret_w = 2592;
            *ret_h = 1944;
        }

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }

            if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            } 
        }

    } else if (set_w*288 == set_h*352) {
        if (((set_w >= 176) && (set_h >= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w >= 352) && (set_h >= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        }

        if (winseqe_set_addr == NULL) {
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qsxga;
                *ret_w = 2592;
                *ret_h = 1944;
            }        


            if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_720p;
                *ret_w = 1280;
                *ret_h = 720;
            } else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_1080p;
                *ret_w = 1920;
                *ret_h = 1080;
            }  
        }
    } else if (set_w*720 == set_h*1280) {
        if (((set_w >= 1280) && (set_h >= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w >= 1920) && (set_h >= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        }

        if (winseqe_set_addr == NULL) {
    
            if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
        		winseqe_set_addr = sensor_qcif;
                *ret_w = 176;
                *ret_h = 144;
        	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_cif;
                *ret_w = 352;
                *ret_h = 288;
            }
        
            if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qvga;
                *ret_w = 320;
                *ret_h = 240;
        	} else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_vga;
                *ret_w = 640;
                *ret_h = 480;
            } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_svga;
                *ret_w = 800;
                *ret_h = 600;
            } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_xga;
                *ret_w = 1024;
                *ret_h = 768;
        	} else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_sxga;
                *ret_w = 1280;
                *ret_h = 1024;
            } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_uxga;
                *ret_w = 1600;
                *ret_h = 1200;
        	} else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qxga;
                *ret_w = 2048;
                *ret_h = 1536;
            } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
                winseqe_set_addr = sensor_qsxga;
                *ret_w = 2592;
                *ret_h = 1944;
            } 
        }
    } else {
        if (((set_w <= 176) && (set_h <= 144)) && (sensor_qcif[0].reg!=SEQUENCE_END)) {
    		winseqe_set_addr = sensor_qcif;
            *ret_w = 176;
            *ret_h = 144;
    	} else if (((set_w <= 320) && (set_h <= 240)) && (sensor_qvga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qvga;
            *ret_w = 320;
            *ret_h = 240;
    	} else if (((set_w <= 352) && (set_h<= 288)) && (sensor_cif[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_cif;
            *ret_w = 352;
            *ret_h = 288;
        } else if (((set_w <= 640) && (set_h <= 480)) && (sensor_vga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_vga;
            *ret_w = 640;
            *ret_h = 480;
        } else if (((set_w <= 800) && (set_h <= 600)) && (sensor_svga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_svga;
            *ret_w = 800;
            *ret_h = 600;
        } else if (((set_w <= 1024) && (set_h <= 768)) && (sensor_xga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_xga;
            *ret_w = 1024;
            *ret_h = 768;
    	} else if (((set_w <= 1280) && (set_h <= 720)) && (sensor_720p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_720p;
            *ret_w = 1280;
            *ret_h = 720;
        } else if (((set_w <= 1280) && (set_h <= 1024)) && (sensor_sxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_sxga;
            *ret_w = 1280;
            *ret_h = 1024;
        } else if (((set_w <= 1600) && (set_h <= 1200)) && (sensor_uxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_uxga;
            *ret_w = 1600;
            *ret_h = 1200;
    	} else if (((set_w <= 1920) && (set_h <= 1080)) && (sensor_1080p[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_1080p;
            *ret_w = 1920;
            *ret_h = 1080;
        } else if (((set_w <= 2048) && (set_h <= 1536)) && (sensor_qxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qxga;
            *ret_w = 2048;
            *ret_h = 1536;
        } else if (((set_w <= 2592) && (set_h <= 1944)) && (sensor_qsxga[0].reg!=SEQUENCE_END)) {
            winseqe_set_addr = sensor_qsxga;
            *ret_w = 2592;
            *ret_h = 1944;
        }        
    }
    
	return winseqe_set_addr;
}

/*modify image with resolution 2592*1944;solve bug that the first 32 pixel data*/
/*in the first line have misplace with the last 32 pixel data in the last line*/
static int sensor_cb(void *arg)
{
   void __iomem *vbpmem;
   struct videobuf_buffer *buffer;
   char *imagey_addr =NULL;
   char *imageuv_addr = NULL;
   char *tempaddr = NULL;
   int  tempsize = 0;
   
   buffer = (struct videobuf_buffer*)arg; 
   if(buffer->width!=SENSOR_MAX_WIDTH||buffer->height!=SENSOR_MAX_HEIGHT||buffer==NULL)
    return -EINVAL;
 
   if (buffer->bsize< YUV420_BUFFER_MAX_SIZE)        //yuv420 format size
    return -EINVAL;

   
   vbpmem = ioremap(buffer->boff,buffer->bsize);
   if(vbpmem == NULL) {
      SENSOR_DG("\n%s..%s..ioremap fail\n",__FUNCTION__,SENSOR_NAME_STRING());
      return -ENXIO;
   }
     
   imagey_addr = (char*)vbpmem;         // y data  to be dealed with
   imageuv_addr = imagey_addr+buffer->width*buffer->height;
   
   tempaddr =  imageuv_addr - 32;  
   memcpy(tempaddr,imagey_addr,32);

   tempaddr = imagey_addr+32;
   memcpy(imagey_addr,tempaddr,32);

                                      //uv data to be dealed with
   tempsize  = YUV420_BUFFER_MAX_SIZE-32;                              
   tempaddr = imagey_addr+tempsize;
   memcpy(tempaddr,imageuv_addr,32);

   tempaddr = imageuv_addr+32;
   memcpy(imageuv_addr,tempaddr,32);
   return 0;
}


static int sensor_s_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
    const struct sensor_datafmt *fmt;
    struct reginfo *winseqe_set_addr=NULL;
    int ret = 0, set_w,set_h,cnt;
    u16 seq_state=0;
    int time = 0;
    u16 targetbrightness,realbrightness;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

	fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (!fmt) {
        ret = -EINVAL;
        goto sensor_s_fmt_end;
    }

	if (sensor->info_priv.fmt.code != mf->code) {
		switch (mf->code)
		{
			case V4L2_MBUS_FMT_YUYV8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_YUYV;
				break;
			}
			case V4L2_MBUS_FMT_UYVY8_2X8:
			{
				winseqe_set_addr = sensor_ClrFmt_UYVY;
				break;
			}
			default:
				break;
		}
		if (winseqe_set_addr != NULL) {
            sensor_write_array(client, winseqe_set_addr);
			sensor->info_priv.fmt.code = mf->code;
            sensor->info_priv.fmt.colorspace= mf->colorspace;            
			SENSOR_DG("%s v4l2_mbus_code:%d set success!\n", SENSOR_NAME_STRING(),mf->code);
		} else {
			SENSOR_TR("%s v4l2_mbus_code:%d is invalidate!\n", SENSOR_NAME_STRING(),mf->code);
		}
	}

    set_w = mf->width;
    set_h = mf->height;

	winseqe_set_addr = sensor_fmt_catch(set_w, set_h, &set_w, &set_h);

    if ((winseqe_set_addr  != sensor->info_priv.winseqe_cur_addr) && winseqe_set_addr)
    { 
       /*solve bug that video set is ineffective */
       /*set five times to make sure sensor_720p set go into effect*/
        if(winseqe_set_addr==sensor_720p)
        {
          time = 5;
        }else{
          time = 1;
        }
        
        while(time > 0)
        {
           time--;
           ret |= sensor_write_array(client, winseqe_set_addr);
           if (ret != 0) {
                SENSOR_TR("%s set format capability failed\n", SENSOR_NAME_STRING());
                goto sensor_s_fmt_end;
           }
           udelay(10);
        }
        sensor->info_priv.winseqe_cur_addr  = winseqe_set_addr;
		if (winseqe_set_addr==sensor_qxga ||winseqe_set_addr==sensor_qsxga||winseqe_set_addr==sensor_uxga ||winseqe_set_addr==sensor_xga)
        {
        	SENSOR_DG("\n%s..%s..Capture icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),__FUNCTION__,set_w,set_h);
		} else {
			SENSOR_DG("\n%s..%s..Video icd->width = %d.. icd->height %d\n",SENSOR_NAME_STRING(),__FUNCTION__,set_w,set_h);
			sensor->info_priv.preview_w = mf->width;
			sensor->info_priv.preview_h = mf->height;
		}
    }

	if (winseqe_set_addr && (winseqe_set_addr==sensor_qxga ||winseqe_set_addr==sensor_qsxga||winseqe_set_addr==sensor_uxga ||winseqe_set_addr==sensor_xga)) 
     {
		ret |= sensor_write_array(client, sensor_Preview2Capture);      
		if (ret != 0) {
        	SENSOR_TR("%s Preview 2 Capture failed\n", SENSOR_NAME_STRING());
        	goto sensor_s_fmt_end;
    	}

      /*check state of register 0x8405 to make sure set is successful*/
      /*set sensor_Preview2Capture more times to make sure set go into effect */
        cnt = 0;
        time  =0;
        do{                      
            ret =  0;
            msleep(50);   
            ret =sensor_read(client,0x8405, &seq_state);
            if (ret < 0)
              goto sensor_s_fmt_end;
            cnt++;
            if(cnt > 9)
            {
                time++;
                cnt = 0;
        		ret |= sensor_write_array(client, sensor_Preview2Capture);      
        		if (ret != 0||time >2) {
                	SENSOR_TR("%s Preview 2 Capture failed\n", SENSOR_NAME_STRING());
                	goto sensor_s_fmt_end;
            	}
                SENSOR_DG("mt9p111 Preview 2 Capture again\n");
            }
            SENSOR_DG("mt9p111 Preview 2 Capture count = %d;seq_state = 0x%x\n",cnt,seq_state);
         } while((seq_state != 0x07) && (time < 4));

       SENSOR_TR("%s Preview 2 Capture successs\n", SENSOR_NAME_STRING());

      #if CONFIG_SENSOR_Flash
       /*The 0xA409 is AE target register address.*/
       /*The 0xB804 is currently total brightness Y value of sensor.*/
       targetbrightness = 0;
       realbrightness =0;
       if((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2))
       {
          if(sensor->info_priv.flash == 1)
          {
            ret =sensor_read(client,0xA409, &targetbrightness);
            if (ret < 0)
              SENSOR_DG("%s ..%s..get targetbrightness fail\n", SENSOR_NAME_STRING(),__FUNCTION__);
            
            ret =sensor_read(client, 0xB804, &realbrightness);
            if (ret < 0)
              SENSOR_DG("%s ..%s..get realbrightness fail\n", SENSOR_NAME_STRING(),__FUNCTION__);
          }
         
          if((realbrightness < targetbrightness)|| (sensor->info_priv.flash == 2))
          {
            sensor_ioctrl(icd, Sensor_Flash, Flash_On);
            SENSOR_DG("%s flash on,realbrightness=%d,targetbrightness=%d\n", SENSOR_NAME_STRING(),realbrightness,targetbrightness);
          }else{
            SENSOR_DG("%s not need to flash in capture!\n", SENSOR_NAME_STRING());
          }
        }
      #endif        
		sensor->info_priv.capture_w = set_w;
		sensor->info_priv.capture_h = set_h;
		sensor->info_priv.snap2preview = true;
	} else if (sensor->info_priv.snap2preview == true) {
		if (winseqe_set_addr || ((sensor->info_priv.preview_w == mf->width) && (sensor->info_priv.preview_h == mf->height))) {
			ret |= sensor_write_array(client, sensor_Capture2Preview);
			if (ret != 0) {
	        	SENSOR_TR("%s Capture 2 Preview success\n", SENSOR_NAME_STRING());
	        	goto sensor_s_fmt_end;
	    	}
            
            cnt = 0;
            do{                                    //check state of register 0x8405 to make sure set is successful
                ret =  0;
                msleep(50);   
                ret =sensor_read(client,0x8405, &seq_state);
                if (ret < 0)
                  goto sensor_s_fmt_end;
                SENSOR_DG("mt9p111 Capture 2 Preview seq_state = 0x%x\n",seq_state);
              } while((seq_state != 0x03) && (cnt < 20));
            
            SENSOR_TR("%s Capture 2 Preview success\n", SENSOR_NAME_STRING());

            #if CONFIG_SENSOR_Flash
            if ((sensor->info_priv.flash == 1) || (sensor->info_priv.flash == 2)) {
                sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
                SENSOR_DG("%s flash off in preivew!\n", SENSOR_NAME_STRING());
            }
            #endif        
    		sensor->info_priv.preview_w = mf->width;
    		sensor->info_priv.preview_h = mf->height;
    		sensor->info_priv.snap2preview = false;
		} else {
			SENSOR_TR("\n %s..%s Format is Invalidate. pix->width = %d.. pix->height = %d\n",SENSOR_NAME_STRING(),__FUNCTION__,mf->width,mf->height);
		}
	}

	mf->width = set_w;
	mf->height = set_h;
sensor_s_fmt_end:
    return ret;
}

static int sensor_try_fmt(struct v4l2_subdev *sd, struct v4l2_mbus_framefmt *mf)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct sensor_datafmt *fmt;
    int ret = 0;
   
	fmt = sensor_find_datafmt(mf->code, sensor_colour_fmts,
				   ARRAY_SIZE(sensor_colour_fmts));
	if (fmt == NULL) {
		fmt = &sensor->info_priv.fmt;
        mf->code = fmt->code;
	} 

    if (mf->height > SENSOR_MAX_HEIGHT)
        mf->height = SENSOR_MAX_HEIGHT;
    else if (mf->height < SENSOR_MIN_HEIGHT)
        mf->height = SENSOR_MIN_HEIGHT;

    if (mf->width > SENSOR_MAX_WIDTH)
        mf->width = SENSOR_MAX_WIDTH;
    else if (mf->width < SENSOR_MIN_WIDTH)
        mf->width = SENSOR_MIN_WIDTH;
    if (sensor_fmt_catch(mf->width, mf->height, &mf->width, &mf->height) == NULL) {
		mf->width = 0;
		mf->height = 0;
	}
    mf->colorspace = fmt->colorspace;
    
    return ret;
}
 static int sensor_g_chip_ident(struct v4l2_subdev *sd, struct v4l2_dbg_chip_ident *id)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);

    if (id->match.type != V4L2_CHIP_MATCH_I2C_ADDR)
        return -EINVAL;

    if (id->match.addr != client->addr)
        return -ENODEV;

    id->ident = SENSOR_V4L2_IDENT;      /* ddl@rock-chips.com :  Return OV2655  identifier */
    id->revision = 0;

    return 0;
}
#if CONFIG_SENSOR_Brightness
static int sensor_set_brightness(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_BrightnessSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_BrightnessSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Effect
static int sensor_set_effect(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    int time =5;
    int ret =0 ;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_EffectSeqe[value - qctrl->minimum] != NULL)
        {
           /*set five times to make sure the set go into effect*/
           /*solve bug for setting invalidate during changing from preview to video*/
            while(time >0)
            {
                time--;
                ret |=sensor_write_array(client, sensor_EffectSeqe[value - qctrl->minimum]);
                if(ret != 0)
                {  
                    SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                    return -EINVAL;
                }
                msleep(50);   
            }       
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Exposure
static int sensor_set_exposure(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ExposureSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ExposureSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Saturation
static int sensor_set_saturation(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SaturationSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SaturationSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Contrast
static int sensor_set_contrast(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_ContrastSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_ContrastSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Mirror
static int sensor_set_mirror(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_MirrorSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_MirrorSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flip
static int sensor_set_flip(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_FlipSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_FlipSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Scene
static int sensor_set_scene(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_SceneSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_SceneSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
    SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_WhiteBalance
static int sensor_set_whiteBalance(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));

    if ((value >= qctrl->minimum) && (value <= qctrl->maximum))
    {
        if (sensor_WhiteBalanceSeqe[value - qctrl->minimum] != NULL)
        {
            if (sensor_write_array(client, sensor_WhiteBalanceSeqe[value - qctrl->minimum]) != 0)
            {
                SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
                return -EINVAL;
            }
            SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
            return 0;
        }
    }
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_DigitalZoom
static int sensor_set_digitalzoom(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
    int digitalzoom_cur, digitalzoom_total;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_ZOOM_ABSOLUTE);
	if (qctrl_info)
		return -EINVAL;

    digitalzoom_cur = sensor->info_priv.digitalzoom;
    digitalzoom_total = qctrl_info->maximum;

    if ((value > 0) && (digitalzoom_cur >= digitalzoom_total))
    {
        SENSOR_TR("%s digitalzoom is maximum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if  ((value < 0) && (digitalzoom_cur <= qctrl_info->minimum))
    {
        SENSOR_TR("%s digitalzoom is minimum - %x\n", SENSOR_NAME_STRING(), digitalzoom_cur);
        return -EINVAL;
    }

    if ((value > 0) && ((digitalzoom_cur + value) > digitalzoom_total))
    {
        value = digitalzoom_total - digitalzoom_cur;
    }

    if ((value < 0) && ((digitalzoom_cur + value) < 0))
    {
        value = 0 - digitalzoom_cur;
    }

    digitalzoom_cur += value;

    if (sensor_ZoomSeqe[digitalzoom_cur] != NULL)
    {
        if (sensor_write_array(client, sensor_ZoomSeqe[digitalzoom_cur]) != 0)
        {
            SENSOR_TR("%s..%s WriteReg Fail.. \n",SENSOR_NAME_STRING(), __FUNCTION__);
            return -EINVAL;
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
        return 0;
    }

    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Flash
static int sensor_set_flash(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{    
    if ((value >= qctrl->minimum) && (value <= qctrl->maximum)) {
        if (value == 3) {       /* ddl@rock-chips.com: torch */
            sensor_ioctrl(icd, Sensor_Flash, Flash_Torch);   /* Flash On */
        } else {
            sensor_ioctrl(icd, Sensor_Flash, Flash_Off);
        }
        SENSOR_DG("%s..%s : %x\n",SENSOR_NAME_STRING(),__FUNCTION__, value);
        return 0;
    }
    
	SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
    return -EINVAL;
}
#endif
#if CONFIG_SENSOR_Focus
static int sensor_set_focus_absolute(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_ABSOLUTE);
	if (!qctrl_info)
		return -EINVAL;

	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

sensor_set_focus_absolute_end:
	return ret;
}
static int sensor_set_focus_relative(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	const struct v4l2_queryctrl *qctrl_info;
	int ret = 0;

	qctrl_info = soc_camera_find_qctrl(&sensor_ops, V4L2_CID_FOCUS_RELATIVE);
	if (!qctrl_info)
		return -EINVAL;

	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK) && (sensor->info_priv.affm_reinit == 0)) {
		if ((value >= qctrl_info->minimum) && (value <= qctrl_info->maximum)) {

			SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
		} else {
			ret = -EINVAL;
			SENSOR_TR("\n %s..%s valure = %d is invalidate..    \n",SENSOR_NAME_STRING(),__FUNCTION__,value);
		}
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}
sensor_set_focus_relative_end:
	return ret;
}

static int sensor_set_focus_mode(struct soc_camera_device *icd, const struct v4l2_queryctrl *qctrl, int value)
{
	struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
	struct sensor *sensor = to_sensor(client);
	int ret = 0;

	if ((sensor->info_priv.funmodule_state & SENSOR_AF_IS_OK)  && (sensor->info_priv.affm_reinit == 0)) {
		switch (value)
		{
			case SENSOR_AF_MODE_AUTO:
			{
				ret = sensor_af_single(client);
				break;
			}

			case SENSOR_AF_MODE_MACRO:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0xff);
				break;
			}

			case SENSOR_AF_MODE_INFINITY:
			{
				ret = sensor_set_focus_absolute(icd, qctrl, 0x00);
				break;
			}

			case SENSOR_AF_MODE_CONTINUOUS:
			{
				ret = sensor_af_const(client);
				break;
			}
			default:
				SENSOR_TR("\n %s..%s AF value(0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,value);
				break;

		}

		SENSOR_DG("%s..%s : %d  ret:0x%x\n",SENSOR_NAME_STRING(),__FUNCTION__, value,ret);
	} else {
		ret = -EACCES;
		SENSOR_TR("\n %s..%s AF module state(0x%x, 0x%x) is error!\n",SENSOR_NAME_STRING(),__FUNCTION__,
			sensor->info_priv.funmodule_state,sensor->info_priv.affm_reinit);
	}

	return ret;
}
#endif
static int sensor_g_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    const struct v4l2_queryctrl *qctrl;
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }

    switch (ctrl->id)
    {
        case V4L2_CID_BRIGHTNESS:
            {
                ctrl->value = sensor->info_priv.brightness;
                break;
            }
        case V4L2_CID_SATURATION:
            {
                ctrl->value = sensor->info_priv.saturation;
                break;
            }
        case V4L2_CID_CONTRAST:
            {
                ctrl->value = sensor->info_priv.contrast;
                break;
            }
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                ctrl->value = sensor->info_priv.whiteBalance;
                break;
            }
        case V4L2_CID_EXPOSURE:
            {
                ctrl->value = sensor->info_priv.exposure;
                break;
            }
        case V4L2_CID_HFLIP:
            {
                ctrl->value = sensor->info_priv.mirror;
                break;
            }
        case V4L2_CID_VFLIP:
            {
                ctrl->value = sensor->info_priv.flip;
                break;
            }
        default :
                break;
    }
    return 0;
}



static int sensor_s_control(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;
    const struct v4l2_queryctrl *qctrl;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    qctrl = soc_camera_find_qctrl(&sensor_ops, ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ctrl->id);
        return -EINVAL;
    }

    switch (ctrl->id)
    {
#if CONFIG_SENSOR_Brightness
        case V4L2_CID_BRIGHTNESS:
            {
                if (ctrl->value != sensor->info_priv.brightness)
                {
                    if (sensor_set_brightness(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.brightness = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Exposure
        case V4L2_CID_EXPOSURE:
            {
                if (ctrl->value != sensor->info_priv.exposure)
                {
                    if (sensor_set_exposure(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.exposure = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Saturation
        case V4L2_CID_SATURATION:
            {
                if (ctrl->value != sensor->info_priv.saturation)
                {
                    if (sensor_set_saturation(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.saturation = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Contrast
        case V4L2_CID_CONTRAST:
            {
                if (ctrl->value != sensor->info_priv.contrast)
                {
                    if (sensor_set_contrast(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.contrast = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_WhiteBalance
        case V4L2_CID_DO_WHITE_BALANCE:
            {
                if (ctrl->value != sensor->info_priv.whiteBalance)
                {
                    if (sensor_set_whiteBalance(icd, qctrl,ctrl->value) != 0)
                    {
                        return -EINVAL;
                    }
                    sensor->info_priv.whiteBalance = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Mirror
        case V4L2_CID_HFLIP:
            {
                if (ctrl->value != sensor->info_priv.mirror)
                {
                    if (sensor_set_mirror(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.mirror = ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Flip
        case V4L2_CID_VFLIP:
            {
                if (ctrl->value != sensor->info_priv.flip)
                {
                    if (sensor_set_flip(icd, qctrl,ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.flip = ctrl->value;
                }
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}
static int sensor_g_ext_control(struct soc_camera_device *icd , struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

    switch (ext_ctrl->id)
    {
        case V4L2_CID_SCENE:
            {
                ext_ctrl->value = sensor->info_priv.scene;
                break;
            }
        case V4L2_CID_EFFECT:
            {
                ext_ctrl->value = sensor->info_priv.effect;
                break;
            }
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                ext_ctrl->value = sensor->info_priv.digitalzoom;
                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                return -EINVAL;
            }
        case V4L2_CID_FLASH:
            {
                ext_ctrl->value = sensor->info_priv.flash;
                break;
            }
        default :
            break;
    }
    return 0;
}
static int sensor_s_ext_control(struct soc_camera_device *icd, struct v4l2_ext_control *ext_ctrl)
{
    const struct v4l2_queryctrl *qctrl;
    struct i2c_client *client = to_i2c_client(to_soc_camera_control(icd));
    struct sensor *sensor = to_sensor(client);
    int val_offset;

    qctrl = soc_camera_find_qctrl(&sensor_ops, ext_ctrl->id);

    if (!qctrl)
    {
        SENSOR_TR("\n %s ioctrl id = 0x%x  is invalidate \n", SENSOR_NAME_STRING(), ext_ctrl->id);
        return -EINVAL;
    }

	val_offset = 0;
    switch (ext_ctrl->id)
    {
#if CONFIG_SENSOR_Scene
        case V4L2_CID_SCENE:
            {
                if (ext_ctrl->value != sensor->info_priv.scene)
                {
                    if (sensor_set_scene(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.scene = ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Effect
        case V4L2_CID_EFFECT:
            {
                if (ext_ctrl->value != sensor->info_priv.effect)
                {
                    if (sensor_set_effect(icd, qctrl,ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.effect= ext_ctrl->value;
                }
                break;
            }
#endif
#if CONFIG_SENSOR_DigitalZoom
        case V4L2_CID_ZOOM_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                if (ext_ctrl->value != sensor->info_priv.digitalzoom)
                {
                    val_offset = ext_ctrl->value -sensor->info_priv.digitalzoom;

                    if (sensor_set_digitalzoom(icd, qctrl,&val_offset) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += val_offset;

                    SENSOR_DG("%s digitalzoom is %x\n",SENSOR_NAME_STRING(),  sensor->info_priv.digitalzoom);
                }

                break;
            }
        case V4L2_CID_ZOOM_RELATIVE:
            {
                if (ext_ctrl->value)
                {
                    if (sensor_set_digitalzoom(icd, qctrl,&ext_ctrl->value) != 0)
                        return -EINVAL;
                    sensor->info_priv.digitalzoom += ext_ctrl->value;

                    SENSOR_DG("%s digitalzoom is %x\n", SENSOR_NAME_STRING(), sensor->info_priv.digitalzoom);
                }
                break;
            }
#endif
#if CONFIG_SENSOR_Focus
        case V4L2_CID_FOCUS_ABSOLUTE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

				if (sensor_set_focus_absolute(icd, qctrl,ext_ctrl->value) == 0) {
					if (ext_ctrl->value == qctrl->minimum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_INFINITY;
					} else if (ext_ctrl->value == qctrl->maximum) {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_MACRO;
					} else {
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_FIXED;
					}
				}

                break;
            }
        case V4L2_CID_FOCUS_RELATIVE:
            {
                if ((ext_ctrl->value < qctrl->minimum) || (ext_ctrl->value > qctrl->maximum))
                    return -EINVAL;

                sensor_set_focus_relative(icd, qctrl,ext_ctrl->value);
                break;
            }
		case V4L2_CID_FOCUS_AUTO:
			{
				if (ext_ctrl->value == 1) {
					if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_AUTO) != 0)
						return -EINVAL;
					sensor->info_priv.auto_focus = SENSOR_AF_MODE_AUTO;
				} else if (SENSOR_AF_MODE_AUTO == sensor->info_priv.auto_focus){
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				}
				break;
			}
		case V4L2_CID_FOCUS_CONTINUOUS:
			{
				if (SENSOR_AF_MODE_CONTINUOUS != sensor->info_priv.auto_focus) {
					if (ext_ctrl->value == 1) {
						if (sensor_set_focus_mode(icd, qctrl,SENSOR_AF_MODE_CONTINUOUS) != 0)
							return -EINVAL;
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CONTINUOUS;
					}
				} else {
					if (ext_ctrl->value == 0)
						sensor->info_priv.auto_focus = SENSOR_AF_MODE_CLOSE;
				}
				break;
			}
#endif
#if CONFIG_SENSOR_Flash
        case V4L2_CID_FLASH:
            {
                if (sensor_set_flash(icd, qctrl,ext_ctrl->value) != 0)
                    return -EINVAL;
                sensor->info_priv.flash = ext_ctrl->value;

                SENSOR_DG("%s flash is %x\n",SENSOR_NAME_STRING(), sensor->info_priv.flash);
                break;
            }
#endif
        default:
            break;
    }

    return 0;
}

static int sensor_g_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());


    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_g_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_ext_controls(struct v4l2_subdev *sd, struct v4l2_ext_controls *ext_ctrl)
{
    struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    int i, error_cnt=0, error_idx=-1;
    
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());

    for (i=0; i<ext_ctrl->count; i++) {
        if (sensor_s_ext_control(icd, &ext_ctrl->controls[i]) != 0) {
            error_cnt++;
            error_idx = i;
        }
    }

    if (error_cnt > 1)
        error_idx = ext_ctrl->count;

    if (error_idx != -1) {
        ext_ctrl->error_idx = error_idx;
        return -EINVAL;
    } else {
        return 0;
    }
}

static int sensor_s_stream(struct v4l2_subdev *sd, int enable)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct sensor *sensor = to_sensor(client);

	if (enable == 1) {
		sensor->info_priv.enable = 1;
	} else if (enable == 0) {
		sensor->info_priv.enable = 0;
	}

	return 0;
}

/* Interface active, can use i2c. If it fails, it can indeed mean, that
 * this wasn't our capture interface, so, we wait for the right one */
static int sensor_video_probe(struct soc_camera_device *icd,
			       struct i2c_client *client)
{
    int ret,pid = 0;
    struct sensor *sensor = to_sensor(client);
#if (SENSOR_RESET_REG != SEQUENCE_END)
    struct reginfo reg_info;
#endif
    /* We must have a parent by now. And it cannot be a wrong one.
     * So this entire test is completely redundant. */
    if (!icd->dev.parent ||
	    to_soc_camera_host(icd->dev.parent)->nr != icd->iface)
		return -ENODEV;

	if (sensor_ioctrl(icd, Sensor_PowerDown, 0) < 0) {
		ret = -ENODEV;
		goto sensor_video_probe_err;
	}

    /* soft reset */
#if (SENSOR_RESET_REG != SEQUENCE_END)   
	reg_info.reg = SENSOR_RESET_REG;
	reg_info.val = SENSOR_RESET_VAL;
	reg_info.reg_len = SENSOR_RESET_REG_LEN;
    ret = sensor_write(client, &reg_info);
    if (ret != 0) {
        SENSOR_TR("%s soft reset sensor failed\n",SENSOR_NAME_STRING());
        ret = -ENODEV;
		goto sensor_video_probe_err;
    }

    mdelay(5);  //delay 5 microseconds
#endif

	/* check if it is an sensor sensor */
#if (SENSOR_ID_REG != SEQUENCE_END)
    ret = sensor_read(client, SENSOR_ID_REG, &pid);
    if (ret != 0) {
        SENSOR_TR("read chip id failed\n");
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }

    SENSOR_DG("\n %s  pid = 0x%x \n", SENSOR_NAME_STRING(), pid);
#else
	pid = SENSOR_ID;
#endif

    if (pid == SENSOR_ID) {
        sensor->model = SENSOR_V4L2_IDENT;
    } else {
        SENSOR_TR("error: %s mismatched   pid = 0x%x\n", SENSOR_NAME_STRING(), pid);
        ret = -ENODEV;
        goto sensor_video_probe_err;
    }

    return 0;

sensor_video_probe_err:

    return ret;
}
static long sensor_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
	struct i2c_client *client = v4l2_get_subdevdata(sd);
    struct soc_camera_device *icd = client->dev.platform_data;
    struct sensor *sensor = to_sensor(client);
#if CONFIG_SENSOR_Flash	
    int i;
#endif
    int ret = 0;
    
    rk29_camera_sensor_cb_s *icd_cb =NULL;
    
	SENSOR_DG("\n%s..%s..cmd:%x \n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
	switch (cmd)
	{
		case RK29_CAM_SUBDEV_DEACTIVATE:
		{
			sensor_deactivate(client);
			break;
		}
		case RK29_CAM_SUBDEV_IOREQUEST:
		{
			sensor->sensor_io_request = (struct rk29camera_platform_data*)arg;           
            if (sensor->sensor_io_request != NULL) { 
                sensor->sensor_gpio_res = NULL;
                for (i=0; i<RK29_CAM_SUPPORT_NUMS;i++) {
                    if (sensor->sensor_io_request->gpio_res[i].dev_name && 
                        (strcmp(sensor->sensor_io_request->gpio_res[i].dev_name, dev_name(icd->pdev)) == 0)) {
                        sensor->sensor_gpio_res = (struct rk29camera_gpio_res*)&sensor->sensor_io_request->gpio_res[i];
                    }
                }
                if (sensor->sensor_gpio_res == NULL) {
                    SENSOR_TR("%s %s obtain gpio resource failed when RK29_CAM_SUBDEV_IOREQUEST \n",SENSOR_NAME_STRING(),__FUNCTION__);
                    ret = -EINVAL;
                    goto sensor_ioctl_end;
                }
            } else {
                SENSOR_TR("%s %s RK29_CAM_SUBDEV_IOREQUEST fail\n",SENSOR_NAME_STRING(),__FUNCTION__);
                ret = -EINVAL;
                goto sensor_ioctl_end;
            }
            /* ddl@rock-chips.com : if gpio_flash havn't been set in board-xxx.c, sensor driver must notify is not support flash control 
               for this project */
            #if CONFIG_SENSOR_Flash	
        	if (sensor->sensor_gpio_res) {
                if (sensor->sensor_gpio_res->gpio_flash == INVALID_GPIO) {
                    for (i = 0; i < icd->ops->num_controls; i++) {
                		if (V4L2_CID_FLASH == icd->ops->controls[i].id) {
                			//memset((char*)&icd->ops->controls[i],0x00,sizeof(struct v4l2_queryctrl));  
                              sensor_controls[i].id=0xffff;         			
                		}
                    }
                    sensor->info_priv.flash = 0xff;
                    SENSOR_DG("%s flash gpio is invalidate!\n",SENSOR_NAME_STRING());
                }else{ //two cameras are the same,need to deal diffrently ,zyc
                    for (i = 0; i < icd->ops->num_controls; i++) {
                           if(0xffff == icd->ops->controls[i].id){
                              sensor_controls[i].id=V4L2_CID_FLASH;
                           }               
                    }
                }
        	}
            #endif
			break;
		}
        case RK29_CAM_SUBDEV_CB_REGISTER:
        {
           icd_cb = (rk29_camera_sensor_cb_s*)(arg);
           icd_cb->sensor_cb = sensor_cb;
           break;    
        }
		default:
		{
			SENSOR_TR("%s %s cmd(0x%x) is unknown !\n",SENSOR_NAME_STRING(),__FUNCTION__,cmd);
			break;
		}
	}
sensor_ioctl_end:
	return ret;

}
static int sensor_enum_fmt(struct v4l2_subdev *sd, unsigned int index,
			    enum v4l2_mbus_pixelcode *code)
{
	if (index >= ARRAY_SIZE(sensor_colour_fmts))
		return -EINVAL;

	*code = sensor_colour_fmts[index].code;
	return 0;
}
static struct v4l2_subdev_core_ops sensor_subdev_core_ops = {
	.init		= sensor_init,
	.g_ctrl		= sensor_g_control,
	.s_ctrl		= sensor_s_control,
	.g_ext_ctrls          = sensor_g_ext_controls,
	.s_ext_ctrls          = sensor_s_ext_controls,
	.g_chip_ident	= sensor_g_chip_ident,
	.ioctl = sensor_ioctl,
};
static struct v4l2_subdev_video_ops sensor_subdev_video_ops = {
	.s_mbus_fmt	= sensor_s_fmt,
	.g_mbus_fmt	= sensor_g_fmt,
	.try_mbus_fmt	= sensor_try_fmt,
	.enum_mbus_fmt	= sensor_enum_fmt,
	.s_stream   = sensor_s_stream,
};
static struct v4l2_subdev_ops sensor_subdev_ops = {
	.core	= &sensor_subdev_core_ops,
	.video = &sensor_subdev_video_ops,
};

static int sensor_probe(struct i2c_client *client,
			 const struct i2c_device_id *did)
{
    struct sensor *sensor;
    struct soc_camera_device *icd = client->dev.platform_data;
    struct i2c_adapter *adapter = to_i2c_adapter(client->dev.parent);
    struct soc_camera_link *icl;
    int ret;

    SENSOR_DG("\n%s..%s..%d..\n",__FUNCTION__,__FILE__,__LINE__);
    if (!icd) {
        dev_err(&client->dev, "%s: missing soc-camera data!\n",SENSOR_NAME_STRING());
        return -EINVAL;
    }

    icl = to_soc_camera_link(icd);
    if (!icl) {
        dev_err(&client->dev, "%s driver needs platform data\n", SENSOR_NAME_STRING());
        return -EINVAL;
    }

    if (!i2c_check_functionality(adapter, I2C_FUNC_I2C)) {
        dev_warn(&adapter->dev,
        	 "I2C-Adapter doesn't support I2C_FUNC_I2C\n");
        return -EIO;
    }

    sensor = kzalloc(sizeof(struct sensor), GFP_KERNEL);
    if (!sensor)
        return -ENOMEM;

    v4l2_i2c_subdev_init(&sensor->subdev, client, &sensor_subdev_ops);

    /* Second stage probe - when a capture adapter is there */
    icd->ops		= &sensor_ops;
    sensor->info_priv.fmt = sensor_colour_fmts[0];
	#if CONFIG_SENSOR_I2C_NOSCHED
	atomic_set(&sensor->tasklock_cnt,0);
	#endif

    ret = sensor_video_probe(icd, client);
    if (ret < 0) {
        icd->ops = NULL;
        i2c_set_clientdata(client, NULL);
        kfree(sensor);
		sensor = NULL;
    }
	hrtimer_init(&(flash_off_timer.timer), CLOCK_MONOTONIC, HRTIMER_MODE_REL);
    SENSOR_DG("\n%s..%s..%d  ret = %x \n",__FUNCTION__,__FILE__,__LINE__,ret);
    return ret;
}

static int sensor_remove(struct i2c_client *client)
{
    struct sensor *sensor = to_sensor(client);
    struct soc_camera_device *icd = client->dev.platform_data;

	#if CONFIG_SENSOR_Focus
	if (sensor->sensor_wq) {
		destroy_workqueue(sensor->sensor_wq);
		sensor->sensor_wq = NULL;
	}
	#endif

    icd->ops = NULL;
    i2c_set_clientdata(client, NULL);
    client->driver = NULL;
    kfree(sensor);
	sensor = NULL;
    return 0;
}

static const struct i2c_device_id sensor_id[] = {
	{SENSOR_NAME_STRING(), 0 },
	{ }
};
MODULE_DEVICE_TABLE(i2c, sensor_id);

static struct i2c_driver sensor_i2c_driver = {
	.driver = {
		.name = SENSOR_NAME_STRING(),
	},
	.probe		= sensor_probe,
	.remove		= sensor_remove,
	.id_table	= sensor_id,
};

static int __init sensor_mod_init(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    return i2c_add_driver(&sensor_i2c_driver);
}

static void __exit sensor_mod_exit(void)
{
    SENSOR_DG("\n%s..%s.. \n",__FUNCTION__,SENSOR_NAME_STRING());
    i2c_del_driver(&sensor_i2c_driver);
}

device_initcall_sync(sensor_mod_init);
module_exit(sensor_mod_exit);

MODULE_DESCRIPTION(SENSOR_NAME_STRING(Camera sensor driver));
MODULE_AUTHOR("ddl <kernel@rock-chips>");
MODULE_LICENSE("GPL");


