/*
 * Driver for OV5640 CMOS Image Sensor from OmniVision
 *
 * Copyright (C) 2008, Guennadi Liakhovetski <kernel@pengutronix.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include "ov5640.h"

static struct reginfo sensor_af_firmware[] =
{
	{0x3000, 0x20},
	{0x8000, 0x02},
	{0x8001, 0x0b},
	{0x8002, 0x61},
	{0x8003, 0x02},
	{0x8004, 0x07},
	{0x8005, 0xb1},
	{0x8006, 0xc2},
	{0x8007, 0x01},
	{0x8008, 0x22},
	{0x8009, 0x22},
	{0x800a, 0x00},
	{0x800b, 0x02},
	{0x800c, 0x0b},
	{0x800d, 0x4b},
	{0x800e, 0xe5},
	{0x800f, 0x1f},
	{0x8010, 0x60},
	{0x8011, 0x03},
	{0x8012, 0x02},
	{0x8013, 0x00},
	{0x8014, 0x97},
	{0x8015, 0xf5},
	{0x8016, 0x1e},
	{0x8017, 0xd2},
	{0x8018, 0x34},
	{0x8019, 0x75},
	{0x801a, 0x34},
	{0x801b, 0xff},
	{0x801c, 0x75},
	{0x801d, 0x35},
	{0x801e, 0x0e},
	{0x801f, 0x75},
	{0x8020, 0x36},
	{0x8021, 0x55},
	{0x8022, 0x75},
	{0x8023, 0x37},
	{0x8024, 0x01},
	{0x8025, 0x12},
	{0x8026, 0x0a},
	{0x8027, 0x3e},
	{0x8028, 0xe4},
	{0x8029, 0xff},
	{0x802a, 0xef},
	{0x802b, 0x25},
	{0x802c, 0xe0},
	{0x802d, 0x24},
	{0x802e, 0x4b},
	{0x802f, 0xf8},
	{0x8030, 0xe4},
	{0x8031, 0xf6},
	{0x8032, 0x08},
	{0x8033, 0xf6},
	{0x8034, 0x0f},
	{0x8035, 0xbf},
	{0x8036, 0x34},
	{0x8037, 0xf2},
	{0x8038, 0x90},
	{0x8039, 0x0e},
	{0x803a, 0x88},
	{0x803b, 0xe4},
	{0x803c, 0x93},
	{0x803d, 0xff},
	{0x803e, 0xe5},
	{0x803f, 0x49},
	{0x8040, 0xc3},
	{0x8041, 0x9f},
	{0x8042, 0x50},
	{0x8043, 0x04},
	{0x8044, 0x7f},
	{0x8045, 0x05},
	{0x8046, 0x80},
	{0x8047, 0x02},
	{0x8048, 0x7f},
	{0x8049, 0xfb},
	{0x804a, 0x78},
	{0x804b, 0xba},
	{0x804c, 0xa6},
	{0x804d, 0x07},
	{0x804e, 0x12},
	{0x804f, 0x0a},
	{0x8050, 0xa8},
	{0x8051, 0x40},
	{0x8052, 0x04},
	{0x8053, 0x7f},
	{0x8054, 0x03},
	{0x8055, 0x80},
	{0x8056, 0x02},
	{0x8057, 0x7f},
	{0x8058, 0x30},
	{0x8059, 0x78},
	{0x805a, 0xb9},
	{0x805b, 0xa6},
	{0x805c, 0x07},
	{0x805d, 0xe6},
	{0x805e, 0x18},
	{0x805f, 0xf6},
	{0x8060, 0x08},
	{0x8061, 0xe6},
	{0x8062, 0x78},
	{0x8063, 0xb6},
	{0x8064, 0xf6},
	{0x8065, 0x78},
	{0x8066, 0xb9},
	{0x8067, 0xe6},
	{0x8068, 0x78},
	{0x8069, 0xb7},
	{0x806a, 0xf6},
	{0x806b, 0x78},
	{0x806c, 0xbc},
	{0x806d, 0x76},
	{0x806e, 0x33},
	{0x806f, 0xe4},
	{0x8070, 0x08},
	{0x8071, 0xf6},
	{0x8072, 0x78},
	{0x8073, 0xb5},
	{0x8074, 0x76},
	{0x8075, 0x01},
	{0x8076, 0x75},
	{0x8077, 0x48},
	{0x8078, 0x02},
	{0x8079, 0x78},
	{0x807a, 0xb3},
	{0x807b, 0xf6},
	{0x807c, 0x08},
	{0x807d, 0xf6},
	{0x807e, 0x74},
	{0x807f, 0xff},
	{0x8080, 0x78},
	{0x8081, 0xbe},
	{0x8082, 0xf6},
	{0x8083, 0x08},
	{0x8084, 0xf6},
	{0x8085, 0x75},
	{0x8086, 0x1f},
	{0x8087, 0x01},
	{0x8088, 0x78},
	{0x8089, 0xb9},
	{0x808a, 0xe6},
	{0x808b, 0x75},
	{0x808c, 0xf0},
	{0x808d, 0x05},
	{0x808e, 0xa4},
	{0x808f, 0xf5},
	{0x8090, 0x49},
	{0x8091, 0x12},
	{0x8092, 0x08},
	{0x8093, 0x4f},
	{0x8094, 0xc2},
	{0x8095, 0x36},
	{0x8096, 0x22},
	{0x8097, 0x78},
	{0x8098, 0xb5},
	{0x8099, 0xe6},
	{0x809a, 0xd3},
	{0x809b, 0x94},
	{0x809c, 0x00},
	{0x809d, 0x40},
	{0x809e, 0x02},
	{0x809f, 0x16},
	{0x80a0, 0x22},
	{0x80a1, 0xe5},
	{0x80a2, 0x1f},
	{0x80a3, 0xb4},
	{0x80a4, 0x05},
	{0x80a5, 0x23},
	{0x80a6, 0xe4},
	{0x80a7, 0xf5},
	{0x80a8, 0x1f},
	{0x80a9, 0xc2},
	{0x80aa, 0x01},
	{0x80ab, 0x78},
	{0x80ac, 0xb3},
	{0x80ad, 0xe6},
	{0x80ae, 0xfe},
	{0x80af, 0x08},
	{0x80b0, 0xe6},
	{0x80b1, 0xff},
	{0x80b2, 0x78},
	{0x80b3, 0x4b},
	{0x80b4, 0xa6},
	{0x80b5, 0x06},
	{0x80b6, 0x08},
	{0x80b7, 0xa6},
	{0x80b8, 0x07},
	{0x80b9, 0xa2},
	{0x80ba, 0x36},
	{0x80bb, 0xe4},
	{0x80bc, 0x33},
	{0x80bd, 0xf5},
	{0x80be, 0x3c},
	{0x80bf, 0x90},
	{0x80c0, 0x30},
	{0x80c1, 0x28},
	{0x80c2, 0xf0},
	{0x80c3, 0x75},
	{0x80c4, 0x1e},
	{0x80c5, 0x10},
	{0x80c6, 0xd2},
	{0x80c7, 0x34},
	{0x80c8, 0x22},
	{0x80c9, 0xe5},
	{0x80ca, 0x49},
	{0x80cb, 0x75},
	{0x80cc, 0xf0},
	{0x80cd, 0x05},
	{0x80ce, 0x84},
	{0x80cf, 0x78},
	{0x80d0, 0xb9},
	{0x80d1, 0xf6},
	{0x80d2, 0x90},
	{0x80d3, 0x0e},
	{0x80d4, 0x85},
	{0x80d5, 0xe4},
	{0x80d6, 0x93},
	{0x80d7, 0xff},
	{0x80d8, 0x25},
	{0x80d9, 0xe0},
	{0x80da, 0x24},
	{0x80db, 0x0a},
	{0x80dc, 0xf8},
	{0x80dd, 0xe6},
	{0x80de, 0xfc},
	{0x80df, 0x08},
	{0x80e0, 0xe6},
	{0x80e1, 0xfd},
	{0x80e2, 0x78},
	{0x80e3, 0xb9},
	{0x80e4, 0xe6},
	{0x80e5, 0x25},
	{0x80e6, 0xe0},
	{0x80e7, 0x24},
	{0x80e8, 0x4b},
	{0x80e9, 0xf8},
	{0x80ea, 0xa6},
	{0x80eb, 0x04},
	{0x80ec, 0x08},
	{0x80ed, 0xa6},
	{0x80ee, 0x05},
	{0x80ef, 0xef},
	{0x80f0, 0x12},
	{0x80f1, 0x0a},
	{0x80f2, 0xaf},
	{0x80f3, 0xd3},
	{0x80f4, 0x78},
	{0x80f5, 0xb4},
	{0x80f6, 0x96},
	{0x80f7, 0xee},
	{0x80f8, 0x18},
	{0x80f9, 0x96},
	{0x80fa, 0x40},
	{0x80fb, 0x0d},
	{0x80fc, 0x78},
	{0x80fd, 0xb9},
	{0x80fe, 0xe6},
	{0x80ff, 0x78},
	{0x8100, 0xb6},
	{0x8101, 0xf6},
	{0x8102, 0x78},
	{0x8103, 0xb3},
	{0x8104, 0xa6},
	{0x8105, 0x06},
	{0x8106, 0x08},
	{0x8107, 0xa6},
	{0x8108, 0x07},
	{0x8109, 0x90},
	{0x810a, 0x0e},
	{0x810b, 0x85},
	{0x810c, 0xe4},
	{0x810d, 0x93},
	{0x810e, 0x12},
	{0x810f, 0x0a},
	{0x8110, 0xaf},
	{0x8111, 0xc3},
	{0x8112, 0x78},
	{0x8113, 0xbf},
	{0x8114, 0x96},
	{0x8115, 0xee},
	{0x8116, 0x18},
	{0x8117, 0x96},
	{0x8118, 0x50},
	{0x8119, 0x0d},
	{0x811a, 0x78},
	{0x811b, 0xb9},
	{0x811c, 0xe6},
	{0x811d, 0x78},
	{0x811e, 0xb7},
	{0x811f, 0xf6},
	{0x8120, 0x78},
	{0x8121, 0xbe},
	{0x8122, 0xa6},
	{0x8123, 0x06},
	{0x8124, 0x08},
	{0x8125, 0xa6},
	{0x8126, 0x07},
	{0x8127, 0x78},
	{0x8128, 0xb3},
	{0x8129, 0xe6},
	{0x812a, 0xfe},
	{0x812b, 0x08},
	{0x812c, 0xe6},
	{0x812d, 0xc3},
	{0x812e, 0x78},
	{0x812f, 0xbf},
	{0x8130, 0x96},
	{0x8131, 0xff},
	{0x8132, 0xee},
	{0x8133, 0x18},
	{0x8134, 0x96},
	{0x8135, 0x78},
	{0x8136, 0xc0},
	{0x8137, 0xf6},
	{0x8138, 0x08},
	{0x8139, 0xa6},
	{0x813a, 0x07},
	{0x813b, 0x90},
	{0x813c, 0x0e},
	{0x813d, 0x8a},
	{0x813e, 0xe4},
	{0x813f, 0x18},
	{0x8140, 0x12},
	{0x8141, 0x0a},
	{0x8142, 0x8d},
	{0x8143, 0x40},
	{0x8144, 0x02},
	{0x8145, 0xd2},
	{0x8146, 0x36},
	{0x8147, 0x78},
	{0x8148, 0xb9},
	{0x8149, 0xe6},
	{0x814a, 0x08},
	{0x814b, 0x26},
	{0x814c, 0x08},
	{0x814d, 0xf6},
	{0x814e, 0xe5},
	{0x814f, 0x1f},
	{0x8150, 0x64},
	{0x8151, 0x01},
	{0x8152, 0x70},
	{0x8153, 0x4a},
	{0x8154, 0xe6},
	{0x8155, 0xc3},
	{0x8156, 0x78},
	{0x8157, 0xbd},
	{0x8158, 0x12},
	{0x8159, 0x0a},
	{0x815a, 0x83},
	{0x815b, 0x40},
	{0x815c, 0x05},
	{0x815d, 0x12},
	{0x815e, 0x0a},
	{0x815f, 0x7e},
	{0x8160, 0x40},
	{0x8161, 0x39},
	{0x8162, 0x12},
	{0x8163, 0x0a},
	{0x8164, 0xa6},
	{0x8165, 0x40},
	{0x8166, 0x04},
	{0x8167, 0x7f},
	{0x8168, 0xfe},
	{0x8169, 0x80},
	{0x816a, 0x02},
	{0x816b, 0x7f},
	{0x816c, 0x02},
	{0x816d, 0x78},
	{0x816e, 0xba},
	{0x816f, 0xa6},
	{0x8170, 0x07},
	{0x8171, 0x78},
	{0x8172, 0xb6},
	{0x8173, 0xe6},
	{0x8174, 0x24},
	{0x8175, 0x03},
	{0x8176, 0x78},
	{0x8177, 0xbc},
	{0x8178, 0xf6},
	{0x8179, 0x78},
	{0x817a, 0xb6},
	{0x817b, 0xe6},
	{0x817c, 0x24},
	{0x817d, 0xfd},
	{0x817e, 0x78},
	{0x817f, 0xbd},
	{0x8180, 0xf6},
	{0x8181, 0x12},
	{0x8182, 0x0a},
	{0x8183, 0xa6},
	{0x8184, 0x40},
	{0x8185, 0x06},
	{0x8186, 0x78},
	{0x8187, 0xbd},
	{0x8188, 0xe6},
	{0x8189, 0xff},
	{0x818a, 0x80},
	{0x818b, 0x04},
	{0x818c, 0x78},
	{0x818d, 0xbc},
	{0x818e, 0xe6},
	{0x818f, 0xff},
	{0x8190, 0x78},
	{0x8191, 0xbb},
	{0x8192, 0xa6},
	{0x8193, 0x07},
	{0x8194, 0x75},
	{0x8195, 0x1f},
	{0x8196, 0x02},
	{0x8197, 0x78},
	{0x8198, 0xb5},
	{0x8199, 0x76},
	{0x819a, 0x01},
	{0x819b, 0x02},
	{0x819c, 0x02},
	{0x819d, 0x5d},
	{0x819e, 0xe5},
	{0x819f, 0x1f},
	{0x81a0, 0x64},
	{0x81a1, 0x02},
	{0x81a2, 0x60},
	{0x81a3, 0x03},
	{0x81a4, 0x02},
	{0x81a5, 0x02},
	{0x81a6, 0x3d},
	{0x81a7, 0x78},
	{0x81a8, 0xbb},
	{0x81a9, 0xe6},
	{0x81aa, 0xff},
	{0x81ab, 0xc3},
	{0x81ac, 0x78},
	{0x81ad, 0xbd},
	{0x81ae, 0x12},
	{0x81af, 0x0a},
	{0x81b0, 0x84},
	{0x81b1, 0x40},
	{0x81b2, 0x08},
	{0x81b3, 0x12},
	{0x81b4, 0x0a},
	{0x81b5, 0x7e},
	{0x81b6, 0x50},
	{0x81b7, 0x03},
	{0x81b8, 0x02},
	{0x81b9, 0x02},
	{0x81ba, 0x3b},
	{0x81bb, 0x12},
	{0x81bc, 0x0a},
	{0x81bd, 0xa6},
	{0x81be, 0x40},
	{0x81bf, 0x04},
	{0x81c0, 0x7f},
	{0x81c1, 0xff},
	{0x81c2, 0x80},
	{0x81c3, 0x02},
	{0x81c4, 0x7f},
	{0x81c5, 0x01},
	{0x81c6, 0x78},
	{0x81c7, 0xba},
	{0x81c8, 0xa6},
	{0x81c9, 0x07},
	{0x81ca, 0x78},
	{0x81cb, 0xb6},
	{0x81cc, 0xe6},
	{0x81cd, 0x04},
	{0x81ce, 0x78},
	{0x81cf, 0xbc},
	{0x81d0, 0xf6},
	{0x81d1, 0x78},
	{0x81d2, 0xb6},
	{0x81d3, 0xe6},
	{0x81d4, 0x14},
	{0x81d5, 0x78},
	{0x81d6, 0xbd},
	{0x81d7, 0xf6},
	{0x81d8, 0x18},
	{0x81d9, 0x12},
	{0x81da, 0x0a},
	{0x81db, 0xa8},
	{0x81dc, 0x40},
	{0x81dd, 0x04},
	{0x81de, 0xe6},
	{0x81df, 0xff},
	{0x81e0, 0x80},
	{0x81e1, 0x02},
	{0x81e2, 0x7f},
	{0x81e3, 0x00},
	{0x81e4, 0x78},
	{0x81e5, 0xbc},
	{0x81e6, 0xa6},
	{0x81e7, 0x07},
	{0x81e8, 0xd3},
	{0x81e9, 0x08},
	{0x81ea, 0xe6},
	{0x81eb, 0x64},
	{0x81ec, 0x80},
	{0x81ed, 0x94},
	{0x81ee, 0x80},
	{0x81ef, 0x40},
	{0x81f0, 0x04},
	{0x81f1, 0xe6},
	{0x81f2, 0xff},
	{0x81f3, 0x80},
	{0x81f4, 0x02},
	{0x81f5, 0x7f},
	{0x81f6, 0x00},
	{0x81f7, 0x78},
	{0x81f8, 0xbd},
	{0x81f9, 0xa6},
	{0x81fa, 0x07},
	{0x81fb, 0xc3},
	{0x81fc, 0x18},
	{0x81fd, 0xe6},
	{0x81fe, 0x64},
	{0x81ff, 0x80},
	{0x8200, 0x94},
	{0x8201, 0xb3},
	{0x8202, 0x50},
	{0x8203, 0x04},
	{0x8204, 0xe6},
	{0x8205, 0xff},
	{0x8206, 0x80},
	{0x8207, 0x02},
	{0x8208, 0x7f},
	{0x8209, 0x33},
	{0x820a, 0x78},
	{0x820b, 0xbc},
	{0x820c, 0xa6},
	{0x820d, 0x07},
	{0x820e, 0xc3},
	{0x820f, 0x08},
	{0x8210, 0xe6},
	{0x8211, 0x64},
	{0x8212, 0x80},
	{0x8213, 0x94},
	{0x8214, 0xb3},
	{0x8215, 0x50},
	{0x8216, 0x04},
	{0x8217, 0xe6},
	{0x8218, 0xff},
	{0x8219, 0x80},
	{0x821a, 0x02},
	{0x821b, 0x7f},
	{0x821c, 0x33},
	{0x821d, 0x78},
	{0x821e, 0xbd},
	{0x821f, 0xa6},
	{0x8220, 0x07},
	{0x8221, 0x12},
	{0x8222, 0x0a},
	{0x8223, 0xa6},
	{0x8224, 0x40},
	{0x8225, 0x06},
	{0x8226, 0x78},
	{0x8227, 0xbd},
	{0x8228, 0xe6},
	{0x8229, 0xff},
	{0x822a, 0x80},
	{0x822b, 0x04},
	{0x822c, 0x78},
	{0x822d, 0xbc},
	{0x822e, 0xe6},
	{0x822f, 0xff},
	{0x8230, 0x78},
	{0x8231, 0xbb},
	{0x8232, 0xa6},
	{0x8233, 0x07},
	{0x8234, 0x75},
	{0x8235, 0x1f},
	{0x8236, 0x03},
	{0x8237, 0x78},
	{0x8238, 0xb5},
	{0x8239, 0x76},
	{0x823a, 0x01},
	{0x823b, 0x80},
	{0x823c, 0x20},
	{0x823d, 0xe5},
	{0x823e, 0x1f},
	{0x823f, 0x64},
	{0x8240, 0x03},
	{0x8241, 0x70},
	{0x8242, 0x26},
	{0x8243, 0x78},
	{0x8244, 0xbb},
	{0x8245, 0xe6},
	{0x8246, 0xff},
	{0x8247, 0xc3},
	{0x8248, 0x78},
	{0x8249, 0xbd},
	{0x824a, 0x12},
	{0x824b, 0x0a},
	{0x824c, 0x84},
	{0x824d, 0x40},
	{0x824e, 0x05},
	{0x824f, 0x12},
	{0x8250, 0x0a},
	{0x8251, 0x7e},
	{0x8252, 0x40},
	{0x8253, 0x09},
	{0x8254, 0x78},
	{0x8255, 0xb6},
	{0x8256, 0xe6},
	{0x8257, 0x78},
	{0x8258, 0xbb},
	{0x8259, 0xf6},
	{0x825a, 0x75},
	{0x825b, 0x1f},
	{0x825c, 0x04},
	{0x825d, 0x78},
	{0x825e, 0xbb},
	{0x825f, 0xe6},
	{0x8260, 0x75},
	{0x8261, 0xf0},
	{0x8262, 0x05},
	{0x8263, 0xa4},
	{0x8264, 0xf5},
	{0x8265, 0x49},
	{0x8266, 0x02},
	{0x8267, 0x08},
	{0x8268, 0x4f},
	{0x8269, 0xe5},
	{0x826a, 0x1f},
	{0x826b, 0xb4},
	{0x826c, 0x04},
	{0x826d, 0x1f},
	{0x826e, 0x90},
	{0x826f, 0x0e},
	{0x8270, 0x89},
	{0x8271, 0xe4},
	{0x8272, 0x78},
	{0x8273, 0xc0},
	{0x8274, 0x12},
	{0x8275, 0x0a},
	{0x8276, 0x8d},
	{0x8277, 0x40},
	{0x8278, 0x02},
	{0x8279, 0xd2},
	{0x827a, 0x36},
	{0x827b, 0x75},
	{0x827c, 0x1f},
	{0x827d, 0x05},
	{0x827e, 0x75},
	{0x827f, 0x34},
	{0x8280, 0xff},
	{0x8281, 0x75},
	{0x8282, 0x35},
	{0x8283, 0x0e},
	{0x8284, 0x75},
	{0x8285, 0x36},
	{0x8286, 0x59},
	{0x8287, 0x75},
	{0x8288, 0x37},
	{0x8289, 0x01},
	{0x828a, 0x12},
	{0x828b, 0x0a},
	{0x828c, 0x3e},
	{0x828d, 0x22},
	{0x828e, 0xef},
	{0x828f, 0x8d},
	{0x8290, 0xf0},
	{0x8291, 0xa4},
	{0x8292, 0xa8},
	{0x8293, 0xf0},
	{0x8294, 0xcf},
	{0x8295, 0x8c},
	{0x8296, 0xf0},
	{0x8297, 0xa4},
	{0x8298, 0x28},
	{0x8299, 0xce},
	{0x829a, 0x8d},
	{0x829b, 0xf0},
	{0x829c, 0xa4},
	{0x829d, 0x2e},
	{0x829e, 0xfe},
	{0x829f, 0x22},
	{0x82a0, 0xbc},
	{0x82a1, 0x00},
	{0x82a2, 0x0b},
	{0x82a3, 0xbe},
	{0x82a4, 0x00},
	{0x82a5, 0x29},
	{0x82a6, 0xef},
	{0x82a7, 0x8d},
	{0x82a8, 0xf0},
	{0x82a9, 0x84},
	{0x82aa, 0xff},
	{0x82ab, 0xad},
	{0x82ac, 0xf0},
	{0x82ad, 0x22},
	{0x82ae, 0xe4},
	{0x82af, 0xcc},
	{0x82b0, 0xf8},
	{0x82b1, 0x75},
	{0x82b2, 0xf0},
	{0x82b3, 0x08},
	{0x82b4, 0xef},
	{0x82b5, 0x2f},
	{0x82b6, 0xff},
	{0x82b7, 0xee},
	{0x82b8, 0x33},
	{0x82b9, 0xfe},
	{0x82ba, 0xec},
	{0x82bb, 0x33},
	{0x82bc, 0xfc},
	{0x82bd, 0xee},
	{0x82be, 0x9d},
	{0x82bf, 0xec},
	{0x82c0, 0x98},
	{0x82c1, 0x40},
	{0x82c2, 0x05},
	{0x82c3, 0xfc},
	{0x82c4, 0xee},
	{0x82c5, 0x9d},
	{0x82c6, 0xfe},
	{0x82c7, 0x0f},
	{0x82c8, 0xd5},
	{0x82c9, 0xf0},
	{0x82ca, 0xe9},
	{0x82cb, 0xe4},
	{0x82cc, 0xce},
	{0x82cd, 0xfd},
	{0x82ce, 0x22},
	{0x82cf, 0xed},
	{0x82d0, 0xf8},
	{0x82d1, 0xf5},
	{0x82d2, 0xf0},
	{0x82d3, 0xee},
	{0x82d4, 0x84},
	{0x82d5, 0x20},
	{0x82d6, 0xd2},
	{0x82d7, 0x1c},
	{0x82d8, 0xfe},
	{0x82d9, 0xad},
	{0x82da, 0xf0},
	{0x82db, 0x75},
	{0x82dc, 0xf0},
	{0x82dd, 0x08},
	{0x82de, 0xef},
	{0x82df, 0x2f},
	{0x82e0, 0xff},
	{0x82e1, 0xed},
	{0x82e2, 0x33},
	{0x82e3, 0xfd},
	{0x82e4, 0x40},
	{0x82e5, 0x07},
	{0x82e6, 0x98},
	{0x82e7, 0x50},
	{0x82e8, 0x06},
	{0x82e9, 0xd5},
	{0x82ea, 0xf0},
	{0x82eb, 0xf2},
	{0x82ec, 0x22},
	{0x82ed, 0xc3},
	{0x82ee, 0x98},
	{0x82ef, 0xfd},
	{0x82f0, 0x0f},
	{0x82f1, 0xd5},
	{0x82f2, 0xf0},
	{0x82f3, 0xea},
	{0x82f4, 0x22},
	{0x82f5, 0xe8},
	{0x82f6, 0x8f},
	{0x82f7, 0xf0},
	{0x82f8, 0xa4},
	{0x82f9, 0xcc},
	{0x82fa, 0x8b},
	{0x82fb, 0xf0},
	{0x82fc, 0xa4},
	{0x82fd, 0x2c},
	{0x82fe, 0xfc},
	{0x82ff, 0xe9},
	{0x8300, 0x8e},
	{0x8301, 0xf0},
	{0x8302, 0xa4},
	{0x8303, 0x2c},
	{0x8304, 0xfc},
	{0x8305, 0x8a},
	{0x8306, 0xf0},
	{0x8307, 0xed},
	{0x8308, 0xa4},
	{0x8309, 0x2c},
	{0x830a, 0xfc},
	{0x830b, 0xea},
	{0x830c, 0x8e},
	{0x830d, 0xf0},
	{0x830e, 0xa4},
	{0x830f, 0xcd},
	{0x8310, 0xa8},
	{0x8311, 0xf0},
	{0x8312, 0x8b},
	{0x8313, 0xf0},
	{0x8314, 0xa4},
	{0x8315, 0x2d},
	{0x8316, 0xcc},
	{0x8317, 0x38},
	{0x8318, 0x25},
	{0x8319, 0xf0},
	{0x831a, 0xfd},
	{0x831b, 0xe9},
	{0x831c, 0x8f},
	{0x831d, 0xf0},
	{0x831e, 0xa4},
	{0x831f, 0x2c},
	{0x8320, 0xcd},
	{0x8321, 0x35},
	{0x8322, 0xf0},
	{0x8323, 0xfc},
	{0x8324, 0xeb},
	{0x8325, 0x8e},
	{0x8326, 0xf0},
	{0x8327, 0xa4},
	{0x8328, 0xfe},
	{0x8329, 0xa9},
	{0x832a, 0xf0},
	{0x832b, 0xeb},
	{0x832c, 0x8f},
	{0x832d, 0xf0},
	{0x832e, 0xa4},
	{0x832f, 0xcf},
	{0x8330, 0xc5},
	{0x8331, 0xf0},
	{0x8332, 0x2e},
	{0x8333, 0xcd},
	{0x8334, 0x39},
	{0x8335, 0xfe},
	{0x8336, 0xe4},
	{0x8337, 0x3c},
	{0x8338, 0xfc},
	{0x8339, 0xea},
	{0x833a, 0xa4},
	{0x833b, 0x2d},
	{0x833c, 0xce},
	{0x833d, 0x35},
	{0x833e, 0xf0},
	{0x833f, 0xfd},
	{0x8340, 0xe4},
	{0x8341, 0x3c},
	{0x8342, 0xfc},
	{0x8343, 0x22},
	{0x8344, 0x75},
	{0x8345, 0xf0},
	{0x8346, 0x08},
	{0x8347, 0x75},
	{0x8348, 0x82},
	{0x8349, 0x00},
	{0x834a, 0xef},
	{0x834b, 0x2f},
	{0x834c, 0xff},
	{0x834d, 0xee},
	{0x834e, 0x33},
	{0x834f, 0xfe},
	{0x8350, 0xcd},
	{0x8351, 0x33},
	{0x8352, 0xcd},
	{0x8353, 0xcc},
	{0x8354, 0x33},
	{0x8355, 0xcc},
	{0x8356, 0xc5},
	{0x8357, 0x82},
	{0x8358, 0x33},
	{0x8359, 0xc5},
	{0x835a, 0x82},
	{0x835b, 0x9b},
	{0x835c, 0xed},
	{0x835d, 0x9a},
	{0x835e, 0xec},
	{0x835f, 0x99},
	{0x8360, 0xe5},
	{0x8361, 0x82},
	{0x8362, 0x98},
	{0x8363, 0x40},
	{0x8364, 0x0c},
	{0x8365, 0xf5},
	{0x8366, 0x82},
	{0x8367, 0xee},
	{0x8368, 0x9b},
	{0x8369, 0xfe},
	{0x836a, 0xed},
	{0x836b, 0x9a},
	{0x836c, 0xfd},
	{0x836d, 0xec},
	{0x836e, 0x99},
	{0x836f, 0xfc},
	{0x8370, 0x0f},
	{0x8371, 0xd5},
	{0x8372, 0xf0},
	{0x8373, 0xd6},
	{0x8374, 0xe4},
	{0x8375, 0xce},
	{0x8376, 0xfb},
	{0x8377, 0xe4},
	{0x8378, 0xcd},
	{0x8379, 0xfa},
	{0x837a, 0xe4},
	{0x837b, 0xcc},
	{0x837c, 0xf9},
	{0x837d, 0xa8},
	{0x837e, 0x82},
	{0x837f, 0x22},
	{0x8380, 0xb8},
	{0x8381, 0x00},
	{0x8382, 0xc1},
	{0x8383, 0xb9},
	{0x8384, 0x00},
	{0x8385, 0x59},
	{0x8386, 0xba},
	{0x8387, 0x00},
	{0x8388, 0x2d},
	{0x8389, 0xec},
	{0x838a, 0x8b},
	{0x838b, 0xf0},
	{0x838c, 0x84},
	{0x838d, 0xcf},
	{0x838e, 0xce},
	{0x838f, 0xcd},
	{0x8390, 0xfc},
	{0x8391, 0xe5},
	{0x8392, 0xf0},
	{0x8393, 0xcb},
	{0x8394, 0xf9},
	{0x8395, 0x78},
	{0x8396, 0x18},
	{0x8397, 0xef},
	{0x8398, 0x2f},
	{0x8399, 0xff},
	{0x839a, 0xee},
	{0x839b, 0x33},
	{0x839c, 0xfe},
	{0x839d, 0xed},
	{0x839e, 0x33},
	{0x839f, 0xfd},
	{0x83a0, 0xec},
	{0x83a1, 0x33},
	{0x83a2, 0xfc},
	{0x83a3, 0xeb},
	{0x83a4, 0x33},
	{0x83a5, 0xfb},
	{0x83a6, 0x10},
	{0x83a7, 0xd7},
	{0x83a8, 0x03},
	{0x83a9, 0x99},
	{0x83aa, 0x40},
	{0x83ab, 0x04},
	{0x83ac, 0xeb},
	{0x83ad, 0x99},
	{0x83ae, 0xfb},
	{0x83af, 0x0f},
	{0x83b0, 0xd8},
	{0x83b1, 0xe5},
	{0x83b2, 0xe4},
	{0x83b3, 0xf9},
	{0x83b4, 0xfa},
	{0x83b5, 0x22},
	{0x83b6, 0x78},
	{0x83b7, 0x18},
	{0x83b8, 0xef},
	{0x83b9, 0x2f},
	{0x83ba, 0xff},
	{0x83bb, 0xee},
	{0x83bc, 0x33},
	{0x83bd, 0xfe},
	{0x83be, 0xed},
	{0x83bf, 0x33},
	{0x83c0, 0xfd},
	{0x83c1, 0xec},
	{0x83c2, 0x33},
	{0x83c3, 0xfc},
	{0x83c4, 0xc9},
	{0x83c5, 0x33},
	{0x83c6, 0xc9},
	{0x83c7, 0x10},
	{0x83c8, 0xd7},
	{0x83c9, 0x05},
	{0x83ca, 0x9b},
	{0x83cb, 0xe9},
	{0x83cc, 0x9a},
	{0x83cd, 0x40},
	{0x83ce, 0x07},
	{0x83cf, 0xec},
	{0x83d0, 0x9b},
	{0x83d1, 0xfc},
	{0x83d2, 0xe9},
	{0x83d3, 0x9a},
	{0x83d4, 0xf9},
	{0x83d5, 0x0f},
	{0x83d6, 0xd8},
	{0x83d7, 0xe0},
	{0x83d8, 0xe4},
	{0x83d9, 0xc9},
	{0x83da, 0xfa},
	{0x83db, 0xe4},
	{0x83dc, 0xcc},
	{0x83dd, 0xfb},
	{0x83de, 0x22},
	{0x83df, 0x75},
	{0x83e0, 0xf0},
	{0x83e1, 0x10},
	{0x83e2, 0xef},
	{0x83e3, 0x2f},
	{0x83e4, 0xff},
	{0x83e5, 0xee},
	{0x83e6, 0x33},
	{0x83e7, 0xfe},
	{0x83e8, 0xed},
	{0x83e9, 0x33},
	{0x83ea, 0xfd},
	{0x83eb, 0xcc},
	{0x83ec, 0x33},
	{0x83ed, 0xcc},
	{0x83ee, 0xc8},
	{0x83ef, 0x33},
	{0x83f0, 0xc8},
	{0x83f1, 0x10},
	{0x83f2, 0xd7},
	{0x83f3, 0x07},
	{0x83f4, 0x9b},
	{0x83f5, 0xec},
	{0x83f6, 0x9a},
	{0x83f7, 0xe8},
	{0x83f8, 0x99},
	{0x83f9, 0x40},
	{0x83fa, 0x0a},
	{0x83fb, 0xed},
	{0x83fc, 0x9b},
	{0x83fd, 0xfd},
	{0x83fe, 0xec},
	{0x83ff, 0x9a},
	{0x8400, 0xfc},
	{0x8401, 0xe8},
	{0x8402, 0x99},
	{0x8403, 0xf8},
	{0x8404, 0x0f},
	{0x8405, 0xd5},
	{0x8406, 0xf0},
	{0x8407, 0xda},
	{0x8408, 0xe4},
	{0x8409, 0xcd},
	{0x840a, 0xfb},
	{0x840b, 0xe4},
	{0x840c, 0xcc},
	{0x840d, 0xfa},
	{0x840e, 0xe4},
	{0x840f, 0xc8},
	{0x8410, 0xf9},
	{0x8411, 0x22},
	{0x8412, 0xeb},
	{0x8413, 0x9f},
	{0x8414, 0xf5},
	{0x8415, 0xf0},
	{0x8416, 0xea},
	{0x8417, 0x9e},
	{0x8418, 0x42},
	{0x8419, 0xf0},
	{0x841a, 0xe9},
	{0x841b, 0x9d},
	{0x841c, 0x42},
	{0x841d, 0xf0},
	{0x841e, 0xe8},
	{0x841f, 0x9c},
	{0x8420, 0x45},
	{0x8421, 0xf0},
	{0x8422, 0x22},
	{0x8423, 0xe8},
	{0x8424, 0x60},
	{0x8425, 0x0f},
	{0x8426, 0xef},
	{0x8427, 0xc3},
	{0x8428, 0x33},
	{0x8429, 0xff},
	{0x842a, 0xee},
	{0x842b, 0x33},
	{0x842c, 0xfe},
	{0x842d, 0xed},
	{0x842e, 0x33},
	{0x842f, 0xfd},
	{0x8430, 0xec},
	{0x8431, 0x33},
	{0x8432, 0xfc},
	{0x8433, 0xd8},
	{0x8434, 0xf1},
	{0x8435, 0x22},
	{0x8436, 0xe4},
	{0x8437, 0x93},
	{0x8438, 0xfc},
	{0x8439, 0x74},
	{0x843a, 0x01},
	{0x843b, 0x93},
	{0x843c, 0xfd},
	{0x843d, 0x74},
	{0x843e, 0x02},
	{0x843f, 0x93},
	{0x8440, 0xfe},
	{0x8441, 0x74},
	{0x8442, 0x03},
	{0x8443, 0x93},
	{0x8444, 0xff},
	{0x8445, 0x22},
	{0x8446, 0xe6},
	{0x8447, 0xfb},
	{0x8448, 0x08},
	{0x8449, 0xe6},
	{0x844a, 0xf9},
	{0x844b, 0x08},
	{0x844c, 0xe6},
	{0x844d, 0xfa},
	{0x844e, 0x08},
	{0x844f, 0xe6},
	{0x8450, 0xcb},
	{0x8451, 0xf8},
	{0x8452, 0x22},
	{0x8453, 0xec},
	{0x8454, 0xf6},
	{0x8455, 0x08},
	{0x8456, 0xed},
	{0x8457, 0xf6},
	{0x8458, 0x08},
	{0x8459, 0xee},
	{0x845a, 0xf6},
	{0x845b, 0x08},
	{0x845c, 0xef},
	{0x845d, 0xf6},
	{0x845e, 0x22},
	{0x845f, 0xa4},
	{0x8460, 0x25},
	{0x8461, 0x82},
	{0x8462, 0xf5},
	{0x8463, 0x82},
	{0x8464, 0xe5},
	{0x8465, 0xf0},
	{0x8466, 0x35},
	{0x8467, 0x83},
	{0x8468, 0xf5},
	{0x8469, 0x83},
	{0x846a, 0x22},
	{0x846b, 0xd0},
	{0x846c, 0x83},
	{0x846d, 0xd0},
	{0x846e, 0x82},
	{0x846f, 0xf8},
	{0x8470, 0xe4},
	{0x8471, 0x93},
	{0x8472, 0x70},
	{0x8473, 0x12},
	{0x8474, 0x74},
	{0x8475, 0x01},
	{0x8476, 0x93},
	{0x8477, 0x70},
	{0x8478, 0x0d},
	{0x8479, 0xa3},
	{0x847a, 0xa3},
	{0x847b, 0x93},
	{0x847c, 0xf8},
	{0x847d, 0x74},
	{0x847e, 0x01},
	{0x847f, 0x93},
	{0x8480, 0xf5},
	{0x8481, 0x82},
	{0x8482, 0x88},
	{0x8483, 0x83},
	{0x8484, 0xe4},
	{0x8485, 0x73},
	{0x8486, 0x74},
	{0x8487, 0x02},
	{0x8488, 0x93},
	{0x8489, 0x68},
	{0x848a, 0x60},
	{0x848b, 0xef},
	{0x848c, 0xa3},
	{0x848d, 0xa3},
	{0x848e, 0xa3},
	{0x848f, 0x80},
	{0x8490, 0xdf},
	{0x8491, 0x90},
	{0x8492, 0x38},
	{0x8493, 0x04},
	{0x8494, 0x78},
	{0x8495, 0x4f},
	{0x8496, 0x12},
	{0x8497, 0x09},
	{0x8498, 0x44},
	{0x8499, 0x90},
	{0x849a, 0x38},
	{0x849b, 0x00},
	{0x849c, 0xe0},
	{0x849d, 0xfe},
	{0x849e, 0xa3},
	{0x849f, 0xe0},
	{0x84a0, 0xfd},
	{0x84a1, 0xed},
	{0x84a2, 0xff},
	{0x84a3, 0xc3},
	{0x84a4, 0x12},
	{0x84a5, 0x08},
	{0x84a6, 0xfd},
	{0x84a7, 0x90},
	{0x84a8, 0x38},
	{0x84a9, 0x10},
	{0x84aa, 0x12},
	{0x84ab, 0x08},
	{0x84ac, 0xf1},
	{0x84ad, 0x90},
	{0x84ae, 0x38},
	{0x84af, 0x06},
	{0x84b0, 0x78},
	{0x84b1, 0x51},
	{0x84b2, 0x12},
	{0x84b3, 0x09},
	{0x84b4, 0x44},
	{0x84b5, 0x90},
	{0x84b6, 0x38},
	{0x84b7, 0x02},
	{0x84b8, 0xe0},
	{0x84b9, 0xfe},
	{0x84ba, 0xa3},
	{0x84bb, 0xe0},
	{0x84bc, 0xfd},
	{0x84bd, 0xed},
	{0x84be, 0xff},
	{0x84bf, 0xc3},
	{0x84c0, 0x12},
	{0x84c1, 0x08},
	{0x84c2, 0xfd},
	{0x84c3, 0x90},
	{0x84c4, 0x38},
	{0x84c5, 0x12},
	{0x84c6, 0x12},
	{0x84c7, 0x08},
	{0x84c8, 0xf1},
	{0x84c9, 0xa3},
	{0x84ca, 0xe0},
	{0x84cb, 0xb4},
	{0x84cc, 0x31},
	{0x84cd, 0x07},
	{0x84ce, 0x78},
	{0x84cf, 0x4f},
	{0x84d0, 0x79},
	{0x84d1, 0x4f},
	{0x84d2, 0x12},
	{0x84d3, 0x09},
	{0x84d4, 0x5a},
	{0x84d5, 0x90},
	{0x84d6, 0x38},
	{0x84d7, 0x14},
	{0x84d8, 0xe0},
	{0x84d9, 0xb4},
	{0x84da, 0x71},
	{0x84db, 0x15},
	{0x84dc, 0x78},
	{0x84dd, 0x4f},
	{0x84de, 0xe6},
	{0x84df, 0xfe},
	{0x84e0, 0x08},
	{0x84e1, 0xe6},
	{0x84e2, 0x78},
	{0x84e3, 0x02},
	{0x84e4, 0xce},
	{0x84e5, 0xc3},
	{0x84e6, 0x13},
	{0x84e7, 0xce},
	{0x84e8, 0x13},
	{0x84e9, 0xd8},
	{0x84ea, 0xf9},
	{0x84eb, 0x79},
	{0x84ec, 0x50},
	{0x84ed, 0xf7},
	{0x84ee, 0xee},
	{0x84ef, 0x19},
	{0x84f0, 0xf7},
	{0x84f1, 0x90},
	{0x84f2, 0x38},
	{0x84f3, 0x15},
	{0x84f4, 0xe0},
	{0x84f5, 0xb4},
	{0x84f6, 0x31},
	{0x84f7, 0x07},
	{0x84f8, 0x78},
	{0x84f9, 0x51},
	{0x84fa, 0x79},
	{0x84fb, 0x51},
	{0x84fc, 0x12},
	{0x84fd, 0x09},
	{0x84fe, 0x5a},
	{0x84ff, 0x90},
	{0x8500, 0x38},
	{0x8501, 0x15},
	{0x8502, 0xe0},
	{0x8503, 0xb4},
	{0x8504, 0x71},
	{0x8505, 0x15},
	{0x8506, 0x78},
	{0x8507, 0x51},
	{0x8508, 0xe6},
	{0x8509, 0xfe},
	{0x850a, 0x08},
	{0x850b, 0xe6},
	{0x850c, 0x78},
	{0x850d, 0x02},
	{0x850e, 0xce},
	{0x850f, 0xc3},
	{0x8510, 0x13},
	{0x8511, 0xce},
	{0x8512, 0x13},
	{0x8513, 0xd8},
	{0x8514, 0xf9},
	{0x8515, 0x79},
	{0x8516, 0x52},
	{0x8517, 0xf7},
	{0x8518, 0xee},
	{0x8519, 0x19},
	{0x851a, 0xf7},
	{0x851b, 0x79},
	{0x851c, 0x4f},
	{0x851d, 0x12},
	{0x851e, 0x09},
	{0x851f, 0x2c},
	{0x8520, 0x09},
	{0x8521, 0x12},
	{0x8522, 0x09},
	{0x8523, 0x2c},
	{0x8524, 0xaf},
	{0x8525, 0x45},
	{0x8526, 0x12},
	{0x8527, 0x08},
	{0x8528, 0xe2},
	{0x8529, 0x7d},
	{0x852a, 0x50},
	{0x852b, 0x12},
	{0x852c, 0x02},
	{0x852d, 0xa0},
	{0x852e, 0x78},
	{0x852f, 0x57},
	{0x8530, 0xa6},
	{0x8531, 0x06},
	{0x8532, 0x08},
	{0x8533, 0xa6},
	{0x8534, 0x07},
	{0x8535, 0xaf},
	{0x8536, 0x43},
	{0x8537, 0x12},
	{0x8538, 0x08},
	{0x8539, 0xe2},
	{0x853a, 0x7d},
	{0x853b, 0x50},
	{0x853c, 0x12},
	{0x853d, 0x02},
	{0x853e, 0xa0},
	{0x853f, 0x78},
	{0x8540, 0x53},
	{0x8541, 0xa6},
	{0x8542, 0x06},
	{0x8543, 0x08},
	{0x8544, 0xa6},
	{0x8545, 0x07},
	{0x8546, 0xaf},
	{0x8547, 0x46},
	{0x8548, 0x78},
	{0x8549, 0x51},
	{0x854a, 0x12},
	{0x854b, 0x08},
	{0x854c, 0xe4},
	{0x854d, 0x7d},
	{0x854e, 0x3c},
	{0x854f, 0x12},
	{0x8550, 0x02},
	{0x8551, 0xa0},
	{0x8552, 0x78},
	{0x8553, 0x59},
	{0x8554, 0xa6},
	{0x8555, 0x06},
	{0x8556, 0x08},
	{0x8557, 0xa6},
	{0x8558, 0x07},
	{0x8559, 0xaf},
	{0x855a, 0x44},
	{0x855b, 0x7e},
	{0x855c, 0x00},
	{0x855d, 0x78},
	{0x855e, 0x51},
	{0x855f, 0x12},
	{0x8560, 0x08},
	{0x8561, 0xe6},
	{0x8562, 0x7d},
	{0x8563, 0x3c},
	{0x8564, 0x12},
	{0x8565, 0x02},
	{0x8566, 0xa0},
	{0x8567, 0x78},
	{0x8568, 0x55},
	{0x8569, 0xa6},
	{0x856a, 0x06},
	{0x856b, 0x08},
	{0x856c, 0xa6},
	{0x856d, 0x07},
	{0x856e, 0xc3},
	{0x856f, 0x78},
	{0x8570, 0x58},
	{0x8571, 0xe6},
	{0x8572, 0x94},
	{0x8573, 0x08},
	{0x8574, 0x18},
	{0x8575, 0xe6},
	{0x8576, 0x94},
	{0x8577, 0x00},
	{0x8578, 0x50},
	{0x8579, 0x05},
	{0x857a, 0x76},
	{0x857b, 0x00},
	{0x857c, 0x08},
	{0x857d, 0x76},
	{0x857e, 0x08},
	{0x857f, 0xc3},
	{0x8580, 0x78},
	{0x8581, 0x5a},
	{0x8582, 0xe6},
	{0x8583, 0x94},
	{0x8584, 0x08},
	{0x8585, 0x18},
	{0x8586, 0xe6},
	{0x8587, 0x94},
	{0x8588, 0x00},
	{0x8589, 0x50},
	{0x858a, 0x05},
	{0x858b, 0x76},
	{0x858c, 0x00},
	{0x858d, 0x08},
	{0x858e, 0x76},
	{0x858f, 0x08},
	{0x8590, 0x78},
	{0x8591, 0x57},
	{0x8592, 0x12},
	{0x8593, 0x09},
	{0x8594, 0x19},
	{0x8595, 0xff},
	{0x8596, 0xd3},
	{0x8597, 0x78},
	{0x8598, 0x54},
	{0x8599, 0xe6},
	{0x859a, 0x9f},
	{0x859b, 0x18},
	{0x859c, 0xe6},
	{0x859d, 0x9e},
	{0x859e, 0x40},
	{0x859f, 0x0e},
	{0x85a0, 0x78},
	{0x85a1, 0x57},
	{0x85a2, 0xe6},
	{0x85a3, 0x13},
	{0x85a4, 0xfe},
	{0x85a5, 0x08},
	{0x85a6, 0xe6},
	{0x85a7, 0x78},
	{0x85a8, 0x54},
	{0x85a9, 0x12},
	{0x85aa, 0x09},
	{0x85ab, 0x4f},
	{0x85ac, 0x80},
	{0x85ad, 0x04},
	{0x85ae, 0x7e},
	{0x85af, 0x00},
	{0x85b0, 0x7f},
	{0x85b1, 0x00},
	{0x85b2, 0x78},
	{0x85b3, 0x5b},
	{0x85b4, 0x12},
	{0x85b5, 0x09},
	{0x85b6, 0x11},
	{0x85b7, 0xff},
	{0x85b8, 0xd3},
	{0x85b9, 0x78},
	{0x85ba, 0x56},
	{0x85bb, 0xe6},
	{0x85bc, 0x9f},
	{0x85bd, 0x18},
	{0x85be, 0xe6},
	{0x85bf, 0x9e},
	{0x85c0, 0x40},
	{0x85c1, 0x0e},
	{0x85c2, 0x78},
	{0x85c3, 0x59},
	{0x85c4, 0xe6},
	{0x85c5, 0x13},
	{0x85c6, 0xfe},
	{0x85c7, 0x08},
	{0x85c8, 0xe6},
	{0x85c9, 0x78},
	{0x85ca, 0x56},
	{0x85cb, 0x12},
	{0x85cc, 0x09},
	{0x85cd, 0x4f},
	{0x85ce, 0x80},
	{0x85cf, 0x04},
	{0x85d0, 0x7e},
	{0x85d1, 0x00},
	{0x85d2, 0x7f},
	{0x85d3, 0x00},
	{0x85d4, 0xe4},
	{0x85d5, 0xfc},
	{0x85d6, 0xfd},
	{0x85d7, 0x78},
	{0x85d8, 0x5f},
	{0x85d9, 0x12},
	{0x85da, 0x04},
	{0x85db, 0x53},
	{0x85dc, 0x78},
	{0x85dd, 0x57},
	{0x85de, 0x12},
	{0x85df, 0x09},
	{0x85e0, 0x19},
	{0x85e1, 0x78},
	{0x85e2, 0x54},
	{0x85e3, 0x26},
	{0x85e4, 0xff},
	{0x85e5, 0xee},
	{0x85e6, 0x18},
	{0x85e7, 0x36},
	{0x85e8, 0xfe},
	{0x85e9, 0x78},
	{0x85ea, 0x63},
	{0x85eb, 0x12},
	{0x85ec, 0x09},
	{0x85ed, 0x11},
	{0x85ee, 0x78},
	{0x85ef, 0x56},
	{0x85f0, 0x26},
	{0x85f1, 0xff},
	{0x85f2, 0xee},
	{0x85f3, 0x18},
	{0x85f4, 0x36},
	{0x85f5, 0xfe},
	{0x85f6, 0xe4},
	{0x85f7, 0xfc},
	{0x85f8, 0xfd},
	{0x85f9, 0x78},
	{0x85fa, 0x67},
	{0x85fb, 0x12},
	{0x85fc, 0x04},
	{0x85fd, 0x53},
	{0x85fe, 0x12},
	{0x85ff, 0x09},
	{0x8600, 0x21},
	{0x8601, 0x78},
	{0x8602, 0x63},
	{0x8603, 0x12},
	{0x8604, 0x04},
	{0x8605, 0x46},
	{0x8606, 0xd3},
	{0x8607, 0x12},
	{0x8608, 0x04},
	{0x8609, 0x12},
	{0x860a, 0x40},
	{0x860b, 0x08},
	{0x860c, 0x12},
	{0x860d, 0x09},
	{0x860e, 0x21},
	{0x860f, 0x78},
	{0x8610, 0x63},
	{0x8611, 0x12},
	{0x8612, 0x04},
	{0x8613, 0x53},
	{0x8614, 0x78},
	{0x8615, 0x51},
	{0x8616, 0x12},
	{0x8617, 0x09},
	{0x8618, 0x23},
	{0x8619, 0x78},
	{0x861a, 0x67},
	{0x861b, 0x12},
	{0x861c, 0x04},
	{0x861d, 0x46},
	{0x861e, 0xd3},
	{0x861f, 0x12},
	{0x8620, 0x04},
	{0x8621, 0x12},
	{0x8622, 0x40},
	{0x8623, 0x0a},
	{0x8624, 0x78},
	{0x8625, 0x51},
	{0x8626, 0x12},
	{0x8627, 0x09},
	{0x8628, 0x23},
	{0x8629, 0x78},
	{0x862a, 0x67},
	{0x862b, 0x12},
	{0x862c, 0x04},
	{0x862d, 0x53},
	{0x862e, 0xe4},
	{0x862f, 0xfd},
	{0x8630, 0x78},
	{0x8631, 0x5e},
	{0x8632, 0x12},
	{0x8633, 0x09},
	{0x8634, 0x3c},
	{0x8635, 0x24},
	{0x8636, 0x01},
	{0x8637, 0x12},
	{0x8638, 0x09},
	{0x8639, 0x05},
	{0x863a, 0x78},
	{0x863b, 0x62},
	{0x863c, 0x12},
	{0x863d, 0x09},
	{0x863e, 0x3c},
	{0x863f, 0x24},
	{0x8640, 0x02},
	{0x8641, 0x12},
	{0x8642, 0x09},
	{0x8643, 0x05},
	{0x8644, 0x78},
	{0x8645, 0x66},
	{0x8646, 0x12},
	{0x8647, 0x09},
	{0x8648, 0x3c},
	{0x8649, 0x24},
	{0x864a, 0x03},
	{0x864b, 0x12},
	{0x864c, 0x09},
	{0x864d, 0x05},
	{0x864e, 0x78},
	{0x864f, 0x6a},
	{0x8650, 0x12},
	{0x8651, 0x09},
	{0x8652, 0x3c},
	{0x8653, 0x24},
	{0x8654, 0x04},
	{0x8655, 0x12},
	{0x8656, 0x09},
	{0x8657, 0x05},
	{0x8658, 0x0d},
	{0x8659, 0xbd},
	{0x865a, 0x05},
	{0x865b, 0xd4},
	{0x865c, 0xc2},
	{0x865d, 0x0e},
	{0x865e, 0xc2},
	{0x865f, 0x06},
	{0x8660, 0x22},
	{0x8661, 0x85},
	{0x8662, 0x08},
	{0x8663, 0x41},
	{0x8664, 0x90},
	{0x8665, 0x30},
	{0x8666, 0x24},
	{0x8667, 0xe0},
	{0x8668, 0xf5},
	{0x8669, 0x3d},
	{0x866a, 0xa3},
	{0x866b, 0xe0},
	{0x866c, 0xf5},
	{0x866d, 0x3e},
	{0x866e, 0xa3},
	{0x866f, 0xe0},
	{0x8670, 0xf5},
	{0x8671, 0x3f},
	{0x8672, 0xa3},
	{0x8673, 0xe0},
	{0x8674, 0xf5},
	{0x8675, 0x40},
	{0x8676, 0xa3},
	{0x8677, 0xe0},
	{0x8678, 0xf5},
	{0x8679, 0x3c},
	{0x867a, 0xd2},
	{0x867b, 0x33},
	{0x867c, 0xe5},
	{0x867d, 0x41},
	{0x867e, 0x12},
	{0x867f, 0x04},
	{0x8680, 0x6b},
	{0x8681, 0x06},
	{0x8682, 0xbe},
	{0x8683, 0x03},
	{0x8684, 0x06},
	{0x8685, 0xc2},
	{0x8686, 0x04},
	{0x8687, 0x06},
	{0x8688, 0xc8},
	{0x8689, 0x07},
	{0x868a, 0x06},
	{0x868b, 0xd1},
	{0x868c, 0x08},
	{0x868d, 0x06},
	{0x868e, 0xe2},
	{0x868f, 0x12},
	{0x8690, 0x06},
	{0x8691, 0xfd},
	{0x8692, 0x18},
	{0x8693, 0x07},
	{0x8694, 0x13},
	{0x8695, 0x19},
	{0x8696, 0x06},
	{0x8697, 0xe8},
	{0x8698, 0x1a},
	{0x8699, 0x06},
	{0x869a, 0xf4},
	{0x869b, 0x1b},
	{0x869c, 0x07},
	{0x869d, 0x37},
	{0x869e, 0x80},
	{0x869f, 0x07},
	{0x86a0, 0x3a},
	{0x86a1, 0x81},
	{0x86a2, 0x07},
	{0x86a3, 0x95},
	{0x86a4, 0x8f},
	{0x86a5, 0x07},
	{0x86a6, 0x84},
	{0x86a7, 0x90},
	{0x86a8, 0x07},
	{0x86a9, 0x95},
	{0x86aa, 0x91},
	{0x86ab, 0x07},
	{0x86ac, 0x95},
	{0x86ad, 0x92},
	{0x86ae, 0x07},
	{0x86af, 0x95},
	{0x86b0, 0x93},
	{0x86b1, 0x07},
	{0x86b2, 0x95},
	{0x86b3, 0x94},
	{0x86b4, 0x07},
	{0x86b5, 0x95},
	{0x86b6, 0x98},
	{0x86b7, 0x07},
	{0x86b8, 0x92},
	{0x86b9, 0x9f},
	{0x86ba, 0x00},
	{0x86bb, 0x00},
	{0x86bc, 0x07},
	{0x86bd, 0xb0},
	{0x86be, 0x12},
	{0x86bf, 0x0a},
	{0x86c0, 0xe8},
	{0x86c1, 0x22},
	{0x86c2, 0x12},
	{0x86c3, 0x0a},
	{0x86c4, 0xe8},
	{0x86c5, 0xd2},
	{0x86c6, 0x03},
	{0x86c7, 0x22},
	{0x86c8, 0xa2},
	{0x86c9, 0x36},
	{0x86ca, 0xe4},
	{0x86cb, 0x33},
	{0x86cc, 0xf5},
	{0x86cd, 0x3c},
	{0x86ce, 0x02},
	{0x86cf, 0x07},
	{0x86d0, 0x95},
	{0x86d1, 0xc2},
	{0x86d2, 0x01},
	{0x86d3, 0xc2},
	{0x86d4, 0x02},
	{0x86d5, 0xc2},
	{0x86d6, 0x03},
	{0x86d7, 0x12},
	{0x86d8, 0x09},
	{0x86d9, 0x64},
	{0x86da, 0x75},
	{0x86db, 0x1e},
	{0x86dc, 0x70},
	{0x86dd, 0xd2},
	{0x86de, 0x34},
	{0x86df, 0x02},
	{0x86e0, 0x07},
	{0x86e1, 0x95},
	{0x86e2, 0x12},
	{0x86e3, 0x04},
	{0x86e4, 0x91},
	{0x86e5, 0x02},
	{0x86e6, 0x07},
	{0x86e7, 0x95},
	{0x86e8, 0x85},
	{0x86e9, 0x40},
	{0x86ea, 0x48},
	{0x86eb, 0x85},
	{0x86ec, 0x3c},
	{0x86ed, 0x49},
	{0x86ee, 0x12},
	{0x86ef, 0x08},
	{0x86f0, 0x4f},
	{0x86f1, 0x02},
	{0x86f2, 0x07},
	{0x86f3, 0x95},
	{0x86f4, 0x85},
	{0x86f5, 0x48},
	{0x86f6, 0x40},
	{0x86f7, 0x85},
	{0x86f8, 0x49},
	{0x86f9, 0x3c},
	{0x86fa, 0x02},
	{0x86fb, 0x07},
	{0x86fc, 0x95},
	{0x86fd, 0xe4},
	{0x86fe, 0xf5},
	{0x86ff, 0x22},
	{0x8700, 0xf5},
	{0x8701, 0x23},
	{0x8702, 0x85},
	{0x8703, 0x40},
	{0x8704, 0x31},
	{0x8705, 0x85},
	{0x8706, 0x3f},
	{0x8707, 0x30},
	{0x8708, 0x85},
	{0x8709, 0x3e},
	{0x870a, 0x2f},
	{0x870b, 0x85},
	{0x870c, 0x3d},
	{0x870d, 0x2e},
	{0x870e, 0x12},
	{0x870f, 0x0a},
	{0x8710, 0xba},
	{0x8711, 0x80},
	{0x8712, 0x1f},
	{0x8713, 0x75},
	{0x8714, 0x22},
	{0x8715, 0x00},
	{0x8716, 0x75},
	{0x8717, 0x23},
	{0x8718, 0x01},
	{0x8719, 0x74},
	{0x871a, 0xff},
	{0x871b, 0xf5},
	{0x871c, 0x2d},
	{0x871d, 0xf5},
	{0x871e, 0x2c},
	{0x871f, 0xf5},
	{0x8720, 0x2b},
	{0x8721, 0xf5},
	{0x8722, 0x2a},
	{0x8723, 0x12},
	{0x8724, 0x0a},
	{0x8725, 0xba},
	{0x8726, 0x85},
	{0x8727, 0x2d},
	{0x8728, 0x40},
	{0x8729, 0x85},
	{0x872a, 0x2c},
	{0x872b, 0x3f},
	{0x872c, 0x85},
	{0x872d, 0x2b},
	{0x872e, 0x3e},
	{0x872f, 0x85},
	{0x8730, 0x2a},
	{0x8731, 0x3d},
	{0x8732, 0xe4},
	{0x8733, 0xf5},
	{0x8734, 0x3c},
	{0x8735, 0x80},
	{0x8736, 0x5e},
	{0x8737, 0x02},
	{0x8738, 0x0b},
	{0x8739, 0x31},
	{0x873a, 0x85},
	{0x873b, 0x3d},
	{0x873c, 0x43},
	{0x873d, 0x85},
	{0x873e, 0x3e},
	{0x873f, 0x44},
	{0x8740, 0xe5},
	{0x8741, 0x45},
	{0x8742, 0xc3},
	{0x8743, 0x13},
	{0x8744, 0xff},
	{0x8745, 0xe5},
	{0x8746, 0x43},
	{0x8747, 0xc3},
	{0x8748, 0x9f},
	{0x8749, 0x50},
	{0x874a, 0x02},
	{0x874b, 0x8f},
	{0x874c, 0x43},
	{0x874d, 0xe5},
	{0x874e, 0x46},
	{0x874f, 0xc3},
	{0x8750, 0x13},
	{0x8751, 0xff},
	{0x8752, 0xe5},
	{0x8753, 0x44},
	{0x8754, 0xc3},
	{0x8755, 0x9f},
	{0x8756, 0x50},
	{0x8757, 0x02},
	{0x8758, 0x8f},
	{0x8759, 0x44},
	{0x875a, 0xe5},
	{0x875b, 0x45},
	{0x875c, 0xc3},
	{0x875d, 0x13},
	{0x875e, 0xff},
	{0x875f, 0xfd},
	{0x8760, 0xe5},
	{0x8761, 0x43},
	{0x8762, 0x90},
	{0x8763, 0x0e},
	{0x8764, 0x7f},
	{0x8765, 0x12},
	{0x8766, 0x0b},
	{0x8767, 0x04},
	{0x8768, 0x40},
	{0x8769, 0x04},
	{0x876a, 0xee},
	{0x876b, 0x9f},
	{0x876c, 0xf5},
	{0x876d, 0x43},
	{0x876e, 0xe5},
	{0x876f, 0x46},
	{0x8770, 0xc3},
	{0x8771, 0x13},
	{0x8772, 0xff},
	{0x8773, 0xfd},
	{0x8774, 0xe5},
	{0x8775, 0x44},
	{0x8776, 0x90},
	{0x8777, 0x0e},
	{0x8778, 0x80},
	{0x8779, 0x12},
	{0x877a, 0x0b},
	{0x877b, 0x04},
	{0x877c, 0x40},
	{0x877d, 0x14},
	{0x877e, 0xee},
	{0x877f, 0x9f},
	{0x8780, 0xf5},
	{0x8781, 0x44},
	{0x8782, 0x80},
	{0x8783, 0x0e},
	{0x8784, 0x85},
	{0x8785, 0x40},
	{0x8786, 0x46},
	{0x8787, 0x85},
	{0x8788, 0x3f},
	{0x8789, 0x45},
	{0x878a, 0x85},
	{0x878b, 0x3e},
	{0x878c, 0x44},
	{0x878d, 0x85},
	{0x878e, 0x3d},
	{0x878f, 0x43},
	{0x8790, 0x80},
	{0x8791, 0x03},
	{0x8792, 0x02},
	{0x8793, 0x04},
	{0x8794, 0x91},
	{0x8795, 0x90},
	{0x8796, 0x30},
	{0x8797, 0x24},
	{0x8798, 0xe5},
	{0x8799, 0x3d},
	{0x879a, 0xf0},
	{0x879b, 0xa3},
	{0x879c, 0xe5},
	{0x879d, 0x3e},
	{0x879e, 0xf0},
	{0x879f, 0xa3},
	{0x87a0, 0xe5},
	{0x87a1, 0x3f},
	{0x87a2, 0xf0},
	{0x87a3, 0xa3},
	{0x87a4, 0xe5},
	{0x87a5, 0x40},
	{0x87a6, 0xf0},
	{0x87a7, 0xa3},
	{0x87a8, 0xe5},
	{0x87a9, 0x3c},
	{0x87aa, 0xf0},
	{0x87ab, 0x90},
	{0x87ac, 0x30},
	{0x87ad, 0x23},
	{0x87ae, 0xe4},
	{0x87af, 0xf0},
	{0x87b0, 0x22},
	{0x87b1, 0xc0},
	{0x87b2, 0xe0},
	{0x87b3, 0xc0},
	{0x87b4, 0x83},
	{0x87b5, 0xc0},
	{0x87b6, 0x82},
	{0x87b7, 0xc0},
	{0x87b8, 0xd0},
	{0x87b9, 0x90},
	{0x87ba, 0x3f},
	{0x87bb, 0x0c},
	{0x87bc, 0xe0},
	{0x87bd, 0xf5},
	{0x87be, 0x32},
	{0x87bf, 0xe5},
	{0x87c0, 0x32},
	{0x87c1, 0x30},
	{0x87c2, 0xe3},
	{0x87c3, 0x4c},
	{0x87c4, 0x30},
	{0x87c5, 0x35},
	{0x87c6, 0x3e},
	{0x87c7, 0x90},
	{0x87c8, 0x60},
	{0x87c9, 0x19},
	{0x87ca, 0xe0},
	{0x87cb, 0xf5},
	{0x87cc, 0x0a},
	{0x87cd, 0xa3},
	{0x87ce, 0xe0},
	{0x87cf, 0xf5},
	{0x87d0, 0x0b},
	{0x87d1, 0x90},
	{0x87d2, 0x60},
	{0x87d3, 0x1d},
	{0x87d4, 0xe0},
	{0x87d5, 0xf5},
	{0x87d6, 0x14},
	{0x87d7, 0xa3},
	{0x87d8, 0xe0},
	{0x87d9, 0xf5},
	{0x87da, 0x15},
	{0x87db, 0x30},
	{0x87dc, 0x01},
	{0x87dd, 0x06},
	{0x87de, 0x30},
	{0x87df, 0x32},
	{0x87e0, 0x03},
	{0x87e1, 0xd3},
	{0x87e2, 0x80},
	{0x87e3, 0x01},
	{0x87e4, 0xc3},
	{0x87e5, 0x92},
	{0x87e6, 0x09},
	{0x87e7, 0x30},
	{0x87e8, 0x02},
	{0x87e9, 0x06},
	{0x87ea, 0x30},
	{0x87eb, 0x32},
	{0x87ec, 0x03},
	{0x87ed, 0xd3},
	{0x87ee, 0x80},
	{0x87ef, 0x01},
	{0x87f0, 0xc3},
	{0x87f1, 0x92},
	{0x87f2, 0x0a},
	{0x87f3, 0x30},
	{0x87f4, 0x32},
	{0x87f5, 0x0c},
	{0x87f6, 0x30},
	{0x87f7, 0x03},
	{0x87f8, 0x09},
	{0x87f9, 0x20},
	{0x87fa, 0x02},
	{0x87fb, 0x06},
	{0x87fc, 0x20},
	{0x87fd, 0x01},
	{0x87fe, 0x03},
	{0x87ff, 0xd3},
	{0x8800, 0x80},
	{0x8801, 0x01},
	{0x8802, 0xc3},
	{0x8803, 0x92},
	{0x8804, 0x0b},
	{0x8805, 0x90},
	{0x8806, 0x30},
	{0x8807, 0x01},
	{0x8808, 0xe0},
	{0x8809, 0x44},
	{0x880a, 0x40},
	{0x880b, 0xf0},
	{0x880c, 0xe0},
	{0x880d, 0x54},
	{0x880e, 0xbf},
	{0x880f, 0xf0},
	{0x8810, 0xe5},
	{0x8811, 0x32},
	{0x8812, 0x30},
	{0x8813, 0xe1},
	{0x8814, 0x14},
	{0x8815, 0x30},
	{0x8816, 0x33},
	{0x8817, 0x11},
	{0x8818, 0x90},
	{0x8819, 0x30},
	{0x881a, 0x22},
	{0x881b, 0xe0},
	{0x881c, 0xf5},
	{0x881d, 0x08},
	{0x881e, 0xe4},
	{0x881f, 0xf0},
	{0x8820, 0x30},
	{0x8821, 0x00},
	{0x8822, 0x03},
	{0x8823, 0xd3},
	{0x8824, 0x80},
	{0x8825, 0x01},
	{0x8826, 0xc3},
	{0x8827, 0x92},
	{0x8828, 0x08},
	{0x8829, 0xe5},
	{0x882a, 0x32},
	{0x882b, 0x30},
	{0x882c, 0xe5},
	{0x882d, 0x12},
	{0x882e, 0x90},
	{0x882f, 0x56},
	{0x8830, 0x90},
	{0x8831, 0xe0},
	{0x8832, 0xf5},
	{0x8833, 0x09},
	{0x8834, 0x30},
	{0x8835, 0x30},
	{0x8836, 0x09},
	{0x8837, 0x30},
	{0x8838, 0x05},
	{0x8839, 0x03},
	{0x883a, 0xd3},
	{0x883b, 0x80},
	{0x883c, 0x01},
	{0x883d, 0xc3},
	{0x883e, 0x92},
	{0x883f, 0x0d},
	{0x8840, 0x90},
	{0x8841, 0x3f},
	{0x8842, 0x0c},
	{0x8843, 0xe5},
	{0x8844, 0x32},
	{0x8845, 0xf0},
	{0x8846, 0xd0},
	{0x8847, 0xd0},
	{0x8848, 0xd0},
	{0x8849, 0x82},
	{0x884a, 0xd0},
	{0x884b, 0x83},
	{0x884c, 0xd0},
	{0x884d, 0xe0},
	{0x884e, 0x32},
	{0x884f, 0x90},
	{0x8850, 0x0e},
	{0x8851, 0x7d},
	{0x8852, 0xe4},
	{0x8853, 0x93},
	{0x8854, 0xfe},
	{0x8855, 0x74},
	{0x8856, 0x01},
	{0x8857, 0x93},
	{0x8858, 0xff},
	{0x8859, 0xc3},
	{0x885a, 0x90},
	{0x885b, 0x0e},
	{0x885c, 0x7b},
	{0x885d, 0x74},
	{0x885e, 0x01},
	{0x885f, 0x93},
	{0x8860, 0x9f},
	{0x8861, 0xff},
	{0x8862, 0xe4},
	{0x8863, 0x93},
	{0x8864, 0x9e},
	{0x8865, 0xfe},
	{0x8866, 0xe4},
	{0x8867, 0x8f},
	{0x8868, 0x3b},
	{0x8869, 0x8e},
	{0x886a, 0x3a},
	{0x886b, 0xf5},
	{0x886c, 0x39},
	{0x886d, 0xf5},
	{0x886e, 0x38},
	{0x886f, 0xab},
	{0x8870, 0x3b},
	{0x8871, 0xaa},
	{0x8872, 0x3a},
	{0x8873, 0xa9},
	{0x8874, 0x39},
	{0x8875, 0xa8},
	{0x8876, 0x38},
	{0x8877, 0xaf},
	{0x8878, 0x49},
	{0x8879, 0xfc},
	{0x887a, 0xfd},
	{0x887b, 0xfe},
	{0x887c, 0x12},
	{0x887d, 0x02},
	{0x887e, 0xf5},
	{0x887f, 0x12},
	{0x8880, 0x0b},
	{0x8881, 0x16},
	{0x8882, 0xe4},
	{0x8883, 0x7b},
	{0x8884, 0xff},
	{0x8885, 0xfa},
	{0x8886, 0xf9},
	{0x8887, 0xf8},
	{0x8888, 0x12},
	{0x8889, 0x03},
	{0x888a, 0x80},
	{0x888b, 0x12},
	{0x888c, 0x0b},
	{0x888d, 0x16},
	{0x888e, 0x90},
	{0x888f, 0x0e},
	{0x8890, 0x69},
	{0x8891, 0xe4},
	{0x8892, 0x12},
	{0x8893, 0x0b},
	{0x8894, 0x2b},
	{0x8895, 0x12},
	{0x8896, 0x0b},
	{0x8897, 0x16},
	{0x8898, 0xe4},
	{0x8899, 0x85},
	{0x889a, 0x48},
	{0x889b, 0x37},
	{0x889c, 0xf5},
	{0x889d, 0x36},
	{0x889e, 0xf5},
	{0x889f, 0x35},
	{0x88a0, 0xf5},
	{0x88a1, 0x34},
	{0x88a2, 0xaf},
	{0x88a3, 0x37},
	{0x88a4, 0xae},
	{0x88a5, 0x36},
	{0x88a6, 0xad},
	{0x88a7, 0x35},
	{0x88a8, 0xac},
	{0x88a9, 0x34},
	{0x88aa, 0xa3},
	{0x88ab, 0x12},
	{0x88ac, 0x0b},
	{0x88ad, 0x2b},
	{0x88ae, 0x8f},
	{0x88af, 0x37},
	{0x88b0, 0x8e},
	{0x88b1, 0x36},
	{0x88b2, 0x8d},
	{0x88b3, 0x35},
	{0x88b4, 0x8c},
	{0x88b5, 0x34},
	{0x88b6, 0xe5},
	{0x88b7, 0x3b},
	{0x88b8, 0x45},
	{0x88b9, 0x37},
	{0x88ba, 0xf5},
	{0x88bb, 0x3b},
	{0x88bc, 0xe5},
	{0x88bd, 0x3a},
	{0x88be, 0x45},
	{0x88bf, 0x36},
	{0x88c0, 0xf5},
	{0x88c1, 0x3a},
	{0x88c2, 0xe5},
	{0x88c3, 0x39},
	{0x88c4, 0x45},
	{0x88c5, 0x35},
	{0x88c6, 0xf5},
	{0x88c7, 0x39},
	{0x88c8, 0xe5},
	{0x88c9, 0x38},
	{0x88ca, 0x45},
	{0x88cb, 0x34},
	{0x88cc, 0xf5},
	{0x88cd, 0x38},
	{0x88ce, 0xe4},
	{0x88cf, 0xf5},
	{0x88d0, 0x22},
	{0x88d1, 0xf5},
	{0x88d2, 0x23},
	{0x88d3, 0x85},
	{0x88d4, 0x3b},
	{0x88d5, 0x31},
	{0x88d6, 0x85},
	{0x88d7, 0x3a},
	{0x88d8, 0x30},
	{0x88d9, 0x85},
	{0x88da, 0x39},
	{0x88db, 0x2f},
	{0x88dc, 0x85},
	{0x88dd, 0x38},
	{0x88de, 0x2e},
	{0x88df, 0x02},
	{0x88e0, 0x0a},
	{0x88e1, 0xba},
	{0x88e2, 0x78},
	{0x88e3, 0x4f},
	{0x88e4, 0x7e},
	{0x88e5, 0x00},
	{0x88e6, 0xe6},
	{0x88e7, 0xfc},
	{0x88e8, 0x08},
	{0x88e9, 0xe6},
	{0x88ea, 0xfd},
	{0x88eb, 0x12},
	{0x88ec, 0x02},
	{0x88ed, 0x8e},
	{0x88ee, 0x7c},
	{0x88ef, 0x00},
	{0x88f0, 0x22},
	{0x88f1, 0xe0},
	{0x88f2, 0xa3},
	{0x88f3, 0xe0},
	{0x88f4, 0x75},
	{0x88f5, 0xf0},
	{0x88f6, 0x02},
	{0x88f7, 0xa4},
	{0x88f8, 0xff},
	{0x88f9, 0xae},
	{0x88fa, 0xf0},
	{0x88fb, 0xc3},
	{0x88fc, 0x08},
	{0x88fd, 0xe6},
	{0x88fe, 0x9f},
	{0x88ff, 0xf6},
	{0x8900, 0x18},
	{0x8901, 0xe6},
	{0x8902, 0x9e},
	{0x8903, 0xf6},
	{0x8904, 0x22},
	{0x8905, 0xff},
	{0x8906, 0xe5},
	{0x8907, 0xf0},
	{0x8908, 0x34},
	{0x8909, 0x60},
	{0x890a, 0x8f},
	{0x890b, 0x82},
	{0x890c, 0xf5},
	{0x890d, 0x83},
	{0x890e, 0xec},
	{0x890f, 0xf0},
	{0x8910, 0x22},
	{0x8911, 0xe4},
	{0x8912, 0xfc},
	{0x8913, 0xfd},
	{0x8914, 0x12},
	{0x8915, 0x04},
	{0x8916, 0x53},
	{0x8917, 0x78},
	{0x8918, 0x59},
	{0x8919, 0xe6},
	{0x891a, 0xc3},
	{0x891b, 0x13},
	{0x891c, 0xfe},
	{0x891d, 0x08},
	{0x891e, 0xe6},
	{0x891f, 0x13},
	{0x8920, 0x22},
	{0x8921, 0x78},
	{0x8922, 0x4f},
	{0x8923, 0xe6},
	{0x8924, 0xfe},
	{0x8925, 0x08},
	{0x8926, 0xe6},
	{0x8927, 0xff},
	{0x8928, 0xe4},
	{0x8929, 0xfc},
	{0x892a, 0xfd},
	{0x892b, 0x22},
	{0x892c, 0xe7},
	{0x892d, 0xc4},
	{0x892e, 0xf8},
	{0x892f, 0x54},
	{0x8930, 0xf0},
	{0x8931, 0xc8},
	{0x8932, 0x68},
	{0x8933, 0xf7},
	{0x8934, 0x09},
	{0x8935, 0xe7},
	{0x8936, 0xc4},
	{0x8937, 0x54},
	{0x8938, 0x0f},
	{0x8939, 0x48},
	{0x893a, 0xf7},
	{0x893b, 0x22},
	{0x893c, 0xe6},
	{0x893d, 0xfc},
	{0x893e, 0xed},
	{0x893f, 0x75},
	{0x8940, 0xf0},
	{0x8941, 0x04},
	{0x8942, 0xa4},
	{0x8943, 0x22},
	{0x8944, 0xe0},
	{0x8945, 0xfe},
	{0x8946, 0xa3},
	{0x8947, 0xe0},
	{0x8948, 0xfd},
	{0x8949, 0xee},
	{0x894a, 0xf6},
	{0x894b, 0xed},
	{0x894c, 0x08},
	{0x894d, 0xf6},
	{0x894e, 0x22},
	{0x894f, 0x13},
	{0x8950, 0xff},
	{0x8951, 0xc3},
	{0x8952, 0xe6},
	{0x8953, 0x9f},
	{0x8954, 0xff},
	{0x8955, 0x18},
	{0x8956, 0xe6},
	{0x8957, 0x9e},
	{0x8958, 0xfe},
	{0x8959, 0x22},
	{0x895a, 0xe6},
	{0x895b, 0xc3},
	{0x895c, 0x13},
	{0x895d, 0xf7},
	{0x895e, 0x08},
	{0x895f, 0xe6},
	{0x8960, 0x13},
	{0x8961, 0x09},
	{0x8962, 0xf7},
	{0x8963, 0x22},
	{0x8964, 0xe4},
	{0x8965, 0xf5},
	{0x8966, 0x49},
	{0x8967, 0x90},
	{0x8968, 0x0e},
	{0x8969, 0x77},
	{0x896a, 0x93},
	{0x896b, 0xff},
	{0x896c, 0xe4},
	{0x896d, 0x8f},
	{0x896e, 0x37},
	{0x896f, 0xf5},
	{0x8970, 0x36},
	{0x8971, 0xf5},
	{0x8972, 0x35},
	{0x8973, 0xf5},
	{0x8974, 0x34},
	{0x8975, 0xaf},
	{0x8976, 0x37},
	{0x8977, 0xae},
	{0x8978, 0x36},
	{0x8979, 0xad},
	{0x897a, 0x35},
	{0x897b, 0xac},
	{0x897c, 0x34},
	{0x897d, 0x90},
	{0x897e, 0x0e},
	{0x897f, 0x6a},
	{0x8980, 0x12},
	{0x8981, 0x0b},
	{0x8982, 0x2b},
	{0x8983, 0x8f},
	{0x8984, 0x37},
	{0x8985, 0x8e},
	{0x8986, 0x36},
	{0x8987, 0x8d},
	{0x8988, 0x35},
	{0x8989, 0x8c},
	{0x898a, 0x34},
	{0x898b, 0x90},
	{0x898c, 0x0e},
	{0x898d, 0x72},
	{0x898e, 0x12},
	{0x898f, 0x04},
	{0x8990, 0x36},
	{0x8991, 0xef},
	{0x8992, 0x45},
	{0x8993, 0x37},
	{0x8994, 0xf5},
	{0x8995, 0x37},
	{0x8996, 0xee},
	{0x8997, 0x45},
	{0x8998, 0x36},
	{0x8999, 0xf5},
	{0x899a, 0x36},
	{0x899b, 0xed},
	{0x899c, 0x45},
	{0x899d, 0x35},
	{0x899e, 0xf5},
	{0x899f, 0x35},
	{0x89a0, 0xec},
	{0x89a1, 0x45},
	{0x89a2, 0x34},
	{0x89a3, 0xf5},
	{0x89a4, 0x34},
	{0x89a5, 0xe4},
	{0x89a6, 0xf5},
	{0x89a7, 0x22},
	{0x89a8, 0xf5},
	{0x89a9, 0x23},
	{0x89aa, 0x85},
	{0x89ab, 0x37},
	{0x89ac, 0x31},
	{0x89ad, 0x85},
	{0x89ae, 0x36},
	{0x89af, 0x30},
	{0x89b0, 0x85},
	{0x89b1, 0x35},
	{0x89b2, 0x2f},
	{0x89b3, 0x85},
	{0x89b4, 0x34},
	{0x89b5, 0x2e},
	{0x89b6, 0x12},
	{0x89b7, 0x0a},
	{0x89b8, 0xba},
	{0x89b9, 0xe4},
	{0x89ba, 0xf5},
	{0x89bb, 0x22},
	{0x89bc, 0xf5},
	{0x89bd, 0x23},
	{0x89be, 0x90},
	{0x89bf, 0x0e},
	{0x89c0, 0x72},
	{0x89c1, 0x12},
	{0x89c2, 0x0b},
	{0x89c3, 0x1f},
	{0x89c4, 0x12},
	{0x89c5, 0x0a},
	{0x89c6, 0xba},
	{0x89c7, 0xe4},
	{0x89c8, 0xf5},
	{0x89c9, 0x22},
	{0x89ca, 0xf5},
	{0x89cb, 0x23},
	{0x89cc, 0x90},
	{0x89cd, 0x0e},
	{0x89ce, 0x6e},
	{0x89cf, 0x12},
	{0x89d0, 0x0b},
	{0x89d1, 0x1f},
	{0x89d2, 0x02},
	{0x89d3, 0x0a},
	{0x89d4, 0xba},
	{0x89d5, 0x75},
	{0x89d6, 0x89},
	{0x89d7, 0x03},
	{0x89d8, 0x75},
	{0x89d9, 0xa8},
	{0x89da, 0x01},
	{0x89db, 0x75},
	{0x89dc, 0xb8},
	{0x89dd, 0x04},
	{0x89de, 0x75},
	{0x89df, 0x34},
	{0x89e0, 0xff},
	{0x89e1, 0x75},
	{0x89e2, 0x35},
	{0x89e3, 0x0e},
	{0x89e4, 0x75},
	{0x89e5, 0x36},
	{0x89e6, 0x15},
	{0x89e7, 0x75},
	{0x89e8, 0x37},
	{0x89e9, 0x0d},
	{0x89ea, 0x12},
	{0x89eb, 0x0a},
	{0x89ec, 0x3e},
	{0x89ed, 0x12},
	{0x89ee, 0x00},
	{0x89ef, 0x09},
	{0x89f0, 0x12},
	{0x89f1, 0x0b},
	{0x89f2, 0x31},
	{0x89f3, 0x12},
	{0x89f4, 0x00},
	{0x89f5, 0x06},
	{0x89f6, 0xd2},
	{0x89f7, 0x00},
	{0x89f8, 0xd2},
	{0x89f9, 0x33},
	{0x89fa, 0xd2},
	{0x89fb, 0xaf},
	{0x89fc, 0x75},
	{0x89fd, 0x34},
	{0x89fe, 0xff},
	{0x89ff, 0x75},
	{0x8a00, 0x35},
	{0x8a01, 0x0e},
	{0x8a02, 0x75},
	{0x8a03, 0x36},
	{0x8a04, 0x49},
	{0x8a05, 0x75},
	{0x8a06, 0x37},
	{0x8a07, 0x03},
	{0x8a08, 0x12},
	{0x8a09, 0x0a},
	{0x8a0a, 0x3e},
	{0x8a0b, 0x30},
	{0x8a0c, 0x08},
	{0x8a0d, 0x09},
	{0x8a0e, 0xc2},
	{0x8a0f, 0x33},
	{0x8a10, 0x12},
	{0x8a11, 0x06},
	{0x8a12, 0x61},
	{0x8a13, 0xc2},
	{0x8a14, 0x08},
	{0x8a15, 0xd2},
	{0x8a16, 0x33},
	{0x8a17, 0x30},
	{0x8a18, 0x09},
	{0x8a19, 0x09},
	{0x8a1a, 0xc2},
	{0x8a1b, 0x35},
	{0x8a1c, 0x12},
	{0x8a1d, 0x00},
	{0x8a1e, 0x0e},
	{0x8a1f, 0xc2},
	{0x8a20, 0x09},
	{0x8a21, 0xd2},
	{0x8a22, 0x35},
	{0x8a23, 0x30},
	{0x8a24, 0x0e},
	{0x8a25, 0x03},
	{0x8a26, 0x12},
	{0x8a27, 0x04},
	{0x8a28, 0x91},
	{0x8a29, 0x30},
	{0x8a2a, 0x34},
	{0x8a2b, 0xdf},
	{0x8a2c, 0x90},
	{0x8a2d, 0x30},
	{0x8a2e, 0x29},
	{0x8a2f, 0xe5},
	{0x8a30, 0x1e},
	{0x8a31, 0xf0},
	{0x8a32, 0xb4},
	{0x8a33, 0x10},
	{0x8a34, 0x05},
	{0x8a35, 0x90},
	{0x8a36, 0x30},
	{0x8a37, 0x23},
	{0x8a38, 0xe4},
	{0x8a39, 0xf0},
	{0x8a3a, 0xc2},
	{0x8a3b, 0x34},
	{0x8a3c, 0x80},
	{0x8a3d, 0xcd},
	{0x8a3e, 0xae},
	{0x8a3f, 0x35},
	{0x8a40, 0xaf},
	{0x8a41, 0x36},
	{0x8a42, 0xe4},
	{0x8a43, 0xfd},
	{0x8a44, 0xed},
	{0x8a45, 0xc3},
	{0x8a46, 0x95},
	{0x8a47, 0x37},
	{0x8a48, 0x50},
	{0x8a49, 0x33},
	{0x8a4a, 0x12},
	{0x8a4b, 0x0b},
	{0x8a4c, 0x78},
	{0x8a4d, 0xe4},
	{0x8a4e, 0x93},
	{0x8a4f, 0xf5},
	{0x8a50, 0x38},
	{0x8a51, 0x74},
	{0x8a52, 0x01},
	{0x8a53, 0x93},
	{0x8a54, 0xf5},
	{0x8a55, 0x39},
	{0x8a56, 0x45},
	{0x8a57, 0x38},
	{0x8a58, 0x60},
	{0x8a59, 0x23},
	{0x8a5a, 0x85},
	{0x8a5b, 0x39},
	{0x8a5c, 0x82},
	{0x8a5d, 0x85},
	{0x8a5e, 0x38},
	{0x8a5f, 0x83},
	{0x8a60, 0xe0},
	{0x8a61, 0xfc},
	{0x8a62, 0x12},
	{0x8a63, 0x0b},
	{0x8a64, 0x78},
	{0x8a65, 0x74},
	{0x8a66, 0x03},
	{0x8a67, 0x93},
	{0x8a68, 0x52},
	{0x8a69, 0x04},
	{0x8a6a, 0x12},
	{0x8a6b, 0x0b},
	{0x8a6c, 0x78},
	{0x8a6d, 0x74},
	{0x8a6e, 0x02},
	{0x8a6f, 0x93},
	{0x8a70, 0x42},
	{0x8a71, 0x04},
	{0x8a72, 0x85},
	{0x8a73, 0x39},
	{0x8a74, 0x82},
	{0x8a75, 0x85},
	{0x8a76, 0x38},
	{0x8a77, 0x83},
	{0x8a78, 0xec},
	{0x8a79, 0xf0},
	{0x8a7a, 0x0d},
	{0x8a7b, 0x80},
	{0x8a7c, 0xc7},
	{0x8a7d, 0x22},
	{0x8a7e, 0x78},
	{0x8a7f, 0xbb},
	{0x8a80, 0xe6},
	{0x8a81, 0xd3},
	{0x8a82, 0x08},
	{0x8a83, 0xff},
	{0x8a84, 0xe6},
	{0x8a85, 0x64},
	{0x8a86, 0x80},
	{0x8a87, 0xf8},
	{0x8a88, 0xef},
	{0x8a89, 0x64},
	{0x8a8a, 0x80},
	{0x8a8b, 0x98},
	{0x8a8c, 0x22},
	{0x8a8d, 0x93},
	{0x8a8e, 0xff},
	{0x8a8f, 0x7e},
	{0x8a90, 0x00},
	{0x8a91, 0xe6},
	{0x8a92, 0xfc},
	{0x8a93, 0x08},
	{0x8a94, 0xe6},
	{0x8a95, 0xfd},
	{0x8a96, 0x12},
	{0x8a97, 0x02},
	{0x8a98, 0x8e},
	{0x8a99, 0x78},
	{0x8a9a, 0xbe},
	{0x8a9b, 0xe6},
	{0x8a9c, 0xfc},
	{0x8a9d, 0x08},
	{0x8a9e, 0xe6},
	{0x8a9f, 0xfd},
	{0x8aa0, 0xd3},
	{0x8aa1, 0xef},
	{0x8aa2, 0x9d},
	{0x8aa3, 0xee},
	{0x8aa4, 0x9c},
	{0x8aa5, 0x22},
	{0x8aa6, 0x78},
	{0x8aa7, 0xba},
	{0x8aa8, 0xd3},
	{0x8aa9, 0xe6},
	{0x8aaa, 0x64},
	{0x8aab, 0x80},
	{0x8aac, 0x94},
	{0x8aad, 0x80},
	{0x8aae, 0x22},
	{0x8aaf, 0x25},
	{0x8ab0, 0xe0},
	{0x8ab1, 0x24},
	{0x8ab2, 0x0a},
	{0x8ab3, 0xf8},
	{0x8ab4, 0xe6},
	{0x8ab5, 0xfe},
	{0x8ab6, 0x08},
	{0x8ab7, 0xe6},
	{0x8ab8, 0xff},
	{0x8ab9, 0x22},
	{0x8aba, 0xa2},
	{0x8abb, 0xaf},
	{0x8abc, 0x92},
	{0x8abd, 0x31},
	{0x8abe, 0xc2},
	{0x8abf, 0xaf},
	{0x8ac0, 0xe5},
	{0x8ac1, 0x23},
	{0x8ac2, 0x45},
	{0x8ac3, 0x22},
	{0x8ac4, 0x90},
	{0x8ac5, 0x0e},
	{0x8ac6, 0x5d},
	{0x8ac7, 0x60},
	{0x8ac8, 0x0b},
	{0x8ac9, 0x12},
	{0x8aca, 0x0b},
	{0x8acb, 0x6d},
	{0x8acc, 0xe0},
	{0x8acd, 0xf5},
	{0x8ace, 0x2c},
	{0x8acf, 0xe0},
	{0x8ad0, 0xf5},
	{0x8ad1, 0x2d},
	{0x8ad2, 0x80},
	{0x8ad3, 0x0f},
	{0x8ad4, 0x12},
	{0x8ad5, 0x0b},
	{0x8ad6, 0x6d},
	{0x8ad7, 0xe5},
	{0x8ad8, 0x30},
	{0x8ad9, 0xf0},
	{0x8ada, 0x90},
	{0x8adb, 0x0e},
	{0x8adc, 0x5f},
	{0x8add, 0x12},
	{0x8ade, 0x0b},
	{0x8adf, 0x6d},
	{0x8ae0, 0xe5},
	{0x8ae1, 0x31},
	{0x8ae2, 0xf0},
	{0x8ae3, 0xa2},
	{0x8ae4, 0x31},
	{0x8ae5, 0x92},
	{0x8ae6, 0xaf},
	{0x8ae7, 0x22},
	{0x8ae8, 0xd2},
	{0x8ae9, 0x01},
	{0x8aea, 0xc2},
	{0x8aeb, 0x02},
	{0x8aec, 0xe4},
	{0x8aed, 0xf5},
	{0x8aee, 0x1f},
	{0x8aef, 0xf5},
	{0x8af0, 0x1e},
	{0x8af1, 0xd2},
	{0x8af2, 0x34},
	{0x8af3, 0xd2},
	{0x8af4, 0x32},
	{0x8af5, 0xd2},
	{0x8af6, 0x35},
	{0x8af7, 0xd2},
	{0x8af8, 0x01},
	{0x8af9, 0xc2},
	{0x8afa, 0x02},
	{0x8afb, 0xf5},
	{0x8afc, 0x1f},
	{0x8afd, 0xf5},
	{0x8afe, 0x1e},
	{0x8aff, 0xd2},
	{0x8b00, 0x34},
	{0x8b01, 0xd2},
	{0x8b02, 0x32},
	{0x8b03, 0x22},
	{0x8b04, 0x2d},
	{0x8b05, 0xfd},
	{0x8b06, 0xe4},
	{0x8b07, 0x33},
	{0x8b08, 0xfc},
	{0x8b09, 0xe4},
	{0x8b0a, 0x93},
	{0x8b0b, 0xfe},
	{0x8b0c, 0xfb},
	{0x8b0d, 0xd3},
	{0x8b0e, 0xed},
	{0x8b0f, 0x9b},
	{0x8b10, 0x74},
	{0x8b11, 0x80},
	{0x8b12, 0xf8},
	{0x8b13, 0x6c},
	{0x8b14, 0x98},
	{0x8b15, 0x22},
	{0x8b16, 0x8f},
	{0x8b17, 0x3b},
	{0x8b18, 0x8e},
	{0x8b19, 0x3a},
	{0x8b1a, 0x8d},
	{0x8b1b, 0x39},
	{0x8b1c, 0x8c},
	{0x8b1d, 0x38},
	{0x8b1e, 0x22},
	{0x8b1f, 0x12},
	{0x8b20, 0x04},
	{0x8b21, 0x36},
	{0x8b22, 0x8f},
	{0x8b23, 0x31},
	{0x8b24, 0x8e},
	{0x8b25, 0x30},
	{0x8b26, 0x8d},
	{0x8b27, 0x2f},
	{0x8b28, 0x8c},
	{0x8b29, 0x2e},
	{0x8b2a, 0x22},
	{0x8b2b, 0x93},
	{0x8b2c, 0xf9},
	{0x8b2d, 0xf8},
	{0x8b2e, 0x02},
	{0x8b2f, 0x04},
	{0x8b30, 0x23},
	{0x8b31, 0x90},
	{0x8b32, 0x0e},
	{0x8b33, 0x81},
	{0x8b34, 0x12},
	{0x8b35, 0x04},
	{0x8b36, 0x36},
	{0x8b37, 0x8f},
	{0x8b38, 0x46},
	{0x8b39, 0x8e},
	{0x8b3a, 0x45},
	{0x8b3b, 0x8d},
	{0x8b3c, 0x44},
	{0x8b3d, 0x8c},
	{0x8b3e, 0x43},
	{0x8b3f, 0xd2},
	{0x8b40, 0x06},
	{0x8b41, 0x30},
	{0x8b42, 0x06},
	{0x8b43, 0x03},
	{0x8b44, 0xd3},
	{0x8b45, 0x80},
	{0x8b46, 0x01},
	{0x8b47, 0xc3},
	{0x8b48, 0x92},
	{0x8b49, 0x0e},
	{0x8b4a, 0x22},
	{0x8b4b, 0xc0},
	{0x8b4c, 0xe0},
	{0x8b4d, 0xc0},
	{0x8b4e, 0x83},
	{0x8b4f, 0xc0},
	{0x8b50, 0x82},
	{0x8b51, 0x90},
	{0x8b52, 0x3f},
	{0x8b53, 0x0d},
	{0x8b54, 0xe0},
	{0x8b55, 0xf5},
	{0x8b56, 0x33},
	{0x8b57, 0xe5},
	{0x8b58, 0x33},
	{0x8b59, 0xf0},
	{0x8b5a, 0xd0},
	{0x8b5b, 0x82},
	{0x8b5c, 0xd0},
	{0x8b5d, 0x83},
	{0x8b5e, 0xd0},
	{0x8b5f, 0xe0},
	{0x8b60, 0x32},
	{0x8b61, 0x78},
	{0x8b62, 0x7f},
	{0x8b63, 0xe4},
	{0x8b64, 0xf6},
	{0x8b65, 0xd8},
	{0x8b66, 0xfd},
	{0x8b67, 0x75},
	{0x8b68, 0x81},
	{0x8b69, 0xca},
	{0x8b6a, 0x02},
	{0x8b6b, 0x09},
	{0x8b6c, 0xd5},
	{0x8b6d, 0xe4},
	{0x8b6e, 0x93},
	{0x8b6f, 0xfe},
	{0x8b70, 0x74},
	{0x8b71, 0x01},
	{0x8b72, 0x93},
	{0x8b73, 0xf5},
	{0x8b74, 0x82},
	{0x8b75, 0x8e},
	{0x8b76, 0x83},
	{0x8b77, 0x22},
	{0x8b78, 0x8f},
	{0x8b79, 0x82},
	{0x8b7a, 0x8e},
	{0x8b7b, 0x83},
	{0x8b7c, 0x75},
	{0x8b7d, 0xf0},
	{0x8b7e, 0x04},
	{0x8b7f, 0xed},
	{0x8b80, 0x02},
	{0x8b81, 0x04},
	{0x8b82, 0x5f},
	{0x8b83, 0x00},
	{0x8b84, 0x00},
	{0x8b85, 0x00},
	{0x8b86, 0x00},
	{0x8b87, 0x00},
	{0x8b88, 0x00},
	{0x8b89, 0x00},
	{0x8b8a, 0x00},
	{0x8b8b, 0x00},
	{0x8b8c, 0x00},
	{0x8b8d, 0x00},
	{0x8b8e, 0x00},
	{0x8b8f, 0x00},
	{0x8b90, 0x00},
	{0x8b91, 0x00},
	{0x8b92, 0x00},
	{0x8b93, 0x00},
	{0x8b94, 0x00},
	{0x8b95, 0x00},
	{0x8b96, 0x00},
	{0x8b97, 0x00},
	{0x8b98, 0x00},
	{0x8b99, 0x00},
	{0x8b9a, 0x00},
	{0x8b9b, 0x00},
	{0x8b9c, 0x00},
	{0x8b9d, 0x00},
	{0x8b9e, 0x00},
	{0x8b9f, 0x00},
	{0x8ba0, 0x00},
	{0x8ba1, 0x00},
	{0x8ba2, 0x00},
	{0x8ba3, 0x00},
	{0x8ba4, 0x00},
	{0x8ba5, 0x00},
	{0x8ba6, 0x00},
	{0x8ba7, 0x00},
	{0x8ba8, 0x00},
	{0x8ba9, 0x00},
	{0x8baa, 0x00},
	{0x8bab, 0x00},
	{0x8bac, 0x00},
	{0x8bad, 0x00},
	{0x8bae, 0x00},
	{0x8baf, 0x00},
	{0x8bb0, 0x00},
	{0x8bb1, 0x00},
	{0x8bb2, 0x00},
	{0x8bb3, 0x00},
	{0x8bb4, 0x00},
	{0x8bb5, 0x00},
	{0x8bb6, 0x00},
	{0x8bb7, 0x00},
	{0x8bb8, 0x00},
	{0x8bb9, 0x00},
	{0x8bba, 0x00},
	{0x8bbb, 0x00},
	{0x8bbc, 0x00},
	{0x8bbd, 0x00},
	{0x8bbe, 0x00},
	{0x8bbf, 0x00},
	{0x8bc0, 0x00},
	{0x8bc1, 0x00},
	{0x8bc2, 0x00},
	{0x8bc3, 0x00},
	{0x8bc4, 0x00},
	{0x8bc5, 0x00},
	{0x8bc6, 0x00},
	{0x8bc7, 0x00},
	{0x8bc8, 0x00},
	{0x8bc9, 0x00},
	{0x8bca, 0x00},
	{0x8bcb, 0x00},
	{0x8bcc, 0x00},
	{0x8bcd, 0x00},
	{0x8bce, 0x00},
	{0x8bcf, 0x00},
	{0x8bd0, 0x00},
	{0x8bd1, 0x00},
	{0x8bd2, 0x00},
	{0x8bd3, 0x00},
	{0x8bd4, 0x00},
	{0x8bd5, 0x00},
	{0x8bd6, 0x00},
	{0x8bd7, 0x00},
	{0x8bd8, 0x00},
	{0x8bd9, 0x00},
	{0x8bda, 0x00},
	{0x8bdb, 0x00},
	{0x8bdc, 0x00},
	{0x8bdd, 0x00},
	{0x8bde, 0x00},
	{0x8bdf, 0x00},
	{0x8be0, 0x00},
	{0x8be1, 0x00},
	{0x8be2, 0x00},
	{0x8be3, 0x00},
	{0x8be4, 0x00},
	{0x8be5, 0x00},
	{0x8be6, 0x00},
	{0x8be7, 0x00},
	{0x8be8, 0x00},
	{0x8be9, 0x00},
	{0x8bea, 0x00},
	{0x8beb, 0x00},
	{0x8bec, 0x00},
	{0x8bed, 0x00},
	{0x8bee, 0x00},
	{0x8bef, 0x00},
	{0x8bf0, 0x00},
	{0x8bf1, 0x00},
	{0x8bf2, 0x00},
	{0x8bf3, 0x00},
	{0x8bf4, 0x00},
	{0x8bf5, 0x00},
	{0x8bf6, 0x00},
	{0x8bf7, 0x00},
	{0x8bf8, 0x00},
	{0x8bf9, 0x00},
	{0x8bfa, 0x00},
	{0x8bfb, 0x00},
	{0x8bfc, 0x00},
	{0x8bfd, 0x00},
	{0x8bfe, 0x00},
	{0x8bff, 0x00},
	{0x8c00, 0x00},
	{0x8c01, 0x00},
	{0x8c02, 0x00},
	{0x8c03, 0x00},
	{0x8c04, 0x00},
	{0x8c05, 0x00},
	{0x8c06, 0x00},
	{0x8c07, 0x00},
	{0x8c08, 0x00},
	{0x8c09, 0x00},
	{0x8c0a, 0x00},
	{0x8c0b, 0x00},
	{0x8c0c, 0x00},
	{0x8c0d, 0x00},
	{0x8c0e, 0x00},
	{0x8c0f, 0x00},
	{0x8c10, 0x00},
	{0x8c11, 0x00},
	{0x8c12, 0x00},
	{0x8c13, 0x00},
	{0x8c14, 0x00},
	{0x8c15, 0x00},
	{0x8c16, 0x00},
	{0x8c17, 0x00},
	{0x8c18, 0x00},
	{0x8c19, 0x00},
	{0x8c1a, 0x00},
	{0x8c1b, 0x00},
	{0x8c1c, 0x00},
	{0x8c1d, 0x00},
	{0x8c1e, 0x00},
	{0x8c1f, 0x00},
	{0x8c20, 0x00},
	{0x8c21, 0x00},
	{0x8c22, 0x00},
	{0x8c23, 0x00},
	{0x8c24, 0x00},
	{0x8c25, 0x00},
	{0x8c26, 0x00},
	{0x8c27, 0x00},
	{0x8c28, 0x00},
	{0x8c29, 0x00},
	{0x8c2a, 0x00},
	{0x8c2b, 0x00},
	{0x8c2c, 0x00},
	{0x8c2d, 0x00},
	{0x8c2e, 0x00},
	{0x8c2f, 0x00},
	{0x8c30, 0x00},
	{0x8c31, 0x00},
	{0x8c32, 0x00},
	{0x8c33, 0x00},
	{0x8c34, 0x00},
	{0x8c35, 0x00},
	{0x8c36, 0x00},
	{0x8c37, 0x00},
	{0x8c38, 0x00},
	{0x8c39, 0x00},
	{0x8c3a, 0x00},
	{0x8c3b, 0x00},
	{0x8c3c, 0x00},
	{0x8c3d, 0x00},
	{0x8c3e, 0x00},
	{0x8c3f, 0x00},
	{0x8c40, 0x00},
	{0x8c41, 0x00},
	{0x8c42, 0x00},
	{0x8c43, 0x00},
	{0x8c44, 0x00},
	{0x8c45, 0x00},
	{0x8c46, 0x00},
	{0x8c47, 0x00},
	{0x8c48, 0x00},
	{0x8c49, 0x00},
	{0x8c4a, 0x00},
	{0x8c4b, 0x00},
	{0x8c4c, 0x00},
	{0x8c4d, 0x00},
	{0x8c4e, 0x00},
	{0x8c4f, 0x00},
	{0x8c50, 0x00},
	{0x8c51, 0x00},
	{0x8c52, 0x00},
	{0x8c53, 0x00},
	{0x8c54, 0x00},
	{0x8c55, 0x00},
	{0x8c56, 0x00},
	{0x8c57, 0x00},
	{0x8c58, 0x00},
	{0x8c59, 0x00},
	{0x8c5a, 0x00},
	{0x8c5b, 0x00},
	{0x8c5c, 0x00},
	{0x8c5d, 0x00},
	{0x8c5e, 0x00},
	{0x8c5f, 0x00},
	{0x8c60, 0x00},
	{0x8c61, 0x00},
	{0x8c62, 0x00},
	{0x8c63, 0x00},
	{0x8c64, 0x00},
	{0x8c65, 0x00},
	{0x8c66, 0x00},
	{0x8c67, 0x00},
	{0x8c68, 0x00},
	{0x8c69, 0x00},
	{0x8c6a, 0x00},
	{0x8c6b, 0x00},
	{0x8c6c, 0x00},
	{0x8c6d, 0x00},
	{0x8c6e, 0x00},
	{0x8c6f, 0x00},
	{0x8c70, 0x00},
	{0x8c71, 0x00},
	{0x8c72, 0x00},
	{0x8c73, 0x00},
	{0x8c74, 0x00},
	{0x8c75, 0x00},
	{0x8c76, 0x00},
	{0x8c77, 0x00},
	{0x8c78, 0x00},
	{0x8c79, 0x00},
	{0x8c7a, 0x00},
	{0x8c7b, 0x00},
	{0x8c7c, 0x00},
	{0x8c7d, 0x00},
	{0x8c7e, 0x00},
	{0x8c7f, 0x00},
	{0x8c80, 0x00},
	{0x8c81, 0x00},
	{0x8c82, 0x00},
	{0x8c83, 0x00},
	{0x8c84, 0x00},
	{0x8c85, 0x00},
	{0x8c86, 0x00},
	{0x8c87, 0x00},
	{0x8c88, 0x00},
	{0x8c89, 0x00},
	{0x8c8a, 0x00},
	{0x8c8b, 0x00},
	{0x8c8c, 0x00},
	{0x8c8d, 0x00},
	{0x8c8e, 0x00},
	{0x8c8f, 0x00},
	{0x8c90, 0x00},
	{0x8c91, 0x00},
	{0x8c92, 0x00},
	{0x8c93, 0x00},
	{0x8c94, 0x00},
	{0x8c95, 0x00},
	{0x8c96, 0x00},
	{0x8c97, 0x00},
	{0x8c98, 0x00},
	{0x8c99, 0x00},
	{0x8c9a, 0x00},
	{0x8c9b, 0x00},
	{0x8c9c, 0x00},
	{0x8c9d, 0x00},
	{0x8c9e, 0x00},
	{0x8c9f, 0x00},
	{0x8ca0, 0x00},
	{0x8ca1, 0x00},
	{0x8ca2, 0x00},
	{0x8ca3, 0x00},
	{0x8ca4, 0x00},
	{0x8ca5, 0x00},
	{0x8ca6, 0x00},
	{0x8ca7, 0x00},
	{0x8ca8, 0x00},
	{0x8ca9, 0x00},
	{0x8caa, 0x00},
	{0x8cab, 0x00},
	{0x8cac, 0x00},
	{0x8cad, 0x00},
	{0x8cae, 0x00},
	{0x8caf, 0x00},
	{0x8cb0, 0x00},
	{0x8cb1, 0x00},
	{0x8cb2, 0x00},
	{0x8cb3, 0x00},
	{0x8cb4, 0x00},
	{0x8cb5, 0x00},
	{0x8cb6, 0x00},
	{0x8cb7, 0x00},
	{0x8cb8, 0x00},
	{0x8cb9, 0x00},
	{0x8cba, 0x00},
	{0x8cbb, 0x00},
	{0x8cbc, 0x00},
	{0x8cbd, 0x00},
	{0x8cbe, 0x00},
	{0x8cbf, 0x00},
	{0x8cc0, 0x00},
	{0x8cc1, 0x00},
	{0x8cc2, 0x00},
	{0x8cc3, 0x00},
	{0x8cc4, 0x00},
	{0x8cc5, 0x00},
	{0x8cc6, 0x00},
	{0x8cc7, 0x00},
	{0x8cc8, 0x00},
	{0x8cc9, 0x00},
	{0x8cca, 0x00},
	{0x8ccb, 0x00},
	{0x8ccc, 0x00},
	{0x8ccd, 0x00},
	{0x8cce, 0x00},
	{0x8ccf, 0x00},
	{0x8cd0, 0x00},
	{0x8cd1, 0x00},
	{0x8cd2, 0x00},
	{0x8cd3, 0x00},
	{0x8cd4, 0x00},
	{0x8cd5, 0x00},
	{0x8cd6, 0x00},
	{0x8cd7, 0x00},
	{0x8cd8, 0x00},
	{0x8cd9, 0x00},
	{0x8cda, 0x00},
	{0x8cdb, 0x00},
	{0x8cdc, 0x00},
	{0x8cdd, 0x00},
	{0x8cde, 0x00},
	{0x8cdf, 0x00},
	{0x8ce0, 0x00},
	{0x8ce1, 0x00},
	{0x8ce2, 0x00},
	{0x8ce3, 0x00},
	{0x8ce4, 0x00},
	{0x8ce5, 0x00},
	{0x8ce6, 0x00},
	{0x8ce7, 0x00},
	{0x8ce8, 0x00},
	{0x8ce9, 0x00},
	{0x8cea, 0x00},
	{0x8ceb, 0x00},
	{0x8cec, 0x00},
	{0x8ced, 0x00},
	{0x8cee, 0x00},
	{0x8cef, 0x00},
	{0x8cf0, 0x00},
	{0x8cf1, 0x00},
	{0x8cf2, 0x00},
	{0x8cf3, 0x00},
	{0x8cf4, 0x00},
	{0x8cf5, 0x00},
	{0x8cf6, 0x00},
	{0x8cf7, 0x00},
	{0x8cf8, 0x00},
	{0x8cf9, 0x00},
	{0x8cfa, 0x00},
	{0x8cfb, 0x00},
	{0x8cfc, 0x00},
	{0x8cfd, 0x00},
	{0x8cfe, 0x00},
	{0x8cff, 0x00},
	{0x8d00, 0x00},
	{0x8d01, 0x00},
	{0x8d02, 0x00},
	{0x8d03, 0x00},
	{0x8d04, 0x00},
	{0x8d05, 0x00},
	{0x8d06, 0x00},
	{0x8d07, 0x00},
	{0x8d08, 0x00},
	{0x8d09, 0x00},
	{0x8d0a, 0x00},
	{0x8d0b, 0x00},
	{0x8d0c, 0x00},
	{0x8d0d, 0x00},
	{0x8d0e, 0x00},
	{0x8d0f, 0x00},
	{0x8d10, 0x00},
	{0x8d11, 0x00},
	{0x8d12, 0x00},
	{0x8d13, 0x00},
	{0x8d14, 0x00},
	{0x8d15, 0x00},
	{0x8d16, 0x00},
	{0x8d17, 0x00},
	{0x8d18, 0x00},
	{0x8d19, 0x00},
	{0x8d1a, 0x00},
	{0x8d1b, 0x00},
	{0x8d1c, 0x00},
	{0x8d1d, 0x00},
	{0x8d1e, 0x00},
	{0x8d1f, 0x00},
	{0x8d20, 0x00},
	{0x8d21, 0x00},
	{0x8d22, 0x00},
	{0x8d23, 0x00},
	{0x8d24, 0x00},
	{0x8d25, 0x00},
	{0x8d26, 0x00},
	{0x8d27, 0x00},
	{0x8d28, 0x00},
	{0x8d29, 0x00},
	{0x8d2a, 0x00},
	{0x8d2b, 0x00},
	{0x8d2c, 0x00},
	{0x8d2d, 0x00},
	{0x8d2e, 0x00},
	{0x8d2f, 0x00},
	{0x8d30, 0x00},
	{0x8d31, 0x00},
	{0x8d32, 0x00},
	{0x8d33, 0x00},
	{0x8d34, 0x00},
	{0x8d35, 0x00},
	{0x8d36, 0x00},
	{0x8d37, 0x00},
	{0x8d38, 0x00},
	{0x8d39, 0x00},
	{0x8d3a, 0x00},
	{0x8d3b, 0x00},
	{0x8d3c, 0x00},
	{0x8d3d, 0x00},
	{0x8d3e, 0x00},
	{0x8d3f, 0x00},
	{0x8d40, 0x00},
	{0x8d41, 0x00},
	{0x8d42, 0x00},
	{0x8d43, 0x00},
	{0x8d44, 0x00},
	{0x8d45, 0x00},
	{0x8d46, 0x00},
	{0x8d47, 0x00},
	{0x8d48, 0x00},
	{0x8d49, 0x00},
	{0x8d4a, 0x00},
	{0x8d4b, 0x00},
	{0x8d4c, 0x00},
	{0x8d4d, 0x00},
	{0x8d4e, 0x00},
	{0x8d4f, 0x00},
	{0x8d50, 0x00},
	{0x8d51, 0x00},
	{0x8d52, 0x00},
	{0x8d53, 0x00},
	{0x8d54, 0x00},
	{0x8d55, 0x00},
	{0x8d56, 0x00},
	{0x8d57, 0x00},
	{0x8d58, 0x00},
	{0x8d59, 0x00},
	{0x8d5a, 0x00},
	{0x8d5b, 0x00},
	{0x8d5c, 0x00},
	{0x8d5d, 0x00},
	{0x8d5e, 0x00},
	{0x8d5f, 0x00},
	{0x8d60, 0x00},
	{0x8d61, 0x00},
	{0x8d62, 0x00},
	{0x8d63, 0x00},
	{0x8d64, 0x00},
	{0x8d65, 0x00},
	{0x8d66, 0x00},
	{0x8d67, 0x00},
	{0x8d68, 0x00},
	{0x8d69, 0x00},
	{0x8d6a, 0x00},
	{0x8d6b, 0x00},
	{0x8d6c, 0x00},
	{0x8d6d, 0x00},
	{0x8d6e, 0x00},
	{0x8d6f, 0x00},
	{0x8d70, 0x00},
	{0x8d71, 0x00},
	{0x8d72, 0x00},
	{0x8d73, 0x00},
	{0x8d74, 0x00},
	{0x8d75, 0x00},
	{0x8d76, 0x00},
	{0x8d77, 0x00},
	{0x8d78, 0x00},
	{0x8d79, 0x00},
	{0x8d7a, 0x00},
	{0x8d7b, 0x00},
	{0x8d7c, 0x00},
	{0x8d7d, 0x00},
	{0x8d7e, 0x00},
	{0x8d7f, 0x00},
	{0x8d80, 0x00},
	{0x8d81, 0x00},
	{0x8d82, 0x00},
	{0x8d83, 0x00},
	{0x8d84, 0x00},
	{0x8d85, 0x00},
	{0x8d86, 0x00},
	{0x8d87, 0x00},
	{0x8d88, 0x00},
	{0x8d89, 0x00},
	{0x8d8a, 0x00},
	{0x8d8b, 0x00},
	{0x8d8c, 0x00},
	{0x8d8d, 0x00},
	{0x8d8e, 0x00},
	{0x8d8f, 0x00},
	{0x8d90, 0x00},
	{0x8d91, 0x00},
	{0x8d92, 0x00},
	{0x8d93, 0x00},
	{0x8d94, 0x00},
	{0x8d95, 0x00},
	{0x8d96, 0x00},
	{0x8d97, 0x00},
	{0x8d98, 0x00},
	{0x8d99, 0x00},
	{0x8d9a, 0x00},
	{0x8d9b, 0x00},
	{0x8d9c, 0x00},
	{0x8d9d, 0x00},
	{0x8d9e, 0x00},
	{0x8d9f, 0x00},
	{0x8da0, 0x00},
	{0x8da1, 0x00},
	{0x8da2, 0x00},
	{0x8da3, 0x00},
	{0x8da4, 0x00},
	{0x8da5, 0x00},
	{0x8da6, 0x00},
	{0x8da7, 0x00},
	{0x8da8, 0x00},
	{0x8da9, 0x00},
	{0x8daa, 0x00},
	{0x8dab, 0x00},
	{0x8dac, 0x00},
	{0x8dad, 0x00},
	{0x8dae, 0x00},
	{0x8daf, 0x00},
	{0x8db0, 0x00},
	{0x8db1, 0x00},
	{0x8db2, 0x00},
	{0x8db3, 0x00},
	{0x8db4, 0x00},
	{0x8db5, 0x00},
	{0x8db6, 0x00},
	{0x8db7, 0x00},
	{0x8db8, 0x00},
	{0x8db9, 0x00},
	{0x8dba, 0x00},
	{0x8dbb, 0x00},
	{0x8dbc, 0x00},
	{0x8dbd, 0x00},
	{0x8dbe, 0x00},
	{0x8dbf, 0x00},
	{0x8dc0, 0x00},
	{0x8dc1, 0x00},
	{0x8dc2, 0x00},
	{0x8dc3, 0x00},
	{0x8dc4, 0x00},
	{0x8dc5, 0x00},
	{0x8dc6, 0x00},
	{0x8dc7, 0x00},
	{0x8dc8, 0x00},
	{0x8dc9, 0x00},
	{0x8dca, 0x00},
	{0x8dcb, 0x00},
	{0x8dcc, 0x00},
	{0x8dcd, 0x00},
	{0x8dce, 0x00},
	{0x8dcf, 0x00},
	{0x8dd0, 0x00},
	{0x8dd1, 0x00},
	{0x8dd2, 0x00},
	{0x8dd3, 0x00},
	{0x8dd4, 0x00},
	{0x8dd5, 0x00},
	{0x8dd6, 0x00},
	{0x8dd7, 0x00},
	{0x8dd8, 0x00},
	{0x8dd9, 0x00},
	{0x8dda, 0x00},
	{0x8ddb, 0x00},
	{0x8ddc, 0x00},
	{0x8ddd, 0x00},
	{0x8dde, 0x00},
	{0x8ddf, 0x00},
	{0x8de0, 0x00},
	{0x8de1, 0x00},
	{0x8de2, 0x00},
	{0x8de3, 0x00},
	{0x8de4, 0x00},
	{0x8de5, 0x00},
	{0x8de6, 0x00},
	{0x8de7, 0x00},
	{0x8de8, 0x00},
	{0x8de9, 0x00},
	{0x8dea, 0x00},
	{0x8deb, 0x00},
	{0x8dec, 0x00},
	{0x8ded, 0x00},
	{0x8dee, 0x00},
	{0x8def, 0x00},
	{0x8df0, 0x00},
	{0x8df1, 0x00},
	{0x8df2, 0x00},
	{0x8df3, 0x00},
	{0x8df4, 0x00},
	{0x8df5, 0x00},
	{0x8df6, 0x00},
	{0x8df7, 0x00},
	{0x8df8, 0x00},
	{0x8df9, 0x00},
	{0x8dfa, 0x00},
	{0x8dfb, 0x00},
	{0x8dfc, 0x00},
	{0x8dfd, 0x00},
	{0x8dfe, 0x00},
	{0x8dff, 0x00},
	{0x8e00, 0x11},
	{0x8e01, 0x04},
	{0x8e02, 0x21},
	{0x8e03, 0x15},
	{0x8e04, 0x12},
	{0x8e05, 0x52},
	{0x8e06, 0x4f},
	{0x8e07, 0x56},
	{0x8e08, 0x54},
	{0x8e09, 0x20},
	{0x8e0a, 0x20},
	{0x8e0b, 0x20},
	{0x8e0c, 0x20},
	{0x8e0d, 0x20},
	{0x8e0e, 0x10},
	{0x8e0f, 0x01},
	{0x8e10, 0x10},
	{0x8e11, 0x00},
	{0x8e12, 0x56},
	{0x8e13, 0x40},
	{0x8e14, 0x1a},
	{0x8e15, 0x30},
	{0x8e16, 0x29},
	{0x8e17, 0x7e},
	{0x8e18, 0x00},
	{0x8e19, 0x30},
	{0x8e1a, 0x04},
	{0x8e1b, 0x20},
	{0x8e1c, 0xdf},
	{0x8e1d, 0x30},
	{0x8e1e, 0x05},
	{0x8e1f, 0x40},
	{0x8e20, 0xbf},
	{0x8e21, 0x50},
	{0x8e22, 0x25},
	{0x8e23, 0x04},
	{0x8e24, 0xfb},
	{0x8e25, 0x50},
	{0x8e26, 0x03},
	{0x8e27, 0x00},
	{0x8e28, 0xfd},
	{0x8e29, 0x50},
	{0x8e2a, 0x27},
	{0x8e2b, 0x01},
	{0x8e2c, 0xfe},
	{0x8e2d, 0x60},
	{0x8e2e, 0x00},
	{0x8e2f, 0x11},
	{0x8e30, 0x00},
	{0x8e31, 0x3f},
	{0x8e32, 0x05},
	{0x8e33, 0x30},
	{0x8e34, 0x00},
	{0x8e35, 0x3f},
	{0x8e36, 0x06},
	{0x8e37, 0x22},
	{0x8e38, 0x00},
	{0x8e39, 0x3f},
	{0x8e3a, 0x01},
	{0x8e3b, 0x29},
	{0x8e3c, 0x00},
	{0x8e3d, 0x3f},
	{0x8e3e, 0x02},
	{0x8e3f, 0x00},
	{0x8e40, 0x00},
	{0x8e41, 0x36},
	{0x8e42, 0x06},
	{0x8e43, 0x07},
	{0x8e44, 0x00},
	{0x8e45, 0x3f},
	{0x8e46, 0x0b},
	{0x8e47, 0x0f},
	{0x8e48, 0xf0},
	{0x8e49, 0x30},
	{0x8e4a, 0x01},
	{0x8e4b, 0x40},
	{0x8e4c, 0xbf},
	{0x8e4d, 0x30},
	{0x8e4e, 0x01},
	{0x8e4f, 0x00},
	{0x8e50, 0xbf},
	{0x8e51, 0x30},
	{0x8e52, 0x29},
	{0x8e53, 0x70},
	{0x8e54, 0x00},
	{0x8e55, 0x3a},
	{0x8e56, 0x00},
	{0x8e57, 0x00},
	{0x8e58, 0xff},
	{0x8e59, 0x3a},
	{0x8e5a, 0x00},
	{0x8e5b, 0x00},
	{0x8e5c, 0xff},
	{0x8e5d, 0x36},
	{0x8e5e, 0x03},
	{0x8e5f, 0x36},
	{0x8e60, 0x02},
	{0x8e61, 0x41},
	{0x8e62, 0x44},
	{0x8e63, 0x58},
	{0x8e64, 0x20},
	{0x8e65, 0x18},
	{0x8e66, 0x10},
	{0x8e67, 0x0a},
	{0x8e68, 0x04},
	{0x8e69, 0x04},
	{0x8e6a, 0x00},
	{0x8e6b, 0x03},
	{0x8e6c, 0xff},
	{0x8e6d, 0x64},
	{0x8e6e, 0x00},
	{0x8e6f, 0x00},
	{0x8e70, 0x80},
	{0x8e71, 0x00},
	{0x8e72, 0x00},
	{0x8e73, 0x00},
	{0x8e74, 0x00},
	{0x8e75, 0x00},
	{0x8e76, 0x00},
	{0x8e77, 0x02},
	{0x8e78, 0x04},
	{0x8e79, 0x06},
	{0x8e7a, 0x00},
	{0x8e7b, 0x03},
	{0x8e7c, 0x98},
	{0x8e7d, 0x00},
	{0x8e7e, 0xcc},
	{0x8e7f, 0x50},
	{0x8e80, 0x3c},
	{0x8e81, 0x28},
	{0x8e82, 0x1e},
	{0x8e83, 0x10},
	{0x8e84, 0x10},
	{0x8e85, 0x00},
	{0x8e86, 0x00},
	{0x8e87, 0x00},
	{0x8e88, 0x6e},
	{0x8e89, 0x06},
	{0x8e8a, 0x05},
	{0x8e8b, 0x00},
	{0x8e8c, 0xa5},
	{0x8e8d, 0x5a},
	{0x3022, 0x00},
	{0x3023, 0x00},
	{0x3024, 0x00},
	{0x3025, 0x00},
	{0x3026, 0x00},
	{0x3027, 0x00},
	{0x3028, 0x00},
	{0x3029, 0xFF},
	{0x3000, 0x00},
	{SEQUENCE_END,0x00},
};
