/*===============================================================================
**  Generic Header information generated by 13521CFG.EXE (Build 4)
**  (C)SEIKO EPSON CORPORATION 2002-2007. All rights reserved.
**
**  DISPLAYS      WxH         FREQ    SUBTYPE
**  ------------- ----------- ------- -------------------------------------------
** *LCD1=Parallel 800x600     NA      EPD Panel
**
**  DIMENSIONS  WxHxBPP @ STRIDE       START   SADDR     ADDITIONAL
**  ----------- ---------------------- ------- --------- -----------------------
** *Main        800x600x4 @ 800        NA      000EA600h LUTAuto=on
**
**  CLOCKS        FREQ        SOURCE
**  ------------- ----------- ---------------------------------------------------
**  INCLK         132.000 MHz PLL
**  SYSCLK         66.000 MHz PLL/2
**  PCLK           26.400 MHz PLL/5
**  SPICLK         13.200 MHz SYSCLK/5
**  I2CCLK          4.125 MHz PLL/16
**  SDRAMCLK      132.000 MHz PLL
**  SDRAMREFCLK    63.954 KHz CLKI/516
**
**  This file defines the configuration environment and registers,
**  which can be used by any software, such as display drivers.
**
**  Note: If you transfer this file to any non-PC system, use ASCII
**  mode (not BINARY) to maintain system-specific line terminators.
**===============================================================================*/

#define S1D_13521

#define S1D_DISPLAY_WIDTH               600
#define S1D_DISPLAY_HEIGHT              800

#define S1D_DISPLAY_BPP                 8

//#define S1D_DISPLAY_SCANLINE_BYTES      600
#define S1D_DISPLAY_FRAME_RATE          0
#define S1D_DISPLAY_PCLK                26400000L
#define S1D_PHYSICAL_REG_ADDR           0x00000000L
#define S1D_PHYSICAL_REG_SIZE           90L
#define S1D_PHYSICAL_VMEM_REQUIRED      640000L
#define S1D_PALETTE_SIZE                256
#define S1D_POWER_DELAY_OFF             0
#define S1D_POWER_DELAY_ON              0
#define S1D_HWBLT
#define S1D_SWBLT


#define BS60_INIT_HSIZE         800
#define BS60_INIT_VSIZE         600

#define BS60_INIT_FSLEN         4
#define BS60_INIT_FBLEN         4
#define BS60_INIT_FELEN         10
#define BS60_INIT_LSLEN         10
#define BS60_INIT_LBLEN         4
#define BS60_INIT_LELEN         100
#define BS60_INIT_PIXCLKDIV     6
#define BS60_INIT_SDRV_CFG      (100 | (1<< 8) | (1<<9))
#define BS60_INIT_GDRV_CFG      0x2
#define BS60_INIT_LUTIDXFMT     (4 | (1<<7))
#define BS60_INIT_ROTMODE       3    // rotation mode = 180 degrees

#define WF_MODE_INIT            0
#define WF_MODE_MU              1
#define WF_MODE_GU              2
#define WF_MODE_GC              3
#define WF_MODE_PU              4

typedef unsigned short S1D_INDEX;
typedef unsigned short S1D_VALUE;

#define S1D_INSTANTIATE_REGISTERS(scope_prefix,variable_name)  \
  scope_prefix S1D_VALUE variable_name[] =  \
        { \
        INIT_SYS_RUN,   0,                                                      \
        INIT_DSPE_CFG,  5,      BS60_INIT_HSIZE,                                \
                                BS60_INIT_VSIZE,                                \
                                BS60_INIT_SDRV_CFG,                             \
                                BS60_INIT_GDRV_CFG,                             \
                                BS60_INIT_LUTIDXFMT,                            \
        INIT_DSPE_TMG,  5,      BS60_INIT_FSLEN,                                \
                                (BS60_INIT_FELEN<<8)|BS60_INIT_FBLEN,           \
                                BS60_INIT_LSLEN,                                \
                                (BS60_INIT_LELEN<<8)|BS60_INIT_LBLEN,           \
                                BS60_INIT_PIXCLKDIV,                            \
        RD_WFM_INFO,    2,      0x0886, 0,                                      \
        UPD_GDRV_CLR,   0,                                                      \
        WAIT_DSPE_TRG,  0,                                                      \
        INIT_ROTMODE,   1,      (BS60_INIT_ROTMODE << 8)                        \
        }



